/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.nodes;

import inform.adt.DateTime;
import inform.adt.InformException;
import inform.adt.LittleEndian;
import inform.adt.Strings;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.Ini;
import inform.agent.LogContext;
import inform.agent.mtd.AuditJournal;
import inform.agent.mtd.MtdCache;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.NodeRecord;
import inform.agent.mtd.RolesTable;
import inform.agent.mtd.Security;
import inform.agent.mtd.UsersTable;
import inform.agent.mtd.nodes.AccountNode;
import inform.agent.mtd.nodes.Node;
import inform.agent.mtd.nodes.UserRole;
import inform.agent.mtd.request.NodeStatus;
import inform.agent.scripts.SSContext;
import inform.common.Empty;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.ArrayList;

public class UserNode
extends AccountNode {
    public static final String BUILT_IN_SERVICE_USER_NAME = "built-in-service-user-name";
    public static final int POSSIBLE_ADMIN_LOGIN_COUNT_MAX_FSTEC = 2;
    private final byte[] securityHash = Security.newMD5Hash();
    private final byte[] securitySalt = Security.newMD5Salt();
    private byte[] sha256Hash = null;
    private byte[] sha256Salt = null;
    protected UserRole role = UserRole.DEFAULT;
    protected byte[] userProps = null;
    private boolean singleLogin = false;
    private boolean serviceUser = false;
    private int possibleLoginCount = 0;
    private boolean changePasswordOnLogin = false;
    private double passwordChangeDate = 0.0;
    protected Props propsCache;

    public UserNode(NodeRecord record) {
        super(record);
    }

    public static UserNode createAdminNode(double id) throws InformException {
        NodeRecord record = new NodeRecord(NodeStatus.MODIFIED);
        record.setId(id);
        record.setType(3);
        record.setParentId(2.0);
        record.setName("admin");
        long time = System.currentTimeMillis();
        record.setCreationTime(time);
        record.setModificationContentTime(time);
        record.setModificationAttributeTime(time);
        UserNode node = new UserNode(record);
        node.role = UserRole.ADMIN;
        byte[] salt = Security.generateSalt();
        byte[] hash = Security.calculateH1(node.getName(), "", salt);
        System.arraycopy(salt, 0, node.securitySalt, 0, salt.length);
        System.arraycopy(hash, 0, node.securityHash, 0, hash.length);
        node.changePasswordOnLogin = true;
        node.afterCreateSystem();
        return node;
    }

    public static UserNode createSafeModeUser() throws InformException {
        NodeRecord record = new NodeRecord(NodeStatus.MODIFIED);
        record.setId(11.0);
        record.setType(3);
        record.setParentId(2.0);
        record.setName(Ini.SafeModeUserName);
        long time = System.currentTimeMillis();
        record.setCreationTime(time);
        record.setModificationContentTime(time);
        record.setModificationAttributeTime(time);
        UserNode node = new UserNode(record);
        node.role = UserRole.ADMIN;
        byte[] salt = Security.generateSalt();
        byte[] hash = Security.calculateH1(node.getName(), "", salt);
        System.arraycopy(salt, 0, node.securitySalt, 0, salt.length);
        System.arraycopy(hash, 0, node.securityHash, 0, hash.length);
        node.afterCreateSystem();
        node.status = null;
        return node;
    }

    public static UserNode createBuiltInServiceUser() throws InformException {
        NodeRecord record = new NodeRecord(NodeStatus.MODIFIED);
        record.setId(13.0);
        record.setType(3);
        record.setParentId(2.0);
        record.setName(BUILT_IN_SERVICE_USER_NAME);
        long time = System.currentTimeMillis();
        record.setCreationTime(time);
        record.setModificationContentTime(time);
        record.setModificationAttributeTime(time);
        UserNode node = new UserNode(record);
        node.role = UserRole.DEFAULT;
        byte[] salt = Security.generateSalt();
        byte[] hash = Security.calculateH1(node.getName(), BUILT_IN_SERVICE_USER_NAME, salt);
        System.arraycopy(salt, 0, node.securitySalt, 0, salt.length);
        System.arraycopy(hash, 0, node.securityHash, 0, hash.length);
        node.systemLoaded();
        node.afterCreateSystem();
        node.status = null;
        return node;
    }

    public Props props() {
        if (this.propsCache == null && this.userProps != null) {
            this.propsCache = new Props(this.userProps);
        }
        return this.propsCache;
    }

    public UserRole getRole() {
        return this.role;
    }

    public boolean isServiceUser() {
        return this.serviceUser;
    }

    public byte[] getSecurityHash() {
        return this.securityHash;
    }

    public byte[] getSecuritySalt() {
        return this.securitySalt;
    }

    public byte[] getSha256Hash() {
        return this.sha256Hash;
    }

    public byte[] getSha256Salt() {
        return this.sha256Salt;
    }

    public boolean isSha256() {
        return this.sha256Hash != null && this.sha256Salt != null;
    }

    public boolean isSingleLogin() {
        return this.singleLogin;
    }

    public int getPossibleLoginCount() {
        if (UserRole.ADMIN == this.role && Core.isFstecBuild) {
            if (this.possibleLoginCount > 0 && this.possibleLoginCount <= 2) {
                return this.possibleLoginCount;
            }
            return 2;
        }
        return this.possibleLoginCount;
    }

    private void setPossibleLoginCount(int value) {
        if (UserRole.ADMIN == this.role && Core.isFstecBuild) {
            if (value > 0 && value <= 2) {
                this.possibleLoginCount = value;
                return;
            }
            return;
        }
        this.possibleLoginCount = value;
    }

    public boolean isChangePasswordOnLogin() {
        return this.changePasswordOnLogin;
    }

    public double getPasswordChangeDate() {
        return this.passwordChangeDate;
    }

    @Override
    protected final boolean isBlockedImpl(LogContext.Builder cause) {
        if (super.isBlockedImpl(cause) || this.isDeletedImpl(cause)) {
            return true;
        }
        if (MtdEngine.isFailedLoginCountExceed(this.getId(), cause)) {
            this.blocked = true;
        }
        return this.blocked;
    }

    @Override
    protected void afterLoadTag(TaggedReader in) throws Throwable {
        switch (in.getCurrentTag()) {
            case 7: {
                this.userProps = in.getRaw();
                this.propsCache = null;
                break;
            }
            case 35: {
                this.setPossibleLoginCount(in.getInt());
                this.singleLogin = this.getPossibleLoginCount() == 1;
                break;
            }
            case 38: {
                this.serviceUser = in.getBoolean();
            }
        }
    }

    @Override
    protected void loadTag(MtdCache mtdCache, TaggedReader in) throws InformException, IOException, InterruptedException {
        switch (in.getCurrentTag()) {
            case 101: {
                if (this.status == NodeStatus.COPIED) break;
                in.getRaw(this.securityHash, this.securityHash.length);
                break;
            }
            case 102: {
                if (this.status == NodeStatus.COPIED) break;
                in.getRaw(this.securitySalt, this.securitySalt.length);
                break;
            }
            case 106: {
                this.role = UserRole.ADMIN;
                break;
            }
            case 108: {
                int roleId = in.getInt();
                this.role = UserRole.get(roleId);
                break;
            }
            case 109: {
                this.userProps = in.getRaw();
                this.propsCache = null;
                break;
            }
            case 117: {
                this.changePasswordOnLogin = in.getBoolean();
                break;
            }
            case 120: {
                this.passwordChangeDate = in.getInt();
                break;
            }
            case 121: {
                if (this.status == NodeStatus.COPIED) break;
                this.sha256Hash = in.getRaw();
                break;
            }
            case 122: {
                if (this.status == NodeStatus.COPIED) break;
                this.sha256Salt = in.getRaw();
                break;
            }
            default: {
                super.loadTag(null, in);
            }
        }
    }

    private String getDisplayedPasswordHash() {
        try {
            if (this.isSha256()) {
                MessageDigest md = MessageDigest.getInstance("SHA-256");
                md.update(this.sha256Hash);
                md.update(this.sha256Salt);
                return Strings.bytes2hex(md.digest());
            }
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(this.securityHash);
            md.update(this.securitySalt);
            return Strings.bytes2hex(md.digest());
        }
        catch (NoSuchAlgorithmException ex) {
            throw InformException.wrap(ex);
        }
    }

    @Override
    public void getAccountInfo(TaggedWriter out, boolean needHash) throws IOException, InformException {
        if (this.role == UserRole.ADMIN) {
            AccountNode.UserInterface ui = this.userInterface();
            ui.canUploadPex = true;
            ui.canWritePex = true;
        }
        super.getAccountInfo(out, needHash);
        if (this.userProps != null && this.userProps.length != 0) {
            out.putRaw(42, this.userProps);
        }
        out.putInt32(38, this.role.toInt());
        out.putBool(80, this.singleLogin);
        out.putInt32(110, this.getPossibleLoginCount());
        out.putBool(81, this.changePasswordOnLogin);
        out.putString(86, this.getDisplayedPasswordHash());
        if (needHash) {
            if (this.isSha256()) {
                out.putRaw(115, this.sha256Hash);
                out.putRaw(116, this.sha256Salt);
            } else {
                out.putRaw(30, this.securityHash);
                out.putRaw(31, this.securitySalt);
            }
        }
        out.putBool(114, this.serviceUser);
    }

    @Override
    public void getNodeInfo(Node.NodeInfoArg arg) throws InformException, IOException, SQLException, InterruptedException {
        super.getNodeInfo(arg);
        if ((arg.options & 0x100) != 0 && this.userProps != null && this.userProps.length != 0) {
            arg.out.putRaw(42, this.userProps);
        }
    }

    public boolean checkPassword(String password) throws InformException {
        if (this.isSha256()) {
            return Security.isHashEquals(Security.sha256CalculateH1(this.getName(), password, this.sha256Salt), this.sha256Hash);
        }
        return Security.isHashEquals(Security.calculateH1(this.getName(), password, this.securitySalt), this.securityHash);
    }

    @Override
    protected void assignName(MtdCache mtdCache, String name) {
        double userId;
        if (!this.blocked && (userId = mtdCache.getUserIdByName(name)) != 0.0 && userId != this.getId()) {
            this.blocked = true;
        }
        super.assignName(mtdCache, name);
    }

    @Override
    public void trySetLock(MtdCache mtdCache, boolean value) throws InterruptedException, InformException {
        double userId;
        if (this.blocked == value) {
            return;
        }
        this.blocked = value ? true : (userId = mtdCache.getUserIdByName(this.getName())) != 0.0 && userId != this.getId();
    }

    @Override
    protected void storeContent(TaggedWriter out) throws IOException {
        super.storeContent(out);
        if (this.userProps != null && this.userProps.length != 0) {
            out.putRaw(7, this.userProps);
        }
        out.putInt32(35, this.getPossibleLoginCount());
        out.putBool(38, this.serviceUser);
    }

    @Override
    public void setNodeChangingProps(Node.ModifyNodeArg arg) throws InformException {
        if ((int)this.passwordChangeDate == 0) {
            this.passwordChangeDate = Math.floor(DateTime.fromUnixTime(this.getModificationAttributeTime()));
        }
        super.setNodeChangingProps(arg);
    }

    protected void getClientTagsContent(UsersTable usersTable, RolesTable rolesTable, TaggedWriter out, boolean skipSomeTags) throws IOException {
        out.putInt32(38, this.role.toInt());
        if (!skipSomeTags) {
            out.putAnsi(33, this.getName());
        }
        if (this.isSha256()) {
            out.putRaw(115, this.sha256Hash, this.sha256Hash.length);
            out.putRaw(116, this.sha256Salt, this.sha256Salt.length);
        } else {
            out.putRaw(30, this.securityHash, this.securityHash.length);
            out.putRaw(31, this.securitySalt, this.securitySalt.length);
        }
        if (usersTable == null || usersTable.field(13) == null) {
            out.putBool(82, this.activeDirectory());
        }
        if (rolesTable != null && rolesTable.enabled()) {
            out.putBool(113, true);
        } else {
            out.putRaw(34, LittleEndian.doubleArrayToBinary(this.explicitGroups()));
        }
        if ((usersTable == null || usersTable.field(14) == null) && this.inheritedStartup()) {
            out.putBool(35, this.inheritedStartup());
        }
        out.putRaw(42, this.userProps);
        out.putRaw(37, this.constants());
        out.putBool(89, this.userInterface().inheritedSavePerRecord);
        if (!this.userInterface().inheritedSavePerRecord) {
            out.putBool(88, this.userInterface().savePerRecord);
        }
        out.putBool(91, this.userInterface().inheritedCanSetupUser);
        if (!this.userInterface().inheritedCanSetupUser) {
            out.putBool(90, this.userInterface().canSetupUser);
        }
        out.putBool(94, this.userInterface().inheritedCanCreateNodes);
        if (!this.userInterface().inheritedCanCreateNodes) {
            if (this.userInterface().canCreateAnyNodes) {
                out.putEmpty(92);
            } else {
                out.putIntArray(93, this.userInterface().canCreateNodeTypes);
            }
        }
        out.putBool(96, this.userInterface().inheritedSimplePopup);
        if (!this.userInterface().inheritedSimplePopup) {
            out.putBool(95, this.userInterface().simplePopup);
        }
        out.putBool(98, this.userInterface().inheritedCanWritePublicFilters);
        if (!this.userInterface().inheritedCanWritePublicFilters) {
            out.putBool(97, this.userInterface().canWritePublicFilters);
        }
        out.putBool(107, this.userInterface().inheritedCanWritePex);
        if (!this.userInterface().inheritedCanWritePex) {
            out.putBool(106, this.userInterface().canWritePex);
        }
        out.putBool(109, this.userInterface().inheritedCanUploadPex);
        if (!this.userInterface().inheritedCanUploadPex) {
            out.putBool(108, this.userInterface().canUploadPex);
        }
        out.putBool(103, this.userInterface().inheritedCanViewDataHistory);
        if (!this.userInterface().inheritedCanViewDataHistory) {
            out.putBool(102, this.userInterface().canViewDataHistory);
        }
        out.putBool(105, this.userInterface().inheritedCanViewMetadataHistory);
        if (!this.userInterface().inheritedCanViewMetadataHistory) {
            out.putBool(104, this.userInterface().canViewMetadataHistory);
        }
        out.putBool(112, this.userInterface().inheritedEditNode);
        if (!this.userInterface().inheritedEditNode) {
            out.putBool(111, this.userInterface().editNode);
        }
        out.putRaw(45, this.saveDbLogins());
        out.putBool(80, this.singleLogin);
        out.putInt32(110, this.getPossibleLoginCount());
        out.putBool(81, this.changePasswordOnLogin);
        out.putBool(51, this.inheritedServerIPs());
        if (!this.inheritedServerIPs()) {
            out.putRaw(50, this.saveServerIPs());
        }
        out.putBool(52, this.blocked);
        if (!(usersTable != null && usersTable.field(14) != null || this.inheritedStartup())) {
            ByteArrayOutputStream data = new ByteArrayOutputStream();
            TaggedWriter stream = new TaggedWriter(data);
            stream.putEmpty(1);
            stream.putDouble(151, this.startupRootNodeId());
            stream.putEmpty(2);
            stream.putDouble(151, this.startupStartNodeId());
            stream.putInt32(3, this.startupStartNodeAction());
            stream.putEmpty(4);
            stream.putDouble(151, this.startupScriptId());
            stream.putEmpty(12);
            stream.putDouble(151, this.webStartNodeId());
            stream.flush();
            out.putRaw(83, data.internalBuffer(), data.size());
        }
        out.flush();
    }

    @Override
    public void storeSpecificAttributes(TaggedWriter out, boolean fullStore) throws InformException, IOException {
        super.storeSpecificAttributes(out, fullStore);
        if (this.isSha256()) {
            out.putRaw(121, this.sha256Hash);
            out.putRaw(122, this.sha256Salt);
        } else {
            out.putRaw(101, this.securityHash);
            out.putRaw(102, this.securitySalt);
        }
        out.putInt32(108, this.role.toInt());
        out.putBool(116, this.singleLogin);
        out.putBool(117, this.changePasswordOnLogin);
        out.putInt32(120, (int)this.passwordChangeDate);
    }

    @Override
    public void loadReplicationTag(int tag, Node.ModifyNodeArg arg, int mask) throws IOException, InformException, SQLException {
        assert (this.status != null);
        TaggedReader in = arg.in;
        switch (tag) {
            case 3: {
                if ((mask & 1) == 0) break;
                this.loadModifyTag(33, arg);
                break;
            }
            case 101: {
                this.loadModifyTag(30, arg);
                break;
            }
            case 102: {
                this.loadModifyTag(31, arg);
                break;
            }
            case 108: {
                this.loadModifyTag(38, arg);
                break;
            }
            case 116: {
                this.loadModifyTag(80, arg);
                break;
            }
            case 117: {
                this.loadModifyTag(81, arg);
                break;
            }
            case 120: {
                this.passwordChangeDate = in.getInt();
                this.setAttrModified();
                break;
            }
            case 121: {
                this.loadModifyTag(115, arg);
                break;
            }
            case 122: {
                this.loadModifyTag(116, arg);
                break;
            }
            default: {
                super.loadReplicationTag(tag, arg, mask);
            }
        }
    }

    public void changeAuthentication(Node.ModifyNodeArg arg) throws IOException, InformException, SQLException {
        boolean locked = this.isBlocked();
        boolean restoreLock = true;
        TaggedReader in = arg.in;
        block4: while (in.next()) {
            switch (in.getCurrentTag()) {
                case 52: {
                    restoreLock = false;
                    this.loadModifyTag(in.getCurrentTag(), arg);
                    continue block4;
                }
                case 30: 
                case 31: 
                case 115: 
                case 116: {
                    this.loadModifyTag(in.getCurrentTag(), arg);
                    continue block4;
                }
            }
        }
        if (restoreLock && !locked) {
            this.setLock(false);
        }
    }

    @Override
    public void loadModifyTag(int tag, Node.ModifyNodeArg arg) throws IOException, InformException, SQLException {
        assert (this.status != null);
        TaggedReader in = arg.in;
        switch (tag) {
            case 4: {
                throw new InformException("\u0418\u043c\u044f \u0443\u0437\u043b\u0430 \u0442\u0438\u043f\u0430 \u041f\u041e\u041b\u042c\u0417\u041e\u0412\u0410\u0422\u0415\u041b\u042c \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u0447\u0435\u0440\u0435\u0437 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0443 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f");
            }
            case 33: {
                String loadedName = in.getString();
                this.setUserName(loadedName, arg);
                this.changePasswordOnLogin = false;
                break;
            }
            case 30: {
                in.getRaw(this.securityHash, this.securityHash.length);
                this.changePasswordOnLogin = false;
                this.passwordChangeDate = DateTime.currentDate();
                break;
            }
            case 31: {
                in.getRaw(this.securitySalt, this.securitySalt.length);
                this.changePasswordOnLogin = false;
                break;
            }
            case 38: {
                int roleId = in.getInt();
                UserRole newRole = UserRole.get(roleId);
                if (this.role != newRole && arg.security.role() != UserRole.ADMIN) {
                    throw new InformException("\u0423\u0440\u043e\u0432\u0435\u043d\u044c \u0434\u043e\u0441\u0442\u0443\u043f\u0430 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u043c\u043e\u0436\u0435\u0442 \u0438\u0437\u043c\u0435\u043d\u044f\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u0441 \u0443\u0440\u043e\u0432\u043d\u0435\u043c \u0434\u043e\u0441\u0442\u0443\u043f\u0430 \u0410\u0414\u041c\u0418\u041d\u0418\u0421\u0422\u0420\u0410\u0422\u041e\u0420");
                }
                this.role = newRole;
                this.setSignificantAttrModified(false);
                break;
            }
            case 42: {
                this.userProps = in.getRaw();
                this.propsCache = null;
                break;
            }
            case 80: {
                this.singleLogin = in.getBoolean();
                int maxSameTimeLogins = this.getPossibleLoginCount();
                if (0 == maxSameTimeLogins) {
                    if (!this.singleLogin) break;
                    this.setPossibleLoginCount(1);
                    break;
                }
                this.singleLogin = 1 == maxSameTimeLogins;
                break;
            }
            case 110: {
                this.setPossibleLoginCount(in.getInt());
                this.singleLogin = this.getPossibleLoginCount() == 1;
                break;
            }
            case 81: {
                this.changePasswordOnLogin = in.getBoolean();
                break;
            }
            case 87: {
                this.modifyUserProps(in.getRaw());
                break;
            }
            case 114: {
                this.serviceUser = in.getBoolean();
                break;
            }
            case 115: {
                if (this.sha256Hash == null) {
                    this.sha256Hash = Security.newSha256Hash();
                }
                in.getRaw(this.sha256Hash, this.sha256Hash.length);
                this.changePasswordOnLogin = false;
                this.passwordChangeDate = DateTime.currentDate();
                break;
            }
            case 116: {
                if (this.sha256Salt == null) {
                    this.sha256Salt = Security.newSha256Salt();
                }
                in.getRaw(this.sha256Salt, this.sha256Salt.length);
                this.changePasswordOnLogin = false;
                break;
            }
            default: {
                super.loadModifyTag(tag, arg);
            }
        }
        this.setContentModified();
    }

    private void modifyUserProps(byte[] modifyProps) throws IOException, TaggedReaderException {
        assert (this.status != null);
        ArrayList<ModifyTag> modifyTags = new ArrayList<ModifyTag>();
        TaggedReader in = new TaggedReader(modifyProps);
        while (in.next()) {
            ModifyTag tag = new ModifyTag(in.getCurrentTag(), in.getRaw());
            modifyTags.add(tag);
        }
        ByteArrayOutputStream newProps = new ByteArrayOutputStream();
        TaggedWriter out = new TaggedWriter(newProps);
        in = new TaggedReader(this.userProps);
        while (in.next()) {
            int tag = in.getCurrentTag();
            ModifyTag modifyTag = null;
            for (ModifyTag t : modifyTags) {
                if (t.tag != tag) continue;
                modifyTag = t;
                break;
            }
            if (modifyTag == null) {
                in.transferTag(out);
                continue;
            }
            out.putRaw(modifyTag.tag, modifyTag.data);
            modifyTag.transfered = true;
        }
        for (ModifyTag modifyTag : modifyTags) {
            if (modifyTag.transfered) continue;
            out.putRaw(modifyTag.tag, modifyTag.data);
        }
        out.flush();
        this.userProps = newProps.toByteArray();
        this.setContentModified();
    }

    private void setUserName(String newName, Node.ModifyNodeArg arg) throws InformException {
        double userId;
        String name = this.getName();
        if (name.equals(newName)) {
            return;
        }
        if (!this.blocked && (userId = MtdEngine.getUserIdByName(newName)) != 0.0 && userId != this.getId()) {
            throw new InformException("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u0441 \u0438\u043c\u0435\u043d\u0435\u043c \"" + newName + "\" \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442.");
        }
        this.changeName(newName, arg);
    }

    @Override
    protected void setLock(boolean newBlocked) throws InformException {
        if (newBlocked == this.blocked) {
            return;
        }
        if (!newBlocked) {
            double userId = MtdEngine.getUserIdByName(this.getName());
            if (userId != 0.0 && userId != this.getId()) {
                throw new InformException("\u0420\u0430\u0437\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e, \u0438\u043c\u044f \"" + this.getName() + "\" \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442.");
            }
            if (this.isDeleted()) {
                throw new InformException("\u0420\u0430\u0437\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e, \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \"" + this.getName() + "\" \u0443\u0434\u0430\u043b\u0435\u043d.");
            }
        }
        super.setLock(newBlocked);
    }

    @Override
    protected void checkCanSetLock(boolean newBlocked, double userId) throws InformException {
        if (newBlocked && this.getId() == userId) {
            throw new InformException("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0441\u0430\u043c\u043e\u0433\u043e \u0441\u0435\u0431\u044f");
        }
    }

    @Override
    public void applyUpdates(SSContext context, Node.ModifyNodeArg arg) throws SQLException, IOException {
        super.applyUpdates(context, arg);
        AuditJournal.registerAuthChangeEvent(context, arg.userId, arg.sessionId, this.getId());
    }

    public static class SystemUsersHelper {
        public static UserNode SERVER_USER = SystemUsersHelper.createServerUser();

        private static UserNode createServerUser() {
            NodeRecord record = new NodeRecord(NodeStatus.MODIFIED);
            record.setId(2.0);
            record.setType(3);
            record.setName("\u0421\u0435\u0440\u0432\u0435\u0440");
            long time = System.currentTimeMillis();
            record.setCreationTime(time);
            record.setModificationContentTime(time);
            record.setModificationAttributeTime(time);
            UserNode node = new UserNode(record);
            node.role = UserRole.ADMIN;
            node.afterCreateSystem();
            node.status = null;
            return node;
        }
    }

    private static class ModifyTag {
        final int tag;
        final byte[] data;
        boolean transfered = false;

        private ModifyTag(int tag, byte[] data) {
            this.tag = tag;
            this.data = data == null || data.length == 0 ? Empty.byteArray : data;
        }
    }

    public static class Props {
        public static final int TAG_NODE_USER_FIO = 1;
        public static final int TAG_NODE_USER_SUBDIVISION = 2;
        public static final int TAG_NODE_USER_POST = 3;
        public static final int TAG_NODE_USER_PHONE = 4;
        public static final int TAG_NODE_USER_EMAIL = 5;
        public static final int TAG_NODE_USER_REGISTERNUMBER = 6;
        public static final int TAG_NODE_USER_UI_SCALE = 7;
        private String fio = "";
        private String phone = "";
        private String email = "";
        private double scale = 1.0;
        private double cardId = 0.0;
        private boolean deleted = false;
        private boolean serverManaged = false;
        private double serverManagedEndDate = 0.0;

        public Props() {
        }

        public Props(byte[] props) {
            String _fio = null;
            TaggedReader r = new TaggedReader(props);
            try {
                while (r.next()) {
                    switch (r.getCurrentTag()) {
                        case 1: {
                            _fio = r.getAnsi();
                        }
                    }
                }
            }
            catch (IOException e) {
                throw InformException.wrap(e);
            }
            this.fio = _fio;
        }

        public void loadScale(byte[] props) {
            if (props == null) {
                return;
            }
            TaggedReader r = new TaggedReader(props);
            try {
                while (r.next()) {
                    switch (r.getCurrentTag()) {
                        case 7: {
                            double s = r.getDouble();
                            if (s >= 0.5 && s <= 3.0) {
                                this.scale = s;
                            }
                            return;
                        }
                    }
                }
            }
            catch (IOException e) {
                throw InformException.wrap(e);
            }
        }

        public void modifyVirtualUserProps(byte[] props) {
            if (props == null) {
                return;
            }
            TaggedReader r = new TaggedReader(props);
            try {
                while (r.next()) {
                    switch (r.getCurrentTag()) {
                        case 1: {
                            this.fio = r.getAnsi();
                            break;
                        }
                        case 4: {
                            this.phone = r.getAnsi();
                            break;
                        }
                        case 5: {
                            this.email = r.getAnsi();
                            break;
                        }
                        case 7: {
                            double s = r.getDouble();
                            if (!(s >= 0.5) || !(s <= 3.0)) break;
                            this.scale = s;
                        }
                    }
                }
            }
            catch (IOException e) {
                throw InformException.wrap(e);
            }
        }

        public byte[] getScaleProps() throws IOException {
            if (this.scale == 1.0) {
                return Empty.byteArray;
            }
            ByteArrayOutputStream data = new ByteArrayOutputStream();
            TaggedWriter out = new TaggedWriter(data);
            out.putDouble(7, this.scale);
            return data.toByteArray();
        }

        public byte[] getVirtualUserProps() throws IOException {
            ByteArrayOutputStream data = new ByteArrayOutputStream();
            TaggedWriter out = new TaggedWriter(data);
            if (!Strings.isVoid(this.fio)) {
                out.putAnsi(1, this.fio);
            }
            if (!Strings.isVoid(this.phone)) {
                out.putAnsi(4, this.phone);
            }
            if (!Strings.isVoid(this.email)) {
                out.putAnsi(5, this.email);
            }
            if (this.scale != 1.0) {
                out.putDouble(7, this.scale);
            }
            return data.toByteArray();
        }

        public String getFio() {
            return this.fio;
        }

        public void setFio(String fio) {
            this.fio = fio;
        }

        public String getPhone() {
            return this.phone;
        }

        public void setPhone(String phone) {
            this.phone = phone;
        }

        public String getEmail() {
            return this.email;
        }

        public void setEmail(String email) {
            this.email = email;
        }

        public double getScale() {
            return this.scale;
        }

        public void setScale(double scale) {
            this.scale = scale;
        }

        public double getCardId() {
            return this.cardId;
        }

        public void setCardId(double cardId) {
            this.cardId = cardId;
        }

        public boolean getServerManaged() {
            return this.serverManaged;
        }

        public void setServerManaged(boolean serverManaged) {
            this.serverManaged = serverManaged;
        }

        public double getServerManagedEndDate() {
            return this.serverManagedEndDate;
        }

        public void setServerManagedEndDate(double serverManagedEndDate) {
            this.serverManagedEndDate = serverManagedEndDate;
        }

        public boolean getDeleted() {
            return this.deleted;
        }

        public void setDeleted(boolean deleted) {
            this.deleted = deleted;
        }
    }
}

