/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.obj;

import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.mtd.obj.DArray;
import inform.agent.mtd.obj.DDatasourceSync;
import inform.agent.mtd.obj.DItem;
import inform.agent.mtd.obj.DProperty;
import java.io.IOException;

public class DDatasourceSyncList
extends DArray {
    public DDatasourceSyncList(DProperty object, String name) {
        super(object, name, 2);
    }

    @Override
    public DProperty loadScriptArrayItem(Object obj) {
        DDatasourceSync item = new DDatasourceSync(this);
        item.loadScriptValue(obj);
        return item;
    }

    @Override
    protected void doAssign(DItem source) {
        if (DDatasourceSyncList.checkAssignType(source, this.getClass())) {
            for (DProperty sourceProperty : ((DDatasourceSyncList)source).properties) {
                if (!DDatasourceSyncList.checkAssignType(sourceProperty, DDatasourceSync.class)) continue;
                DDatasourceSync sourceDs = (DDatasourceSync)sourceProperty;
                DDatasourceSync ds = new DDatasourceSync(this);
                ds.assign(sourceDs);
                this.properties.add(ds);
            }
        }
    }

    @Override
    public DProperty getDefaultArrayItem() {
        return new DDatasourceSync(this);
    }

    public int addItem(int dataSourceSyncKind) {
        DDatasourceSync datasourceSync = new DDatasourceSync(this);
        datasourceSync.setKind(dataSourceSyncKind);
        if (this.properties.add(datasourceSync)) {
            return this.properties.size() - 1;
        }
        return -1;
    }

    public void setDatasourceId(int index, int uid) {
        if (index < 0 || index >= this.size()) {
            return;
        }
        DProperty prop = (DProperty)this.properties.get(index);
        if (prop instanceof DDatasourceSync) {
            DDatasourceSync datasourceSync = (DDatasourceSync)prop;
            datasourceSync.sourceId.value = uid;
        }
    }

    public void setDatasourceName(int index, String name) {
        if (index < 0 || index >= this.size()) {
            return;
        }
        DProperty prop = (DProperty)this.properties.get(index);
        if (prop instanceof DDatasourceSync) {
            DDatasourceSync datasourceSync = (DDatasourceSync)prop;
            datasourceSync.targetName.value = name;
        }
    }

    @Override
    public void loadTaggedContent(TaggedReader in) throws IOException {
        int tag;
        DDatasourceSync datasourceSync = null;
        while ((tag = in.getNextTag()) != 0) {
            switch (tag) {
                case 1: {
                    datasourceSync = new DDatasourceSync(this);
                    datasourceSync.syncKind.loadTaggedContent(in);
                    this.properties.add(datasourceSync);
                    break;
                }
                case 2: {
                    if (datasourceSync == null) break;
                    datasourceSync.sourceId.loadTaggedContent(in);
                    break;
                }
                case 3: {
                    if (datasourceSync == null) break;
                    datasourceSync.targetName.loadTaggedContent(in);
                }
            }
        }
    }

    @Override
    public void storeTaggedContent(TaggedWriter out) throws IOException {
        for (DProperty p : this.properties) {
            if (!(p instanceof DDatasourceSync)) continue;
            DDatasourceSync datasourceSync = (DDatasourceSync)p;
            datasourceSync.storeTaggedContent(out);
        }
    }
}

