/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.obj;

import inform.adt.InformException;
import inform.adt.LittleEndian;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.mtd.obj.DFieldRef;
import inform.agent.mtd.obj.DFieldRefs;
import inform.agent.mtd.obj.DObject;
import inform.agent.mtd.obj.DProperty;
import inform.agent.mtd.obj.DPropertyBool;
import inform.agent.mtd.obj.DPropertyDatasource;
import inform.agent.mtd.obj.DPropertyDouble;
import inform.agent.mtd.obj.DPropertyEnum;
import inform.agent.mtd.obj.DPropertyInt;
import inform.agent.mtd.obj.DPropertyString;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class DExpression
extends DObject {
    protected final DPropertyEnum kindType = new DPropertyEnum(this, "kindType", 32768, 0, null, EXPRESSION_KIND_TYPES_NAMES, EXPRESSION_KIND_TYPES_TITLES);
    protected final DPropertyEnum operationKind = new DPropertyEnum(this, "operationKind", 32770, 0, null, EXPRESSION_OPERATION_TYPES_NAMES, EXPRESSION_OPERATION_TYPES_TITLES);
    protected final DPropertyEnum operationRange = new DPropertyEnum(this, "operationRange", 32770, 0, null, EXPRESSION_OPERATION_RANGES_NAMES, EXPRESSION_OPERATION_RANGES_TITLES);
    protected final DPropertyEnum symbolKind = new DPropertyEnum(this, "symbolKind", 32770, -1, null, EXPRESSION_SYMBOL_KINDS_NAMES, EXPRESSION_SYMBOL_KINDS_TITLES);
    protected final DPropertyInt elementId = new DPropertyInt(this, "elementId", 32768);
    protected final DPropertyInt globalConstId = new DPropertyInt(this, "globalConstId", 32770);
    protected final DPropertyInt paramId = new DPropertyInt(this, "paramId", 32770);
    protected final DPropertyInt argumentFieldId = new DPropertyInt(this, "argumentFieldId", 32770);
    protected final DPropertyInt datatypeConstant = new DPropertyInt(this, "datatypeConstant", 32770);
    protected final DPropertyInt colorValConstant = new DPropertyInt(this, "colorValConstant", 32770);
    protected final DPropertyInt fontStyleConstant = new DPropertyInt(this, "fontStyleConstant", 32770);
    protected final DPropertyInt propId = new DPropertyInt(this, "propId", 32770);
    protected final DPropertyInt functionId = new DPropertyInt(this, "functionId", 32770);
    protected final DFieldRefs argumentFieldIds = new DFieldRefs(this, "argumentFieldIds");
    protected final DPropertyDouble numberConstant = new DPropertyDouble(this, "numberConstant", 2);
    protected final DPropertyDouble datetimeConstant = new DPropertyDouble(this, "datetimeConstant", 2);
    protected final DPropertyDouble subId = new DPropertyDouble(this, "subId", 2);
    protected final DPropertyDatasource datasourceId = new DPropertyDatasource(this, "datasourceId", 2);
    protected final DPropertyDatasource propDatasourceId = new DPropertyDatasource(this, "propDatasourceId", 2);
    protected final DPropertyString elementTag = new DPropertyString(this, "elementTag", 0x200002);
    protected final DPropertyString name = new DPropertyString(this, "name", 0x200002);
    protected final DPropertyString elementCaption = new DPropertyString(this, "elementCaption", 0x200002);
    protected final DPropertyString textConstant = new DPropertyString(this, "textConstant", 0x200002);
    protected final DPropertyString decorationText = new DPropertyString(this, "decorationText", 0x200002);
    protected final DPropertyString insertValue = new DPropertyString(this, "insertValue", 0x200002);
    protected final DPropertyBool sameAsPrev = new DPropertyBool(this, "sameAsPrev", 4096, false);
    protected final DPropertyBool boolConstant = new DPropertyBool(this, "boolConstant", 4096);
    protected final DPropertyBool operationRangeAny = new DPropertyBool(this, "operationRangeAny", 4098, false);
    protected final DPropertyBool isCollapsed = new DPropertyBool(this, "isCollapsed", 4098, false);
    protected final DPropertyBool isConstantNull = new DPropertyBool(this, "isConstantNull", 4098, false);

    public DExpression(DProperty object) {
        super(object, null, 32);
    }

    @Override
    public void loadTaggedContent(TaggedReader in) throws IOException {
        int tag;
        block31: while ((tag = in.getNextTag()) != 0) {
            switch (tag) {
                case 1: {
                    this.elementId.loadTaggedContent(in);
                    break;
                }
                case 2: {
                    this.name.loadTaggedContent(in);
                    break;
                }
                case 3: {
                    this.elementTag.loadTaggedContent(in);
                    break;
                }
                case 22: {
                    this.sameAsPrev.value = true;
                    break;
                }
                case 4: {
                    this.operationKind.loadTaggedContent(in);
                    break;
                }
                case 5: {
                    this.symbolKind.loadTaggedContent(in);
                    break;
                }
                case 7: {
                    this.textConstant.loadTaggedContent(in);
                    break;
                }
                case 10: {
                    this.globalConstId.loadTaggedContent(in);
                    break;
                }
                case 11: {
                    this.paramId.loadTaggedContent(in);
                    break;
                }
                case 12: {
                    this.datasourceId.loadTaggedContent(in);
                    break;
                }
                case 13: {
                    this.argumentFieldId.loadTaggedContent(in);
                    break;
                }
                case 14: {
                    byte[] data = in.getRaw();
                    if (data.length % 4 != 0) {
                        throw new InformException("Invalid TAG_ELEMENT_ARGUMENT_FIELD_ID_PATH size");
                    }
                    int numberOfInts = data.length / 4;
                    for (int i = 0; i < numberOfInts; ++i) {
                        DFieldRef prop = new DFieldRef(this);
                        prop.setValue(LittleEndian.getInt(data, i * 4));
                        this.argumentFieldIds.properties.add(prop);
                    }
                    continue block31;
                }
                case 15: {
                    this.elementCaption.loadTaggedContent(in);
                    break;
                }
                case 16: {
                    this.isCollapsed.value = true;
                    break;
                }
                case 17: {
                    this.numberConstant.loadTaggedContent(in);
                    break;
                }
                case 18: {
                    this.datetimeConstant.loadTaggedContent(in);
                    break;
                }
                case 19: {
                    this.boolConstant.loadTaggedContent(in);
                    break;
                }
                case 20: {
                    this.isConstantNull.value = true;
                    break;
                }
                case 21: {
                    this.datatypeConstant.loadTaggedContent(in);
                    break;
                }
                case 24: {
                    this.decorationText.loadTaggedContent(in);
                    break;
                }
                case 25: {
                    this.insertValue.loadTaggedContent(in);
                    break;
                }
                case 26: {
                    this.operationRange.loadTaggedContent(in);
                    break;
                }
                case 27: {
                    this.operationRangeAny.value = true;
                    break;
                }
                case 28: {
                    this.colorValConstant.loadTaggedContent(in);
                    break;
                }
                case 29: {
                    this.fontStyleConstant.loadTaggedContent(in);
                    break;
                }
                case 30: {
                    this.propDatasourceId.loadTaggedContent(in);
                    break;
                }
                case 31: {
                    this.propId.loadTaggedContent(in);
                    break;
                }
                case 32: {
                    this.subId.loadTaggedContent(in);
                    break;
                }
                case 6: {
                    this.functionId.loadTaggedContent(in);
                }
            }
        }
    }

    public void setKindType(int kindType) {
        this.kindType.value = kindType;
    }

    @Override
    public void storeTaggedContent(TaggedWriter out) throws IOException {
        this.kindType.storeTaggedContentAs(1, out);
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        TaggedWriter stream = new TaggedWriter(data);
        this.elementId.storeTaggedContentAs(1, stream);
        this.name.storeTaggedContentAs(2, stream);
        this.elementTag.storeTaggedContentAs(3, stream);
        this.boolConstant.storeTaggedContentAs(19, stream);
        if (!this.operationKind.isDefault()) {
            this.operationKind.storeTaggedContentAs(4, stream);
        }
        if (!this.globalConstId.isDefault()) {
            this.globalConstId.storeTaggedContentAs(10, stream);
        }
        if (!this.paramId.isDefault()) {
            this.paramId.storeTaggedContentAs(11, stream);
        }
        if (!this.argumentFieldId.isDefault()) {
            this.argumentFieldId.storeTaggedContentAs(13, stream);
        }
        if (!this.argumentFieldIds.isDefault()) {
            ByteBuffer byteBuffer = ByteBuffer.allocate(this.argumentFieldIds.properties.size() * 4);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            for (DProperty p : this.argumentFieldIds.properties) {
                byteBuffer.putInt(((DFieldRef)p).fieldId.value);
            }
            stream.putRaw(14, byteBuffer.array());
        }
        if (!this.datatypeConstant.isDefault()) {
            this.datatypeConstant.storeTaggedContentAs(21, stream);
        }
        if (!this.operationRange.isDefault()) {
            this.operationRange.storeTaggedContentAs(26, stream);
        }
        if (!this.symbolKind.isDefault()) {
            this.symbolKind.storeTaggedContentAs(5, stream);
        }
        if (!this.colorValConstant.isDefault()) {
            this.colorValConstant.storeTaggedContentAs(28, stream);
        }
        if (!this.fontStyleConstant.isDefault()) {
            this.fontStyleConstant.storeTaggedContentAs(29, stream);
        }
        if (!this.propId.isDefault()) {
            this.propId.storeTaggedContentAs(31, stream);
        }
        if (!this.functionId.isDefault()) {
            this.functionId.storeTaggedContentAs(6, stream);
        }
        if (!this.numberConstant.isDefault()) {
            this.numberConstant.storeTaggedContentAs(17, stream);
        }
        if (!this.datetimeConstant.isDefault()) {
            this.datetimeConstant.storeTaggedContentAs(18, stream);
        }
        if (!this.subId.isDefault()) {
            this.subId.storeTaggedContentAs(32, stream);
        }
        if (!this.datasourceId.isDefault()) {
            this.datasourceId.storeTaggedContentAs(12, stream);
        }
        if (!this.propDatasourceId.isDefault()) {
            this.propDatasourceId.storeTaggedContentAs(30, stream);
        }
        if (!this.elementCaption.isDefault()) {
            this.elementCaption.storeTaggedContentAs(15, stream);
        }
        if (!this.textConstant.isDefault()) {
            this.textConstant.storeTaggedContentAs(7, stream);
        }
        if (!this.decorationText.isDefault()) {
            this.decorationText.storeTaggedContentAs(24, stream);
        }
        if (!this.insertValue.isDefault()) {
            this.insertValue.storeTaggedContentAs(25, stream);
        }
        if (this.operationRangeAny.value) {
            this.operationRangeAny.storeTaggedContentAs(27, stream);
        }
        if (this.isCollapsed.value) {
            stream.putEmpty(16);
        }
        if (this.isConstantNull.value) {
            stream.putEmpty(20);
        }
        if (this.sameAsPrev.value) {
            stream.putEmpty(22);
        }
        stream.flush();
        out.putRaw(202, data);
    }

    @Override
    public boolean isDefault() {
        for (DProperty p : this.properties) {
            if (p.isDefault() || !p.isStorable()) continue;
            return false;
        }
        return true;
    }
}

