/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.obj;

import inform.adt.LittleEndian;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.mtd.obj.DArray;
import inform.agent.mtd.obj.DItem;
import inform.agent.mtd.obj.DObject;
import inform.agent.mtd.obj.DProperty;
import inform.agent.mtd.obj.DPropertyDouble;
import inform.agent.mtd.obj.DPropertyInt;
import inform.agent.mtd.obj.DPropertyString;
import inform.agent.mtd.obj.DTagTermHeader;
import java.io.IOException;

public class DFieldExpression
extends DArray {
    public DFieldExpression(DProperty object, String name) {
        super(object, name, 2);
    }

    @Override
    public void loadTaggedContent(TaggedReader in) throws IOException {
        while (in.next()) {
            if (in.getCurrentTag() != 1) continue;
            DTerm term = new DTerm(this);
            term.loadTaggedContent(in);
            this.properties.add(term);
        }
    }

    @Override
    public void storeTaggedContent(TaggedWriter out) throws IOException {
        for (DProperty prop : this.properties) {
            prop.storeTaggedContent(out);
        }
    }

    @Override
    public DProperty loadScriptArrayItem(Object obj) {
        DTerm item = new DTerm(this);
        item.loadScriptValue(obj);
        return item;
    }

    @Override
    protected void doAssign(DItem source) {
        if (DFieldExpression.checkAssignType(source, this.getClass())) {
            for (DProperty sourceProperty : ((DFieldExpression)source).properties) {
                if (!DFieldExpression.checkAssignType(sourceProperty, DTerm.class)) continue;
                DTerm sourceTerm = (DTerm)sourceProperty;
                DTerm term = new DTerm(this);
                term.assign(sourceTerm);
                this.properties.add(term);
            }
        }
    }

    @Override
    public DProperty getDefaultArrayItem() {
        return new DTerm(this);
    }

    protected static class DTerm
    extends DObject {
        protected static final int TK_OPERATOR = 0;
        protected static final int TK_CONST = 1;
        protected static final int TK_FIELD = 2;
        protected static final int TK_EXTERNAL_VALUE = 3;
        protected final DTagTermHeader header = new DTagTermHeader(this, "header");
        protected final DPropertyInt valueId = new DPropertyInt(this, "valueId", 32770);
        protected final DPropertyInt datasourceId = new DPropertyInt(this, "datasourceId", 32770);
        protected final DPropertyInt filedId = new DPropertyInt(this, "filedId", 32770);
        protected final DPropertyDouble operationArg = new DPropertyDouble(this, "operationArg", 2);
        protected final DPropertyString constValue = new DPropertyString(this, "constValue", 0x200002);

        public DTerm(DProperty object) {
            super(object, null, 32);
        }

        @Override
        public boolean isDefault() {
            for (DProperty p : this.properties) {
                if (p.isDefault() || !p.isStorable()) continue;
                return false;
            }
            return true;
        }

        @Override
        public void loadTaggedContent(TaggedReader in) throws IOException {
            this.header.loadTaggedContent(in);
            if (in.getNextTag() == 5) {
                this.operationArg.value = in.getDouble(5);
            } else {
                in.tagback();
            }
            switch (this.header.kind.getValue()) {
                case 1: {
                    this.constValue.value = in.getAnsi(2);
                    break;
                }
                case 2: {
                    byte[] data = in.getRaw(3);
                    if (data.length != 8) break;
                    this.datasourceId.value = LittleEndian.getInt(data, 0);
                    this.filedId.value = LittleEndian.getInt(data, 4);
                    break;
                }
                case 3: {
                    this.valueId.value = in.getInt(4);
                }
            }
        }

        @Override
        public void storeTaggedContent(TaggedWriter out) throws IOException {
            this.header.storeTaggedContentAs(1, out);
            switch (this.header.kind.getValue()) {
                case 1: {
                    this.constValue.storeTaggedContentAs(2, out);
                    break;
                }
                case 2: {
                    if (this.datasourceId.isDefault()) break;
                    byte[] d = new byte[8];
                    LittleEndian.setInteger(this.datasourceId.value, d, 0);
                    LittleEndian.setInteger(this.filedId.value, d, 4);
                    out.putRaw(3, d);
                    break;
                }
                case 3: {
                    this.valueId.storeTaggedContentAs(4, out);
                }
            }
            this.operationArg.storeTaggedContentAs(5, out);
        }
    }
}

