/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.obj;

import inform.adt.LittleEndian;
import inform.adt.Memory;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.mtd.obj.DColors;
import inform.agent.mtd.obj.DObject;
import inform.agent.mtd.obj.DProperty;
import inform.agent.mtd.obj.DPropertyEnum;
import inform.agent.mtd.obj.DPropertyEnumSet;
import inform.agent.mtd.obj.DPropertyInt;
import inform.agent.mtd.obj.DPropertyString;
import java.io.IOException;

public class DFont
extends DObject {
    protected final DPropertyInt size = new DPropertyInt(this, "size", 131072, 8);
    protected final DPropertyString fontName = new DPropertyString(this, "name", 131072, STABLE_FONT_NAMES[0]);
    protected final DPropertyEnum color = new DPropertyEnum(this, "color", 49154, 0, DColors.VALUES, DColors.NAMES);
    protected final DPropertyEnumSet style = new DPropertyEnumSet((DProperty)this, "style", 131074, 0, FONT_STYLE_NAMES);
    protected final DPropertyInt charset = new DPropertyInt(this, "charset", 262146, 0);
    private static final String[] STABLE_FONT_NAMES = new String[]{"MS Sans Serif", "Times New Roman", "Arial", "Courier New", "System", "Tahoma", "Symbol", "Verdana", "Lucida Sans Unicode", "Georgia", "Lucida Console", "Consolas", "Arial Black", "Comic Sans MS", "Impact", "Palatino Linotype", "Calibri", "Cambria", "Corbel", "Constantia", "Segoe UI"};

    public DFont(DProperty object, String name) {
        super(object, name);
        this.charset.value = 204;
    }

    @Override
    public boolean isStorable() {
        return super.isStorable();
    }

    @Override
    public void loadTaggedContent(TaggedReader in) throws IOException {
        byte[] content = in.getRaw();
        if (Memory.isVoid(content)) {
            return;
        }
        int offset = 0;
        int length = content.length;
        switch (content.length) {
            case 39: {
                this.color.value = LittleEndian.getInt(content, offset);
                offset += 4;
                this.style.value = content[offset++];
                this.size.value = content[offset++];
                this.charset.value = content[offset++];
                this.charset.value &= 0xFF;
                for (int index = offset; index < length; ++index) {
                    if (content[index] != 0) continue;
                    length = index - offset;
                    break;
                }
                this.fontName.value = new String(content, offset, length, TaggedWriter.ANSI);
                break;
            }
            case 8: {
                this.color.value = LittleEndian.getInt(content, offset);
                offset += 4;
                this.style.value = content[offset++];
                this.size.value = content[offset++];
                this.charset.value = content[offset++];
                this.charset.value &= 0xFF;
                int index = content[offset] & 0xFF;
                this.fontName.value = index < STABLE_FONT_NAMES.length ? STABLE_FONT_NAMES[index] : STABLE_FONT_NAMES[0];
            }
        }
    }

    @Override
    public void storeTaggedContentAs(int tag, TaggedWriter out) throws IOException {
        byte[] raw;
        if (!this.isStorable() || STABLE_FONT_NAMES[0].equalsIgnoreCase(this.fontName.value) && this.size.value == 8 && this.style.value == 204) {
            return;
        }
        int fontIndex = STABLE_FONT_NAMES.length;
        for (int index = 0; index < fontIndex; ++index) {
            if (!STABLE_FONT_NAMES[index].equalsIgnoreCase(this.fontName.value)) continue;
            fontIndex = index;
            break;
        }
        int offset = 0;
        if (fontIndex < STABLE_FONT_NAMES.length) {
            raw = new byte[8];
            LittleEndian.setInteger(this.color.value, raw, offset);
            offset += 4;
            raw[offset++] = (byte)this.style.value;
            raw[offset++] = (byte)this.size.value;
            raw[offset++] = (byte)(this.charset.value & 0xFF);
            raw[offset] = (byte)fontIndex;
        } else {
            raw = new byte[39];
            LittleEndian.setInteger(this.color.value, raw, offset);
            offset += 4;
            raw[offset++] = (byte)this.style.value;
            raw[offset++] = (byte)this.size.value;
            raw[offset++] = (byte)(this.charset.value & 0xFF);
            byte[] rawName = this.fontName.value.getBytes(TaggedWriter.ANSI);
            for (int index = 0; offset < rawName.length && index < rawName.length; ++index, ++offset) {
                raw[offset] = rawName[index];
            }
        }
        out.putRaw(tag, raw);
    }
}

