/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.obj;

import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.mtd.obj.DArray;
import inform.agent.mtd.obj.DItem;
import inform.agent.mtd.obj.DParameterSync;
import inform.agent.mtd.obj.DProperty;
import java.io.IOException;

public class DParameterSyncList
extends DArray {
    public DParameterSyncList(DProperty object, String name) {
        super(object, name, 2);
    }

    @Override
    public DProperty loadScriptArrayItem(Object obj) {
        DParameterSync item = new DParameterSync(this);
        item.loadScriptValue(obj);
        return item;
    }

    @Override
    protected void doAssign(DItem source) {
        if (DParameterSyncList.checkAssignType(source, this.getClass())) {
            for (DProperty sourceProperty : ((DParameterSyncList)source).properties) {
                if (!DParameterSyncList.checkAssignType(sourceProperty, DParameterSync.class)) continue;
                DParameterSync sourcePar = (DParameterSync)sourceProperty;
                DParameterSync par = new DParameterSync(this);
                par.assign(sourcePar);
                this.properties.add(par);
            }
        }
    }

    @Override
    public DProperty getDefaultArrayItem() {
        return new DParameterSync(this);
    }

    public void setSourceParamId(int index, int paramId) {
        if (index < 0 || index >= this.size()) {
            return;
        }
        DProperty prop = (DProperty)this.properties.get(index);
        if (prop instanceof DParameterSync) {
            DParameterSync parameterSync = (DParameterSync)prop;
            parameterSync.sourceParamId.value = paramId;
        }
    }

    public int addItem(String name) {
        DParameterSync param = new DParameterSync(this);
        param.targetParamName.value = name;
        if (this.properties.add(param)) {
            return this.properties.size() - 1;
        }
        return -1;
    }

    @Override
    public void loadTaggedContent(TaggedReader in) throws IOException {
        int tag;
        DParameterSync parSync = null;
        while ((tag = in.getNextTag()) != 0) {
            switch (tag) {
                case 1: {
                    parSync = new DParameterSync(this);
                    this.properties.add(parSync);
                    parSync.sourceParamId.loadTaggedContent(in);
                    break;
                }
                case 2: {
                    if (parSync == null) break;
                    parSync.targetParamName.loadTaggedContent(in);
                    break;
                }
                case 3: {
                    if (parSync == null) break;
                    parSync.isVisible.loadTaggedContent(in);
                    break;
                }
                case 4: {
                    if (parSync == null) break;
                    parSync.datasourceId.loadTaggedContent(in);
                    break;
                }
                case 5: {
                    if (parSync == null) break;
                    parSync.fieldId.loadTaggedContent(in);
                }
            }
        }
    }

    @Override
    public void storeTaggedContent(TaggedWriter out) throws IOException {
        for (DProperty p : this.properties) {
            if (!(p instanceof DParameterSync)) continue;
            DParameterSync parameterSync = (DParameterSync)p;
            parameterSync.storeTaggedContent(out);
        }
    }
}

