/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.obj;

import inform.adt.Strings;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.mtd.obj.DComponent;
import inform.agent.mtd.obj.DComponentContainer;
import inform.agent.mtd.obj.DItem;
import inform.agent.mtd.obj.DPropertyBool;
import inform.agent.mtd.obj.PropertyVisibilityReflection;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public abstract class DProperty
extends DItem {
    public final DProperty object;
    protected final String name;
    protected String[] aliases = null;
    protected int propOptions;
    protected final ArrayList<DProperty> properties = new ArrayList();
    protected final HashMap<String, DProperty> propertyByName = new HashMap();
    private DPropertyBool storableBy = null;
    private boolean storableByValue = true;

    public DProperty() {
        this.object = null;
        this.name = null;
        this.propOptions = 0;
    }

    public DProperty(DProperty object, String name, int propOptions) {
        this.object = object;
        this.name = name;
        this.propOptions = propOptions;
        if (object != null) {
            object.registerProperty(this);
        }
    }

    public String getPropName() {
        return this.name;
    }

    public DComponentContainer getComponentContainer() {
        DComponent owner;
        if (this.object instanceof DComponentContainer) {
            return (DComponentContainer)((Object)this.object);
        }
        if (this.object instanceof DComponent && (owner = ((DComponent)this.object).getOwner()) instanceof DComponentContainer) {
            return (DComponentContainer)((Object)owner);
        }
        if (this.object != null) {
            return this.object.getComponentContainer();
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    public abstract boolean isDefault();

    public boolean checkPropOptions(int value) {
        return (this.propOptions & value) == value;
    }

    public boolean isArray() {
        return this.checkPropOptions(16);
    }

    public boolean isItem() {
        return this.checkPropOptions(32);
    }

    public boolean isHexFormat() {
        return this.checkPropOptions(16384);
    }

    public boolean isStorable() {
        if (this.object instanceof PropertyVisibilityReflection) {
            return ((PropertyVisibilityReflection)((Object)this.object)).isPropVisible(this);
        }
        if (this.checkPropOptions(8)) {
            return false;
        }
        if (this.storableBy != null) {
            return this.storableBy.value == this.storableByValue;
        }
        return true;
    }

    public void setStorable(boolean value) {
        this.propOptions = value ? (this.propOptions &= 0xFFFFFFF7) : (this.propOptions |= 8);
    }

    public boolean scriptable() {
        return !this.checkPropOptions(4);
    }

    public void setScriptable(boolean value) {
        this.propOptions = value ? (this.propOptions &= 0xFFFFFFFB) : (this.propOptions |= 4);
    }

    public void setStorableBy(DPropertyBool storableBy, boolean storableByValue) {
        this.storableBy = storableBy;
        this.storableByValue = storableByValue;
    }

    public void registerProperty(DProperty property) {
        if (property.isItem()) {
            return;
        }
        if (!this.isArray()) {
            if (Strings.isVoid(property.name)) {
                throw new IllegalArgumentException("The property must have a name specified");
            }
            if (this.propertyByName.containsKey(property.name)) {
                throw new IllegalArgumentException("The property \"" + property.name + "\" already exists");
            }
            this.propertyByName.put(property.name, property);
        }
        if (property.checkPropOptions(1)) {
            int count = this.properties.size();
            for (int index = 0; index < count; ++index) {
                if (this.properties.get(index).checkPropOptions(1)) continue;
                this.properties.add(index, property);
                return;
            }
        } else if (!property.checkPropOptions(64)) {
            for (int index = this.properties.size() - 1; index >= 0; --index) {
                if (this.properties.get(index).checkPropOptions(64)) continue;
                this.properties.add(index + 1, property);
                return;
            }
        }
        this.properties.add(property);
    }

    public final void storeTaggedContentIf(int tag, TaggedWriter out) throws IOException {
        if (this.checkPropOptions(2) && this.isDefault()) {
            return;
        }
        this.storeTaggedContentAs(tag, out);
    }

    public int storeTextContentProperties(int textOptions, StringBuilder out, int level) {
        ArrayList<DProperty> props = (textOptions & 1) != 0 ? new ArrayList<DProperty>() : null;
        int multiCount = 0;
        int outputCount = 0;
        int count = 0;
        boolean forceInOneLine = this.checkPropOptions(256);
        for (DProperty property : this.properties) {
            if (!property.isStorable() || !property.scriptable() || property.checkPropOptions(2) && property.isDefault()) continue;
            if (props != null) {
                props.add(property);
                continue;
            }
            if (count != 0) {
                out.append(',');
            }
            ++count;
            int propCount = property.storeTextContent(textOptions | (property.checkPropOptions(128) ? 1 : 0), out, level, false);
            outputCount += propCount;
            if (propCount <= 1) continue;
            multiCount += propCount;
        }
        if (props != null) {
            if (!forceInOneLine && props.size() > 1) {
                textOptions &= 0xFFFFFFFE;
            }
            int to = 0;
            for (DProperty property : props) {
                if (count != 0) {
                    out.append(',');
                    if (!property.checkPropOptions(128)) {
                        to = 8;
                        DProperty.addNewLineIfNeed(textOptions, out);
                    }
                } else {
                    to = 0;
                }
                ++count;
                int propCount = property.storeTextContent(textOptions | to | (property.checkPropOptions(128) ? 1 : 0), out, level, false);
                outputCount += propCount;
                if (propCount <= 1) continue;
                multiCount += propCount;
            }
        }
        if (forceInOneLine) {
            return multiCount > 1 ? outputCount : 1;
        }
        return outputCount;
    }

    public int storeSpec(int textOptions, StringBuilder out, int level, boolean needComma) {
        DProperty.addComma(DProperty.textContentAddPropName(textOptions, out, level, this.name, "property"), needComma);
        return 1;
    }

    public Collection<DProperty> getProperties() {
        return this.properties;
    }
}

