/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.obj;

import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.db.types.ValueCaster;
import inform.agent.mtd.obj.DItem;
import inform.agent.mtd.obj.DProperty;
import java.io.IOException;

public class DPropertyBool
extends DProperty {
    protected boolean value;
    protected boolean defaultValue;

    public DPropertyBool(DProperty object, String name, int tagOption) {
        this(object, name, tagOption, false);
    }

    public DPropertyBool(DProperty object, String name, int tagOption, boolean defaultValue) {
        super(object, name, tagOption);
        this.value = this.defaultValue = defaultValue;
    }

    public boolean getValue() {
        return this.value;
    }

    public void setValue(boolean value) {
        this.value = value;
    }

    public void assignValue(Object value) {
        this.value = ValueCaster.toBoolean(value);
    }

    @Override
    public boolean isDefault() {
        return this.checkPropOptions(2) && this.value == this.defaultValue;
    }

    @Override
    public void loadTaggedContent(TaggedReader in) throws IOException {
        this.value = this.checkPropOptions(4096) ? true : (this.checkPropOptions(8192) ? false : in.getBoolean());
    }

    @Override
    protected void doAssign(DItem source) {
        if (DPropertyBool.checkAssignType(source, this.getClass())) {
            this.value = ((DPropertyBool)source).value;
        }
    }

    @Override
    public void loadScriptValue(Object obj) {
        this.value = ValueCaster.toBoolean(obj);
    }

    @Override
    public void storeTaggedContentAs(int tag, TaggedWriter out) throws IOException {
        if (!this.isStorable() || this.isDefault()) {
            return;
        }
        if (this.checkPropOptions(4096)) {
            if (this.value) {
                out.putEmpty(tag);
            }
        } else if (this.checkPropOptions(8192)) {
            if (!this.value) {
                out.putEmpty(tag);
            }
        } else {
            out.putBool(tag, this.value);
        }
    }

    @Override
    public int storeTextContent(int textOptions, StringBuilder out, int level, boolean needComma) {
        DPropertyBool.addComma(DPropertyBool.textContentAddProp(textOptions, out, level, this.name, this.value), needComma);
        return 1;
    }

    @Override
    public int storeSpec(int textOptions, StringBuilder out, int level, boolean needComma) {
        DPropertyBool.addComma(DPropertyBool.textContentAddPropName(textOptions, out, level, this.name, "bool"), needComma);
        return 1;
    }
}

