/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.obj;

import inform.adt.Strings;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.db.types.ValueCaster;
import inform.agent.mtd.obj.DItem;
import inform.agent.mtd.obj.DProperty;
import java.io.IOException;

public class DPropertyEnum
extends DProperty {
    protected int[] mapValues;
    protected String[] mapNames;
    protected String[] mapTranslatedNames;
    protected int value;
    protected int defaultValue;

    public DPropertyEnum(DProperty object, String name, int propOptions, String[] mapNames) {
        this(object, name, propOptions, 0, null, mapNames);
    }

    public DPropertyEnum(DProperty object, String name, int propOptions, int[] mapValues, String[] mapNames) {
        this(object, name, propOptions, 0, mapValues, mapNames);
    }

    public DPropertyEnum(DProperty object, String name, int propOptions, int defaultValue, String[] mapNames) {
        this(object, name, propOptions, defaultValue, null, mapNames);
    }

    public DPropertyEnum(DProperty object, String name, int propOptions, int defaultValue, int[] mapValues, String[] mapNames) {
        this(object, name, propOptions, defaultValue, mapValues, mapNames, null);
    }

    public DPropertyEnum(DProperty object, String name, int propOptions, int defaultValue, int[] mapValues, String[] mapNames, String[] mapTranslatedNames) {
        super(object, name, propOptions);
        this.mapValues = mapValues;
        this.mapNames = mapNames;
        this.mapTranslatedNames = mapTranslatedNames;
        this.value = this.defaultValue = defaultValue;
    }

    public void setMaps(String[] mapNames) {
        this.mapValues = null;
        this.mapNames = mapNames;
        this.mapTranslatedNames = null;
    }

    public void setMaps(int[] mapValues, String[] mapNames) {
        this.mapValues = mapValues;
        this.mapNames = mapNames;
        this.mapTranslatedNames = null;
    }

    public void setMaps(int[] mapValues, String[] mapNames, String[] mapTranslatedNames) {
        this.mapValues = mapValues;
        this.mapNames = mapNames;
        this.mapTranslatedNames = mapTranslatedNames;
    }

    public static String mapValue(int value, String[] mapNames) {
        return DPropertyEnum.mapValue(value, null, mapNames);
    }

    public static String mapValue(int value, int[] mapValues, String[] mapNames) {
        if (mapValues == null) {
            if (0 <= value && value < mapNames.length) {
                return mapNames[value];
            }
        } else {
            for (int index = 0; index < mapValues.length; ++index) {
                if (mapValues[index] != value) continue;
                return mapNames[index];
            }
        }
        return null;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public void setValue(String value) {
        this.value = this.stringToValue(value);
    }

    public void setDefaultValue(int value) {
        this.value = this.defaultValue = value;
    }

    public void assignValue(Object value) {
        this.setValue(ValueCaster.toString(value));
    }

    @Override
    public boolean isDefault() {
        return this.checkPropOptions(2) && this.value == this.defaultValue;
    }

    @Override
    public boolean scriptable() {
        return super.scriptable() && (!this.checkPropOptions(512) || this.value != this.defaultValue);
    }

    @Override
    public void loadTaggedContent(TaggedReader in) throws IOException {
        this.value = this.checkPropOptions(4096) ? 1 : (this.checkPropOptions(131072) ? (int)in.getByte() : (this.checkPropOptions(65536) ? (int)in.getShort() : in.getInt()));
    }

    @Override
    protected void doAssign(DItem source) {
        if (DPropertyEnum.checkAssignType(source, this.getClass())) {
            this.value = ((DPropertyEnum)source).value;
        }
    }

    @Override
    public void loadScriptValue(Object obj) {
        this.value = obj instanceof String ? this.stringToValue((String)obj) : (this.checkPropOptions(16384) ? (int)ValueCaster.toNumber(obj).longValue() : ValueCaster.toInt(obj));
    }

    @Override
    public void storeTaggedContentAs(int tag, TaggedWriter out) throws IOException {
        if (!this.isStorable() || this.isDefault()) {
            return;
        }
        if (this.checkPropOptions(4096)) {
            if (this.value == 1) {
                out.putEmpty(tag);
            }
        } else if (this.checkPropOptions(131072)) {
            out.putInt08(tag, (byte)this.value);
        } else if (this.checkPropOptions(65536)) {
            out.putInt16(tag, (short)this.value);
        } else {
            out.putInt32(tag, this.value);
        }
    }

    @Override
    public int storeTextContent(int textOptions, StringBuilder out, int level, boolean needComma) {
        if (this.checkPropOptions(0x800000)) {
            String v = this.mapValue(this.value);
            if (v != null) {
                DPropertyEnum.textContentAddProp(textOptions, out, level, this.name, v);
            } else {
                DPropertyEnum.textContentAddProp(textOptions, out, level, this.name, this.value);
            }
        } else {
            if (this.isHexFormat()) {
                DPropertyEnum.textContentAddHexProp(textOptions, out, level, this.name, this.value);
            } else {
                DPropertyEnum.textContentAddProp(textOptions, out, level, this.name, this.value);
            }
            String v = this.mapValue(this.value);
            if (v != null) {
                out.append("/*").append(v).append("*/");
            }
        }
        DPropertyEnum.addComma(out, needComma);
        return 1;
    }

    @Override
    public int storeSpec(int textOptions, StringBuilder out, int level, boolean needComma) {
        if ((textOptions & 0x10) == 0) {
            DPropertyEnum.addTextShiftLn(textOptions, out, level).append(this.name).append(": ");
        }
        DPropertyEnum.addTextShiftLn(textOptions, out, level).append("<");
        for (int i = 0; i < this.mapNames.length; ++i) {
            int value;
            DPropertyEnum.addComma(out, i != 0);
            int n = value = this.mapValues != null ? this.mapValues[i] : i;
            if (this.isHexFormat()) {
                DPropertyEnum.addTextShiftLn(textOptions, out, level + 1).append("0x").append(Integer.toHexString(value));
            } else {
                DPropertyEnum.addTextShiftLn(textOptions, out, level + 1).append(value);
            }
            out.append(" /*").append(this.mapNames[i]).append("*/");
        }
        DPropertyEnum.addTextShiftLn(textOptions, out, level).append(">");
        return 1;
    }

    protected int stringToValue(String value) {
        int validIndex = -1;
        if (!Strings.isVoid(value)) {
            for (int index = 0; index < this.mapNames.length; ++index) {
                String name = this.mapNames[index];
                if (value.equals(name)) {
                    return this.mapValues == null ? index : this.mapValues[index];
                }
                if (validIndex >= 0 || !value.equalsIgnoreCase(name)) continue;
                validIndex = index;
            }
        }
        if (validIndex < 0) {
            try {
                return Integer.parseInt(value);
            }
            catch (Throwable e) {
                throw new IllegalArgumentException("Illegal value \"" + value + "\"");
            }
        }
        return this.mapValues == null ? validIndex : this.mapValues[validIndex];
    }

    protected String mapValue(int value) {
        return DPropertyEnum.mapValue(value, this.mapValues, this.mapNames);
    }
}

