/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.obj;

import inform.adt.LittleEndian;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.mtd.obj.DObject;
import inform.agent.mtd.obj.DProperty;
import inform.agent.mtd.obj.DPropertyEnum;
import inform.agent.mtd.obj.DPropertyInt;
import java.io.IOException;

public class DTagTermHeader
extends DObject {
    protected final DPropertyInt braceCount = new DPropertyInt(this, "braceCount", 32770);
    protected final DPropertyEnum kind = new DPropertyEnum(this, "kind", 131072, FIELD_EXPRESSION_TERM_KIND);
    protected final DPropertyEnum operator = new DPropertyEnum(this, "operator", 131072, FIELD_EXPRESSION_TERM_OPERATOR);

    public DTagTermHeader(DProperty object, String name) {
        super(object, name, 2);
    }

    @Override
    public void loadTaggedContent(TaggedReader in) throws IOException {
        byte[] header = in.getRaw();
        int offset = 0;
        this.braceCount.value = LittleEndian.getInt(header, offset);
        this.kind.value = LittleEndian.getByte(header, offset += 4);
        this.operator.value = LittleEndian.getByte(header, ++offset);
    }

    @Override
    public void storeTaggedContentAs(int tag, TaggedWriter out) throws IOException {
        byte[] header = new byte[6];
        int offset = 0;
        LittleEndian.setInteger(this.braceCount.value, header, offset);
        LittleEndian.setByte((byte)(this.kind.value & 0xFF), header, offset += 4);
        LittleEndian.setByte((byte)(this.operator.value & 0xFF), header, ++offset);
        out.putRaw(tag, header);
    }

    @Override
    public boolean isDefault() {
        for (DProperty p : this.properties) {
            if (p.isDefault() || !p.isStorable()) continue;
            return false;
        }
        return true;
    }
}

