/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.obj;

import inform.adt.Memory;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.mtd.obj.DItem;
import inform.common.Empty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.postgresql.shaded.com.ongres.scram.common.bouncycastle.base64.Base64;

public class RawObject
extends DItem {
    protected int tag;
    protected int tagSize;
    protected byte[] data;
    protected ArrayList<RawObject> children = null;

    public RawObject() {
        this.tag = 0;
        this.data = null;
        this.tagSize = 0;
    }

    public RawObject(int tag) {
        this.tag = tag;
        this.data = null;
        this.tagSize = 0;
    }

    public RawObject(int tag, byte[] data) {
        this.tag = tag;
        this.data = data;
        this.tagSize = Memory.isVoid(data) ? 0 : data.length;
    }

    @Override
    public void loadTaggedContent(TaggedReader in) throws IOException {
        this.tag = in.getCurrentTag();
        this.tagSize = in.getCurrentTagSize();
        if (this.tag == 202) {
            this.data = null;
            this.loadChildrenTaggedContent(in.getStreamReader());
        } else {
            this.children = null;
            this.data = this.tagSize != 0 ? in.getRaw() : Empty.byteArray;
        }
    }

    @Override
    public void storeTaggedContent(TaggedWriter out) throws IOException {
        if (this.tag != 202) {
            out.putRaw(this.tag, this.data);
        }
        if (this.children != null && !this.children.isEmpty()) {
            ByteArrayOutputStream data = new ByteArrayOutputStream();
            TaggedWriter stream = new TaggedWriter(data);
            for (RawObject o : this.children) {
                o.storeTaggedContent(stream);
            }
            stream.flush();
            out.putRaw(202, data);
        }
    }

    public void loadChildrenTaggedContent(TaggedReader in) throws IOException {
        this.children = new ArrayList();
        while (in.next()) {
            RawObject item = new RawObject();
            this.children.add(item);
            item.loadTaggedContent(in);
        }
    }

    @Override
    public int storeTextContent(int textOptions, StringBuilder out, int level, boolean needComma) {
        int outputCount = 1;
        textOptions = 0;
        RawObject.addTextShiftLn(textOptions, out, level).append("{ tag: ").append(this.tag);
        if (this.tagSize != 0) {
            out.append(", tagSize: ").append(this.tagSize);
        }
        if (this.children != null) {
            outputCount += this.children.size();
            out.append(", stream: [");
            int lastIndex = this.children.size() - 1;
            for (int index = 0; index <= lastIndex; ++index) {
                RawObject item = this.children.get(index);
                item.storeTextContent(textOptions, out, level + 2, index != lastIndex);
            }
            RawObject.addTextShiftLn(textOptions, out, level + 1).append(']');
            RawObject.addTextShiftLn(textOptions, out, level);
        } else if (!Memory.isVoid(this.data)) {
            RawObject.storeDataArray(out, this.data);
        }
        RawObject.addComma(out.append('}'), needComma);
        return outputCount;
    }

    private static boolean isString1251(byte[] data) {
        for (byte datum : data) {
            int c = datum & 0xFF;
            if (c < 32 || c == 127) {
                return false;
            }
            if (c <= 127 || c >= 192) continue;
            return false;
        }
        return true;
    }

    private static boolean isStringAscii(byte[] data) {
        for (byte datum : data) {
            int c = datum & 0xFF;
            if (c >= 32 && c < 127) continue;
            return false;
        }
        return true;
    }

    private static long toLong(byte[] data) {
        long r = 0L;
        for (int i = data.length - 1; i >= 0; --i) {
            int c = data[i] & 0xFF;
            r = r << 8 | (long)c;
        }
        return r;
    }

    private static int countQuotes(byte[] data) {
        int r = 0;
        for (byte b : data) {
            if (b != 34) continue;
            ++r;
        }
        return r;
    }

    private static String toQString(byte[] data) {
        int qcnt = RawObject.countQuotes(data);
        if (qcnt == 0) {
            return new String(data, 0, data.length, TaggedWriter.ANSI);
        }
        byte[] qdata = Arrays.copyOf(data, data.length + qcnt);
        int j = 0;
        for (byte b : data) {
            if (b == 34) {
                qdata[j++] = 92;
            }
            qdata[j++] = b;
        }
        return new String(qdata, 0, qdata.length, TaggedWriter.ANSI);
    }

    private static void storeDataArray(StringBuilder out, byte[] data) {
        long l;
        double d;
        if (Memory.isVoid(data)) {
            return;
        }
        if (data.length == 8 && Double.isFinite(d = Double.longBitsToDouble(l = RawObject.toLong(data))) && (double)((long)d) == d) {
            out.append(", num: ").append((long)d);
            return;
        }
        if (RawObject.isStringAscii(data)) {
            String str = RawObject.toQString(data);
            out.append(", str: \"").append(str).append('\"');
            return;
        }
        if (data.length == 1) {
            out.append(", num: ").append(RawObject.toLong(data));
            return;
        }
        if (data.length == 4) {
            out.append(", num: ").append((int)RawObject.toLong(data));
            return;
        }
        if (RawObject.isString1251(data)) {
            String str = RawObject.toQString(data);
            out.append(", str: \"").append(str).append('\"');
            return;
        }
        out.append(", data: \"").append(Base64.toBase64String((byte[])data)).append('\"');
    }
}

