/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.obj.search;

import inform.adt.LittleEndian;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.mtd.obj.DArray;
import inform.agent.mtd.obj.DItem;
import inform.agent.mtd.obj.DProperty;
import inform.agent.mtd.obj.DPropertyValue;
import inform.agent.mtd.obj.search.DSearch;
import inform.agent.mtd.obj.search.DSearchConditionItem;
import inform.agent.mtd.obj.search.DSearchConditionOperand;
import inform.agent.mtd.obj.search.DSearchRoot;
import java.io.IOException;

public class DSearchCondition
extends DArray {
    public DSearchCondition(DProperty object, String name) {
        super(object, name, 2);
    }

    private void checkPrior() {
        DSearch search = ((DSearchRoot)this.object).search;
        if (search.hierarchic.getValue()) {
            for (DProperty property : this.properties) {
                if (!(property instanceof DSearchConditionItem)) continue;
                DSearchConditionItem item = (DSearchConditionItem)property;
                if (item.left.prior.getValue()) {
                    item.left.prior.setValue(!item.left.entry.isDefault());
                }
                if (!item.right.prior.getValue()) continue;
                item.right.prior.setValue(!item.right.isDefault());
            }
        } else {
            for (DProperty property : this.properties) {
                if (!(property instanceof DSearchConditionItem)) continue;
                DSearchConditionItem item = (DSearchConditionItem)property;
                if (item.left.prior.getValue()) {
                    item.left.prior.setValue(!item.left.entry.isDefault());
                }
                if (!item.right.prior.getValue()) continue;
                item.right.prior.setValue(!item.right.isDefault());
            }
        }
    }

    @Override
    public void loadTaggedContent(TaggedReader in) throws IOException {
        DSearchConditionItem item = null;
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 1: {
                    byte[] raw = in.getRaw();
                    item = new DSearchConditionItem(this);
                    this.properties.add(item);
                    item.braceCount.setValue(LittleEndian.getInt(raw, 0));
                    item.compare.setValue(LittleEndian.getInt(raw, 4));
                    item.operator.setValue(LittleEndian.getInt(raw, 8));
                    break;
                }
                case 11: {
                    if (item == null) break;
                    item.updateDataType();
                    item.rightExpression.load(in.getSubStreamReader(), item.dataType);
                    break;
                }
                case 12: {
                    if (item == null) break;
                    item.modificator.loadTaggedContent(in);
                    break;
                }
                case 2: {
                    if (item == null) break;
                    byte[] raw = in.getRaw();
                    DSearchConditionOperand operand = item.getOperandToLoad();
                    int entryId = LittleEndian.getInt(raw, 0);
                    if (entryId != -1) {
                        operand.entry.setValue(entryId);
                        operand.field.setValue(LittleEndian.getInt(raw, 4));
                    } else {
                        operand.parameter.setValue(LittleEndian.getInt(raw, 4));
                    }
                    operand.prior.setValue(false);
                    break;
                }
                case 10: {
                    if (item == null) break;
                    byte[] raw = in.getRaw();
                    DSearchConditionOperand operand = item.getOperandToLoad();
                    int entryId = LittleEndian.getInt(raw, 0);
                    operand.entry.setValue(entryId);
                    operand.field.setValue(LittleEndian.getInt(raw, 4));
                    operand.prior.setValue(true);
                    break;
                }
                case 13: {
                    if (item == null) break;
                    DSearchConditionOperand operand = item.right;
                    operand.setStorable(true);
                    operand.function.loadTaggedContent(in);
                    break;
                }
                case 3: {
                    if (item == null) break;
                    DSearchConditionOperand operand = item.getOperandToLoad();
                    operand.valueInt.setStorable(true);
                    operand.valueInt.loadTaggedContent(in);
                    operand.prior.setValue(false);
                    break;
                }
                case 6: {
                    if (item == null) break;
                    DSearchConditionOperand operand = item.getOperandToLoad();
                    operand.valueDateTime.setStorable(true);
                    operand.valueDateTime.loadTaggedContent(in);
                    operand.prior.setValue(false);
                    break;
                }
                case 4: {
                    if (item == null) break;
                    DSearchConditionOperand operand = item.getOperandToLoad();
                    operand.valueDouble.setStorable(true);
                    operand.valueDouble.loadTaggedContent(in);
                    operand.prior.setValue(false);
                    break;
                }
                case 5: {
                    if (item == null) break;
                    DSearchConditionOperand operand = item.getOperandToLoad();
                    operand.valueString.setStorable(true);
                    operand.valueString.loadTaggedContent(in);
                    operand.prior.setValue(false);
                    break;
                }
                case 7: {
                    if (item == null) break;
                    DSearchConditionOperand operand = item.getOperandToLoad();
                    operand.value.setStorable(true);
                    operand.value.setType(DPropertyValue.Type.Null);
                    operand.prior.setValue(false);
                    break;
                }
                case 8: {
                    if (item == null) break;
                    DSearchConditionOperand operand = item.getOperandToLoad();
                    operand.parameter.loadTaggedContent(in);
                    operand.prior.setValue(false);
                }
            }
        }
        this.checkPrior();
    }

    @Override
    public DProperty loadScriptArrayItem(Object obj) {
        DSearchConditionItem item = new DSearchConditionItem(this);
        item.loadScriptValue(obj);
        return item;
    }

    @Override
    protected void doAssign(DItem source) {
        if (DSearchCondition.checkAssignType(source, this.getClass())) {
            for (DProperty sourceProperty : ((DSearchCondition)source).properties) {
                if (!(sourceProperty instanceof DSearchConditionItem)) continue;
                DSearchConditionItem sourceItem = (DSearchConditionItem)sourceProperty;
                DSearchConditionItem item = new DSearchConditionItem(this.object);
                item.assign(sourceItem);
                this.properties.add(item);
            }
        }
    }

    @Override
    public void storeTaggedContent(TaggedWriter out) throws IOException {
        this.checkPrior();
        for (DProperty property : this.properties) {
            property.storeTaggedContent(out);
        }
    }

    @Override
    public int storeTextContent(int textOptions, StringBuilder out, int level, boolean needComma) {
        return super.storeTextContent(textOptions, out, level, needComma);
    }
}

