/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.obj.search;

import inform.adt.InformException;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.db.sql.engine.SearchEntry;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.FindNode;
import inform.agent.mtd.nodes.Node;
import inform.agent.mtd.obj.DItem;
import inform.agent.mtd.obj.DProperty;
import inform.agent.mtd.obj.DPropertyBool;
import inform.agent.mtd.obj.DPropertyEnum;
import inform.agent.mtd.obj.DPropertyInt;
import inform.agent.mtd.obj.DReturnedFields;
import inform.agent.mtd.obj.search.DSearchEntry;
import inform.agent.mtd.obj.search.DSearchEntryParameters;
import inform.agent.mtd.obj.search.DSearchFieldBinds;
import inform.agent.scripts.ParametersList;
import java.io.IOException;
import org.mozilla.javascript.ScriptableObject;

public class DSearchDatasourceEntry
extends DSearchEntry {
    protected final DPropertyEnum join = new DPropertyEnum(this, "join", 4098, JOIN_TYPE);
    protected final DPropertyInt link = new DPropertyInt(this, "link", 32770);
    protected final DReturnedFields returnedFields = new DReturnedFields((DProperty)this, "returnedFields", null);
    protected final DPropertyBool useCTE = new DPropertyBool(this, "useCTE", 4098);
    protected final DSearchFieldBinds fieldBinds = new DSearchFieldBinds(this, "fieldBinds");
    protected ParametersList searchParameters = null;
    protected final DSearchEntryParameters parameters = new DSearchEntryParameters(this);

    public DSearchDatasourceEntry(DProperty object, DSearchEntry parent, boolean entryBindable) {
        super(object, parent, 0, 0.0, 0.0);
        this.parameters.entryBindable = entryBindable;
    }

    public DSearchDatasourceEntry(DProperty object, DSearchEntry parent, int entryId, double tableId) {
        super(object, parent, entryId, tableId, 0.0);
    }

    public DSearchDatasourceEntry(DProperty object, DSearchEntry parent, int entryId, double searchId, FindNode.Descriptor descriptor, boolean entryBindable) {
        super(object, parent, entryId, descriptor.getRootTableId(), searchId);
        this.parameters.entryBindable = entryBindable;
        if (descriptor != null && descriptor.getInputParams() != null) {
            this.searchParameters = new ParametersList();
            try {
                this.searchParameters.load(null, new TaggedReader(descriptor.getInputParams()), Core.serverTimeZoneHost);
            }
            catch (IOException e) {
                throw InformException.wrap(e);
            }
        }
    }

    @Override
    public int entryKind() {
        return this.node.getValue() != this.tableId || this.tableId == 0.0 ? SearchEntry.Kind.Find.typeId : SearchEntry.Kind.Table.typeId;
    }

    @Override
    public void loadTaggedContent(TaggedReader in) throws IOException {
        switch (in.getCurrentTag()) {
            case 3: {
                this.link.loadTaggedContent(in);
                break;
            }
            case 8: {
                this.join.loadTaggedContent(in);
                break;
            }
            case 13: {
                this.returnedFields.loadTaggedContent(in.getSubStreamReader());
                break;
            }
            case 18: {
                this.useCTE.loadTaggedContent(in);
                break;
            }
            case 10: {
                this.fieldBinds.loadTaggedContent(in.getSubStreamReader());
                break;
            }
            case 9: {
                this.parameters.loadTaggedContent(in.getSubStreamReader());
                break;
            }
            default: {
                super.loadTaggedContent(in);
            }
        }
    }

    protected boolean updateParametersList() {
        Node node;
        if (this.searchParameters == null && this.node.getValue() != 0.0 && (node = MtdEngine.getNode(this.node.getValue())) instanceof FindNode) {
            FindNode.Descriptor descriptor = ((FindNode)node).getDescriptor();
            this.tableId = descriptor.getRootTableId();
            if (descriptor.getInputParams() == null) {
                this.searchParameters = null;
            } else {
                this.searchParameters = new ParametersList();
                try {
                    this.searchParameters.load(null, new TaggedReader(descriptor.getInputParams()), Core.serverTimeZoneHost);
                }
                catch (IOException e) {
                    throw InformException.wrap(e);
                }
            }
        }
        return this.searchParameters != null && !this.searchParameters.isEmpty();
    }

    @Override
    public void loadScriptContent(ScriptableObject obj) {
        this.searchParameters = null;
        super.loadScriptContent(obj);
    }

    @Override
    protected void doAssign(DItem obj) {
        if (obj instanceof DSearchDatasourceEntry) {
            this.searchParameters = ((DSearchDatasourceEntry)obj).searchParameters;
            this.parameters.update(this.searchParameters);
        } else {
            this.searchParameters = null;
        }
        super.doAssign(obj);
    }

    @Override
    protected void storeEntryTags(TaggedWriter out) throws IOException {
        this.link.storeTaggedContentAs(3, out);
        if (this.link.getValue() != 0 || !this.fieldBinds.isDefault()) {
            this.join.storeTaggedContentAs(8, out);
        }
        super.storeEntryTags(out);
        this.parameters.storeTaggedContentAsNonEmptyStream(9, out);
        if (this.node.getValue() != this.tableId) {
            this.useCTE.storeTaggedContentAs(18, out);
        }
        this.fieldBinds.storeTaggedContentAsNonEmptyStream(10, out);
    }

    @Override
    protected void storeReturnedFields(TaggedWriter out) throws IOException {
        if (!this.returnedFields.isEmpty()) {
            this.returnedFields.storeTaggedContentAsNonEmptyStream(13, out);
        }
    }
}

