/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.obj.search;

import inform.adt.LittleEndian;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.db.sql.engine.SearchEntry;
import inform.agent.mtd.obj.DProperty;
import inform.agent.mtd.obj.search.DPropertySearchField;
import inform.agent.mtd.obj.search.DSearchEntry;
import java.io.IOException;

public class DSearchDirectoryEntry
extends DSearchEntry {
    protected DPropertySearchField referenceFieldId;

    public DSearchDirectoryEntry(DProperty object, DSearchEntry parent) {
        this(object, parent, 0, 0.0);
    }

    public DSearchDirectoryEntry(DProperty object, DSearchEntry parent, int entryId, double tableId) {
        super(object, parent, entryId, tableId);
        this.referenceFieldId = new DPropertySearchField((DProperty)this, "referenceFieldId", 0, this.parent);
    }

    @Override
    public int entryKind() {
        return SearchEntry.Kind.Directory.typeId;
    }

    @Override
    public void loadTaggedContent(TaggedReader in) throws IOException {
        switch (in.getCurrentTag()) {
            case 7: {
                byte[] raw = in.getRaw();
                this.referenceFieldId.setValue(LittleEndian.getInt(raw, 4));
                break;
            }
            default: {
                super.loadTaggedContent(in);
            }
        }
    }

    @Override
    protected void storeEntryTags(TaggedWriter out) throws IOException {
        super.storeEntryTags(out);
        if (this.parent != null) {
            byte[] raw = new byte[8];
            LittleEndian.setInteger(this.parent.entryId.getValue(), raw, 0);
            LittleEndian.setInteger(this.referenceFieldId.getValue(), raw, 4);
            out.putRaw(7, raw);
        }
    }
}

