/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.request;

import inform.adt.InformException;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.Ini;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.RequestResult;
import inform.agent.ServerSideHost;
import inform.agent.VersionInfo;
import inform.agent.db.connect.Connector;
import inform.agent.mtd.MetadataNodeReader;
import inform.agent.mtd.MtdCache;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.NodeRecord;
import inform.agent.mtd.nodes.BasicNode;
import inform.agent.mtd.nodes.Node;
import inform.agent.mtd.request.NodeStatus;
import inform.agent.net.Client;
import java.sql.SQLException;

public class AddNode
extends Request {
    public AddNode(RequestHeader rq) {
        super(rq, RequestDuration.SHORT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Throwable {
        if (Ini.ReadonlyMode) {
            this.sendError("\u0410\u0433\u0435\u043d\u0442 \u0437\u0430\u043f\u0443\u0449\u0435\u043d \u0432 \u0440\u0435\u0436\u0438\u043c\u0435 \u0442\u043e\u043b\u044c\u043a\u043e \u0434\u043b\u044f \u0447\u0442\u0435\u043d\u0438\u044f!", "");
            return;
        }
        TaggedReader in = this.createRequestContentReader();
        AddNodeParams params = new AddNodeParams();
        while (in.getNextTag() != 0) {
            switch (in.getCurrentTag()) {
                case 1: {
                    params.nodeId = in.getDouble();
                    break;
                }
                case 2: {
                    params.typeId = in.getInt();
                    break;
                }
                case 3: {
                    params.parentId = in.getDouble();
                    break;
                }
                case 4: {
                    params.name = in.getAnsi();
                    break;
                }
                case 7: {
                    params.refNodeId = in.getDouble();
                    break;
                }
                case 13: {
                    params.identifier = in.getAnsi();
                    break;
                }
                case 12: {
                    params.description = in.getAnsi();
                    break;
                }
                case 8: {
                    params.uiStyle = in.getInt();
                    break;
                }
                case 9: {
                    params.uiImage = in.getInt();
                    break;
                }
                case 29: {
                    params.replicaId = in.getDouble();
                }
            }
        }
        RequestResult result = new RequestResult(this);
        if (params.typeId == 16 && VersionInfo.toNumber(5L, 1L, 0L) < this.client().getVersion().toNumber()) {
            MetadataNodeReader.ConfNode conf = new MetadataNodeReader.ConfNode(params.parentId, params.name);
            try (Connector.Metabase connector = new Connector.Metabase();){
                conf.create(connector.connection());
                TaggedWriter out = result.getWriter();
                out.putDouble(1, conf.id);
                result.sendResult();
            }
            return;
        }
        AddNode.checkParams(params, this);
        BasicNode parentNode = MtdEngine.getValidTranslatedNode(params.parentId);
        this.checkNodeAccess(parentNode, 0x10000000, "\u041d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e \u043f\u0440\u0430\u0432 \u0434\u043b\u044f \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0443\u0437\u043b\u0430");
        AddNode.addNodeImpl(params, this, result);
    }

    public static void checkParams(AddNodeParams params, ServerSideHost host) {
        if (params.nodeId == 0.0) {
            params.nodeId = Core.generateId();
        }
        if (params.nodeId != 0.0 && MtdEngine.getNode(params.nodeId) != null) {
            throw new InformException("\u0423\u0437\u0435\u043b \u0441 \u0442\u0430\u043a\u0438\u043c id \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442");
        }
        if (params.parentId == 0.0) {
            if (host instanceof Request) {
                params.parentId = ((Request)host).getRootNodeID();
            } else {
                Client client = host.client();
                if (client != null) {
                    params.parentId = host.client().getRootNodeId();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addNodeImpl(AddNodeParams params, ServerSideHost host, RequestResult result) throws Exception {
        BasicNode parentNode = MtdEngine.getValidTranslatedNode(params.parentId);
        try (Connector.Metabase connector = new Connector.Metabase();){
            params.name = parentNode.getNewChildName(connector, params.name);
            params.parentId = parentNode.getId();
            if (params.refNodeId != 0.0) {
                BasicNode refNode = MtdEngine.getValidTranslatedNode(params.refNodeId);
                params.refNodeId = refNode.getId();
            }
            NodeRecord record = new NodeRecord(NodeStatus.MODIFIED);
            record.setId(params.nodeId);
            record.setParentId(params.parentId);
            record.setType(params.typeId);
            record.setDescription(params.description);
            record.setOwnerId(host.getUserID());
            record.setModificationUserId(host.getUserID());
            record.setSessionId(host.getSessionID());
            record.setCreationTime(System.currentTimeMillis());
            record.setOrderNo(parentNode.getNewOrderNo(connector));
            record.setReplId(params.replicaId);
            Node node = MtdCache.createNodeInstance(record);
            assert (node != null);
            Node.CreationArg arg = new Node.CreationArg();
            arg.name = params.name;
            arg.identifier = params.identifier;
            arg.refNodeId = params.refNodeId;
            node.afterCreateNew(arg);
            node.setModificationAttributeTime(System.currentTimeMillis());
            if (result != null) {
                TaggedWriter out = result.getWriter();
                out.putDouble(1, node.getId());
                if (!params.identifier.isEmpty() && node.getIdentName().isEmpty()) {
                    out.putEmpty(13);
                }
            }
            try {
                MtdEngine.createNewNode(null, connector, node, null);
            }
            catch (SQLException ex) {
                throw InformException.wrap(ex, "\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u0443\u0437\u043b\u0430");
            }
        }
        if (result != null) {
            result.sendResult();
        }
    }

    public static class AddNodeParams {
        public double nodeId = 0.0;
        public double parentId = 0.0;
        public double refNodeId = 0.0;
        public double replicaId = 0.0;
        public String name = "";
        public String identifier = "";
        public String description = "";
        public int typeId = -1;
        public int uiStyle = 0;
        public int uiImage = 0;
    }
}

