/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.request;

import inform.adt.taggedio.TaggedReader;
import inform.agent.Ini;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.RequestResult;
import inform.agent.db.connect.Connector;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.Security;
import inform.agent.mtd.nodes.AccountNode;
import inform.agent.mtd.nodes.Node;
import inform.agent.mtd.nodes.UserNode;
import inform.agent.mtd.request.NodeStatus;
import inform.common.Empty;

public class ChangeUserPassword
extends Request {
    public ChangeUserPassword(RequestHeader rq) {
        super(rq, RequestDuration.SHORT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Throwable {
        if (Ini.ReadonlyMode) {
            this.sendError("\u0410\u0433\u0435\u043d\u0442 \u0437\u0430\u043f\u0443\u0449\u0435\u043d \u0432 \u0440\u0435\u0436\u0438\u043c\u0435 \u0442\u043e\u043b\u044c\u043a\u043e \u0434\u043b\u044f \u0447\u0442\u0435\u043d\u0438\u044f!", "");
            return;
        }
        AccountNode accountNode = MtdEngine.getValidAccountNode(this.getTranslatedNodeID());
        if (accountNode.getType() != 3) {
            this.sendResult();
            return;
        }
        byte[] requestParams = this.getRequestContent();
        TaggedReader in = new TaggedReader(requestParams);
        if (MtdEngine.serverNode().descriptor().requiredChangeEmptyPassword) {
            byte[] hash = Empty.byteArray;
            byte[] salt = Empty.byteArray;
            TaggedReader stream = new TaggedReader(requestParams);
            block8: while (stream.next()) {
                switch (stream.getCurrentTag()) {
                    case 33: {
                        if (in.getString().equals(accountNode.getName())) continue block8;
                        this.sendError("\u041f\u0435\u0440\u0435\u0434\u0430\u043d\u043d\u043e\u0435 \u0438\u043c\u044f \u043d\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u0435\u0442 \u0441 \u0438\u043c\u0435\u043d\u0435\u043c \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f. \u0417\u0430\u0434\u0430\u0432\u0430\u0439\u0442\u0435 \u0438\u043c\u044f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u0431\u0435\u0437 \u043a\u043b\u044e\u0447\u0430 \u0447\u0435\u0440\u0435\u0437 \u0441\u043b\u044d\u0448, \u043b\u0438\u0431\u043e \u043e\u0431\u043d\u043e\u0432\u0438\u0442\u0435 \u043a\u043b\u0438\u0435\u043d\u0442 \u0434\u043e \u0432\u0435\u0440\u0441\u0438\u0438 \u043d\u0435 \u043c\u0435\u043d\u0435\u0435 \u0447\u0435\u043c 5.2.1200", null);
                        return;
                    }
                    case 30: 
                    case 115: {
                        hash = stream.getRaw();
                        continue block8;
                    }
                    case 31: 
                    case 116: {
                        salt = stream.getRaw();
                        continue block8;
                    }
                }
            }
            boolean passwordIsEmpty = true;
            if (salt.length == 16) {
                passwordIsEmpty = Security.isHashEquals(Security.sha256CalculateH1(accountNode.getName(), "", salt), hash);
            } else if (salt.length == 8) {
                passwordIsEmpty = Security.isHashEquals(Security.calculateH1(accountNode.getName(), "", salt), hash);
            }
            if (passwordIsEmpty) {
                this.sendError("\u041f\u0443\u0441\u0442\u044b\u0435 \u043f\u0430\u0440\u043e\u043b\u0438 \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u044b", null);
                return;
            }
        }
        RequestResult result = new RequestResult(this);
        try (Connector.Metabase connector = new Connector.Metabase();){
            Node.ModifyNodeArg arg = new Node.ModifyNodeArg(this, connector, NodeStatus.MODIFIED, this.security());
            arg.in = in;
            arg.userId = this.getUserID();
            arg.sessionId = this.getSessionID();
            UserNode node = arg.modifyNode((UserNode)accountNode);
            node.changeAuthentication(arg);
            node.setModificationAttributeTime(System.currentTimeMillis());
            node.setNodeChangingProps(arg);
            node.applyUpdates(this.ssContext, arg);
            AccountNode.invalidateSecurity();
        }
        result.sendResult();
    }
}

