/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.request;

import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.mtd.AuditJournal;

public class GetAuditInfo
extends Request {
    private static final int TAG_GET_REPLICA_ID_COUNT = 1;

    public GetAuditInfo(RequestHeader rq) {
        super(rq, RequestDuration.NORMAL);
    }

    @Override
    public void execute() throws Throwable {
        TaggedReader in = this.createRequestContentReader();
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        TaggedWriter out = new TaggedWriter(result);
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 1: {
                    double replicaId = in.getDouble();
                    AuditJournal journal = new AuditJournal(AuditJournal.Journal.REPLICATION);
                    int replicaCount = journal.getRegisteredReplicaIdCount(this.ssContext, replicaId);
                    out.putInt32(1, replicaCount);
                }
            }
        }
        out.flush();
        this.sendResult(result.internalBuffer(), result.size());
    }
}

