/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.request;

import inform.adt.InformException;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.connect.ResultSet;
import inform.agent.mtd.MetadataNodeReader;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.BasicNode;
import inform.common.Base64BinString;
import inform.common.Empty;
import java.sql.SQLException;

public class GetHistoryItem
extends Request {
    private static final int TAG_CONTENT = 1;
    private static final int TAG_ATTRIBUTES = 2;

    public GetHistoryItem(RequestHeader rq) {
        super(rq, RequestDuration.NORMAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Throwable {
        double entryId = -1.0;
        TaggedReader reader = this.createRequestContentReader();
        while (reader.getNextTag() != 0) {
            switch (reader.getCurrentTag()) {
                case 4: {
                    entryId = reader.getDouble();
                }
            }
        }
        double requestedNodeId = this.getTranslatedNodeID();
        BasicNode node = MtdEngine.getValidNode(requestedNodeId).getRealNode();
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        TaggedWriter writer = new TaggedWriter(stream);
        writer.putRaw(1, node.getContent(entryId));
        try {
            DatabaseDescriptor dd = DatabaseDescriptor.getMetabase();
            try (DatabaseConnection c = dd.connectPrivileged("rq:GetHistoryItem");
                 PreparedStatement ps = c.prepareStatement("getAttributes", "SELECT ATTRS_B64  FROM " + MetadataNodeReader.mtdTreeLogTableName + " WHERE ID=?");){
                ps.setDouble(1, entryId);
                try (ResultSet rs = ps.executeQuery(null);){
                    if (!rs.next()) {
                        throw new InformException("\u041d\u0435 \u043c\u043e\u0433\u0443 \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u044b \u0443\u0437\u043b\u0430").detail(String.format("Cannot fetch record from MTD_TREE* for node[%.0f(pin:%.0f)]", node.getId(), entryId));
                    }
                    writer.putRaw(2, Base64BinString.Decode(rs.getString(1)));
                }
            }
        }
        catch (SQLException e) {
            Core.logger.error(null, e);
            this.sendError(e.getMessage(), "");
        }
        writer.flush();
        stream.flush();
        byte[] result = Empty.byteArray;
        result = stream.toByteArray();
        this.sendResult(result, result.length);
    }
}

