/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.request;

import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.RequestResult;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.AccountNode;

public class GetUserListFor
extends Request {
    private static final int TAG_GETUSERLISTFOR_LOCKED_USERS = 1;
    private static final int TAG_GETUSERLISTFOR_UNLOCKED_USERS = 2;

    public GetUserListFor(RequestHeader rq) {
        super(rq, RequestDuration.NORMAL);
    }

    @Override
    public void execute() throws Throwable {
        AccountNode[] accounts;
        TaggedReader in = this.createRequestContentReader();
        boolean locked = false;
        boolean unlocked = false;
        while (in.getNextTag() != 0) {
            switch (in.getCurrentTag()) {
                case 1: {
                    locked = true;
                    break;
                }
                case 2: {
                    unlocked = true;
                }
            }
        }
        RequestResult result = new RequestResult(this);
        TaggedWriter out = result.getWriter();
        for (AccountNode account : accounts = MtdEngine.getAccounts()) {
            boolean blocked = account.isBlocked();
            if (locked && blocked) {
                out.putDouble(1, account.getId());
                continue;
            }
            if (!unlocked || blocked) continue;
            out.putDouble(1, account.getId());
        }
        result.sendResult();
    }
}

