/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.request;

import inform.adt.DateTime;
import inform.adt.taggedio.TaggedReader;
import inform.agent.Ini;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.mtd.AuditJournal;

public class RegistrateReplication
extends Request {
    private static final int TAG_RRR_OPCODE = 1;
    private static final int TAG_RRR_BEGINTIME = 2;
    private static final int TAG_RRR_ENDTIME = 3;
    private static final int TAG_RRR_DATASLICETIME = 4;
    private static final int TAG_RRR_USER = 5;
    private static final int TAG_RRR_REPLICATION_NODE_ID = 6;
    private static final int TAG_RRR_RESULTMESSAGE = 7;
    private static final int TAG_RRR_SUCCESSFULLY = 8;
    private static final int TAG_RRR_REPLICA_ID = 9;
    private static final int TAG_RRR_REPLICA_SIZE = 10;
    private static final int TAG_RRR_FILE_NAME = 11;
    private static final int TAG_RRR_UPDATE = 12;

    public RegistrateReplication(RequestHeader rq) {
        super(rq, RequestDuration.NORMAL);
    }

    @Override
    public void execute() throws Throwable {
        if (Ini.ReadonlyMode) {
            this.sendError("\u0410\u0433\u0435\u043d\u0442 \u0437\u0430\u043f\u0443\u0449\u0435\u043d \u0432 \u0440\u0435\u0436\u0438\u043c\u0435 \u0442\u043e\u043b\u044c\u043a\u043e \u0434\u043b\u044f \u0447\u0442\u0435\u043d\u0438\u044f!", "");
            return;
        }
        AuditJournal journal = new AuditJournal(AuditJournal.Journal.REPLICATION);
        if (!journal.isEnabled()) {
            return;
        }
        TaggedReader in = this.createRequestContentReader();
        AuditJournal.ReplicationParams rrParams = new AuditJournal.ReplicationParams();
        rrParams.opCode = 4;
        rrParams.successfullyResult = true;
        rrParams.userNodeId = this.getUserID();
        double auditId = 0.0;
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 1: {
                    rrParams.opCode = in.getInt();
                    break;
                }
                case 2: {
                    rrParams.timeBeginOperation = DateTime.toServerTime(in.getDouble(), this);
                    break;
                }
                case 3: {
                    rrParams.timeEndOperation = DateTime.toServerTime(in.getDouble(), this);
                    break;
                }
                case 4: {
                    rrParams.dataSliceEnd = in.getDouble();
                    break;
                }
                case 5: {
                    rrParams.userNodeId = in.getDouble();
                    break;
                }
                case 6: {
                    rrParams.replNodeId = in.getDouble();
                    break;
                }
                case 7: {
                    rrParams.resultMessage = in.getAnsi();
                    break;
                }
                case 8: {
                    rrParams.successfullyResult = in.getBoolean();
                    break;
                }
                case 9: {
                    rrParams.replicaId = in.getDouble();
                    break;
                }
                case 10: {
                    rrParams.replicaSize = in.getLong();
                    break;
                }
                case 11: {
                    rrParams.fileName = in.getString();
                    break;
                }
                case 12: {
                    auditId = in.getDouble();
                }
            }
        }
        this.idle();
        if (auditId == 0.0) {
            journal.registerReplication(this.ssContext, rrParams);
        } else {
            AuditJournal.UpdateReplicationParams updateReplicationParams = new AuditJournal.UpdateReplicationParams();
            updateReplicationParams.auditId = auditId;
            updateReplicationParams.fileSize = rrParams.replicaSize;
            updateReplicationParams.fileName = rrParams.fileName;
            journal.updateReplication(this.ssContext, updateReplicationParams);
        }
    }
}

