/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.request;

import inform.adt.DateTime;
import inform.adt.Strings;
import inform.adt.taggedio.TaggedReader;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.db.ClosableResult;
import inform.agent.db.connect.Connector;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.connect.ResultSet;
import inform.agent.db.types.SqlDataType;
import inform.agent.mtd.MetadataNodeReader;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.TableNode;
import inform.common.Base64BinString;
import inform.common.Empty;

public class RestoreNodeFromHistory
extends Request {
    private static final int TAG_HISTORY_ID = 1;
    private static final int TAG_RESTORE_ATTRIBUTES = 2;

    public RestoreNodeFromHistory(RequestHeader rq) {
        super(rq, RequestDuration.NORMAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Throwable {
        TaggedReader in = this.createRequestContentReader();
        double historyId = 0.0;
        boolean restoreAttributes = false;
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 1: {
                    historyId = in.getDouble();
                    break;
                }
                case 2: {
                    restoreAttributes = true;
                }
            }
        }
        double nodeId = this.getNodeID();
        double userId = this.getUserID();
        double sessionId = this.getSessionID();
        StringBuilder historySql = new StringBuilder();
        historySql.append("select ").append("ATTRS_B64").append(',').append("RAW_CONTENT").append(',').append("DSL_CONTENT").append(',').append("MOD_CONTENT_TIME").append(',').append("MOD_USER_ID").append(',').append("NODE_TYPE").append(" from ").append(MetadataNodeReader.mtdTreeLogTableName).append(" H").append(" where H.ID").append("=? and H.").append("NODE_ID").append("=?");
        StringBuilder updateSql = new StringBuilder();
        updateSql.append("update ").append(MetadataNodeReader.mtdTreeTableName).append(" set ").append("CNT_ATTR_B64").append("=?,").append("RAW_CONTENT").append("=?,").append("DSL_CONTENT").append("=?,").append("MOD_CONTENT_TIME").append("=?,").append("MOD_USER_ID").append("=?,").append("MOD_ATTRS_TIME").append("=?");
        if (restoreAttributes) {
            updateSql.append(',').append("ATTRS_B64").append("=?");
        }
        updateSql.append(" where ").append("ID").append("=?");
        this.idle();
        try (Connector.Metabase connector = new Connector.Metabase();){
            int nodeType;
            double mu;
            double mct;
            String dsl;
            byte[] c;
            String a;
            DatabaseConnection connection = connector.connection();
            try (PreparedStatement statement = connection.prepareStatement("RestoreNodeFromHistory select", historySql.toString());){
                statement.setDouble(1, historyId);
                statement.setDouble(2, nodeId);
                try (ResultSet resultSet = statement.executeQuery(null);){
                    if (!resultSet.next()) {
                        return;
                    }
                    a = resultSet.getString(1);
                    c = resultSet.getBlobBytes(2);
                    dsl = resultSet.getString(3);
                    mct = resultSet.getDateTime(4);
                    mu = resultSet.getDouble(5);
                    nodeType = resultSet.getAsInteger(6);
                }
            }
            if (c == null) {
                c = Empty.byteArray;
            }
            this.idle();
            byte[] ca = nodeType == 12 ? TableNode.generateContentAttr(nodeId, mct, c) : null;
            String ca64 = null;
            if (ca != null) {
                ca64 = Base64BinString.Encode(ca);
            }
            statement = connection.prepareStatement("RestoreNodeFromHistory update", updateSql.toString());
            try {
                int i = 1;
                if (Strings.isVoid(ca64)) {
                    statement.setNull(i++, SqlDataType.STRING);
                } else {
                    statement.setString(i++, ca64);
                }
                statement.setBlob(i++, c);
                if (dsl == null) {
                    statement.setNull(i++, SqlDataType.BLOB);
                } else {
                    statement.setString(i++, dsl);
                }
                statement.setDateTime(i++, mct);
                statement.setDouble(i++, mu);
                statement.setDateTime(i++, DateTime.currentDateTime());
                if (restoreAttributes) {
                    statement.setString(i++, a);
                }
                statement.setDouble(i++, nodeId);
                statement.executeUpdate(null);
            }
            finally {
                statement.close();
            }
            String commentStr = "\u0412\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435";
            if (!restoreAttributes) {
                commentStr = "\u0412\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0433\u043e";
            }
            MtdEngine.registerMtdOperation(null, connection, nodeId, userId, sessionId, commentStr, 4, true, 0);
            connection.commit();
            this.idle();
            try (ClosableResult closableResult = MetadataNodeReader.getResultSetForNode(null, nodeId, connection, false);){
                MtdEngine.sync(closableResult, System.currentTimeMillis(), MtdEngine.getMtdCache());
                this.idle();
                connection.commit();
            }
        }
    }
}

