/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.net;

import inform.adt.DateTime;
import inform.adt.InformException;
import inform.adt.Strings;
import inform.adt.taggedio.AbstractTaggedReader;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TagVersionInfo;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.ActiveDirectory;
import inform.agent.AgentJARVersion;
import inform.agent.ClientUpdateInfo;
import inform.agent.Core;
import inform.agent.Ini;
import inform.agent.LogContext;
import inform.agent.RequestStatistics;
import inform.agent.VersionInfo;
import inform.agent.am.Telemeter;
import inform.agent.mtd.AuditJournal;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.PersistentSessionEngine;
import inform.agent.mtd.nodes.ServerNode;
import inform.agent.mtd.nodes.UserNode;
import inform.agent.mtd.nodes.UserRole;
import inform.agent.mtd.nodes.VirtualUser;
import inform.agent.net.Client;
import inform.agent.net.ClientLoginInfo;
import inform.agent.net.ClientProtocol;
import inform.agent.net.ClientSession;
import inform.agent.net.LdapUser;
import inform.agent.net.LoginController;
import inform.agent.net.Security;
import inform.agent.scripts.SSContext;
import inform.agent.web.HttpServer;
import inform.agent.web.JWT;
import inform.common.IdGenerator;
import io.jsonwebtoken.JwtException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;

public class LoginProtocol
extends ClientProtocol
implements LogContext {
    public static final VersionInfo minServerVersion = new VersionInfo(5L, 0L, 100L);
    public static final String BAD_LOGIN = "\u041d\u0435\u0432\u0435\u0440\u043d\u043e\u0435 \u0438\u043c\u044f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u0438\u043b\u0438 \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u043f\u0430\u0440\u043e\u043b\u044c";
    public static final String SHA256_CLIENT_SUPPORT_REQUIRED = "\u0414\u043b\u044f \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u043d\u043e\u0432\u0430\u044f \u0432\u0435\u0440\u0441\u0438\u044f \u043a\u043b\u0438\u0435\u043d\u0442\u0430";
    public static final String OBSOLETE_LOGIN = "\u0421\u0440\u043e\u043a \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u0430\u0443\u0442\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438 \u0437\u0430\u0432\u0435\u0440\u0448\u0451\u043d";
    public static final String OBSOLETE_LOGIN_OR_TRYING_AD_WITHOUT_BROWSER_PROMPT = "\u0421\u0440\u043e\u043a \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u0430\u0443\u0442\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438 \u0437\u0430\u0432\u0435\u0440\u0448\u0451\u043d,\n\u043b\u0438\u0431\u043e \u043e\u0448\u0438\u0431\u043e\u0447\u043d\u0430\u044f \u043f\u043e\u043f\u044b\u0442\u043a\u0430 \u0432\u0445\u043e\u0434\u0430 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u043c Active Directory,\n\u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u044f \u043d\u0435 \u043f\u0440\u0435\u0434\u043d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u043d\u043e\u0435 \u0434\u043b\u044f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u0439 ActiveDirectory \u043e\u043a\u043d\u043e";
    private static final String NOT_ALLOWED_ACCESS = "\u043d\u0435 \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d \u0434\u043e\u0441\u0442\u0443\u043f \u043a \u044d\u0442\u043e\u043c\u0443 \u0441\u0435\u0440\u0432\u0435\u0440\u0443";
    public static final String USER_IS_BLOCKED = "\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d";
    private static final String ADMIN_PART_MSG = ".\n\u041e\u0431\u0440\u0430\u0442\u0438\u0442\u0435\u0441\u044c \u043a \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0443.";
    private final ClientSession session;
    private final boolean isTlsSession;
    private final TaggedWriter out;
    private Stage stage;
    private boolean isLdapIntegration = false;
    private UserNode userNode;
    private UserNode masterUser;
    private String failedMessage;
    private ActiveDirectory activeDirectory = null;
    private final InetAddress addr;
    private final InetAddress localAddress;
    private final ClientLoginInfo loginInfo;
    private int clientId;
    private String domainName;
    private boolean activeDirectoryAuthorization;
    private String wasmHttpSessionID;
    private String encodedJWT;
    boolean needLogin;
    boolean isValidWasmHttpSessionID = false;
    boolean isWasmHttpSessionIDV2 = false;
    byte[] disposibleKey;
    byte[] salt;
    byte[] persistentSessionDisposableKey = null;
    private Client client;
    private final int taskId = Telemeter.genId();
    private int authorizationType = 0;
    private Thread thread;
    private final SSContext.ClientContext ssContext;
    private ServerNode.Descriptor serverNodeDescriptor;
    boolean clientHasTLSCapability = false;
    private int expectedExtraTag = 0;

    public LoginProtocol(ClientSession session, boolean isTlsSession) throws InformException {
        this.session = session;
        this.isTlsSession = isTlsSession;
        this.out = session.createSyncedWriter();
        this.stage = Stage.SIGNATURE;
        this.userNode = null;
        this.masterUser = null;
        this.failedMessage = BAD_LOGIN;
        InetSocketAddress inetSocketAddress = session.localAddress();
        this.localAddress = inetSocketAddress.getAddress();
        inetSocketAddress = session.socketAddress();
        this.addr = inetSocketAddress.getAddress();
        this.loginInfo = new ClientLoginInfo();
        this.loginInfo.peerIp = inetSocketAddress.getAddress().getHostAddress();
        this.loginInfo.peerPort = Integer.toString(inetSocketAddress.getPort());
        this.loginInfo.agentIP = ((InetSocketAddress)session.channel.getLocalAddress()).getAddress().getHostAddress();
        this.ssContext = new SSContext.ClientContext(this.loginInfo);
        this.clientId = 0;
        this.domainName = null;
        this.activeDirectoryAuthorization = false;
        this.needLogin = false;
        this.disposibleKey = null;
        this.salt = null;
        this.client = null;
    }

    private synchronized void closeAd() {
        if (this.activeDirectory != null) {
            this.activeDirectory.close();
            this.activeDirectory = null;
        }
    }

    @Override
    public void close(String reason) {
        this.closeAd();
    }

    @Override
    public boolean isLive() {
        return !this.session.isClosing() && this.stage != Stage.CLOSED && !Core.isAgentStopped();
    }

    private synchronized boolean isWorking() {
        return this.isLive() && this.stage != Stage.CONNECTED && this.stage != Stage.CLOSED;
    }

    @Override
    public void handleTag(AbstractTaggedReader in) throws Exception {
        this.thread = Thread.currentThread();
        LogContext.CURRENT.set(this);
        try {
            this.internal_handleTag(in);
        }
        finally {
            LogContext.CURRENT.set(null);
            this.thread = null;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void internal_handleTag(AbstractTaggedReader in) throws Exception {
        try {
            switch (1.$SwitchMap$inform$agent$net$LoginProtocol$Stage[this.stage.ordinal()]) {
                case 1: {
                    in.getSignature();
                    this.stage(Stage.PROTOCOL_VERSION);
                    break;
                }
                case 2: {
                    this.stage(Stage.INIT);
                    protocolVersion = 0;
                    if (in.getCurrentTag() == 7) {
                        protocolVersion = in.getInt();
                    }
                    if (protocolVersion != 10) {
                        Core.logger.warn("\u041d\u0435\u0441\u043e\u0432\u043f\u0430\u0434\u0435\u043d\u0438\u0435 \u0432\u0435\u0440\u0441\u0438\u0439 \u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b\u0430 \u0432\u0437\u0430\u0438\u043c\u043e\u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u0430\u0433\u0435\u043d\u0442\u0430({}) \u0438 \u043a\u043b\u0438\u0435\u043d\u0442\u0430({}) {}", new Object[]{10, protocolVersion, this.addr.getHostAddress()});
                        this.out.putSignature();
                        this.out.putInt32(7, 10);
                        this.dropLogin();
                        return;
                    }
                    break;
                }
                case 3: {
                    this.initStage(in);
                    break;
                }
                case 4: {
                    if (!Strings.isVoid(this.wasmHttpSessionID)) ** GOTO lbl73
                    if (this.activeDirectory == null) {
                        this.registerFailedLoginCount(LoginController.Result.Failed);
                        this.out.putAnsi(11, "\u041d\u0435\u0432\u0435\u0440\u043d\u043e\u0435 \u0438\u043c\u044f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u0438\u043b\u0438 \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u043f\u0430\u0440\u043e\u043b\u044c");
                        this.loginInfo.registrateFailedLogin(this.failedMessage, "#1");
                        this.out.putEmpty(9);
                        this.dropLogin();
                        return;
                    }
                    try {
                        if (!this.activeDirectory.isSuccessful()) {
                            if (in.getCurrentTag() == 47) {
                                this.registerFailedLoginCount(LoginController.Result.Failed);
                                this.out.putAnsi(11, "\u041d\u0435\u0432\u0435\u0440\u043d\u043e\u0435 \u0438\u043c\u044f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u0438\u043b\u0438 \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u043f\u0430\u0440\u043e\u043b\u044c");
                                this.loginInfo.registrateFailedLogin(this.failedMessage, "#2");
                                this.out.putEmpty(9);
                                this.dropLogin();
                                return;
                            }
                            in.checkCurrentTag(45);
                            data = in.getRaw();
                            data = this.activeDirectory.process(data);
                            if (data.length != 0) {
                                this.out.putRaw(45, data);
                                this.out.flush();
                            }
                            if (!this.activeDirectory.isSuccessful()) {
                                return;
                            }
                        }
                        if (!this.activeDirectory.isSuccessful()) {
                            this.registerFailedLoginCount(LoginController.Result.Failed);
                            this.out.putAnsi(11, "\u041d\u0435\u0432\u0435\u0440\u043d\u043e\u0435 \u0438\u043c\u044f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u0438\u043b\u0438 \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u043f\u0430\u0440\u043e\u043b\u044c");
                            this.loginInfo.registrateFailedLogin(this.failedMessage, "#3");
                            this.out.putEmpty(9);
                            this.dropLogin();
                            return;
                        }
                        adUserName = this.activeDirectory.getUserName();
                        v0 = authName = Strings.isVoid(this.loginInfo.certName) != false ? this.loginInfo.userName : this.loginInfo.certName;
                        if (!authName.equalsIgnoreCase(adUserName)) {
                            this.registerFailedLoginCount(LoginController.Result.Failed);
                            this.out.putAnsi(11, "\u041d\u0435\u0432\u0435\u0440\u043d\u043e\u0435 \u0438\u043c\u044f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u0438\u043b\u0438 \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u043f\u0430\u0440\u043e\u043b\u044c");
                            this.loginInfo.registrateFailedLogin(this.failedMessage, "#4");
                            this.out.putEmpty(9);
                            this.dropLogin();
                            return;
                        }
                        ** GOTO lbl81
                    }
                    catch (ActiveDirectory.Error e) {
                        Core.logger.error("AD", e);
                        this.registerFailedLoginCount(LoginController.Result.Failed);
                        this.out.putAnsi(11, "\u041d\u0435\u0432\u0435\u0440\u043d\u043e\u0435 \u0438\u043c\u044f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u0438\u043b\u0438 \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u043f\u0430\u0440\u043e\u043b\u044c");
                        this.loginInfo.registrateFailedLogin(this.failedMessage, "#5");
                        this.out.putEmpty(9);
                        this.dropLogin();
                        return;
                    }
lbl73:
                    // 1 sources

                    if (!this.isValidWasmHttpSessionID) {
                        this.failedMessage = "\u0421\u0440\u043e\u043a \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u0430\u0443\u0442\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438 \u0437\u0430\u0432\u0435\u0440\u0448\u0451\u043d";
                        this.registerFailedLoginCount(LoginController.Result.Obsolete);
                        this.out.putAnsi(11, "\u0421\u0440\u043e\u043a \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u0430\u0443\u0442\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438 \u0437\u0430\u0432\u0435\u0440\u0448\u0451\u043d");
                        this.loginInfo.registrateFailedLogin(this.failedMessage, "#6");
                        this.out.putEmpty(9);
                        this.dropLogin();
                        return;
                    }
lbl81:
                    // 3 sources

                    this.stage(Stage.CREATE_CLIENT);
                    this.createClientStage();
                    this.registerFailedLoginCount(LoginController.Result.Success);
                    break;
                }
                case 5: {
                    if (in.getCurrentTag() == 136 && Core.isAuthorizedKeyValid(this.loginInfo.certName, signature = in.getRaw(), this.disposibleKey)) {
                        if (this.userNode != null && Strings.equals(this.loginInfo.userName, this.loginInfo.certName)) {
                            this.stage(Stage.CREATE_CLIENT);
                            this.createClientStage();
                            this.registerFailedLoginCount(LoginController.Result.Success);
                        } else if (this.activeDirectoryAuthorization) {
                            if (Strings.isVoid(this.wasmHttpSessionID)) {
                                this.activeDirectory = ActiveDirectory.createInstance(this.loginInfo.authorizationType);
                                this.stage(Stage.BEGIN_ACTIVE_DIRECTORY_AUTHORIZATION);
                                this.out.putEmpty(46);
                                this.out.flush();
                            } else if (!this.isValidWasmHttpSessionID) {
                                this.failedMessage = "\u0421\u0440\u043e\u043a \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u0430\u0443\u0442\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438 \u0437\u0430\u0432\u0435\u0440\u0448\u0451\u043d";
                                this.registerFailedLoginCount(LoginController.Result.Obsolete);
                                this.out.putAnsi(11, "\u0421\u0440\u043e\u043a \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u0430\u0443\u0442\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438 \u0437\u0430\u0432\u0435\u0440\u0448\u0451\u043d");
                                this.loginInfo.registrateFailedLogin(this.failedMessage, "#7");
                                this.out.putEmpty(9);
                                this.dropLogin();
                            } else {
                                this.stage(Stage.CREATE_CLIENT);
                                this.createClientStage();
                                this.registerFailedLoginCount(LoginController.Result.Success);
                            }
                        } else {
                            this.stage(Stage.DEFAULT_AUTHORIZATION);
                            if (this.userNode.isSha256()) {
                                if (!this.isClientSupportSha256()) {
                                    this.failedMessage = "\u0414\u043b\u044f \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u043d\u043e\u0432\u0430\u044f \u0432\u0435\u0440\u0441\u0438\u044f \u043a\u043b\u0438\u0435\u043d\u0442\u0430";
                                    this.out.putAnsi(11, this.failedMessage);
                                    this.loginInfo.registrateFailedLogin(this.failedMessage, "#8-1");
                                    this.dropLogin();
                                    return;
                                }
                                this.disposibleKey = inform.agent.mtd.Security.sha256GenerateSalt();
                                this.salt = this.userNode.getSha256Salt();
                            } else {
                                this.disposibleKey = inform.agent.mtd.Security.generateSalt();
                                this.salt = this.userNode.getSecuritySalt();
                            }
                            this.out.putRaw(22, this.salt);
                            this.out.putRaw(24, this.disposibleKey);
                            this.out.putEmpty(9);
                            this.out.flush();
                        }
                        return;
                    }
                    this.failedMessage = "\u041d\u0435\u0432\u0435\u0440\u043d\u043e\u0435 \u0438\u043c\u044f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u0438\u043b\u0438 \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u043f\u0430\u0440\u043e\u043b\u044c";
                    this.out.putAnsi(11, this.failedMessage);
                    this.loginInfo.registrateFailedLogin(this.failedMessage, "#8");
                    this.dropLogin();
                    return;
                }
                case 6: {
                    this.persistentSessionRestoreStage(in);
                    break;
                }
                case 7: {
                    this.persistentSessionInitStage(in);
                    break;
                }
                case 8: {
                    login = false;
                    if (this.userNode != null && this.salt != null) {
                        if (in.getCurrentTagSize() == 32) {
                            in.checkCurrentTag(21, 32);
                        } else {
                            in.checkCurrentTag(21, 16);
                        }
                        clientHash = in.getRaw();
                        if (this.userNode.isSha256()) {
                            userHash = this.userNode.getSha256Hash();
                            calcHash = inform.agent.mtd.Security.sha256CalculateH2(userHash, this.disposibleKey);
                        } else {
                            userHash = this.userNode.getSecurityHash();
                            calcHash = inform.agent.mtd.Security.calculateH2(userHash, this.disposibleKey);
                        }
                        v1 = login = Ini.SafeMode != false || inform.agent.mtd.Security.isHashEquals(calcHash, clientHash) != false;
                        if (!login && !Ini.MasterUser.isEmpty()) {
                            this.masterUser = MtdEngine.getUserNodeByName(Ini.MasterUser);
                            if (this.masterUser != null) {
                                this.stage(Stage.MASTER_USER_AUTHORIZATION);
                                if (this.masterUser.isSha256()) {
                                    if (!this.isClientSupportSha256()) {
                                        this.failedMessage = "\u0414\u043b\u044f \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u043d\u043e\u0432\u0430\u044f \u0432\u0435\u0440\u0441\u0438\u044f \u043a\u043b\u0438\u0435\u043d\u0442\u0430";
                                        this.out.putAnsi(11, this.failedMessage);
                                        this.loginInfo.registrateFailedLogin(this.failedMessage, "#9-1");
                                        this.dropLogin();
                                        return;
                                    }
                                    this.disposibleKey = inform.agent.mtd.Security.sha256GenerateSalt();
                                    this.salt = this.masterUser.getSha256Salt();
                                } else {
                                    this.disposibleKey = inform.agent.mtd.Security.generateSalt();
                                    this.salt = this.masterUser.getSecuritySalt();
                                }
                                this.out.putAnsi(43, Ini.MasterUser);
                                this.out.putRaw(22, this.salt);
                                this.out.putRaw(24, this.disposibleKey);
                                this.out.putEmpty(9);
                                this.out.flush();
                                break;
                            }
                        }
                    }
                    if (!login) {
                        this.registerFailedLoginCount(LoginController.Result.Failed);
                        this.out.putAnsi(11, "\u041d\u0435\u0432\u0435\u0440\u043d\u043e\u0435 \u0438\u043c\u044f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u0438\u043b\u0438 \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u043f\u0430\u0440\u043e\u043b\u044c");
                        this.loginInfo.registrateFailedLogin(this.failedMessage, "#9");
                        this.out.putEmpty(9);
                        this.dropLogin();
                        return;
                    }
                    if (Ini.UsePersistentSessions && this.isWasmHttpSessionIDV2) {
                        this.stage(Stage.PERSISTENT_SESSION_INIT);
                        this.out.putInt32(131, 7);
                        this.out.putEmpty(9);
                        this.out.flush();
                        return;
                    }
                    this.stage(Stage.CREATE_CLIENT);
                    this.createClientStage();
                    this.registerFailedLoginCount(LoginController.Result.Success);
                    break;
                }
                case 9: {
                    if (in.getCurrentTag() == 9) {
                        return;
                    }
                    if (in.getCurrentTagSize() == 32) {
                        in.checkCurrentTag(21, 32);
                    } else {
                        in.checkCurrentTag(21, 16);
                    }
                    clientHash = in.getRaw();
                    if (this.masterUser.isSha256()) {
                        userHash = this.masterUser.getSha256Hash();
                        calcHash = inform.agent.mtd.Security.sha256CalculateH2(userHash, this.disposibleKey);
                    } else {
                        userHash = this.masterUser.getSecurityHash();
                        calcHash = inform.agent.mtd.Security.calculateH2(userHash, this.disposibleKey);
                    }
                    login = inform.agent.mtd.Security.isHashEquals(calcHash, clientHash);
                    if (!login) {
                        this.registerFailedLoginCount(LoginController.Result.Failed);
                        this.out.putAnsi(11, "\u041d\u0435\u0432\u0435\u0440\u043d\u043e\u0435 \u0438\u043c\u044f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u0438\u043b\u0438 \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u043f\u0430\u0440\u043e\u043b\u044c");
                        this.loginInfo.registrateFailedLogin(this.failedMessage, "#10");
                        this.out.putEmpty(9);
                        this.dropLogin();
                        return;
                    }
                    this.loginInfo.secutity = new Security(this.masterUser.getId());
                    this.stage(Stage.CREATE_CLIENT);
                    this.createClientStage();
                    this.registerFailedLoginCount(LoginController.Result.Success);
                    break;
                }
                case 10: {
                    this.createClientStage();
                }
            }
        }
        catch (Exception ex) {
            Core.logger.error(null, ex);
            this.registerFailedLoginCount(LoginController.Result.Failed);
            this.out.putAnsi(11, "\u041d\u0435\u0432\u0435\u0440\u043d\u043e\u0435 \u0438\u043c\u044f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u0438\u043b\u0438 \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u043f\u0430\u0440\u043e\u043b\u044c");
            this.loginInfo.registrateFailedLogin(ex.toString(), "#11");
            this.out.putEmpty(9);
            this.dropLogin();
        }
        catch (Throwable ex) {
            Core.logger.error(null, ex);
            this.registerFailedLoginCount(LoginController.Result.Failed);
            this.out.putAnsi(11, "\u041d\u0435\u0432\u0435\u0440\u043d\u043e\u0435 \u0438\u043c\u044f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u0438\u043b\u0438 \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u043f\u0430\u0440\u043e\u043b\u044c");
            this.loginInfo.registrateFailedLogin(ex.toString(), "#12");
            this.out.putEmpty(9);
            this.dropLogin();
            throw ex;
        }
    }

    void dropLogin() throws IOException {
        this.stage(Stage.CLOSED);
        this.out.flush();
        this.session.close(false);
    }

    private boolean isUserNodeRestrictionsIncorrect(String callPlace) throws IOException {
        String msg;
        if (this.userNode == null) {
            this.out.putAnsi(11, BAD_LOGIN);
            this.failedMessage = "\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c " + this.loginInfo.userName + " \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0432 \u0443\u0437\u043b\u0430\u0445 \u043c\u0435\u0442\u0430\u0434\u0430\u043d\u043d\u044b\u0445";
            this.failedMessage = MtdEngine.serverNode().descriptor().useUsersTable ? this.failedMessage + " \u0438\u043b\u0438 \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u0439" : this.failedMessage + ", \u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0435 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u0439 \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435 \u043d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d\u043e";
            this.loginInfo.registrateFailedLogin(this.failedMessage, "#13" + callPlace);
            this.dropLogin();
            return true;
        }
        if (!this.userNode.acceptServerIP(this.localAddress, this.loginInfo.serverHostName)) {
            this.failedMessage = "\u0412\u0430\u043c \u043d\u0435 \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d \u0434\u043e\u0441\u0442\u0443\u043f \u043a \u044d\u0442\u043e\u043c\u0443 \u0441\u0435\u0440\u0432\u0435\u0440\u0443";
            this.out.putAnsi(11, this.failedMessage);
            this.loginInfo.registrateFailedLogin(NOT_ALLOWED_ACCESS, "#14" + callPlace);
            this.dropLogin();
            return true;
        }
        LogContext.Builder blockCause = new LogContext.Builder();
        if (this.userNode.isAccountBlocked(blockCause)) {
            this.failedMessage = USER_IS_BLOCKED;
            String detailedFailedMessage = this.failedMessage + ", " + blockCause;
            this.out.putAnsi(116, detailedFailedMessage);
            this.out.putAnsi(11, this.failedMessage + ADMIN_PART_MSG);
            this.loginInfo.registrateFailedLogin(detailedFailedMessage, "#15" + callPlace);
            this.dropLogin();
            return true;
        }
        if (MtdEngine.serverNode().descriptor().requiredRootNode && this.userNode.getRole() != UserRole.ADMIN && !Strings.isVoid(msg = this.userNode.checkStartupRootNodeAssigned())) {
            this.registerFailedLoginCount(LoginController.Result.Failed);
            String errorMsg = "\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044e " + this.userNode.getName() + " \u0441 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d\u043d\u044b\u043c \u0441\u0438\u0441\u0442\u0435\u043c\u043d\u044b\u043c \u043a\u043e\u0440\u043d\u0435\u0432\u044b\u043c \u0443\u0437\u043b\u043e\u043c \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d \u0434\u043e\u0441\u0442\u0443\u043f \u043a \u0441\u0435\u0440\u0432\u0435\u0440\u0443";
            this.out.putAnsi(116, msg);
            this.out.putAnsi(11, errorMsg + ADMIN_PART_MSG);
            this.loginInfo.registrateFailedLogin(errorMsg + ":" + msg, "#16" + callPlace);
            this.dropLogin();
            return true;
        }
        this.ssContext.userId = this.loginInfo.userId = this.userNode.getId();
        this.loginInfo.secutity = new Security(this.loginInfo.userId);
        String blockMessage = LoginController.isBlocked(this.userNode.getId());
        if (blockMessage != null) {
            this.registerFailedLoginCount(LoginController.Result.Failed);
            this.out.putAnsi(11, "\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c " + this.userNode.getName() + " \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e \u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c, \u043f\u043e\u043f\u0440\u043e\u0431\u0443\u0439\u0442\u0435 \u043f\u043e\u0432\u0442\u043e\u0440\u0438\u0442\u044c \u043f\u043e\u043f\u044b\u0442\u043a\u0443 \u043f\u043e\u0437\u0434\u043d\u0435\u0435");
            this.loginInfo.registrateFailedLogin(blockMessage, "#17" + callPlace);
            this.dropLogin();
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private void initStage(AbstractTaggedReader in) throws Exception {
        block2 : switch (in.getCurrentTag()) {
            case 97: {
                this.loginInfo.sessionId = in.getDouble();
                break;
            }
            case 30: {
                this.clientId = in.getInt();
                break;
            }
            case 20: {
                this.loginInfo.userName = in.getAnsi();
                break;
            }
            case 26: {
                this.loginInfo.hostUserName = in.getAnsi();
                break;
            }
            case 27: {
                this.loginInfo.hostComputerName = in.getAnsi();
                break;
            }
            case 41: {
                this.domainName = in.getAnsi();
                break;
            }
            case 129: {
                this.loginInfo.effectiveUserId = in.getDouble();
                break;
            }
            case 42: {
                this.activeDirectoryAuthorization = true;
                break;
            }
            case 14: {
                this.needLogin = true;
                break;
            }
            case 17: {
                this.loginInfo.serverToServerLogin = true;
                break;
            }
            case 137: {
                this.loginInfo.clientType = ClientProtocol.ClientType.getType(in.getInt());
                break;
            }
            case 71: {
                this.loginInfo.clientVersion.setBinary(in.getRaw());
                break;
            }
            case 134: {
                this.loginInfo.authorizationType = in.getInt();
                switch (this.loginInfo.authorizationType) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        break block2;
                    }
                }
                this.loginInfo.authorizationType = 0;
                break;
            }
            case 128: {
                this.loginInfo.productInfo.load(in.getStreamReader());
                this.loginInfo.clientVersion.setChannel(this.loginInfo.productInfo.channel());
                this.loginInfo.clientVersion.setUpdate(this.loginInfo.productInfo.update());
                break;
            }
            case 78: {
                this.loginInfo.clientLevel = in.getInt();
                break;
            }
            case 44: {
                this.loginInfo.serverHostName = in.getAnsi();
                break;
            }
            case 31: {
                this.loginInfo.packTraffic = true;
                break;
            }
            case 127: {
                this.wasmHttpSessionID = in.getAnsi();
                this.isValidWasmHttpSessionID = HttpServer.isValidWasmTicket(this.wasmHttpSessionID);
                break;
            }
            case 142: {
                this.encodedJWT = in.getAnsi();
                break;
            }
            case 135: {
                this.loginInfo.certName = in.getString();
                break;
            }
            case 131: {
                switch (in.getInt()) {
                    case 4: {
                        this.clientHasTLSCapability = true;
                        break block2;
                    }
                    case 6: {
                        this.isWasmHttpSessionIDV2 = true;
                        break block2;
                    }
                }
                break;
            }
            case 138: {
                if (!Core.isTimeZoneConversionUsed) break;
                this.loginInfo.timeZoneOffset = in.getInt() * 1000;
                this.loginInfo.timeZoneAssigned = -86400000 <= this.loginInfo.timeZoneOffset && this.loginInfo.timeZoneOffset <= 86400000;
                break;
            }
            case 9: {
                if (this.loginInfo.sessionId == 0.0) {
                    this.loginInfo.sessionId = Core.generateId();
                    this.loginInfo.auditId = 0.0;
                } else {
                    this.loginInfo.auditId = this.loginInfo.sessionId;
                }
                this.out.putSignature();
                this.out.putInt32(7, 10);
                jwt = null;
                if (!Strings.isVoid(this.wasmHttpSessionID)) {
                    jwtFromSession = HttpServer.popJwtFromSession(this.wasmHttpSessionID);
                    if (Strings.isVoid(this.encodedJWT)) {
                        this.encodedJWT = jwtFromSession;
                    } else if (!Strings.isVoid(jwtFromSession) && !this.encodedJWT.equals(jwtFromSession)) {
                        this.out.putAnsi(11, "\u041d\u0435\u043a\u043e\u043d\u0441\u0438\u0441\u0442\u0435\u043d\u0442\u043d\u043e\u0435 \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435 JWT");
                        this.dropLogin();
                        return;
                    }
                    if (Ini.UsePersistentSessions && this.isWasmHttpSessionIDV2) {
                        persistentSessionId = HttpServer.getPersistentSessionIdFromWasmSession(this.wasmHttpSessionID);
                        if (null == persistentSessionId) {
                            this.loginInfo.persistentSessionId = Core.generateId();
                        } else {
                            this.loginInfo.persistentSessionId = persistentSessionId;
                            this.userNode = PersistentSessionEngine.syncLoginInfoAndGetUserNode(this.loginInfo);
                            if (null == this.userNode) {
                                Core.logger.error("PersistentSession: sync login info error, maybe persistent session {} has expired", persistentSessionId);
                                this.out.putInt32(131, 13);
                                this.loginInfo.persistentSessionId = Core.generateId();
                            } else {
                                this.loginInfo.authorizationType = 4;
                            }
                        }
                    }
                }
                if (!Strings.isVoid(this.encodedJWT)) {
                    try {
                        jwt = new JWT(this.encodedJWT, "^__DEFAULT_TRUSTED_ORIGIN__^");
                    }
                    catch (JwtException e) {
                        this.out.putAnsi(11, "\u041d\u0435\u0432\u0430\u043b\u0438\u0434\u043d\u044b\u0439 JWT: " + e.getMessage());
                        this.dropLogin();
                        return;
                    }
                    if (Strings.isVoid(this.loginInfo.userName)) {
                        this.loginInfo.userName = jwt.username;
                    } else if (!this.loginInfo.userName.equals(jwt.username)) {
                        this.out.putAnsi(11, "\u041f\u0435\u0440\u0435\u0434\u0430\u043d\u043d\u043e\u0435 \u0438\u043c\u044f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f " + this.loginInfo.userName + " \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0438\u043c\u0435\u043d\u0438 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u0432 JWT" + jwt.username);
                        this.dropLogin();
                        return;
                    }
                    this.loginInfo.authorizationType = 3;
                }
                if (Ini.useTlsOverTcp && !this.isTlsSession) {
                    if (this.clientHasTLSCapability) {
                        this.out.putInt32(131, 3);
                    } else {
                        this.out.putAnsi(11, "\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0438\u0442\u044c\u0441\u044f \u043f\u043e \u043d\u0435\u0437\u0430\u0449\u0438\u0449\u0435\u043d\u043d\u043e\u043c\u0443 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044e. \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u043a\u043b\u0438\u0435\u043d\u0442 \u0441 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u043a\u043e\u0439 TLS.");
                    }
                    this.dropLogin();
                    return;
                }
                connectionType = 0;
                if (this.loginInfo.packTraffic) {
                    connectionType |= 1;
                }
                if (connectionType != 0) {
                    this.out.putInt32(31, connectionType);
                }
                if ((httpPort = HttpServer.port()) != 0) {
                    this.out.putInt16(49, (short)httpPort);
                    if (HttpServer.isHttpsProtocol()) {
                        this.out.putEmpty(8);
                    }
                } else if (Ini.extHttpsPort != 0) {
                    this.out.putInt16(49, (short)Ini.extHttpsPort);
                    this.out.putEmpty(8);
                } else if (Ini.extHttpPort != 0) {
                    this.out.putInt16(49, (short)Ini.extHttpPort);
                }
                this.out.putAnsi(118, this.loginInfo.peerIp);
                if (!this.needLogin) {
                    this.dropLogin();
                    return;
                }
                maxConnectionCount = Core.clientLimit();
                if (maxConnectionCount > 0 && ClientSession.clientSessionCount() >= maxConnectionCount) {
                    this.out.putAnsi(11, "\u041f\u0440\u0435\u0432\u044b\u0448\u0435\u043d\u043e \u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0439 \u043a \u0441\u0435\u0440\u0432\u0435\u0440\u0443");
                    this.dropLogin();
                    return;
                }
                if (Strings.isVoid(this.loginInfo.certName)) {
                    this.loginInfo.certName = this.loginInfo.userName;
                }
                this.loginInfo.ip = this.addr.getHostAddress();
                if (Ini.SafeMode) {
                    if (!Ini.SafeModeUserName.equals(this.loginInfo.userName)) {
                        this.failedMessage = "\u041d\u0435\u0432\u0435\u0440\u043d\u043e\u0435 \u0438\u043c\u044f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u0438\u043b\u0438 \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u043f\u0430\u0440\u043e\u043b\u044c";
                        this.out.putAnsi(11, this.failedMessage);
                        this.loginInfo.registrateFailedLogin(this.failedMessage, "#20");
                        this.dropLogin();
                        return;
                    }
                    this.activeDirectoryAuthorization = false;
                    this.userNode = MtdEngine.createSafeModeUser();
                } else {
                    MtdEngine.syncUser(this.loginInfo.userName);
                    this.userNode = MtdEngine.getUserNodeByName(this.loginInfo.userName);
                    v0 = this.loginInfo.isAnonUser = this.userNode != null && MtdEngine.serverNode().descriptor().webUser == this.userNode.getId();
                    if (this.loginInfo.isAnonUser) {
                        this.activeDirectoryAuthorization = false;
                    }
                    if (!this.activeDirectoryAuthorization) {
                        v1 = this.activeDirectoryAuthorization = this.userNode != null && this.userNode.isActiveDirectoryAuthorization() != false;
                    }
                    if (this.activeDirectoryAuthorization) {
                        try {
                            this.userNode = MtdEngine.getAcitiveDirectoryUserNodes(this.loginInfo.userName);
                        }
                        catch (InformException ex) {
                            Core.logger.error(null, ex);
                            this.failedMessage = ex.toString();
                            this.out.putAnsi(11, this.failedMessage);
                            this.loginInfo.registrateFailedLogin(this.failedMessage, "#21");
                            this.dropLogin();
                            return;
                        }
                    }
                    if (this.userNode == null) {
                        this.userNode = MtdEngine.getUserNodeByName(this.loginInfo.userName);
                    }
                    v2 = this.isLdapIntegration = (this.userNode == null || this.activeDirectoryAuthorization != false) && Strings.isVoid(this.wasmHttpSessionID) != false && LdapUser.useLDAP(this.getServerNodeDescriptor()) != false;
                    if (this.userNode != null && this.userNode.isActiveDirectoryAuthorization() != this.activeDirectoryAuthorization && Strings.isVoid(this.wasmHttpSessionID)) {
                        this.userNode = null;
                    }
                    if (!(this.userNode == null || this.loginInfo.isAnonUser || this.isWasmHttpSessionIDV2 || Strings.isVoid(this.wasmHttpSessionID) || this.userNode.isActiveDirectoryAuthorization() || null != jwt)) {
                        this.userNode = null;
                    }
                    if (this.isLdapIntegration && this.userNode == null) {
                        this.activeDirectoryAuthorization = true;
                    }
                }
                this.loginInfo.isDomainAuthentication = this.activeDirectoryAuthorization;
                if (this.isLdapIntegration && this.userNode != null && !this.userNode.serverManaged()) {
                    this.isLdapIntegration = false;
                }
                if ((!this.isLdapIntegration || this.userNode != null) && this.isUserNodeRestrictionsIncorrect(".1")) {
                    return;
                }
                this.out.putDouble(126, Core.getApplicationId());
                switch (this.loginInfo.authorizationType) {
                    case 0: 
                    case 1: {
                        if (Strings.isVoid(Ini.AD_DC)) break;
                        this.out.putInt32(131, 1);
                        this.out.putString(133, Ini.AD_DC);
                        break;
                    }
                    case 2: {
                        if (Strings.isVoid(Ini.GssService)) {
                            this.loginInfo.authorizationType = 0;
                            break;
                        }
                        this.out.putInt32(131, 2);
                        this.out.putString(133, Ini.GssService);
                        break;
                    }
                    case 3: {
                        break;
                    }
                    case 4: {
                        this.stage(Stage.PERSISTENT_SESSION_RESTORE);
                        this.persistentSessionDisposableKey = inform.agent.mtd.Security.sha256GenerateSalt();
                        this.out.putInt32(131, 11);
                        this.out.putRaw(143, this.persistentSessionDisposableKey);
                        this.out.putEmpty(9);
                        this.out.flush();
                        return;
                    }
                }
                if (!this.loginInfo.clientType.checkAuthorizedKey || !this.session.allowAuthorizedKeys || !Core.needCheckAuthorizedKeys()) ** GOTO lbl236
                this.stage(Stage.AUTHORIZED_KEY);
                this.disposibleKey = inform.agent.mtd.Security.generateSalt();
                this.out.putRaw(136, this.disposibleKey);
                ** GOTO lbl284
lbl236:
                // 1 sources

                if (!this.activeDirectoryAuthorization) ** GOTO lbl255
                if (Strings.isVoid(this.wasmHttpSessionID)) {
                    this.activeDirectory = ActiveDirectory.createInstance(this.loginInfo.authorizationType);
                    this.stage(Stage.BEGIN_ACTIVE_DIRECTORY_AUTHORIZATION);
                    this.out.putEmpty(46);
                } else {
                    if (!this.isValidWasmHttpSessionID) {
                        this.failedMessage = "\u0421\u0440\u043e\u043a \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u0430\u0443\u0442\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438 \u0437\u0430\u0432\u0435\u0440\u0448\u0451\u043d,\n\u043b\u0438\u0431\u043e \u043e\u0448\u0438\u0431\u043e\u0447\u043d\u0430\u044f \u043f\u043e\u043f\u044b\u0442\u043a\u0430 \u0432\u0445\u043e\u0434\u0430 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u043c Active Directory,\n\u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u044f \u043d\u0435 \u043f\u0440\u0435\u0434\u043d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u043d\u043e\u0435 \u0434\u043b\u044f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u0439 ActiveDirectory \u043e\u043a\u043d\u043e";
                        this.registerFailedLoginCount(LoginController.Result.Obsolete);
                        this.out.putAnsi(11, "\u0421\u0440\u043e\u043a \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u0430\u0443\u0442\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438 \u0437\u0430\u0432\u0435\u0440\u0448\u0451\u043d,\n\u043b\u0438\u0431\u043e \u043e\u0448\u0438\u0431\u043e\u0447\u043d\u0430\u044f \u043f\u043e\u043f\u044b\u0442\u043a\u0430 \u0432\u0445\u043e\u0434\u0430 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u043c Active Directory,\n\u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u044f \u043d\u0435 \u043f\u0440\u0435\u0434\u043d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u043d\u043e\u0435 \u0434\u043b\u044f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u0439 ActiveDirectory \u043e\u043a\u043d\u043e");
                        this.loginInfo.registrateFailedLogin(this.failedMessage, "#22");
                        this.out.putEmpty(9);
                        this.dropLogin();
                        return;
                    }
                    this.out.flush();
                    this.stage(Stage.CREATE_CLIENT);
                    this.createClientStage();
                    this.registerFailedLoginCount(LoginController.Result.Success);
                    return;
lbl255:
                    // 1 sources

                    if (this.loginInfo.isAnonUser && this.isValidWasmHttpSessionID) {
                        this.out.putInt32(131, 5);
                        this.out.flush();
                        this.stage(Stage.CONNECTED);
                        this.createClientStage();
                        this.registerFailedLoginCount(LoginController.Result.Success);
                        return;
                    }
                    if (null != jwt) {
                        this.out.flush();
                        this.stage(Stage.CONNECTED);
                        this.createClientStage();
                        this.registerFailedLoginCount(LoginController.Result.Success);
                        return;
                    }
                    this.stage(Stage.DEFAULT_AUTHORIZATION);
                    if (this.userNode.isSha256()) {
                        if (!this.isClientSupportSha256()) {
                            this.failedMessage = "\u0414\u043b\u044f \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u043d\u043e\u0432\u0430\u044f \u0432\u0435\u0440\u0441\u0438\u044f \u043a\u043b\u0438\u0435\u043d\u0442\u0430";
                            this.out.putAnsi(11, this.failedMessage);
                            this.loginInfo.registrateFailedLogin(this.failedMessage, "#22-1");
                            this.dropLogin();
                            return;
                        }
                        this.disposibleKey = inform.agent.mtd.Security.sha256GenerateSalt();
                        this.salt = this.userNode.getSha256Salt();
                    } else {
                        this.disposibleKey = inform.agent.mtd.Security.generateSalt();
                        this.salt = this.userNode.getSecuritySalt();
                    }
                    this.out.putRaw(22, this.salt);
                    this.out.putRaw(24, this.disposibleKey);
                    this.out.putEmpty(9);
                }
lbl284:
                // 3 sources

                this.out.flush();
            }
        }
    }

    private void persistentSessionRestoreStage(AbstractTaggedReader in) throws Exception {
        int currentTag = in.getCurrentTag();
        switch (currentTag) {
            case 9: {
                return;
            }
            case 131: {
                this.expectedExtraTag = in.getInt();
                if (13 != this.expectedExtraTag) break;
                Core.logger.error("Persistent session {} has been expired by client", this.loginInfo.persistentSessionId);
                HttpServer.removePersistentSessionIdFromWasmSession(this.wasmHttpSessionID);
                this.loginInfo.persistentSessionId = 0.0;
                this.dropLogin();
                break;
            }
            case 143: {
                switch (this.expectedExtraTag) {
                    case 12: {
                        byte[] userH2 = in.getRaw();
                        byte[] calcH2 = inform.agent.mtd.Security.sha256CalculateH2(this.loginInfo.persistentSessionH1, this.persistentSessionDisposableKey);
                        this.persistentSessionDisposableKey = null;
                        if (!inform.agent.mtd.Security.isHashEquals(userH2, calcH2)) {
                            this.out.putInt32(131, 13);
                            HttpServer.removePersistentSessionIdFromWasmSession(this.wasmHttpSessionID);
                            this.out.flush();
                            this.dropLogin();
                            return;
                        }
                        PersistentSessionEngine.updatePersistentSessionOnLogin(this.loginInfo.persistentSessionId, HttpServer.getUserAgentOfSession(this.wasmHttpSessionID));
                        this.stage(Stage.CREATE_CLIENT);
                        this.createClientStage();
                        this.registerFailedLoginCount(LoginController.Result.Success);
                        break;
                    }
                    default: {
                        Core.logger.error("PERSISTENT_SESSION_RESTORE Unexpected extraRaw tag {}", this.expectedExtraTag);
                        this.dropLogin();
                        return;
                    }
                }
                this.expectedExtraTag = 0;
                break;
            }
            default: {
                Core.logger.error("PERSISTENT_SESSION_RESTORE Unexpected tag #1 {}", currentTag);
                this.dropLogin();
            }
        }
    }

    private void persistentSessionInitStage(AbstractTaggedReader in) throws Exception {
        int currentTag = in.getCurrentTag();
        switch (currentTag) {
            case 9: {
                return;
            }
            case 131: {
                this.expectedExtraTag = in.getInt();
                break;
            }
            case 143: {
                switch (this.expectedExtraTag) {
                    case 10: {
                        if (!this.isWasmHttpSessionIDV2) {
                            Core.logger.error("PERSISTENT_SESSION_INIT invalid http session id {}", this.wasmHttpSessionID);
                            this.out.putInt32(131, 9);
                            break;
                        }
                        this.loginInfo.persistentSessionH1 = in.getRaw();
                        HttpServer.setPersistentSessionIdForWasmSession(this.wasmHttpSessionID, this.loginInfo.persistentSessionId);
                        PersistentSessionEngine.initPersistentSession(this.loginInfo, HttpServer.getUserAgentOfSession(this.wasmHttpSessionID));
                        this.out.putInt32(131, 8);
                        break;
                    }
                    default: {
                        Core.logger.error("PERSISTENT_SESSION_INIT Unexpected extraRaw tag, was waiting for #1 {}", this.expectedExtraTag);
                        this.out.putInt32(131, 9);
                    }
                }
                this.expectedExtraTag = 0;
                this.stage(Stage.CREATE_CLIENT);
                this.createClientStage();
                this.registerFailedLoginCount(LoginController.Result.Success);
                break;
            }
            default: {
                Core.logger.error("PERSISTENT_SESSION_INIT Unexpected tag {}", currentTag);
                this.out.putInt32(131, 9);
            }
        }
    }

    private void createClientStage() throws Exception {
        AuditJournal clientLogJournal;
        byte[] versionInfo;
        int loginCount;
        int possibleLoginCount;
        if (this.isLdapIntegration) {
            boolean needLaunchScript = false;
            boolean needCheckRestrictions = false;
            boolean needUpdateEndDate = false;
            LdapUser.Info ldapInfo = null;
            if (this.userNode == null) {
                ldapInfo = LdapUser.queryUserInfo(this.loginInfo.userName, this.getServerNodeDescriptor());
                this.userNode = LdapUser.createUserNode(ldapInfo, this.getServerNodeDescriptor());
                needLaunchScript = true;
                needCheckRestrictions = true;
            } else if (this.userNode instanceof VirtualUser) {
                VirtualUser user = (VirtualUser)this.userNode;
                double serverManagedEndDate = user.props().getServerManagedEndDate();
                needLaunchScript = serverManagedEndDate < DateTime.currentDateTime();
                needUpdateEndDate = needLaunchScript;
            }
            if (needLaunchScript) {
                if (ldapInfo == null) {
                    ldapInfo = LdapUser.queryUserInfo(this.loginInfo.userName, this.getServerNodeDescriptor());
                }
                LdapUser.updateUserNode(this.userNode.getId(), ldapInfo, this.getServerNodeDescriptor(), needUpdateEndDate);
            }
            if (needCheckRestrictions && this.isUserNodeRestrictionsIncorrect(".2")) {
                return;
            }
        }
        if (this.userNode == null) {
            if (this.isUserNodeRestrictionsIncorrect(".3")) {
                return;
            }
            if (this.userNode == null) {
                return;
            }
        }
        if (this.userNode.isServiceUser() && !this.loginInfo.serverToServerLogin) {
            this.failedMessage = "\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0438\u043d\u0442\u0435\u0440\u0430\u043a\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f \u0441\u043b\u0443\u0436\u0435\u0431\u043d\u044b\u043c \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u043c";
            this.out.putAnsi(11, BAD_LOGIN);
            this.loginInfo.registrateFailedLogin(this.failedMessage, "#23");
            this.dropLogin();
            return;
        }
        if (this.clientId != 0) {
            this.client = this.session.testAndGet(this.clientId);
        }
        if ((possibleLoginCount = this.userNode.getPossibleLoginCount()) == 0 && MtdEngine.serverNode().descriptor().allUserSingleLogin) {
            possibleLoginCount = 1;
        }
        if (possibleLoginCount != 0 && possibleLoginCount <= (loginCount = ClientSession.loginCount(this.userNode.getId()))) {
            this.failedMessage = "\u041f\u0440\u0435\u0432\u044b\u0448\u0435\u043d\u043e \u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0439 - " + possibleLoginCount + ".";
            this.out.putAnsi(11, this.failedMessage);
            this.loginInfo.registrateFailedLogin(this.failedMessage, "#24");
            this.dropLogin();
            return;
        }
        Core.logger.info("createClientStage tagVersionInfo {}", (Object)AgentJARVersion.asString());
        this.out.putRaw(71, VersionInfo.getBinary(AgentJARVersion.MAJOR, AgentJARVersion.MINOR, AgentJARVersion.RELEASE, AgentJARVersion.UPDATE));
        this.out.putInt32(131, 15);
        this.out.putString(133, AgentJARVersion.CHANNEL);
        if (!this.activeDirectoryAuthorization && !Ini.SafeMode) {
            if (this.userNode.isChangePasswordOnLogin()) {
                this.out.putEmpty(77);
            } else {
                ServerNode.Descriptor sd = this.getServerNodeDescriptor();
                if (sd.requiredChangeEmptyPassword && this.userNode.checkPassword("")) {
                    this.out.putEmpty(77);
                } else {
                    double days = DateTime.currentDate() - this.userNode.getPasswordChangeDate();
                    if (sd.passwordPeriod > 0 && days >= (double)sd.passwordPeriod) {
                        this.out.putEmpty(77);
                    }
                }
            }
        }
        if (Ini.ServerIdGeneratorNo > 0 || !Strings.isVoid(Ini.ServerIdGeneratorFunction)) {
            ByteArrayOutputStream args = new ByteArrayOutputStream();
            TaggedWriter stream = new TaggedWriter(args);
            stream.putDouble(1, IdGenerator.generateLoginTemplate());
            stream.putInt32(2, 9);
            stream.flush();
            this.out.putRaw(87, args);
        }
        if (!Ini.AgentID.isEmpty()) {
            this.out.putAnsi(51, Ini.AgentID);
        }
        if (!Ini.ServerID.isEmpty()) {
            this.out.putAnsi(50, Ini.ServerID);
        }
        if (!Strings.isVoid(Ini.AgentName)) {
            this.out.putString(54, Ini.AgentName);
        }
        if (Ini.ProcessID != 0 || !Strings.isVoid(Ini.FQDN)) {
            ByteArrayOutputStream agentInfo = new ByteArrayOutputStream();
            TaggedWriter stream = new TaggedWriter(agentInfo);
            if (Ini.ProcessID != 0) {
                stream.putInt32(32, Ini.ProcessID);
            }
            if (!Strings.isVoid(Ini.FQDN)) {
                stream.putString(37, Ini.FQDN);
            }
            if (Ini.authPasswordMinLength > 0) {
                stream.putInt32(38, Ini.authPasswordMinLength);
            }
            if (Ini.authPasswordComplex) {
                stream.putEmpty(39);
            }
            if (Ini.authPasswordDifferent) {
                stream.putEmpty(40);
            }
            stream.flush();
            this.out.putRaw(92, agentInfo);
        }
        if (Core.isTimeZoneConversionUsed) {
            this.out.putInt32(138, DateTime.serverZoneOffset() / 1000);
        }
        if (!Ini.NoUpdateClientInfo && (versionInfo = ClientUpdateInfo.getClientUpdateInfo(this.loginInfo.clientVersion, this.loginInfo.productInfo)) != null) {
            this.out.putRaw(62, versionInfo);
        }
        if ((clientLogJournal = new AuditJournal(AuditJournal.Journal.CLIENTLOG)).isEnabled()) {
            this.out.putBool(104, Ini.GetClientLogOnLogin);
        }
        int clientUpdateOption = 0;
        if (Ini.AutoConfirmAutoupdateClient) {
            clientUpdateOption |= 1;
        }
        if (clientUpdateOption != 0) {
            this.out.putInt32(80, clientUpdateOption);
        }
        this.out.putDouble(97, this.loginInfo.sessionId);
        this.out.putEmpty(10);
        if (this.session.isClosing() || !this.session.isConnected()) {
            return;
        }
        if (this.client == null) {
            this.client = new Client(this.session, this.userNode.getDbLogins());
        }
        this.out.putInt32(30, this.client.getClientId());
        this.out.putAnsi(20, this.loginInfo.userName);
        this.out.putDouble(29, this.userNode.getId());
        this.out.putEmpty(9);
        this.loginInfo.rootNodeId = this.userNode.getActualRootNodeId();
        this.loginInfo.registrateLogin(1, this.client.getClientId());
        this.client.setLoginInfo(this.loginInfo);
        this.stage(Stage.CONNECTED);
        this.session.switchProtocol(this.client);
        this.out.flush();
        this.client.writeLogInfo("login");
        TagVersionInfo minVersion = Core.getMinClientVersion(this.loginInfo.clientVersion.getMajor());
        TagVersionInfo maxVersion = Core.getMaxClientVersion();
        if (this.loginInfo.serverToServerLogin) {
            if (this.loginInfo.clientVersion.lessThen(minServerVersion)) {
                this.loginInfo.discardedVersion = true;
            }
        } else if (this.loginInfo.clientVersion.lessThen(minVersion) || maxVersion.lessThen(this.loginInfo.clientVersion)) {
            this.loginInfo.discardedVersion = true;
        }
        this.closeAd();
    }

    private void stage(Stage stage) {
        this.stage = stage;
        if (Ini.verbose) {
            Core.logger.info("Client({}):{}", (Object)this.session.channel.getRemoteAddress(), (Object)stage);
        }
    }

    ServerNode.Descriptor getServerNodeDescriptor() {
        if (this.serverNodeDescriptor == null) {
            this.serverNodeDescriptor = MtdEngine.serverNode().descriptor();
        }
        return this.serverNodeDescriptor;
    }

    @Override
    public void gatherTelemetry(Telemeter.Gatherer gatherer) throws IOException {
        gatherer.task(0, 64, this.stage.name(), this.thread);
    }

    private void registerFailedLoginCount(LoginController.Result result) throws InformException {
        boolean success;
        boolean bl = success = result == LoginController.Result.Success;
        if (success) {
            LoginController.successLogin(this.loginInfo.userId);
        } else {
            LoginController.failedLogin(this.loginInfo.userId, result);
        }
        int failedCount = MtdEngine.serverNode().descriptor().failedLoginCount;
        if (failedCount <= 0) {
            return;
        }
        MtdEngine.registerFailedLoginCount(this.loginInfo.userId, success);
    }

    @Override
    public void contextMessage(LogContext.Builder out) {
    }

    @Override
    public Client client() {
        return null;
    }

    @Override
    public RequestStatistics.Value rqstat() {
        return null;
    }

    @Override
    public SSContext getSSContext() {
        return this.ssContext;
    }

    private boolean isClientSupportSha256() {
        if (this.loginInfo == null || this.loginInfo.clientVersion == null) {
            return false;
        }
        if (this.loginInfo.clientVersion.getMajor() == 5) {
            return this.loginInfo.clientVersion.toNumber() >= VersionInfo.SHA256_PHX_CLIENT_VERSION;
        }
        return this.loginInfo.clientVersion.toNumber() >= VersionInfo.SHA256_RE_CLIENT_VERSION;
    }

    private static enum Stage {
        SIGNATURE,
        PROTOCOL_VERSION,
        INIT,
        BEGIN_ACTIVE_DIRECTORY_AUTHORIZATION,
        AUTHORIZED_KEY,
        DEFAULT_AUTHORIZATION,
        MASTER_USER_AUTHORIZATION,
        JWT_AUTHORIZATION,
        PERSISTENT_SESSION_INIT,
        PERSISTENT_SESSION_RESTORE,
        CREATE_CLIENT,
        CONNECTED,
        CLOSED;

    }
}

