/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.net;

import inform.adt.InformException;
import inform.adt.collections.DoubleHash;
import inform.adt.collections.DoubleSet;
import inform.agent.db.DBLogin;
import inform.agent.mtd.Acl;
import inform.agent.mtd.CalculateAccessMask;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.AccountNode;
import inform.agent.mtd.nodes.BasicNode;
import inform.agent.mtd.nodes.ConstantsNode;
import inform.agent.mtd.nodes.Node;
import inform.agent.mtd.nodes.UserNode;
import inform.agent.mtd.nodes.UserRole;
import java.util.ArrayList;
import java.util.Arrays;

public class Security {
    public static final Security ZERO = new Security(0.0);
    private final DoubleSet revokedRoles = new DoubleSet();
    private final DoubleHash<NodeAccessMask> masksCache = new DoubleHash();
    private int securityChangeNo;
    private AccountNode account;
    public final double id;

    public Security(double userId) {
        this.id = userId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int accessMask(Node node) throws InformException {
        NodeAccessMask nam;
        double nodeId = node.getId();
        int chNo = AccountNode.globalSecurityChangeNo();
        DoubleHash<NodeAccessMask> doubleHash = this.masksCache;
        synchronized (doubleHash) {
            if (this.securityChangeNo == chNo) {
                nam = this.masksCache.get(nodeId);
            } else {
                this.masksCache.clear();
                nam = null;
                this.securityChangeNo = chNo;
                this.account = null;
            }
        }
        if (nam == null) {
            AccountNode acc = this.account();
            int mask = acc == null ? 0 : Security.calculateAccessMask(node, acc, this.filterRoles(acc.effectiveGroups()));
            nam = new NodeAccessMask(nodeId, mask);
            DoubleHash<NodeAccessMask> doubleHash2 = this.masksCache;
            synchronized (doubleHash2) {
                this.masksCache.add(nam);
            }
        }
        return nam.mask;
    }

    public int accessMask(Acl acl) throws InformException {
        AccountNode acc = this.account();
        if (acc == null) {
            return 0;
        }
        return Security.calculateAccessMask(acl, acc.getId(), this.filterRoles(acc.effectiveGroups()));
    }

    public UserRole role() throws InformException {
        AccountNode acc = this.account();
        if (!(acc instanceof UserNode)) {
            return UserRole.DEFAULT;
        }
        return ((UserNode)acc).getRole();
    }

    public AccountNode.UserInterface userInterface() {
        AccountNode acc = this.account();
        if (!(acc instanceof UserNode)) {
            return new AccountNode.UserInterface();
        }
        return acc.getActualUserInterface();
    }

    public static int calculateAccessMask(Acl acl, double userId, double[] roles) {
        CalculateAccessMask calculator = new CalculateAccessMask();
        acl.updateAccessMasks(calculator, roles);
        acl.updateAccessMasks(calculator, userId, -1.0);
        return calculator.getMask();
    }

    public static int calculateAccessMask(Node node, AccountNode account, double[] roles) throws InformException {
        BasicNode n;
        UserRole role = account instanceof UserNode ? ((UserNode)account).getRole() : UserRole.DEFAULT;
        int result = Security.roleAccessMask(role, account.getId(), node);
        if (node instanceof ConstantsNode) {
            result |= Integer.MIN_VALUE;
        }
        if ((n = node.getRefNode()) == null) {
            return -1;
        }
        Acl acl = Security.acl(n);
        if (acl != null) {
            result |= Security.calculateAccessMask(acl, account.getId(), roles);
            if (role != UserRole.ADMIN && n instanceof UserNode && ((UserNode)n).getRole() == UserRole.ADMIN) {
                result &= 0xBFFFFFFF;
            }
        }
        return result;
    }

    public ArrayList<DBLogin> getDbLogins() throws InformException {
        AccountNode accountNode = this.account();
        return accountNode.getDbLogins();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double[] filterRoles(double[] roles) {
        DoubleSet doubleSet = this.revokedRoles;
        synchronized (doubleSet) {
            if (this.revokedRoles.empty()) {
                return roles;
            }
            double[] tmp = new double[roles.length];
            int idx = 0;
            for (double r : roles) {
                if (this.revokedRoles.contains(r)) continue;
                tmp[idx++] = r;
            }
            return Arrays.copyOf(tmp, idx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revokeRoles(double ... roles) {
        DoubleSet doubleSet = this.revokedRoles;
        synchronized (doubleSet) {
            for (double r : roles) {
                this.revokedRoles.add(r);
            }
        }
    }

    public AccountNode.UserInterface getUserInterface() {
        AccountNode node = this.account();
        return node.getActualUserInterface();
    }

    private static int roleAccessMask(UserRole role, double userId, Node node) {
        switch (role) {
            case ADMIN: {
                return -671088640;
            }
        }
        int mask = 0;
        if (node.getParentId() == userId) {
            mask |= 0xC0000000;
        }
        if (node.getId() == userId) {
            mask |= 0x90000000;
        }
        return mask;
    }

    private AccountNode account() throws InformException {
        AccountNode result = this.account;
        if (result == null) {
            this.account = result = MtdEngine.getValidAccountNode(this.id);
        }
        return result;
    }

    public static Acl acl(BasicNode node) throws InformException {
        if (node == null) {
            return null;
        }
        Acl r = node.acl();
        if (r != null) {
            return r;
        }
        Node n = MtdEngine.getNode(node.getParentId());
        while (n instanceof BasicNode) {
            node = (BasicNode)n;
            r = node.childrenAcl();
            if (r != null) {
                return r;
            }
            r = node.acl();
            if (r != null) {
                return r;
            }
            n = MtdEngine.getNode(node.getParentId());
        }
        return null;
    }

    private static class NodeAccessMask
    implements DoubleHash.Entry {
        private final double nodeId;
        private final int mask;

        public NodeAccessMask(double nodeId, int mask) {
            this.nodeId = nodeId;
            this.mask = mask;
        }

        @Override
        public double key() {
            return this.nodeId;
        }
    }
}

