/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.net.request;

import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Ini;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import java.io.File;
import java.io.FileInputStream;

public class GetFonts
extends Request {
    private static final String FONTS_INI_KEY = "fonts.ini";
    public static final int TAG_FAIL_MESSAGE = 1;
    public static final int TAG_FILE_NAME = 2;
    public static final int TAG_FILE_CONTENT = 3;

    public GetFonts(RequestHeader rq) {
        super(rq, RequestDuration.NORMAL);
    }

    @Override
    public void execute() throws Throwable {
        String fontName = "";
        TaggedReader in = this.createRequestContentReader();
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 2: {
                    fontName = in.getAnsi();
                }
            }
        }
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        TaggedWriter out = new TaggedWriter(result);
        this.sub(out, fontName);
        this.sendResult(result.internalBuffer(), result.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void sub(TaggedWriter out, String fontName) throws Throwable {
        String dirPath = Ini.HomePath + File.separator + "fonts";
        File dir = new File(dirPath);
        if (!dir.exists()) {
            out.putString(1, "The directory 'Fonts' doesn't exist in the root path.");
            return;
        }
        if (fontName.isEmpty()) {
            out.putString(1, "The name of the font is empty.");
            return;
        }
        if (fontName.toLowerCase().compareTo(FONTS_INI_KEY) != 0) {
            File fontFile = new File(dir, fontName);
            if (!fontFile.exists()) {
                out.putString(1, "The font '" + fontName + "' doesn't exist.");
                return;
            }
            this.readFile(out, fontFile, null);
        } else {
            try (ByteArrayOutputStream whole = new ByteArrayOutputStream();){
                for (String fileName : dir.list()) {
                    File fontFile;
                    if (!fileName.endsWith(".ini") || !(fontFile = new File(dir, fileName)).exists()) continue;
                    this.readFile(out, fontFile, whole);
                }
                if (whole.size() > 0) {
                    byte[] data = whole.toByteArray();
                    out.putAnsi(2, FONTS_INI_KEY);
                    out.putRaw(3, data, data.length);
                }
            }
        }
        out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFile(TaggedWriter out, File fontFile, ByteArrayOutputStream whole) throws Throwable {
        byte[] data = null;
        try (FileInputStream fin = new FileInputStream(fontFile);){
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            int n = 0;
            byte[] buf = new byte[4096];
            try {
                while ((n = fin.read(buf)) > -1) {
                    output.write(buf, 0, n);
                }
                data = output.toByteArray();
            }
            finally {
                output.close();
            }
        }
        if (data != null) {
            if (whole != null) {
                whole.write(data);
            } else {
                out.putAnsi(2, fontFile.getName());
                out.putRaw(3, data, data.length);
            }
        }
    }
}

