/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.net.request;

import inform.adt.Strings;
import inform.adt.taggedio.TagVersionInfo;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.AgentJARVersion;
import inform.agent.ClientUpdateInfo;
import inform.agent.Core;
import inform.agent.Ini;
import inform.agent.ProductInfo;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.RequestResult;
import inform.agent.VersionInfo;
import java.io.File;
import java.text.DateFormat;
import java.util.Date;

public class GetServerInfo
extends Request {
    private static final int TAG_SI_INFOSTRING = 1;
    private static final int TAG_SI_CLIENT_UPDATE_INFO = 2;
    private static final int TAG_SI_RENEWAL_INFO = 3;
    private static final int TAG_SI_GET_CLIENT_UPDATE_INFO = 4;
    private static final int TAG_SI_GET_RENEWAL_INFO = 5;
    private static final int TAG_SI_NO_SEREVER_INFO = 7;
    private static final int TAG_SI_GET_CLIENT_BAD_INFO = 8;
    private static final int TAG_SI_GET_LICENSE_INFO = 9;
    private static final int TAG_SI_LICENSE_INFO = 10;

    public GetServerInfo(RequestHeader rq) {
        super(rq, RequestDuration.NORMAL);
    }

    @Override
    public void execute() throws Throwable {
        StringBuilder info;
        TaggedReader in = this.createRequestContentReader();
        boolean needServerInfo = true;
        boolean getBadClientInfo = false;
        boolean getLastClientUpdate = false;
        boolean needLicenseInfo = false;
        String renewal = null;
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 8: {
                    getBadClientInfo = true;
                }
                case 4: {
                    getLastClientUpdate = true;
                    break;
                }
                case 5: {
                    renewal = in.getAnsi();
                    break;
                }
                case 7: {
                    needServerInfo = false;
                    break;
                }
                case 9: {
                    needLicenseInfo = true;
                }
            }
        }
        RequestResult result = new RequestResult(this);
        TaggedWriter out = result.getWriter();
        if (needServerInfo) {
            info = new StringBuilder();
            info.append("v ").append(AgentJARVersion.MAJOR).append('.').append(AgentJARVersion.MINOR).append('.').append(AgentJARVersion.RELEASE).append(AgentJARVersion.CHANNEL).append(AgentJARVersion.UPDATE).append(" x").append(Core.platformVersion).append(" [").append(DateFormat.getDateTimeInstance(2, 3).format(new Date(AgentJARVersion.BUILD_DATE))).append(']');
            if (Ini.MetabaseDBTypeName == null || Ini.MetabaseDBTypeName.isEmpty()) {
                info.append(" metabase !none");
            } else {
                info.append(" metabase ").append(Ini.MetabaseDBTypeName).append(' ').append(Ini.MetabaseDB);
                if (!Strings.isVoid(Ini.MetabaseScheme)) {
                    info.append('[').append(Ini.MetabaseScheme).append(']');
                }
                info.append(' ').append(Ini.MetabaseLogin);
            }
            out.putAnsi(1, info.toString());
        }
        if (getLastClientUpdate) {
            VersionInfo maxVersion = new VersionInfo();
            ProductInfo productInfo = this.client().getProduct();
            File file = ClientUpdateInfo.getMaxVersion(this.getClientVersion(), ClientUpdateInfo.getBadVersions(productInfo), maxVersion, productInfo);
            if (file != null && file.canRead()) {
                StringBuilder info2 = new StringBuilder();
                info2.append("\u041f\u043e\u0441\u043b\u0435\u0434\u043d\u044f\u044f \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430\u044f \u0432\u0435\u0440\u0441\u0438\u044f \u043a\u043b\u0438\u0435\u043d\u0442\u0430 ").append(maxVersion.toString()).append(" \u0440\u0430\u0437\u043c\u0435\u0440 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f ").append(this.sizeToString(file.length()));
                out.putAnsi(2, info2.toString());
            }
        }
        if (renewal != null && !renewal.isEmpty()) {
            info = new StringBuilder();
            info.append("\u041e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 \u0434\u043b\u044f ").append(renewal);
            TagVersionInfo maxVersion = new TagVersionInfo();
            File maxFile = ClientUpdateInfo.getMaxRenewal(renewal, maxVersion);
            if (maxFile != null && maxFile.canRead()) {
                info.append(' ').append(maxFile.getName()).append(" \u0440\u0430\u0437\u043c\u0435\u0440 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f ").append(this.sizeToString(maxFile.length()));
            } else {
                info.append(" \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442");
            }
            out.putAnsi(3, info.toString());
        }
        if (needLicenseInfo) {
            out.putString(10, Core.licenseLimitTexts());
        }
        result.sendResult();
    }

    private String sizeToString(long size) {
        long S1MB = 0x100000L;
        if (size > 0x100000L) {
            return size / 0x100000L + "Mb";
        }
        return size + " bytes";
    }
}

