/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.net.request;

import inform.adt.InformException;
import inform.adt.collections.Cursor;
import inform.adt.collections.DoubleSet;
import inform.adt.taggedio.TaggedReader;
import inform.agent.Core;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import java.io.IOException;

public class SendNotification
extends Request {
    public static final int TAG_NOTIFICATION_TOPIC_USER_ID = 1;
    public static final int TAG_NOTIFICATION_TOPIC_CONTENT = 2;
    private DoubleSet users = null;
    private byte[] content = null;

    public SendNotification(RequestHeader rq) {
        super(rq, RequestDuration.NORMAL);
    }

    @Override
    public void execute() throws Throwable {
        TaggedReader in = this.createRequestContentReader();
        this.users = null;
        this.content = null;
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 1: {
                    if (this.users == null) {
                        this.users = new DoubleSet();
                    }
                    this.users.add(in.getDouble());
                    break;
                }
                case 2: {
                    this.content = in.getRaw();
                    this.send();
                }
            }
        }
    }

    private void send() throws InformException, IOException {
        if (this.users == null || this.content == null) {
            return;
        }
        for (Cursor.Double userId : this.users) {
            Core.sendUserNotification(userId.value, this.content);
        }
        this.users = null;
        this.content = null;
    }
}

