/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.replication;

import inform.adt.DateTime;
import inform.adt.InformException;
import inform.adt.LittleEndian;
import inform.adt.NumberConverter;
import inform.adt.TimeZoneHost;
import inform.adt.TimeZoneOffsetHost;
import inform.adt.collections.DoubleSet;
import inform.adt.collections.IntegerSet;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.agent.Core;
import inform.agent.Ini;
import inform.agent.ServerSideHost;
import inform.agent.db.AbstractConnectionManager;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.PhenixLinks;
import inform.agent.db.TableDescriptor;
import inform.agent.db.commit.AuditModification;
import inform.agent.db.commit.DeleteEngine;
import inform.agent.db.commit.TableDataAudit;
import inform.agent.db.connect.ConnectionManager;
import inform.agent.db.connect.Connector;
import inform.agent.db.connect.DatabaseCaps;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.connect.ResultSet;
import inform.agent.db.types.DataType;
import inform.agent.db.types.SqlDataType;
import inform.agent.db.utils.SqlCommand;
import inform.agent.db.utils.SqlExecutor;
import inform.agent.db.utils.SqlParameter;
import inform.agent.db.utils.SqlStringBuilder;
import inform.agent.db.utils.UnpackedRowContent;
import inform.agent.files.BFS;
import inform.agent.mtd.AccessMask;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.AccountNode;
import inform.agent.mtd.nodes.Node;
import inform.agent.mtd.nodes.TableNode;
import inform.agent.net.Security;
import inform.agent.replication.ModifyCommand;
import inform.agent.replication.TableDataIO;
import inform.agent.scripts.SSContext;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;

public class DataReplicationApplyEngine {
    private static final String INVALID_CONNECTION = "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u0441 \u0411\u0414 \u043f\u0440\u0438 \u0440\u0435\u043f\u043b\u0438\u043a\u0430\u0446\u0438\u0438 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438";
    private static final int MAX_UNCOMMITED_ROWS = 8192;
    private DoubleSet deletedRecords = null;
    public final ServerSideHost ssHost;
    public TimeZoneHost timeZoneHost;
    public final SSContext ssContext;
    public final double receivingId;
    public final double replicaId;
    private boolean datalogEnabled = true;
    private boolean auditAutoDetectFieldChanges = false;
    private boolean replaceData = false;
    private boolean deferredCheckConstraints = false;
    private boolean insertData = false;
    private boolean autoCommit = false;
    private double userId;
    private double dataLogOwnerId = 0.0;
    private double dataLogEventId = 0.0;
    private final double sessionId;
    private final double connectedUserId;
    private final ArrayList<TableDataIO.FieldMetadata> metadata = new ArrayList();
    private final AccountNode applyAccount;
    private AccountNode lastAccount = null;
    private Node lastTableNode = null;
    private DoubleSet modifyAccess = null;
    private DoubleSet insertAccess = null;
    private final AbstractConnectionManager connectionManager;
    private TableDescriptor currentTable = null;
    private Connection currentConnection = null;
    private final LinkedList<Connection> connections = new LinkedList();
    private final ModifyCommand modifyCommand;
    private int modificationCount = 0;
    private BFS bfs = null;
    private BFS.Replica bfsReplica = null;
    private BFS.ReplicationBlobFile rbf = null;
    private long recordCount;
    private boolean verbose = false;

    DataReplicationApplyEngine(SSContext context, double receivingId, double replicaId, ServerSideHost ssHost, TimeZoneHost timeZoneHost, AccountNode applyAccount) throws InformException {
        this.ssHost = ssHost;
        this.timeZoneHost = timeZoneHost;
        this.ssContext = context;
        this.applyAccount = applyAccount;
        this.receivingId = receivingId;
        this.replicaId = replicaId;
        this.userId = this.connectedUserId = ssHost.security().id;
        this.modifyCommand = new ModifyCommand(this, ssHost);
        this.sessionId = ssHost.getSessionID();
        this.connectionManager = new ConnectionManager(context, "DataReplicationApplyEngine", true);
    }

    void beginUploadTableData(TableDescriptor table) throws InformException, SQLException {
        this.currentTable = table;
        this.deletedRecords = null;
        if (!this.currentTable.isRealTable()) {
            return;
        }
        this.initConnection();
        if (this.replaceData) {
            this.dropTableData();
        }
        this.modifyCommand.setForceInsert(this.replaceData || this.insertData || !this.currentTable.isOperableTable());
    }

    boolean isRealCurrentTable() {
        return this.currentTable != null && this.currentTable.isRealTable();
    }

    void endUploadTableData() throws InformException, SQLException {
        this.idle();
        if (this.currentTable != null && this.currentTable.isRealTable()) {
            this.applyDelete();
            this.idle();
            this.modifyCommand.flush(true);
            this.idle();
            if (this.currentConnection != null && this.currentConnection.auditWriter != null) {
                this.currentConnection.auditWriter.flush();
            }
        }
        if (this.verbose && this.ssHost != null) {
            try {
                this.ssHost.putRequestStateText("\u0417\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u043e " + this.recordCount + " \u0437\u0430\u043f\u0438\u0441\u0435\u0439");
            }
            catch (Exception e) {
                Core.logger.error(null, e);
                this.verbose = false;
            }
        }
        this.dataLogOwnerId = 0.0;
        this.dataLogEventId = 0.0;
        this.idle();
    }

    void updateTableDataTag(IntegerSet fieldFilter, TaggedReader in, String detailing) throws InformException, SQLException, IOException, NoSuchAlgorithmException {
        this.idle();
        switch (in.getCurrentTag()) {
            case 1: {
                if (this.currentTable != null) {
                    this.applyDelete();
                    if (this.verbose && this.ssHost != null) {
                        try {
                            this.ssHost.putRequestStateText("\u0417\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u043e " + this.recordCount + " \u0437\u0430\u043f\u0438\u0441\u0435\u0439");
                        }
                        catch (Exception e) {
                            Core.logger.error(null, e);
                            this.verbose = false;
                        }
                    }
                }
                this.loadMetadata(in.getStreamReader(), fieldFilter);
                this.recordCount = 0L;
                break;
            }
            case 14: {
                this.dataLogOwnerId = in.getDouble();
                break;
            }
            case 15: {
                this.dataLogEventId = in.getDouble();
                break;
            }
            case 2: {
                double rowId = in.getDouble();
                this.readUserId(in);
                this.deleteRow(this.currentTable.getNodeId(), rowId);
                this.registerModification(this.currentTable, rowId, AuditModification.DELETE, true, 0.0, 0.0, 0.0);
                this.dataLogOwnerId = 0.0;
                this.dataLogEventId = 0.0;
                break;
            }
            case 4: {
                if (this.rbf != null) {
                    throw new IllegalStateException();
                }
                if (this.currentTable != null) {
                    this.applyDelete();
                }
                double rowId = in.getDouble();
                in.skipNextTag();
                this.userId = this.connectedUserId;
                if (in.getCurrentTag() == 9) {
                    this.readUserId(in);
                    in.skipNextTag();
                }
                this.dataLogOwnerId = 0.0;
                if (in.getCurrentTag() == 14) {
                    this.dataLogOwnerId = in.getDouble();
                    in.skipNextTag();
                }
                this.dataLogEventId = 0.0;
                if (in.getCurrentTag() == 15) {
                    this.dataLogEventId = in.getDouble();
                    in.skipNextTag();
                }
                double parentTableId = 0.0;
                double parentRowId = 0.0;
                if (in.getCurrentTag() == 21) {
                    parentTableId = in.getDouble(21);
                    parentRowId = in.getDouble(22);
                    in.skipNextTag();
                }
                if (in.getCurrentTag() == 23) {
                    this.applyLinked(in.getStreamReader(), rowId);
                    in.skipNextTag();
                }
                UnpackedRowContent unpacked = new UnpackedRowContent(rowId, parentTableId, parentRowId, this.userId, this.timeZoneHost);
                unpacked.dataLogOwnerId = this.dataLogOwnerId;
                unpacked.dataLogEventId = this.dataLogEventId;
                switch (in.getCurrentTag()) {
                    case 5: {
                        unpacked.unpack(in.getRaw(), this.metadata, this.currentTable);
                        break;
                    }
                    case 10: {
                        unpacked.unpackReplica(in.getRaw(), this.currentTable, detailing);
                        break;
                    }
                    default: {
                        TaggedReader.throwInvalidTag();
                    }
                }
                this.modifyRow(rowId, unpacked, parentTableId, parentRowId);
                this.checkBatchFlush();
                this.checkAutoCommit();
                this.dataLogOwnerId = 0.0;
                this.dataLogEventId = 0.0;
                break;
            }
            case 6: {
                if (this.currentTable != null) {
                    this.applyDelete();
                }
                double rowId = in.getDouble(6);
                double prevRowId = in.getDouble(7);
                this.readUserId(in);
                this.changeRowPrimaryKey(rowId, prevRowId);
                break;
            }
            case 8: {
                if (this.currentTable != null) {
                    this.applyDelete();
                }
                PhenixLinks.LinkRecord link = new PhenixLinks.LinkRecord();
                link.setBinary(in.getRaw());
                this.makeLink(link);
                break;
            }
            case 11: {
                if (this.bfsReplica == null) break;
                double[] ids = LittleEndian.toDoubleArray(in.getRaw());
                if (ids[0] != this.currentTable.getNodeId()) {
                    throw new IllegalMonitorStateException();
                }
                this.rbf = this.bfsReplica.addFile(this.currentTable, (int)ids[1], ids[2]);
                break;
            }
            case 12: {
                if (this.bfsReplica == null) break;
                if (this.rbf == null) {
                    throw new IllegalStateException();
                }
                this.rbf.writeFile(in.getRaw());
                break;
            }
            case 13: {
                byte[] digest;
                if (this.bfsReplica == null) break;
                if (this.rbf == null) {
                    throw new IllegalStateException();
                }
                this.rbf.endWrite();
                if (in.getCurrentTagSize() != 0 && !MessageDigest.isEqual(digest = in.getRaw(), this.rbf.digest)) {
                    throw new InformException("\u041d\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u044e\u0442 \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u043d\u044b\u0435 \u0441\u0443\u043c\u043c\u044b \u0431\u043b\u043e\u0431 \u0444\u0430\u0439\u043b\u0430").detail(this.rbf.logInfo());
                }
                this.rbf = null;
                break;
            }
            case 40: {
                this.logSlicePeriods(in.getStreamReader());
                break;
            }
            case 5: {
                int offset = in.getInt();
                if (!Core.isTimeZoneConversionUsed || this.timeZoneHost != null && this.timeZoneHost.getTimeZoneOffset() == offset) break;
                this.timeZoneHost = new TimeZoneOffsetHost(offset);
            }
        }
        this.idle();
    }

    void logSlicePeriods(TaggedReader in) throws IOException {
        double minChangesTime = 0.0;
        double minTransTime = 0.0;
        double maxTransTime = 0.0;
        int sampleMode = -1;
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 1: {
                    minChangesTime = in.getDouble();
                    break;
                }
                case 2: {
                    minTransTime = in.getDouble();
                    break;
                }
                case 3: {
                    maxTransTime = in.getDouble();
                    break;
                }
                case 4: {
                    sampleMode = in.getInt();
                }
            }
        }
        Core.logger.info("Table Data Slice - repl-sample-mode: {} tableId: {}, minChangeTime: {}, minTransTime: {}, maxTransTime: {}", sampleMode, NumberConverter.doubleToString(this.currentTable.getNodeId()), minChangesTime == 0.0 ? "-" : DateTime.toString(minChangesTime), minTransTime == 0.0 ? "-" : DateTime.toString(minTransTime), maxTransTime == 0.0 ? "-" : DateTime.toString(maxTransTime));
    }

    void updateTableData(IntegerSet fieldFilter, TaggedReader in, String detailing) throws InformException, IOException, SQLException, NoSuchAlgorithmException {
        while (in.next()) {
            this.updateTableDataTag(fieldFilter, in, detailing);
            this.idle();
        }
    }

    public void commit() throws SQLException, IOException {
        this.idle();
        for (Connection c : this.connections) {
            if (c.deleter == null) continue;
            c.deleter.applyReplica();
            c.deleter.checkReplicationReferringIntegrity();
        }
        for (Connection c : this.connections) {
            c.connection.commit();
            this.idle();
        }
        this.connectionManager.commit();
        if (this.bfsReplica != null) {
            this.bfsReplica.commit();
        }
        if (this.bfs != null) {
            this.bfs.commit();
        }
        this.idle();
    }

    public void close() {
        try {
            this.modifyCommand.close();
            for (Connection c : this.connections) {
                c.connection.close();
            }
        }
        finally {
            this.connectionManager.release();
        }
    }

    public void rollback() {
        if (this.bfsReplica != null) {
            this.bfsReplica.rollback();
        }
        if (this.bfs != null) {
            this.bfs.rollback();
        }
    }

    void setAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    void setDatalogEnabled(boolean datalogEnabled) {
        this.datalogEnabled = datalogEnabled;
    }

    public boolean isAuditAutoDetectFieldChanges() {
        return this.auditAutoDetectFieldChanges && !this.replaceData;
    }

    void setAuditAutoDetectFieldChangesEnabled(boolean value) {
        if (value) {
            this.datalogEnabled = true;
            this.auditAutoDetectFieldChanges = true;
        } else {
            this.auditAutoDetectFieldChanges = false;
        }
    }

    void setReplaceData(boolean replaceData) {
        this.replaceData = replaceData;
        if (replaceData) {
            this.insertData = true;
        }
    }

    void setInsertData(boolean insertData) {
        if (insertData) {
            this.insertData = true;
        }
    }

    void setDeferredCheckConstraints(boolean deferredCheckConstraints) {
        this.deferredCheckConstraints = deferredCheckConstraints;
    }

    private void checkAutoCommit() throws SQLException, InformException {
        if (!this.autoCommit) {
            return;
        }
        ++this.modificationCount;
        if (this.modificationCount > 8192 && this.currentConnection != null) {
            if (!this.currentConnection.connection.isTransactionSupported()) {
                this.autoCommit = false;
                return;
            }
            this.currentConnection.connection.commit();
            this.idle();
            Object tableId = "";
            if (this.currentTable != null) {
                tableId = "[" + this.currentTable.getLogNodeId() + "]";
            }
            Core.logger.info("auto commit {} {} rows", tableId, (Object)this.modificationCount);
            this.modificationCount = 0;
        }
    }

    private void checkBatchFlush() throws SQLException, InformException {
        this.checkConnection();
        this.modifyCommand.flush(Ini.VerboseReplication);
    }

    private void generateAlternativeWhere(SqlCommand command, UnpackedRowContent unpacked, double rowId, FieldDescriptor pkField) {
        assert (unpacked.altKeyFields.size() == unpacked.altKeyValues.size());
        this.idle();
        int count = unpacked.altKeyFields.size();
        String delimiter = " (";
        for (int i = 0; i < count; ++i) {
            String name = unpacked.altKeyFields.get(i);
            SqlParameter param = (SqlParameter)unpacked.altKeyValues.get(i);
            command.sqlText.append(delimiter).append(name);
            delimiter = " AND ";
            if (param.isNull()) {
                command.sqlText.append(" IS NULL");
                continue;
            }
            command.sqlText.append(" = ?");
            command.params.add(param);
        }
        if (count > 0) {
            command.sqlText.append(") OR");
        }
        command.sqlText.append(' ').append(pkField).append("=?");
        command.params.add(new SqlParameter().setDouble(rowId));
    }

    private void checkAlternativeKeyConflict(double remoteRowId, double rowId, ResultSet resultSet) throws SQLException, InformException {
        this.idle();
        if (!resultSet.next()) {
            return;
        }
        double rowID2 = resultSet.getDouble(1);
        StringBuilder msg = new StringBuilder();
        msg.append("\u041a\u043e\u043d\u0444\u043b\u0438\u043a\u0442 \u0430\u043b\u044c\u0442\u0435\u0440\u043d\u0430\u0442\u0438\u0432\u043d\u044b\u0445 \u043a\u043b\u044e\u0447\u0435\u0439, \u0434\u0432\u0435 \u0437\u0430\u043f\u0438\u0441\u0438 \u043f\u043e\u0434\u0445\u043e\u0434\u044f\u0442 \u0434\u043b\u044f \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f");
        if (this.currentTable != null) {
            msg.append(" table: [").append(this.currentTable.getLogNodeId()).append("] ").append(this.currentTable.getRawName());
        }
        msg.append(" id:").append(NumberConverter.doubleToString(remoteRowId));
        msg.append(" \u043a\u043e\u043d\u0444\u043b\u0438\u043a\u0442\u0443\u0435\u0442 \u0441 (").append(NumberConverter.doubleToString(rowId)).append(", ").append(NumberConverter.doubleToString(rowID2)).append(")");
        Core.logger.error(msg.toString());
        throw new InformException(msg.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void modifyRow(double rowId, UnpackedRowContent unpacked, double parentTableId, double parentRowId) throws InformException, IOException, SQLException {
        block15: {
            if (unpacked.fields.isEmpty()) {
                return;
            }
            this.checkConnection();
            if (this.verbose && this.ssHost != null) {
                ++this.recordCount;
                if (this.recordCount % 1000L == 0L) {
                    try {
                        this.ssHost.putRequestStateText("\u0417\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u043e " + this.recordCount + " \u0437\u0430\u043f\u0438\u0441\u0435\u0439");
                    }
                    catch (Exception e) {
                        Core.logger.error(null, e);
                        this.verbose = false;
                    }
                }
            }
            this.modifyCommand.setTable(this.currentTable, this.currentAuditWriter(), this.currentConnection.connection);
            this.modifyCommand.setDeletedRows(this.deletedRecords);
            this.modifyCommand.add(unpacked, this.isAuditAutoDetectFieldChanges());
            if (parentTableId > 0.0 && parentRowId > 0.0) {
                try (SqlExecutor select = PhenixLinks.createSelectLeftTableExecutor(this.ssContext, 1, this.currentConnection.connection);){
                    ((SqlParameter)select.params.get(0)).setDouble(parentTableId);
                    ((SqlParameter)select.params.get(1)).setDouble(parentRowId);
                    ((SqlParameter)select.params.get(2)).setDouble(this.currentTable.getNodeId());
                    ((SqlParameter)select.params.get(3)).setDouble(rowId);
                    try (ResultSet resultSet = select.executeQueryCached();){
                        if (resultSet.next()) break block15;
                        try (SqlExecutor insert = PhenixLinks.createInsertExecutor(this.ssContext, 1, this.currentConnection.connection);){
                            ((SqlParameter)insert.params.get(0)).setDouble(parentTableId);
                            ((SqlParameter)insert.params.get(1)).setDouble(parentRowId);
                            ((SqlParameter)insert.params.get(2)).setDouble(this.currentTable.getNodeId());
                            ((SqlParameter)insert.params.get(3)).setDouble(rowId);
                            insert.executeUpdateCached();
                            this.idle();
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeLink(PhenixLinks.LinkRecord link) throws InformException, SQLException {
        block8: {
            this.checkModifyAccess();
            this.checkConnection();
            SqlExecutor drop = PhenixLinks.createDeleteExecutor(this.ssContext, 2, this.currentConnection.connection);
            ((SqlParameter)drop.params.get(0)).setDouble(link.left.table);
            ((SqlParameter)drop.params.get(1)).setDouble(link.left.row);
            ((SqlParameter)drop.params.get(2)).setDouble(link.right.table);
            ((SqlParameter)drop.params.get(3)).setDouble(link.right.row);
            try {
                drop.executeUpdateCached();
                if (!link.dropped) {
                    SqlExecutor insert = PhenixLinks.createInsertExecutor(this.ssContext, 2, this.currentConnection.connection);
                    ((SqlParameter)insert.params.get(0)).setDouble(link.left.table);
                    ((SqlParameter)insert.params.get(1)).setDouble(link.left.row);
                    ((SqlParameter)insert.params.get(2)).setDouble(link.right.table);
                    ((SqlParameter)insert.params.get(3)).setDouble(link.right.row);
                    try {
                        insert.executeUpdateCached();
                        this.idle();
                    }
                    finally {
                        insert.close();
                    }
                    this.registerModification(this.currentTable, link.right.row, AuditModification.LINK_CREATE, false, 0.0, link.left.table, link.left.row);
                    break block8;
                }
                this.registerModification(this.currentTable, link.right.row, AuditModification.LINK_DROP, false, 0.0, link.left.table, link.left.row);
            }
            finally {
                drop.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyLinked(TaggedReader in, double rowId) throws InformException, SQLException, IOException {
        this.checkConnection();
        try (SqlExecutor select = PhenixLinks.createSelectLeftTableExecutor(this.ssContext, 2, this.currentConnection.connection);
             SqlExecutor insert = PhenixLinks.createInsertExecutor(this.ssContext, 2, this.currentConnection.connection);){
            ((SqlParameter)select.params.get(2)).setDouble(this.currentTable.getNodeId());
            ((SqlParameter)select.params.get(3)).setDouble(rowId);
            ((SqlParameter)insert.params.get(2)).setDouble(this.currentTable.getNodeId());
            ((SqlParameter)insert.params.get(3)).setDouble(rowId);
            while (in.next()) {
                double parentTableId = in.getDouble(21);
                double parentRowId = in.getDouble(22);
                ((SqlParameter)select.params.get(0)).setDouble(parentTableId);
                ((SqlParameter)select.params.get(1)).setDouble(parentRowId);
                try (ResultSet resultSet = select.executeQueryCached();){
                    if (resultSet.next()) continue;
                    this.idle();
                    ((SqlParameter)insert.params.get(0)).setDouble(parentTableId);
                    ((SqlParameter)insert.params.get(1)).setDouble(parentRowId);
                    insert.executeUpdateCached();
                    this.registerModification(this.currentTable, rowId, AuditModification.LINK_CREATE, false, 0.0, parentTableId, parentRowId);
                }
            }
        }
    }

    private void readUserId(TaggedReader in) throws IOException, TaggedReaderException {
        this.userId = in.getDouble(9);
        if (this.userId == -1.0) {
            this.userId = this.connectedUserId;
        }
    }

    private void loadMetadata(TaggedReader in, IntegerSet fieldFilter) throws IOException, TaggedReaderException {
        this.metadata.clear();
        TableDataIO.FieldMetadata field = null;
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 10: {
                    int fieldId = in.getInt();
                    field = new TableDataIO.FieldMetadata();
                    this.metadata.add(field);
                    field.id = fieldId;
                    field.type = SqlDataType.UNSUPPORTED;
                    field.used = fieldFilter.empty() || fieldFilter.contains(fieldId);
                    field.alternativeKey = false;
                    break;
                }
                case 12: {
                    if (field == null) break;
                    field.type = DataType.getDataTypeById(in.getInt()).toSqlDataType();
                    break;
                }
                case 56: {
                    if (field == null) break;
                    field.alternativeKey = true;
                }
            }
        }
    }

    private void checkDeleteEngine() throws InformException {
        double accountId;
        this.checkConnection();
        AccountNode account = this.getApplyAccount();
        double d = accountId = account == null ? this.userId : account.getId();
        if (this.currentConnection.deleter == null) {
            this.currentConnection.deleter = new DeleteEngine(this.ssContext, this.connectionManager, null, accountId, this.ssHost);
            this.currentConnection.deleter.setDisableRelatedDelete(true);
            this.currentConnection.deleter.setDisableChecking(Ini.SkipCheckReferringIntegrityReplication);
            this.currentConnection.deleter.setLogDeletingRecords(true);
        }
        this.currentConnection.deleter.setUserID(accountId);
    }

    private void applyDelete() throws InformException, SQLException {
        this.checkDeleteEngine();
        this.currentConnection.deleter.applyReplica();
        this.idle();
    }

    private void deleteRow(double tableId, double rowId) throws InformException, SQLException {
        this.checkDeleteEngine();
        this.currentConnection.deleter.deleteRow(tableId, rowId);
        this.idle();
        if (this.deletedRecords == null) {
            this.deletedRecords = new DoubleSet();
        }
        this.deletedRecords.add(rowId);
    }

    private void initConnection() throws InformException, SQLException {
        if (this.currentTable == null) {
            this.currentConnection = null;
            return;
        }
        double databaseId = this.currentTable.getDbId();
        if (this.currentConnection != null && this.currentConnection.database.getNodeId() == databaseId) {
            return;
        }
        for (Connection c : this.connections) {
            if (c.database.getNodeId() != databaseId) continue;
            this.currentConnection = c;
            return;
        }
        this.currentConnection = new Connection(this.currentTable, this.connectionManager, this.ssContext, this.deferredCheckConstraints);
        this.connections.addFirst(this.currentConnection);
        this.idle();
    }

    private void checkConnection() throws InformException {
        if (this.currentConnection == null) {
            if (this.currentTable != null && this.currentTable.isViewable() && !this.currentTable.hasStandartPrimaryKey()) {
                throw new InformException("\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u0442\u0430\u0431\u043b\u0438\u0446 \u0441 \u0441\u043e\u0441\u0442\u0430\u0432\u043d\u044b\u043c \u043f\u0435\u0440\u0432\u0438\u0447\u043d\u044b\u043c \u043a\u043b\u044e\u0447\u043e\u043c \u043d\u0435 \u043f\u043e\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f").detail(this.currentTable.toString());
            }
            throw new InformException(INVALID_CONNECTION);
        }
        this.idle();
    }

    private TableDataAudit currentAuditWriter() throws InformException {
        if (!this.datalogEnabled) {
            return null;
        }
        this.checkConnection();
        if (this.currentConnection.auditWriter == null) {
            DatabaseConnection c = this.currentConnection.connection;
            this.currentConnection.auditWriter = new TableDataAudit(this.ssContext, c, this.userId, 0.0, this.receivingId, this.replicaId, this.sessionId);
            this.currentConnection.auditWriter.setBatchMode(true);
        }
        this.currentConnection.auditWriter.setUserID(this.userId);
        this.currentConnection.auditWriter.setOwnerId(this.dataLogOwnerId);
        this.currentConnection.auditWriter.setAuditEventId(this.dataLogEventId);
        return this.currentConnection.auditWriter;
    }

    private void registerModification(TableDescriptor tableInfo, double rowId, AuditModification modification, boolean isActualOwner, double prevRowId, double masterTableId, double masterRowId) throws InformException, SQLException {
        this.idle();
        if (!this.datalogEnabled) {
            return;
        }
        this.checkConnection();
        if (this.currentConnection.auditWriter == null) {
            DatabaseConnection c = this.currentConnection.connection;
            this.currentConnection.auditWriter = new TableDataAudit(this.ssContext, c, this.userId, 0.0, this.receivingId, this.replicaId, this.sessionId);
            this.currentConnection.auditWriter.setBatchMode(true);
        }
        this.currentConnection.auditWriter.setUserID(this.userId);
        if (isActualOwner) {
            this.currentConnection.auditWriter.setOwnerId(this.dataLogOwnerId);
            this.currentConnection.auditWriter.setAuditEventId(this.dataLogEventId);
        }
        this.currentConnection.auditWriter.registrateModification(tableInfo, rowId, modification, prevRowId);
        this.idle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean truncateTableRecords(SSContext ssContext, Connector connector, TableNode tableNode, double userId, double receivingId, double replicaId, double sessionId, Security security) throws SQLException {
        int accessMask;
        TableDescriptor tableDescriptor = tableNode.getDescriptor();
        DatabaseDescriptor databaseDescriptor = tableDescriptor.getDatabaseDescriptor();
        switch (tableDescriptor.getKind()) {
            case INTERNAL: 
            case EXTERNAL: {
                break;
            }
            default: {
                return false;
            }
        }
        DatabaseCaps caps = databaseDescriptor.getDatabaseType().caps();
        int n = accessMask = security == null ? 0 : security.accessMask(tableNode);
        if (AccessMask.accessDenied(0x800000, accessMask)) {
            double id = security == null ? userId : security.id;
            StringBuilder msg = new StringBuilder();
            msg.append("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044e ");
            MtdEngine.appendUserNameForLog(msg, id);
            msg.append("\u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0434\u0430\u043d\u043d\u044b\u0445 \u0438\u0437 \u0442\u0430\u0431\u043b\u0438\u0446\u044b ");
            MtdEngine.appendNodeNameForLog(msg, tableDescriptor.getNodeId());
            throw new InformException(msg.toString());
        }
        SqlStringBuilder sql = new SqlStringBuilder();
        sql.append(caps.truncateTableRecords()).appendFull(tableDescriptor);
        DatabaseConnection connection = connector.connection();
        try (PreparedStatement statement = connection.prepareStatement(sql.toString());){
            statement.executeUpdate(ssContext);
            Core.logger.ddl("{}: truncated", (Object)tableDescriptor.toString());
        }
        TableDataAudit auditWriter = new TableDataAudit(ssContext, connection, userId, 0.0, receivingId, replicaId, sessionId);
        auditWriter.registrateModification(tableDescriptor, 0.0, AuditModification.DROP_TABLE, 0.0);
        auditWriter.flush();
        connection.commit();
        return true;
    }

    private void dropTableData() throws SQLException, InformException {
        this.checkDeleteAccess();
        this.checkConnection();
        SqlStringBuilder sql = new SqlStringBuilder();
        sql.append("delete from ").appendFull(this.currentTable);
        try (PreparedStatement statement = this.currentConnection.connection.prepareStatement(sql.toString());){
            statement.executeUpdate(this.ssContext);
        }
        this.registerModification(this.currentTable, 0.0, AuditModification.DROP_TABLE, false, 0.0, 0.0, 0.0);
    }

    private AccountNode getApplyAccount() {
        if (this.applyAccount != null) {
            return this.applyAccount;
        }
        if (this.lastAccount != null && this.lastAccount.getId() == this.userId) {
            return this.lastAccount;
        }
        this.lastAccount = MtdEngine.getAccountNode(this.userId);
        return this.lastAccount;
    }

    private Node getTableNode() {
        if (this.lastTableNode != null && this.lastTableNode.getId() == this.currentTable.getNodeId()) {
            return this.lastTableNode;
        }
        this.insertAccess = null;
        this.modifyAccess = null;
        this.lastTableNode = MtdEngine.getValidNode(this.currentTable.getNodeId());
        return this.lastTableNode;
    }

    private void checkDeleteAccess() {
        int accessMask;
        if (this.currentTable == null) {
            return;
        }
        Node node = this.getTableNode();
        AccountNode account = this.getApplyAccount();
        int n = accessMask = account == null ? 0 : Security.calculateAccessMask(node, account, account.effectiveGroups());
        if (AccessMask.accessDenied(0x800000, accessMask)) {
            double id = account == null ? this.userId : account.getId();
            StringBuilder msg = new StringBuilder();
            msg.append("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044e ");
            MtdEngine.appendUserNameForLog(msg, id);
            msg.append(" \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0434\u0430\u043d\u043d\u044b\u0445 \u0438\u0437 \u0442\u0430\u0431\u043b\u0438\u0446\u044b ");
            MtdEngine.appendNodeNameForLog(msg, this.currentTable.getNodeId());
            if (account == null) {
                msg.append(", \u0442\u0430\u043a \u043a\u0430\u043a \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c [").append(NumberConverter.doubleToString(this.userId)).append("] \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442");
            }
            throw new InformException(msg.toString());
        }
    }

    void checkModifyAccess() {
        int accessMask;
        if (this.currentTable == null) {
            return;
        }
        Node node = this.getTableNode();
        AccountNode account = this.getApplyAccount();
        if (this.modifyAccess == null) {
            this.modifyAccess = new DoubleSet();
        }
        if (account != null && !this.modifyAccess.add(account.getId())) {
            return;
        }
        int n = accessMask = account == null ? 0 : Security.calculateAccessMask(node, account, account.effectiveGroups());
        if (AccessMask.accessDenied(0x1000000, accessMask)) {
            double id = account == null ? this.userId : account.getId();
            StringBuilder msg = new StringBuilder();
            msg.append("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044e ");
            MtdEngine.appendUserNameForLog(msg, id);
            msg.append(" \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u0434\u0430\u043d\u043d\u044b\u0445 \u0442\u0430\u0431\u043b\u0438\u0446\u044b ");
            MtdEngine.appendNodeNameForLog(msg, this.currentTable.getNodeId());
            if (account == null) {
                msg.append(", \u0442\u0430\u043a \u043a\u0430\u043a \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c [").append(NumberConverter.doubleToString(this.userId)).append("] \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442");
            }
            throw new InformException(msg.toString());
        }
    }

    void checkInsertAccess() {
        int accessMask;
        if (this.currentTable == null) {
            return;
        }
        Node node = this.getTableNode();
        AccountNode account = this.getApplyAccount();
        if (this.insertAccess == null) {
            this.insertAccess = new DoubleSet();
        }
        if (account != null && !this.insertAccess.add(account.getId())) {
            return;
        }
        int n = accessMask = account == null ? 0 : Security.calculateAccessMask(node, account, account.effectiveGroups());
        if (AccessMask.accessDenied(0x2000000, accessMask)) {
            double id = account == null ? this.userId : account.getId();
            StringBuilder msg = new StringBuilder();
            msg.append("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044e ");
            MtdEngine.appendUserNameForLog(msg, id);
            msg.append(" \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0434\u0430\u043d\u043d\u044b\u0445 \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0443 ");
            MtdEngine.appendNodeNameForLog(msg, this.currentTable.getNodeId());
            if (account == null) {
                msg.append(", \u0442\u0430\u043a \u043a\u0430\u043a \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c [").append(NumberConverter.doubleToString(this.userId)).append("] \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442");
            }
            throw new InformException(msg.toString());
        }
    }

    private void changeRowPrimaryKey(double newRowId, double prevRowId) throws InformException, SQLException {
        this.checkModifyAccess();
        this.checkConnection();
        SqlCommand command = new SqlCommand();
        FieldDescriptor pkField = this.currentTable.getValidRecordIdField();
        command.sqlText.append("update ").appendFull(this.currentTable).append(" set ").append(pkField).append("=? where ").append(pkField).append("=?");
        command.params.add(new SqlParameter().setDouble(newRowId));
        command.params.add(new SqlParameter().setDouble(prevRowId));
        command.executeUpdate(this.ssContext, this.currentConnection.connection);
        this.registerModification(this.currentTable, newRowId, AuditModification.MODIFY, false, prevRowId, 0.0, 0.0);
    }

    private void idle() {
        if (this.ssHost != null) {
            this.ssHost.idle();
        }
    }

    public void setBfs(BFS bfs) {
        this.bfs = bfs;
        this.modifyCommand.setBfs(bfs);
    }

    void setBfsReplica(BFS.Replica bfsReplica) {
        this.bfsReplica = bfsReplica;
        this.modifyCommand.setBfsReplica(bfsReplica);
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    private static class Connection {
        final DatabaseDescriptor database;
        final DatabaseConnection connection;
        TableDataAudit auditWriter = null;
        DeleteEngine deleter = null;

        Connection(TableDescriptor table, AbstractConnectionManager connectionManager, SSContext ssContext, boolean deferredConstraints) throws InformException, SQLException {
            this.connection = connectionManager.getConnection(table.getDbId(), "DataReplicationApplyEngine:Connection");
            this.connection.setPendingDirty();
            if (deferredConstraints) {
                this.connection.setAllConstraintsDeferred(ssContext);
            }
            this.database = this.connection.getDescriptor();
        }
    }
}

