/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.replication;

import inform.adt.InformException;
import inform.adt.NumberConverter;
import inform.adt.Strings;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.SendReadyResponse;
import inform.adt.taggedio.SendReadyTaggedWriter;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.agent.Core;
import inform.agent.ServerSideHost;
import inform.agent.db.utils.SqlParameter;
import inform.agent.mtd.MtdEngine;
import inform.agent.net.AgentConnection;
import inform.agent.net.ClientProtocol;
import inform.agent.replication.ReplicationChannel;
import java.io.IOException;
import java.util.zip.DeflaterOutputStream;

public class NetChannel
extends ReplicationChannel
implements SendReadyResponse {
    private String server = "";
    private String agent = "";
    private double userId = 0.0;
    private String login = "";
    private String password = "";
    private AgentConnection connection = null;
    private AgentConnection.Request request = null;
    private ByteArrayOutputStream chunk = null;
    private DeflaterOutputStream compression = null;
    private SendReadyTaggedWriter out = null;
    private int chunkCount = 0;
    private long dataSize = 0L;
    private long sendedSize = 0L;

    public NetChannel(double id, ServerSideHost ssHost) {
        this(id, ssHost, 0.0);
    }

    public NetChannel(double id, ServerSideHost ssHost, double userId) {
        super(id, ssHost);
        this.userId = userId;
    }

    @Override
    public boolean setMaxChunkSize(int value) {
        return false;
    }

    public String getAgent() {
        return this.agent;
    }

    public void setAgent(String agent) {
        this.agent = agent;
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public String getName() {
        return "\u0421\u0435\u0442\u0435\u0432\u0430\u044f \u0440\u0435\u043f\u043b\u0438\u043a\u0430\u0446\u0438\u044f";
    }

    @Override
    public long getReplicaSize() {
        return this.sendedSize;
    }

    public AgentConnection getConnection() throws InformException {
        if (this.connection == null) {
            throw new InformException(String.format("\u041d\u0435\u0442 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f \u043a %s %s %s", this.server, this.agent, this.login));
        }
        return this.connection;
    }

    @Override
    public SendReadyTaggedWriter connect(double replicaId) throws InformException, IOException {
        Core.logger.info("\u0420\u0435\u043f\u043b\u0438\u043a\u0430\u0446\u0438\u044f \u0447\u0435\u0440\u0435\u0437 \u0441\u0435\u0442\u044c {}/{}", (Object)this.server, (Object)this.agent);
        this.idle();
        this.connection = new AgentConnection(ClientProtocol.ClientType.Replication, this.ssHost, this.server, this.agent, this.userId, this.login, this.password, this.id);
        AgentConnection.Request checkReceiving = new AgentConnection.Request(570, this.receivingId);
        try {
            this.connection.request(checkReceiving);
            this.connection.waitForResult();
            this.idle();
        }
        catch (AgentConnection.RemoteAgentError ex) {
            RuntimeException t = InformException.wrap(ex, "\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0443\u0437\u0435\u043b \u043f\u0440\u0438\u0435\u043c\u0430 \u0440\u0435\u043f\u043b\u0438\u043a\u0430\u0446\u0438\u0438 \u043d\u0430 \u0443\u0434\u0430\u043b\u0435\u043d\u043d\u043e\u043c \u0441\u0435\u0440\u0432\u0435\u0440\u0435");
            throw InformException.detail(t, "\u0443\u0437\u0435\u043b [" + NumberConverter.doubleToString(this.receivingId) + "]");
        }
        byte[][] receivingResult = checkReceiving.getResult();
        if (receivingResult != null && receivingResult.length > 0 && receivingResult[0] != null) {
            TaggedReader in = new TaggedReader(receivingResult[0]);
            while (in.next()) {
                this.idle();
                if (in.getCurrentTag() != 2) continue;
                int type = in.getInt();
                if (type == 23) break;
                MtdEngine.throwDetailError("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0443\u0437\u0435\u043b \u043f\u0440\u0438\u0435\u043c\u0430 \u0440\u0435\u043f\u043b\u0438\u043a\u0430\u0446\u0438\u0438 \u043d\u0430 \u0443\u0434\u0430\u043b\u0435\u043d\u043d\u043e\u043c \u0441\u0435\u0440\u0432\u0435\u0440\u0435", this.receivingId);
                break;
            }
        }
        this.chunk = new ByteArrayOutputStream();
        this.compression = new DeflaterOutputStream(this.chunk);
        this.out = new SendReadyTaggedWriter(this.compression, this);
        this.chunkCount = 0;
        this.idle();
        return this.out;
    }

    @Override
    public boolean isValid() {
        return this.server != null && !this.server.isEmpty() && this.login != null && !this.login.isEmpty();
    }

    @Override
    public void cancel() {
        if (this.connection != null) {
            try {
                if (this.connection.hasRequest()) {
                    this.connection.cancelCurrentRequest();
                }
            }
            catch (InformException ex) {
                Core.logger.error(null, ex);
            }
        }
        this.idle();
    }

    @Override
    protected void commit() throws InformException {
        this.idle();
        try {
            this.connection.sendEndOfChunks();
            this.connection.waitForResult();
        }
        catch (Throwable ex) {
            throw InformException.wrap(ex);
        }
    }

    @Override
    protected void ready(ReplicationChannel.Readme readme, byte[] info, int infoSize) throws InformException {
    }

    @Override
    public void close() {
        this.idle();
        if (this.connection == null) {
            return;
        }
        try {
            this.connection.close();
        }
        catch (Throwable ex) {
            Core.logger.error(null, ex);
        }
        this.idle();
    }

    @Override
    public int getOperationCode() {
        return 1;
    }

    @Override
    protected void flush() throws InformException, IOException {
        this.notifyReadyToSend();
    }

    @Override
    public void notifyReadyToSend() throws InformException, IOException {
        this.idle();
        if (this.out == null) {
            return;
        }
        if (this.out.getInputSize() == 0L) {
            return;
        }
        if (this.request == null) {
            this.request = new AgentConnection.Request(512, this.receivingId);
            this.connection.request(this.request);
        }
        this.out.flush();
        this.compression.close();
        this.idle();
        if (this.chunk.size() != 0) {
            ++this.chunkCount;
            long chunkDataSize = this.out.getInputSize();
            long chunkSize = this.chunk.size();
            this.dataSize += chunkDataSize;
            this.sendedSize += chunkSize;
            Core.logger.info("\u041e\u0442\u043f\u0440\u0430\u0432\u043a\u0430 \u0447\u0430\u0441\u0442\u0438 \u0440\u0435\u043f\u043b\u0438\u043a\u0438(\u043d\u043e\u043c\u0435\u0440 {}, \u0440\u0430\u0437\u043c\u0435\u0440 {}, \u0432\u0441\u0435\u0433\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e {})", this.chunkCount, chunkSize, this.sendedSize);
            this.connection.sendChunk(this.chunk.internalBuffer(), this.chunk.size());
        }
        this.chunk.reset();
        this.compression = new DeflaterOutputStream(this.chunk);
        this.out.reset(this.compression);
        this.idle();
    }

    @Override
    protected void loadFields(SqlParameter[] fields) {
        super.loadFields(fields);
        SqlParameter field = fields[4];
        if (field != null) {
            this.server = field.getString();
            if (Strings.isVoid(this.server)) {
                this.server = "";
            }
        }
        if ((field = fields[5]) != null) {
            this.agent = field.getString();
            if (Strings.isVoid(this.agent)) {
                this.agent = "";
            }
        }
        if ((field = fields[6]) != null) {
            this.login = field.getString();
            if (Strings.isVoid(this.login)) {
                this.login = "";
            }
        }
        if ((field = fields[7]) != null) {
            this.password = field.getString();
            if (Strings.isVoid(this.password)) {
                this.password = "";
            }
        }
    }

    @Override
    protected void loadTag(TaggedReader in) throws IOException, TaggedReaderException {
        switch (in.getCurrentTag()) {
            case 10: {
                this.server = in.getAnsi();
                break;
            }
            case 11: {
                this.agent = in.getAnsi();
                break;
            }
            case 12: {
                this.login = in.getAnsi();
                break;
            }
            case 13: {
                this.password = in.getAnsi();
                break;
            }
            default: {
                super.loadTag(in);
            }
        }
    }

    @Override
    public boolean getWriteInfo(ReplicationChannel.WriteInfo info) {
        if (info.chunkCount == this.chunkCount) {
            return false;
        }
        info.chunkCount = this.chunkCount;
        info.dataSize = this.dataSize;
        info.sendedSize = this.sendedSize;
        return true;
    }

    @Override
    public long getTransferSize() {
        if (this.out != null) {
            return this.dataSize + this.out.getInputSize();
        }
        return this.dataSize;
    }

    @Override
    protected int getChunkCount() {
        return this.chunkCount;
    }
}

