/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.replication;

import inform.adt.InformException;
import inform.adt.LittleEndian;
import inform.adt.taggedio.LittleEndianDataOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.mtd.MetadataNodeReader;
import inform.agent.scripts.SSContext;
import java.io.DataOutput;
import java.io.IOException;
import java.util.zip.Adler32;

public final class NodeCrc {
    public static final int TAG_NODE_ID = 1;
    public static final int TAG_CRC = 2;
    public static final int TAG_NODE_DIFFERENCE = 1;
    public static final int TAG_CHILDREN_DIFFERENCE = 2;
    public static final int TAG_DIFFERENCE = 3;
    public static final byte DIF_NODE = 1;
    public static final byte DIF_CHILDREN = 2;
    public final SSContext ssContext;
    private double nodeId = 0.0;
    private boolean hasNodeCrc = false;
    private boolean hasChildrenCrc = false;
    private int childrenCrc = 1;
    private int nodeCrc = 1;
    private double[] children;

    public NodeCrc(SSContext ssContext) {
        this.ssContext = ssContext;
    }

    public NodeCrc(SSContext ssContext, double nodeId, boolean calcChildrenCrc, DatabaseConnection connection) {
        this.nodeId = nodeId;
        this.hasChildrenCrc = calcChildrenCrc;
        this.ssContext = ssContext;
        this.calculate(connection);
    }

    public void reset(double nodeId, boolean calcChildrenCrc, DatabaseConnection connection) {
        this.nodeId = nodeId;
        this.hasNodeCrc = false;
        this.hasChildrenCrc = calcChildrenCrc;
        this.childrenCrc = 1;
        this.nodeCrc = 1;
        this.children = null;
        this.calculate(connection);
    }

    public byte difference(NodeCrc crc) {
        byte dif = 0;
        if (crc.hasNodeCrc != this.hasNodeCrc || this.hasNodeCrc && crc.nodeCrc != this.nodeCrc) {
            dif = (byte)(dif | 1);
        }
        if (crc.hasChildrenCrc != this.hasChildrenCrc || this.hasChildrenCrc && crc.childrenCrc != this.childrenCrc) {
            dif = (byte)(dif | 2);
        }
        return dif;
    }

    public double getNodeId() {
        return this.nodeId;
    }

    public boolean isHasChildrenCrc() {
        return this.hasChildrenCrc;
    }

    public double[] getChildren() {
        if (this.hasChildrenCrc) {
            return this.children;
        }
        return null;
    }

    public void store(TaggedWriter out) throws IOException {
        if (!this.hasNodeCrc) {
            return;
        }
        out.putDouble(1, this.nodeId);
        if (this.hasChildrenCrc) {
            out.putIntArray(2, new int[]{this.nodeCrc, this.childrenCrc});
        } else {
            out.putInt32(2, this.nodeCrc);
        }
        out.flush();
    }

    public void storeDifference(NodeCrc crc, TaggedWriter out) throws IOException {
        byte dif = this.difference(crc);
        switch (dif) {
            case 0: {
                break;
            }
            case 1: {
                out.putDouble(1, this.nodeId);
                break;
            }
            case 2: {
                out.putDouble(2, this.nodeId);
                break;
            }
            case 3: {
                out.putDouble(3, this.nodeId);
            }
        }
    }

    public void load(TaggedReader in) throws IOException, TaggedReaderException {
        this.hasNodeCrc = false;
        this.hasChildrenCrc = false;
        this.nodeCrc = 1;
        this.childrenCrc = 1;
        do {
            switch (in.getCurrentTag()) {
                case 1: {
                    this.nodeId = in.getDouble();
                    break;
                }
                case 2: {
                    this.hasNodeCrc = true;
                    int[] crc = LittleEndian.toIntArray(in.getRaw());
                    this.nodeCrc = crc[0];
                    if (crc.length > 1) {
                        this.hasChildrenCrc = true;
                        this.childrenCrc = crc[1];
                    }
                    return;
                }
            }
        } while (in.next());
    }

    private static int bytesAdler(byte[] bytes) {
        Adler32 adler = new Adler32();
        if (bytes != null) {
            adler.update(bytes);
        }
        return (int)adler.getValue();
    }

    private static int dataStreamAdler(LittleEndianDataOutputStream.With writer) {
        try {
            return NodeCrc.bytesAdler(LittleEndianDataOutputStream.With.toBytes(writer));
        }
        catch (Throwable e) {
            throw InformException.wrap(e);
        }
    }

    private void calculate(final DatabaseConnection connection) {
        final MetadataNodeReader nodeReader = MetadataNodeReader.createNode(this.ssContext, this.nodeId, connection);
        if (nodeReader == null) {
            this.hasNodeCrc = false;
        } else {
            this.hasNodeCrc = true;
            if (this.hasChildrenCrc) {
                this.childrenCrc = NodeCrc.dataStreamAdler(new LittleEndianDataOutputStream.With(){

                    @Override
                    public void write(DataOutput stream) throws Throwable {
                        NodeCrc.this.children = MetadataNodeReader.getNodeChildrenIds(null, connection, NodeCrc.this.nodeId);
                        if (NodeCrc.this.children != null) {
                            for (double childNodeId : NodeCrc.this.children) {
                                stream.writeDouble(childNodeId);
                            }
                        }
                    }
                });
            }
            this.nodeCrc = NodeCrc.dataStreamAdler(new LittleEndianDataOutputStream.With(){

                @Override
                public void write(DataOutput stream) throws Throwable {
                    if (nodeReader.attributesContent == null) {
                        stream.write(0);
                    } else {
                        stream.write(1);
                        stream.write(nodeReader.attributesContent);
                    }
                    stream.writeDouble(nodeReader.parentId);
                    stream.writeInt(nodeReader.type);
                    if (nodeReader.name == null) {
                        stream.write(0);
                    } else {
                        stream.write(1);
                        stream.writeUTF(nodeReader.name);
                    }
                    if (nodeReader.identName == null) {
                        stream.write(0);
                    } else {
                        stream.write(1);
                        stream.writeUTF(nodeReader.identName);
                    }
                    if (nodeReader.description == null) {
                        stream.write(0);
                    } else {
                        stream.write(1);
                        stream.writeUTF(nodeReader.description);
                    }
                    stream.writeDouble(nodeReader.ownerId);
                    stream.writeInt(nodeReader.orderNo);
                    stream.writeDouble(nodeReader.modificationContentTime);
                }
            });
        }
    }
}

