/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.replication;

import inform.adt.DateTime;
import inform.adt.InformException;
import inform.adt.LittleEndian;
import inform.adt.Memory;
import inform.adt.NumberConverter;
import inform.adt.Strings;
import inform.adt.collections.Cursor;
import inform.adt.collections.DoubleHash;
import inform.adt.collections.DoubleList;
import inform.adt.collections.DoubleSet;
import inform.adt.collections.IntegerSet;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.SendReadyTaggedWriter;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.Ini;
import inform.agent.ServerSideHost;
import inform.agent.VersionInfo;
import inform.agent.db.AbstractConnectionManager;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.TableDescriptor;
import inform.agent.db.commit.TableDataAudit;
import inform.agent.db.connect.ConnectionManager;
import inform.agent.db.connect.Connector;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.connect.ResultSet;
import inform.agent.db.types.DataType;
import inform.agent.db.utils.SqlStringBuilder;
import inform.agent.mtd.AuditJournal;
import inform.agent.mtd.LockEngine;
import inform.agent.mtd.MetadataNodeReader;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.NodeLock;
import inform.agent.mtd.nodes.Node;
import inform.agent.mtd.nodes.UserNode;
import inform.agent.net.AgentConnection;
import inform.agent.replication.NetChannel;
import inform.agent.replication.NodeCrc;
import inform.agent.replication.ReplicationChannel;
import inform.agent.replication.ReplicationConf;
import inform.agent.replication.ReplicationException;
import inform.agent.replication.TableDataIO;
import inform.agent.scripts.Constant;
import inform.agent.scripts.Constants;
import inform.agent.scripts.SSContext;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;

public class Replication
implements TableDataIO.Idler,
ReplicationChannel.Readme {
    public static final long MIN_APPLY_REPLICATION_SERVER_WITH_DSL_VERSION = VersionInfo.toNumber(5L, 2L, 3022L);
    private static final int MTD_CHUNK_SIZE = 0x400000;
    private static final int DATA_CHUNK_SIZE = 0x2000000;
    static final int SCOPE_METADATA = 1;
    static final int SCOPE_DATA = 2;
    static final int SYNC_CHILDREN = 4;
    static final int AUTHENTICATION_ONLY = 8;
    private final AuditJournal.ReplicationParams audit = new AuditJournal.ReplicationParams();
    private final ServerSideHost host;
    protected final ReplicaContext ssContext;
    private final ReplicationChannel channel;
    private final double replNodeId;
    private double userId;
    private boolean startReplicaOnly = false;
    private double startReplicaDate = DateTime.currentDateTime();
    private boolean fullReplica = false;
    private boolean syncMetadata = false;
    private boolean disableAudit = false;
    private boolean replaceData = false;
    private boolean cancelIfNoData = false;
    private int useFieldChanges = 0;
    private boolean deferrableCheckConstraints = false;
    private final ByteArrayOutputStream infoData = new ByteArrayOutputStream();
    private final TaggedWriter infoOut = new TaggedWriter(this.infoData);
    private final ReplicationChannel.WriteInfo channelInfo;
    private long replicaSize = 0L;
    private final AbstractConnectionManager connectionManager;
    private final Connector metabaseConnector;
    private double replicaId;
    private int processedRows;
    private final DataParam dataParam = new DataParam();
    private final DoubleHash<MetaItem> metaCache = new DoubleHash();
    private final ArrayList<MetaItem> metaList = new ArrayList();
    private boolean hasTableNodes = false;
    private final ArrayList<TableDataIO.ReplicationItem> dataList = new ArrayList();
    private final ArrayList<TableDataIO.ReplicationItem> checkDataList = new ArrayList();
    private final DoubleSet sharedConf = new DoubleSet();
    private final DoubleList conf = new DoubleList(8);
    private Stage stage = Stage.CONNECTING_TO_REMOTE_SERVER;
    private String lastInfo = null;
    private boolean requestStateLogEnabled = true;
    private int mtdChunkSize = 0x400000;
    private int dataChunkSize = 0x2000000;
    private String mode = null;
    private boolean ignoreNoneAuditTables = false;
    private double maxRange = 0.0;
    private long startReplicationTime;
    private ScopeList scopeList = null;
    private final DoubleHash<TransParams> transParams = new DoubleHash();
    private double maxTransEndTime = 0.0;
    private static final TableDataIO.RowStats emptyRowStats = new TableDataIO.RowStats();
    private long minApplyServerVersion = 0L;

    public Replication(SSContext parentContext, ServerSideHost host, double replNodeId, ReplicationChannel channel) throws InformException, IOException {
        if (channel != null && channel.receivingId == 0.0) {
            StringBuilder msg = new StringBuilder("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u0443\u0437\u0435\u043b \u043f\u0440\u0438\u0451\u043c\u0430\n\u043a\u0430\u043d\u0430\u043b \u0440\u0435\u043f\u043b\u0438\u043a\u0430\u0446\u0438\u0438:");
            channel.appendNodeNameForLog(msg);
            throw new InformException(msg.toString());
        }
        this.host = host;
        this.replNodeId = replNodeId;
        this.channel = channel;
        this.channelInfo = new ReplicationChannel.WriteInfo();
        parentContext = SSContext.getContext(parentContext);
        this.ssContext = new ReplicaContext(parentContext);
        this.ssContext.nodeId = replNodeId;
        if (channel != null) {
            this.ssContext.channelId = channel.getId();
            this.ssContext.type = channel.getName();
            channel.setContext(this.ssContext);
        }
        this.connectionManager = new ConnectionManager(this.ssContext, "Replication", true);
        this.metabaseConnector = this.connectionManager.metadataConnector("Replication");
        if (host != null) {
            this.userId = host.security().id;
        }
        this.loadProps();
    }

    public void setStartReplicaDate(double startReplicaDate) {
        this.startReplicaOnly = true;
        this.startReplicaDate = startReplicaDate;
    }

    void setMaxChunkSize(int chunkSize) {
        if (this.channel.setMaxChunkSize(chunkSize)) {
            this.mtdChunkSize = chunkSize;
            this.dataChunkSize = chunkSize;
            return;
        }
        if (chunkSize < 4096) {
            chunkSize = 4096;
        }
        this.mtdChunkSize = chunkSize < 0x400000 ? chunkSize : 0x400000;
        this.dataChunkSize = chunkSize < 0x2000000 ? chunkSize : 0x2000000;
    }

    long getReplicaSize() {
        return this.replicaSize;
    }

    public void setRequestStateLogEnabled(boolean requestStateLogEnabled) {
        this.requestStateLogEnabled = requestStateLogEnabled;
    }

    public void putRequestStateLog(String msg) throws Exception {
        if (this.requestStateLogEnabled) {
            this.host.putRequestStateLog(msg);
        }
    }

    private StringBuilder getChannelInfo() {
        StringBuilder msg = new StringBuilder();
        msg.append("\u041f\u0435\u0440\u0435\u0434\u0430\u043d\u043e \u0434\u0430\u043d\u043d\u044b\u0445/\u0441\u0436\u0430\u0442\u044b\u0445/\u0447\u0430\u0441\u0442\u0435\u0439 [").append(this.channelInfo.dataSize).append("/").append(this.channelInfo.sendedSize).append("/").append(this.channelInfo.chunkCount).append("]");
        return msg;
    }

    private void updateChannelInfo() throws Exception {
        if (this.channel != null && this.channel.getWriteInfo(this.channelInfo)) {
            StringBuilder msg = this.getChannelInfo();
            Core.logger.info("export stage {} {}", (Object)this.stage, (Object)msg);
            this.putRequestStateLog(msg.toString());
        }
    }

    private void replicationInfo(Node node) throws Exception {
        if (this.host == null || this.channel == null) {
            return;
        }
        StringBuilder msg = new StringBuilder();
        if (node != null) {
            msg.append(node.getName()).append(" [").append(NumberConverter.doubleToString(node.getId())).append("] ");
            this.host.putRequestStateText(msg.toString());
        }
        Core.logger.info("export stage {} {}", (Object)this.stage, (Object)msg);
        this.putRequestStateLog(msg.toString());
        this.updateChannelInfo();
        this.lastInfo = msg.toString();
    }

    public void close() throws SQLException {
        this.connectionManager.release();
    }

    public void setFullReplica() {
        this.fullReplica = true;
    }

    public void setSyncMetadata() {
        this.syncMetadata = true;
    }

    public void setCancelIfNoData() {
        this.cancelIfNoData = true;
    }

    public void setDisableAudit() {
        this.disableAudit = true;
    }

    public void setReplaceData() {
        this.replaceData = true;
    }

    public boolean isFullReplica() {
        return this.fullReplica;
    }

    boolean isSyncMetadata() {
        return this.syncMetadata;
    }

    private boolean isUseFieldChanges() {
        return this.useFieldChanges == 2;
    }

    public void setUseFieldChanges(int value) {
        this.useFieldChanges = value;
    }

    public void setDeferrableCheckConstraints(boolean deferrableCheckConstraints) {
        this.deferrableCheckConstraints = deferrableCheckConstraints;
    }

    public void setIgnoreNoneAuditTables() {
        this.ignoreNoneAuditTables = true;
    }

    public void setMaxRange(double maxRange) {
        this.maxRange = maxRange;
    }

    public double getReplicaId() {
        return this.replicaId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncFilter() throws Exception {
        this.host.putRequestStateInstruction("\u041f\u043e\u0434\u0441\u0447\u0435\u0442 \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u044b\u0445 \u0441\u0443\u043c\u043c");
        Core.logger.info("--- \u041f\u043e\u0434\u0441\u0447\u0435\u0442 \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u044b\u0445 \u0441\u0443\u043c\u043c {}", (Object)this.getLogInfo());
        ByteArrayOutputStream params = new ByteArrayOutputStream();
        TaggedWriter writer = new TaggedWriter(params);
        NodeCrc crc = new NodeCrc(this.ssContext);
        try (Connector.Metabase connector = new Connector.Metabase();){
            DatabaseConnection databaseConnection = connector.connection();
            for (MetaItem item : this.metaList) {
                crc.reset(item.key(), item.syncChildren, databaseConnection);
                item.difference = 0;
                item.children = crc.getChildren();
                crc.store(writer);
            }
            databaseConnection.commit();
        }
        writer.flush();
        this.host.putRequestStateInstruction("\u0417\u0430\u043f\u0440\u043e\u0441 \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u044b\u0445 \u0441\u0443\u043c\u043c \u043d\u0430 \u0443\u0434\u0430\u043b\u0435\u043d\u043d\u043e\u043c \u0441\u0435\u0440\u0432\u0435\u0440\u0435");
        Core.logger.info("--- \u0417\u0430\u043f\u0440\u043e\u0441 \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u044b\u0445 \u0441\u0443\u043c\u043c \u043d\u0430 \u0443\u0434\u0430\u043b\u0435\u043d\u043d\u043e\u043c \u0441\u0435\u0440\u0432\u0435\u0440\u0435 {}", (Object)this.getLogInfo());
        AgentConnection connection = ((NetChannel)this.channel).getConnection();
        AgentConnection.Request request = new AgentConnection.Request(518);
        request.setParams(params.toByteArray());
        connection.request(request);
        connection.waitForResult();
        String logInfo = this.getLogInfo();
        this.host.putRequestStateInstruction("\u041f\u043e\u0434\u0441\u0447\u0451\u0442 \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u044b\u0445 \u0441\u0443\u043c\u043c");
        Core.logger.info("--- \u041f\u043e\u0434\u0441\u0447\u0451\u0442 \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u044b\u0445 \u0441\u0443\u043c\u043c {}", (Object)logInfo);
        int changedNodeCount = 0;
        byte[][] chunks = request.getResult();
        if (chunks == null) {
            this.metaList.clear();
        } else {
            for (byte[] chunk : chunks) {
                TaggedReader reader = new TaggedReader(chunk);
                while (reader.next()) {
                    int difference = reader.getCurrentTag();
                    double nodeId = reader.getDouble();
                    MetaItem item = this.metaCache.get(nodeId);
                    if (item == null) continue;
                    if (item.difference != 0) {
                        ++changedNodeCount;
                    }
                    item.difference = difference;
                }
            }
            Object object = this.metaList.iterator();
            while (object.hasNext()) {
                MetaItem item = (MetaItem)object.next();
                if ((item.difference & 2) != 2 || item.children == null) continue;
                for (double childId : item.children) {
                    MetaItem childItem = this.metaCache.get(childId);
                    if (childItem == null) continue;
                    if (item.difference != 0) {
                        ++changedNodeCount;
                    }
                    childItem.difference |= 1;
                }
            }
            Iterator<MetaItem> it = this.metaList.iterator();
            while (it.hasNext()) {
                MetaItem item = it.next();
                if (item.difference != 0) continue;
                it.remove();
            }
        }
        String msg = "\u041d\u0430\u0439\u0434\u0435\u043d\u043e \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u043d\u044b\u0445 \u0443\u0437\u043b\u043e\u0432: " + changedNodeCount + " \u0448\u0442";
        this.putRequestStateLog(msg);
        Core.logger.info("--- " + msg + " {}", (Object)logInfo);
    }

    @Override
    public String getReadme() throws InformException {
        StringBuilder str = new StringBuilder();
        str.append("\u0420\u0435\u043f\u043b\u0438\u043a\u0430: ").append(NumberConverter.doubleToString(this.audit.replicaId)).append("\n").append(this.mode).append("\n\u0414\u0430\u0442\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f: ").append(DateTime.toString(DateTime.currentDateTime())).append("\n\u0421\u0440\u0435\u0437 \u0434\u0430\u043d\u043d\u044b\u0445");
        if (this.audit.dataSliceBegin != 0.0) {
            str.append(" c ").append(DateTime.toString(this.audit.dataSliceBegin));
        }
        str.append(" \u043f\u043e ").append(DateTime.toString(this.audit.dataSliceEnd)).append("\n\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c: ");
        MtdEngine.appendUserNameForLog(str, this.audit.userNodeId);
        str.append("\n\u041a\u0430\u043d\u0430\u043b: ");
        MtdEngine.appendNodeNameForLog(str, this.audit.channelId);
        str.append("\n\u0423\u0437\u0435\u043b \u0440\u0435\u043f\u043b\u0438\u043a\u0430\u0446\u0438\u0438: ");
        MtdEngine.appendNodeNameForLog(str, this.audit.replNodeId);
        str.append("\n\u0423\u0437\u0435\u043b \u043f\u0440\u0438\u0435\u043c\u0430: ").append(NumberConverter.doubleToString(this.channel.getReceivingId()));
        if (!Strings.isVoid(Ini.AgentName)) {
            str.append("\n\u0418\u043c\u044f \u0430\u0433\u0435\u043d\u0442\u0430: ").append(Ini.AgentName);
        }
        return str.toString();
    }

    private void writeDataReplicaNodeSpecific(ScopeItem item, boolean needSpecific, TaggedWriter out) throws IOException {
        out.putDouble(11, item.id);
        if (needSpecific) {
            if (item.filterId != 0.0) {
                out.putDouble(31, item.filterId);
            }
            if (item.fieldFilter != null && !item.fieldFilter.empty()) {
                out.putIntArray(32, item.fieldFilter.toArray());
            }
        }
    }

    public void getReplicaNodes(TaggedWriter out, boolean needIncludeFilter) throws InformException, IOException, SQLException {
        this.scopeList = new ScopeList();
        this.fullReplica = true;
        this.load();
        block4: for (ScopeItem item : this.scopeList) {
            switch (item.scope & 3) {
                case 1: {
                    out.putDouble(10, item.id);
                    continue block4;
                }
                case 3: {
                    this.writeDataReplicaNodeSpecific(item, needIncludeFilter, out);
                    continue block4;
                }
            }
            this.writeDataReplicaNodeSpecific(item, needIncludeFilter, out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(double periodBegin, double periodEnd) throws ReplicationException {
        block80: {
            this.startReplicationTime = System.currentTimeMillis();
            AuditJournal journal = new AuditJournal(AuditJournal.Journal.REPLICATION);
            LockEngine.Locker replicaAlreadyLocked = LockEngine.lockReplica(this.replNodeId, this.channel.getId(), this.userId);
            if (replicaAlreadyLocked != null) {
                String msg = replicaAlreadyLocked.getReplicaError();
                this.audit.timeBeginOperation = this.audit.timeEndOperation = DateTime.currentDateTime();
                this.audit.userNodeId = this.userId;
                this.audit.replNodeId = this.replNodeId;
                this.audit.replicaId = this.replicaId;
                this.audit.channelId = this.channel.getId();
                this.audit.opCode = this.channel.getOperationCode();
                this.audit.successfullyResult = false;
                this.audit.resultMessage = msg;
                journal.registerReplication(this.ssContext, this.audit);
                throw new ReplicationException(msg).detail(this.getLockReplicaLogString());
            }
            try {
                DateTime lastSuccessfulDate;
                double periodEnd0;
                double periodBegin0;
                block79: {
                    try {
                        this.replicaId = Core.generateId();
                    }
                    catch (InformException ex) {
                        throw ReplicationException.remake("\u0433\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u044f ID \u0440\u0435\u043f\u043b\u0438\u043a\u0438", this.getLogInfo(), ex);
                    }
                    periodBegin0 = periodBegin;
                    periodEnd0 = periodEnd;
                    lastSuccessfulDate = null;
                    try {
                        this.audit.timeBeginOperation = DateTime.currentDateTime();
                        this.audit.userNodeId = this.userId;
                        this.audit.replNodeId = this.replNodeId;
                        this.audit.replicaId = this.replicaId;
                        this.audit.channelId = this.channel.getId();
                        this.audit.opCode = this.channel.getOperationCode();
                        if (periodBegin == periodEnd || this.startReplicaOnly) {
                            periodEnd = this.startReplicaOnly ? this.startReplicaDate : DateTime.currentDateTime();
                            if (this.fullReplica) {
                                periodBegin = 0.0;
                            } else {
                                try {
                                    lastSuccessfulDate = journal.getLastSuccessfulReplication(this.ssContext, this.replNodeId, this.channel.id);
                                }
                                catch (InformException | SQLException ex) {
                                    throw ReplicationException.remake("\u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0434\u0430\u0442\u044b \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0439 \u0440\u0435\u043f\u043b\u0438\u043a\u0430\u0446\u0438\u0438", this.getLogInfo(), ex);
                                }
                                periodBegin = lastSuccessfulDate == null ? periodEnd : lastSuccessfulDate.value();
                            }
                        } else if (periodBegin != 0.0 && periodEnd == 0.0) {
                            periodEnd = DateTime.currentDateTime();
                        }
                        if (this.maxRange > 0.0 && periodBegin != 0.0 && periodBegin != periodEnd && !this.fullReplica && (periodEnd < periodBegin || periodEnd - periodBegin > this.maxRange)) {
                            periodEnd = periodBegin + this.maxRange;
                        }
                        this.dataParam.periodBegin = periodBegin;
                        this.dataParam.periodEnd = periodEnd;
                        this.dataParam.backReceivingId = this.channel.backReceivingId;
                        this.dataParam.useFieldChanges = this.isUseFieldChanges();
                        this.audit.dataSliceBegin = periodBegin;
                        this.audit.dataSliceEnd = periodEnd;
                        boolean bl = this.audit.successfullyResult = periodBegin == periodEnd;
                        if (this.audit.successfullyResult) {
                            this.audit.timeEndOperation = periodBegin;
                            try {
                                journal.registerReplication(this.ssContext, this.audit);
                            }
                            catch (InformException ex) {
                                throw ReplicationException.remake("\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f \u043d\u0430\u0447\u0430\u043b\u044c\u043d\u043e\u0439 \u0440\u0435\u043f\u043b\u0438\u043a\u0438 \u0432 \u0436\u0443\u0440\u043d\u0430\u043b\u0435 \u0440\u0435\u043f\u043b\u0438\u043a\u0430\u0446\u0438\u0439", this.getLogInfo(), ex);
                            }
                            return;
                        }
                        if (!this.startReplicaOnly) break block79;
                        return;
                    }
                    catch (ReplicationException ex) {
                        this.audit.timeEndOperation = DateTime.currentDateTime();
                        this.audit.successfullyResult = false;
                        this.audit.resultMessage = AuditJournal.getJournalErrorText(ex);
                        try {
                            journal.registerReplication(this.ssContext, this.audit);
                        }
                        catch (InformException ex1) {
                            Core.logger.error(null, ex1);
                        }
                        throw ex;
                    }
                }
                this.dataParam.constants = this.channel.getConstants();
                Constant sliceBegin = this.dataParam.constants.get(-8);
                Constant sliceEnd = this.dataParam.constants.get(-9);
                sliceBegin.setRawValue(periodBegin);
                sliceEnd.setRawValue(periodEnd);
                try {
                    String logInfo = this.getLogInfo();
                    this.host.putRequestStateInstruction("\u041d\u0430\u0447\u0430\u043b\u043e \u043f\u0435\u0440\u0435\u0434\u0430\u0447\u0438 \u0440\u0435\u043f\u043b\u0438\u043a\u0438");
                    Core.logger.info("--- \u041d\u0430\u0447\u0430\u043b\u043e \u043f\u0435\u0440\u0435\u0434\u0430\u0447\u0438 \u0440\u0435\u043f\u043b\u0438\u043a\u0438 {}", (Object)logInfo);
                    StringBuilder propMsg = new StringBuilder();
                    propMsg.append("replica props:");
                    propMsg.append(" periodBegin=").append(DateTime.toString(periodBegin));
                    propMsg.append(" periodEnd=").append(DateTime.toString(periodEnd));
                    propMsg.append(" lastPeriod=").append(lastSuccessfulDate);
                    if (periodBegin0 != 0.0 || periodEnd0 != 0.0 || this.maxRange != 0.0) {
                        propMsg.append("\nscript assigned:");
                        if (periodBegin0 != 0.0) {
                            propMsg.append(" periodBegin=").append(DateTime.toString(periodBegin0));
                        }
                        if (periodEnd0 != 0.0) {
                            propMsg.append(" periodEnd=").append(DateTime.toString(periodEnd0));
                        }
                        if (this.maxRange != 0.0) {
                            propMsg.append(" maxRange=").append(this.maxRange);
                        }
                    }
                    Core.logger.info(propMsg.toString());
                    this.infoData.reset();
                    this.infoOut.reset(this.infoData);
                    this.putRequestStateLog("\u0421\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 ...");
                    SendReadyTaggedWriter out = this.channel.connect(this.replicaId);
                    out.setNotifySize(this.mtdChunkSize);
                    try {
                        this.host.putRequestStateInstruction("\u0421\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u0441\u043f\u0438\u0441\u043a\u0430 \u0443\u0437\u043b\u043e\u0432...");
                        try {
                            if (this.load() == 0) {
                                throw new ReplicationException("\u041d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d\u044b \u0443\u0437\u043b\u044b \u0434\u043b\u044f \u0440\u0435\u043f\u043b\u0438\u043a\u0430\u0446\u0438\u0438 ").detail(logInfo);
                            }
                        }
                        catch (Throwable ex) {
                            throw ReplicationException.remake("\u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u0443\u0437\u043b\u0430 \u0440\u0435\u043f\u043b\u0438\u043a\u0430\u0446\u0438\u0438 ", logInfo, ex);
                        }
                        String subMode = "";
                        if (this.deferrableCheckConstraints) {
                            if (this.dataList.isEmpty()) {
                                this.deferrableCheckConstraints = false;
                            } else {
                                subMode = " (\u043e\u0442\u043b\u043e\u0436\u0435\u043d\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0439)";
                            }
                        }
                        if (!this.fullReplica) {
                            this.replaceData = false;
                        }
                        if (!this.fullReplica && !this.ignoreNoneAuditTables) {
                            this.putRequestStateLog("\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0443\u0437\u043b\u043e\u0432");
                            boolean hasDisabledAuditTable = false;
                            StringBuilder msg = new StringBuilder();
                            DoubleSet enabledDatabases = new DoubleSet();
                            block43: for (TableDataIO.ReplicationItem item : this.dataList) {
                                TableDescriptor descriptor = TableDescriptor.get(item.tableId);
                                switch (descriptor.getKind()) {
                                    case VIRTUAL: 
                                    case VIEW: {
                                        continue block43;
                                    }
                                }
                                if (descriptor.getAuditType() == TableDescriptor.AuditType.NONE) {
                                    hasDisabledAuditTable = true;
                                    msg.append(descriptor.getCaption()).append(" [").append(NumberConverter.doubleToString(descriptor.getNodeId())).append("] - \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d \u0430\u0443\u0434\u0438\u0442 \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435\n");
                                    continue;
                                }
                                if (enabledDatabases.contains(descriptor.getDbId())) continue;
                                DatabaseDescriptor databaseDescriptor = descriptor.getDbDescIfExists();
                                if (databaseDescriptor != null && !databaseDescriptor.isAuditEnabled()) {
                                    hasDisabledAuditTable = true;
                                    msg.append(descriptor.getCaption()).append(" [").append(NumberConverter.doubleToString(descriptor.getNodeId())).append("] - \u043e\u0442\u0441\u043a\u043b\u044e\u0447\u0435\u043d \u0430\u0443\u0434\u0438\u0442 \u0432 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0438\n");
                                    continue;
                                }
                                enabledDatabases.add(descriptor.getDbId());
                            }
                            if (hasDisabledAuditTable) {
                                msg.append(logInfo);
                                throw new ReplicationException("\u0412 \u0440\u0435\u043f\u043b\u0438\u0446\u0438\u0440\u0443\u0435\u043c\u044b\u0445 \u0442\u0430\u0431\u043b\u0438\u0446\u0430\u0445 \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d \u0430\u0443\u0434\u0438\u0442 \u0434\u0430\u043d\u043d\u044b\u0445").detail(msg.toString());
                            }
                        }
                        if (this.isSyncMetadata()) {
                            this.mode = "\u0420\u0435\u0436\u0438\u043c \u0441\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0430\u0446\u0438\u044f \u043c\u0435\u0442\u0430\u0434\u0430\u043d\u043d\u044b\u0445";
                            this.putRequestStateLog(this.mode);
                            Core.logger.info(this.mode);
                            try {
                                this.syncFilter();
                            }
                            catch (Exception ex) {
                                throw ReplicationException.remake("\u043f\u043e\u0434\u0441\u0447\u0451\u0442 \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u044b\u0445 \u0441\u0443\u043c\u043c", logInfo, ex);
                            }
                        } else if (this.fullReplica) {
                            if (this.replaceData) {
                                this.mode = "\u0420\u0435\u0436\u0438\u043c \u043f\u043e\u043b\u043d\u0430\u044f \u0440\u0435\u043f\u043b\u0438\u043a\u0430\u0446\u0438\u044f \u0441 \u0437\u0430\u043c\u0435\u0449\u0435\u043d\u0438\u0435\u043c \u0434\u0430\u043d\u043d\u044b\u0445" + subMode;
                                this.putRequestStateLog(this.mode);
                                Core.logger.info(this.mode);
                            } else {
                                this.mode = "\u0420\u0435\u0436\u0438\u043c \u043f\u043e\u043b\u043d\u0430\u044f \u0440\u0435\u043f\u043b\u0438\u043a\u0430\u0446\u0438\u044f" + subMode;
                                this.putRequestStateLog(this.mode);
                                Core.logger.info(this.mode);
                            }
                        } else {
                            this.mode = "\u0420\u0435\u0436\u0438\u043c \u0440\u0435\u043f\u043b\u0438\u043a\u0430\u0446\u0438\u044f \u043f\u043e \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f\u043c" + subMode;
                            this.putRequestStateLog(this.mode);
                            Core.logger.info(this.mode);
                        }
                        out.putDouble(19, this.userId);
                        out.putDouble(27, this.channel.getReceivingId());
                        out.putDouble(20, this.replicaId);
                        if (this.channel.backReceivingId != 0.0) {
                            out.putDouble(32, this.channel.backReceivingId);
                        }
                        out.putDouble(26, this.replNodeId);
                        out.putInt32(34, DateTime.serverZoneOffset());
                        out.putDouble(21, periodBegin);
                        out.putDouble(22, periodEnd);
                        if (this.disableAudit) {
                            out.putEmpty(24);
                        }
                        if (this.replaceData) {
                            out.putEmpty(25);
                        }
                        if (this.deferrableCheckConstraints) {
                            out.putEmpty(31);
                        }
                        this.generateReplication(out);
                        out.putEmpty(99);
                        out.flush();
                        this.channel.finish();
                        this.stage = Stage.PENDING_FINISH;
                        Core.logger.info("export stage {} {}", (Object)this.stage, (Object)"\u0424\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0440\u0435\u043f\u043b\u0438\u043a\u0438 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u043e");
                        this.putRequestStateLog("\u0424\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0440\u0435\u043f\u043b\u0438\u043a\u0438 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u043e");
                        this.putRequestStateLog("\u041e\u0436\u0438\u0434\u0430\u043d\u0438\u0435 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0438\u044f \u043f\u0435\u0440\u0435\u0434\u0430\u0447\u0438 \u0440\u0435\u043f\u043b\u0438\u043a\u0438 ...");
                        if (this.needCancelByAbsentData()) {
                            this.replicaSize = 0L;
                            this.audit.replicaSize = this.replicaSize;
                            this.infoData.reset();
                            this.infoOut.reset(this.infoData);
                            this.infoOut.putEmpty(9);
                            this.infoOut.flush();
                            this.host.putRequestStateInstruction("\u0420\u0435\u043f\u043b\u0438\u043a\u0430\u0446\u0438\u044f \u043e\u0442\u043c\u0435\u043d\u0435\u043d\u0430 \u043d\u0435\u0442 \u0434\u0430\u043d\u043d\u044b\u0445");
                            this.channel.rollback(this, this.infoData.internalBuffer(), this.infoData.size());
                            Core.logger.info("--- \u0420\u0435\u043f\u043b\u0438\u043a\u0430\u0446\u0438\u044f \u043e\u0442\u043c\u0435\u043d\u0435\u043d\u0430 \u043d\u0435\u0442 \u0434\u0430\u043d\u043d\u044b\u0445 {}", (Object)logInfo);
                            this.audit.timeEndOperation = DateTime.currentDateTime();
                            this.audit.successfullyResult = true;
                            break block80;
                        }
                        this.channel.getWriteInfo(this.channelInfo);
                        this.channel.commit();
                        this.replicaSize = this.channel.getReplicaSize();
                        this.infoOut.putDouble(10, this.replicaSize);
                        this.infoOut.putDouble(1, this.channel.receivingId);
                        this.infoOut.putInt32(8, this.channel.getChunkCount());
                        this.infoOut.putDouble(2, this.replicaId);
                        this.infoOut.putDouble(3, periodBegin);
                        this.infoOut.putDouble(4, periodEnd);
                        this.infoOut.putDouble(5, this.userId);
                        this.infoOut.putAnsiIf(11, this.mode);
                        String successMsg = this.shortLogInfo();
                        String channelInfoMsg = this.getChannelInfo().toString();
                        this.host.putRequestStateInstruction(successMsg);
                        this.host.putRequestStateText(channelInfoMsg);
                        this.host.putRequestStateLog(channelInfoMsg);
                        if (!this.needCancelByAbsentData()) {
                            try {
                                this.audit.timeEndOperation = DateTime.currentDateTime();
                                this.audit.successfullyResult = true;
                                this.audit.replicaSize = this.replicaSize;
                                double auditId = journal.registerReplication(this.ssContext, this.audit);
                                if (auditId != 0.0) {
                                    this.infoOut.putDouble(12, auditId);
                                }
                            }
                            catch (InformException ex) {
                                throw ReplicationException.remake("\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f \u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0440\u0435\u043f\u043b\u0438\u043a\u0438 \u0432 \u0436\u0443\u0440\u043d\u0430\u043b\u0435 \u0440\u0435\u043f\u043b\u0438\u043a\u0430\u0446\u0438\u0439", logInfo, ex);
                            }
                        }
                        this.infoOut.flush();
                        this.channel.ready(this, this.infoData.internalBuffer(), this.infoData.size());
                        Core.logger.info("--- \u0417\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0438\u0435 \u043f\u0435\u0440\u0435\u0434\u0430\u0447\u0438 \u0440\u0435\u043f\u043b\u0438\u043a\u0438 {}", (Object)logInfo);
                    }
                    catch (AgentConnection.RemoteAgentError ex) {
                        throw ReplicationException.remake(null, logInfo, ex);
                    }
                    catch (Throwable ex) {
                        try {
                            this.channel.cancel();
                        }
                        catch (Throwable e) {
                            Core.logger.error(null, e);
                        }
                        throw ReplicationException.remake(null, logInfo, ex);
                    }
                    finally {
                        try {
                            this.channel.close();
                        }
                        catch (Throwable e) {
                            Core.logger.error(null, e);
                        }
                    }
                }
                catch (Throwable ex) {
                    StringBuilder msg = new StringBuilder();
                    msg.append(this.getLogInfo());
                    if (this.lastInfo != null) {
                        msg.append('\n').append(this.lastInfo);
                    }
                    msg.append("\n stage ").append((Object)this.stage);
                    try {
                        this.host.putRequestStateInstruction("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u0435\u0440\u0435\u0434\u0430\u0447\u0435 \u0440\u0435\u043f\u043b\u0438\u043a\u0438");
                    }
                    catch (Exception ex1) {
                        throw ReplicationException.remake(null, msg.toString(), ex);
                    }
                    Core.logger.error("--- \u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u0435\u0440\u0435\u0434\u0430\u0447\u0435 \u0440\u0435\u043f\u043b\u0438\u043a\u0438 " + this.getLogInfo(), ex);
                    this.audit.timeEndOperation = DateTime.currentDateTime();
                    this.audit.successfullyResult = false;
                    this.audit.resultMessage = AuditJournal.getJournalErrorText(ex);
                    try {
                        journal.registerReplication(this.ssContext, this.audit);
                    }
                    catch (InformException ex1) {
                        msg.append('\n').append(ex.toString());
                        throw ReplicationException.remake("\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f \u043e\u0448\u0438\u0431\u043a\u0438 \u0432 \u0436\u0443\u0440\u043d\u0430\u043b\u0435 \u0440\u0435\u043f\u043b\u0438\u043a\u0430\u0446\u0438\u0439", msg.toString(), ex1);
                    }
                    throw ReplicationException.remake(null, msg.toString(), ex);
                }
            }
            finally {
                LockEngine.unlockReplica(this.replNodeId, this.channel.getId());
            }
        }
    }

    private boolean needCancelByAbsentData() {
        return this.cancelIfNoData && this.processedRows == 0;
    }

    private String getLockReplicaLogString() {
        return "\"" + MtdEngine.tryGetNodeName(this.replNodeId) + "\" \u0447\u0435\u0440\u0435\u0437 \u043a\u0430\u043d\u0430\u043b \"" + this.channel.getTitle() + "\" [replnode-id:" + NumberConverter.doubleToString(this.replNodeId) + ", channel-id: " + NumberConverter.doubleToString(this.channel.getId()) + ", session-id: " + (long)this.host.getSessionID() + "]";
    }

    private String getLogInfo() {
        return "\"" + MtdEngine.tryGetNodeName(this.replNodeId) + "\" \u0447\u0435\u0440\u0435\u0437 \u043a\u0430\u043d\u0430\u043b \"" + this.channel.getTitle() + "\" [replnode-id: " + NumberConverter.doubleToString(this.replNodeId) + ", channel-id: " + NumberConverter.doubleToString(this.channel.getId()) + ", replica-id: " + NumberConverter.doubleToString(this.replicaId) + ", receiving-id: " + NumberConverter.doubleToString(this.channel.receivingId) + ", back-receiving-id: " + NumberConverter.doubleToString(this.channel.backReceivingId) + ", session-id: " + (long)this.host.getSessionID() + "]";
    }

    private String shortLogInfo() {
        return "\u0420\u0435\u043f\u043b\u0438\u043a\u0430\u0446\u0438\u044f '" + this.channel.getTitle() + "'";
    }

    Connector metabaseConnector() {
        return this.metabaseConnector;
    }

    boolean isProcessNodeByTime(double time) {
        return this.fullReplica || this.syncMetadata || this.dataParam.periodBegin <= time && time < this.dataParam.periodEnd;
    }

    @Override
    public void idle() {
        if (this.host != null) {
            try {
                this.host.idle();
            }
            catch (Throwable e) {
                Object reason = null;
                try {
                    String coreReason = Core.getAgentStopReason();
                    String hostReason = this.host.getCancelReason();
                    if (coreReason != null) {
                        reason = coreReason;
                    }
                    if (hostReason != null) {
                        reason = reason == null ? hostReason : (String)reason + "\n" + hostReason;
                    }
                }
                catch (Throwable ee) {
                    Core.logger.error(null, ee);
                }
                if (reason == null) {
                    throw InformException.wrap(e);
                }
                throw InformException.detail(e, (String)reason);
            }
        }
        try {
            this.updateChannelInfo();
        }
        catch (Throwable ex) {
            Core.logger.error(null, ex);
        }
    }

    void addSharedConf(double id) {
        if (!this.sharedConf.add(id)) {
            return;
        }
        this.conf.add(id);
    }

    void addItem(Node node, int option, ReplicationConf.Conf conf) throws InformException {
        if (this.scopeList != null) {
            double id = node.getId();
            ScopeItem s = this.scopeList.get(id);
            if (s == null) {
                s = new ScopeItem(id, conf.includeDataFilter, conf.fieldFilter, option);
                this.scopeList.put(s);
            } else {
                if ((option & 2) != 0 && (s.scope & 2) == 0) {
                    s.filterId = conf.includeDataFilter;
                }
                s.scope |= option;
                if (s.fieldFilter != null && conf.fieldFilter != null) {
                    for (Cursor.Integer c : conf.fieldFilter) {
                        s.fieldFilter.add(c.value);
                    }
                }
            }
            return;
        }
        if ((option & 1) != 0) {
            MetaItem item = this.metaCache.get(node.getId());
            if (item == null) {
                item = new MetaItem(node, (option & 4) != 0, (option & 8) != 0);
                this.metaCache.add(item);
                this.metaList.add(item);
                if (node.getType() == 12) {
                    this.hasTableNodes = true;
                    item.hasData = (option & 2) != 0;
                }
            } else {
                if ((option & 4) != 0) {
                    item.syncChildren = true;
                }
                if ((option & 8) == 0) {
                    item.authenticationOnly = false;
                }
                if (node.getType() == 12 && !item.hasData) {
                    boolean bl = item.hasData = (option & 2) != 0;
                }
            }
        }
        if ((option & 2) != 0) {
            TableDataIO.ReplicationItem param = new TableDataIO.ReplicationItem();
            param.tableId = node.getId();
            if (param.tableId == node.getId()) {
                param.includeFilter = conf.includeDataFilter;
                param.excludeFilter = conf.excludeDataFilter;
                if (conf.fieldFilter != null) {
                    param.fieldFilter = conf.fieldFilter;
                }
            }
            param.useDataSlice = !this.fullReplica;
            for (TableDataIO.ReplicationItem item : this.dataList) {
                if (!item.isEqual(param)) continue;
                if (!param.useDataSlice) {
                    item.useDataSlice = false;
                }
                if (param.fieldFilter != null) {
                    for (Cursor.Integer c : param.fieldFilter) {
                        if (item.fieldFilter == null) {
                            item.fieldFilter = new IntegerSet();
                        }
                        item.fieldFilter.add(c.value);
                    }
                }
                param = null;
                break;
            }
            if (param != null) {
                this.dataList.add(param);
                if ((option & 1) == 0) {
                    this.checkDataList.add(param);
                }
            }
        }
    }

    private void loadProps() throws InformException, IOException {
        if (this.replNodeId == 0.0) {
            return;
        }
        TaggedReader in = new TaggedReader(MtdEngine.getNodeContent(this.replNodeId));
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 32: {
                    this.setUseFieldChanges(in.getInt());
                    break;
                }
                case 33: {
                    this.setDeferrableCheckConstraints(true);
                }
            }
        }
    }

    private int load() throws InformException, IOException, SQLException {
        this.addSharedConf(this.replNodeId);
        int nodeCount = 0;
        for (int i = 0; i < this.conf.size(); ++i) {
            Double aConf = this.conf.get(i);
            ReplicationConf c = new ReplicationConf(aConf, this);
            nodeCount += c.getNodes();
        }
        return nodeCount;
    }

    private void replicateSyncChildren(Node node, TaggedWriter out) throws Exception {
        this.idle();
        double[] children = node.getChildren(this.metabaseConnector);
        if (children != null && children.length != 0) {
            this.infoOut.putDouble(6, node.getId());
            out.putDouble(1, node.getId());
            out.putRaw(14, LittleEndian.doubleArrayToBinary(children));
            out.notifyReady();
        }
    }

    private void replicateMetadata(Node node, TaggedWriter out, boolean syncChildren, boolean hasData, MetaItem replicatedItem) throws Exception {
        this.idle();
        if (replicatedItem != null) {
            out.putDouble(1, node.getId());
            out.putDouble(2, node.getParentId());
            out.putInt32(3, node.getType());
        } else {
            double nodeTime;
            MetadataNodeReader mtd = MetadataNodeReader.createNode((SSContext)this.ssContext, node.getId(), this.metabaseConnector.connection(), true);
            Core.logger.debug("\u0420\u0435\u043f\u043b\u0438\u043a\u0430\u0446\u0438\u044f \u0443\u0437\u043b\u0430 {} {}", NumberConverter.doubleToString(mtd.id), mtd.name);
            this.infoOut.putDouble(6, mtd.id);
            out.putDouble(1, mtd.id);
            out.putDouble(2, mtd.parentId);
            out.putInt32(3, mtd.type);
            out.putAnsiIf(4, mtd.name);
            out.putAnsiIf(5, mtd.identName);
            out.putAnsiIf(6, mtd.description);
            out.putDouble(7, mtd.ownerId);
            out.putInt32(8, mtd.orderNo);
            out.putDouble(9, mtd.creationTime);
            out.putDouble(10, mtd.modificationContentTime);
            out.putDouble(11, mtd.modificationUserId);
            out.putRaw(12, mtd.attributesContent);
            if (mtd.dslContent != null) {
                this.setMinApplyServerVersion(out, MIN_APPLY_REPLICATION_SERVER_WITH_DSL_VERSION);
                out.putRaw(35, mtd.dslContent.getBytes(TaggedWriter.UTF8));
            } else if (Memory.isVoid(mtd.content)) {
                out.putEmpty(13);
            } else {
                out.putRaw(13, mtd.content);
            }
            if (hasData) {
                out.putEmpty(30);
            }
            if (syncChildren) {
                this.idle();
                double[] children = node.getChildren(this.metabaseConnector);
                if (children != null && children.length != 0) {
                    out.putRaw(14, LittleEndian.doubleArrayToBinary(children));
                }
            }
            if (!this.fullReplica && this.maxTransEndTime < (nodeTime = DateTime.fromUnixTime(node.lastModificationTime()))) {
                this.maxTransEndTime = nodeTime;
                this.audit.dataSliceEnd = nodeTime;
            }
        }
        this.idle();
        out.putEmpty(15);
        out.notifyReady();
    }

    private void replicateAuthentication(UserNode node, TaggedWriter out, boolean syncChildren) throws Exception {
        double nodeTime;
        double[] children;
        ByteArrayOutputStream authentication = new ByteArrayOutputStream();
        TaggedWriter writer = new TaggedWriter(authentication);
        if (node.isSha256()) {
            writer.putRaw(115, node.getSha256Hash());
            writer.putRaw(116, node.getSha256Salt());
        } else {
            writer.putRaw(30, node.getSecurityHash());
            writer.putRaw(31, node.getSecuritySalt());
        }
        writer.flush();
        out.putDouble(1, node.getId());
        out.putRaw(23, authentication);
        if (syncChildren && (children = node.getChildren(this.metabaseConnector)) != null && children.length != 0) {
            out.putRaw(14, LittleEndian.doubleArrayToBinary(children));
        }
        out.putEmpty(15);
        out.notifyReady();
        if (!this.fullReplica && this.maxTransEndTime < (nodeTime = DateTime.fromUnixTime(node.lastModificationTime()))) {
            this.maxTransEndTime = nodeTime;
            this.audit.dataSliceEnd = nodeTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateDataParams(TableDataIO.ReplicationItem item) throws SQLException {
        if (item.useDataSlice) {
            TableDescriptor tableDescriptor = TableDescriptor.get(item.tableId);
            double databaseId = tableDescriptor.getDbId();
            TransParams tp = this.transParams.get(databaseId);
            if (tp == null) {
                double minEndTime;
                double maxEndTime;
                double minChangesTime;
                DatabaseDescriptor databaseDescriptor = tableDescriptor.getDatabaseDescriptor();
                SqlStringBuilder sql = new SqlStringBuilder();
                sql.append("select min(T.").append(TableDataAudit.TRANS_AUDIT_BEGIN_FIELD).append("), max(T.").append(TableDataAudit.TRANS_AUDIT_END_FIELD).append("), min(T.").append(TableDataAudit.TRANS_AUDIT_END_FIELD).append(") from ");
                databaseDescriptor.appendAuditTableRawName("PHX_CHANGELOG_TRANS", sql.getBuilder());
                sql.append(" T where ?<T.").append(TableDataAudit.TRANS_AUDIT_END_FIELD).append(" and T.").append(TableDataAudit.TRANS_AUDIT_END_FIELD).append("<? and (");
                if (this.channel.backReceivingId != 0.0) {
                    sql.append("T.").append("REPL_NODE_ID").append("<>? or ");
                }
                sql.append("T.").append("REPL_NODE_ID").append(" is null)");
                DatabaseConnection connection = this.connectionManager.getConnection(databaseId, "Replication.updateDataParams");
                try (PreparedStatement statement = connection.prepareStatement(sql.toString());){
                    statement.setDateTime(1, this.dataParam.periodBegin);
                    statement.setDateTime(2, this.dataParam.periodEnd);
                    if (this.channel.backReceivingId != 0.0) {
                        statement.setDouble(3, this.channel.backReceivingId);
                    }
                    try (ResultSet resultSet = statement.executeQuery(this.ssContext);){
                        if (!resultSet.next()) {
                            boolean bl = false;
                            return bl;
                        }
                        minChangesTime = resultSet.getDateTime(1);
                        if (resultSet.wasNull()) {
                            boolean bl = false;
                            return bl;
                        }
                        maxEndTime = resultSet.getDateTime(2);
                        if (resultSet.wasNull()) {
                            boolean bl = false;
                            return bl;
                        }
                        minEndTime = resultSet.getDateTime(3);
                        if (resultSet.wasNull()) {
                            boolean bl = false;
                            return bl;
                        }
                    }
                }
                tp = new TransParams(databaseId, minChangesTime, minEndTime, maxEndTime);
                this.transParams.add(tp);
                if (this.maxTransEndTime < maxEndTime) {
                    this.maxTransEndTime = maxEndTime;
                    this.audit.dataSliceEnd = maxEndTime;
                }
            }
            this.dataParam.minChangesTime = tp.minTime;
            this.dataParam.minTransEndTime = tp.minEndTime;
            this.dataParam.maxTransEndTime = tp.maxTime;
        }
        return true;
    }

    private void generateReplication(SendReadyTaggedWriter out) throws Exception {
        if (!this.checkDataList.isEmpty()) {
            this.stage = Stage.CHECK_TABLES;
            this.host.putRequestStateInstruction("\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u0442\u0440\u0443\u043a\u0442\u0443\u0440 \u0442\u0430\u0431\u043b\u0438\u0446...");
            block22: for (TableDataIO.ReplicationItem replicationItem : this.checkDataList) {
                java.io.ByteArrayOutputStream checkStruct = null;
                TaggedWriter writer = null;
                try {
                    this.replicationInfo(MtdEngine.getValidNode(replicationItem.tableId));
                    TableDescriptor descriptor = TableDescriptor.get(replicationItem.tableId);
                    switch (descriptor.getKind()) {
                        case VIRTUAL: 
                        case VIEW: {
                            break;
                        }
                        default: {
                            if (checkStruct == null) {
                                out.putEmpty(28);
                                checkStruct = new ByteArrayOutputStream();
                                writer = new TaggedWriter(checkStruct);
                            } else {
                                checkStruct.reset();
                                writer.reset(checkStruct);
                            }
                            if (descriptor.getKind() == TableDescriptor.Kind.INTERNAL) {
                                writer.putInt32(1, -1);
                                writer.putInt32(2, DataType.PRIMARY_KEY.toInt());
                                writer.putString(3, "ID");
                            }
                            for (FieldDescriptor field : descriptor.getFields()) {
                                if (field.isAbstract()) continue;
                                writer.putInt32(1, field.getId());
                                writer.putInt32(2, field.getType().toInt());
                                writer.putString(3, field.getCaption());
                            }
                            writer.flush();
                            if (checkStruct.size() == 0) continue block22;
                            out.putDouble(29, replicationItem.tableId);
                            out.putRaw(202, ((ByteArrayOutputStream)checkStruct).internalBuffer(), checkStruct.size());
                            break;
                        }
                    }
                }
                catch (AgentConnection.RemoteAgentError ex) {
                    throw ReplicationException.remake(null, this.getLogInfo(), ex);
                }
                catch (Throwable ex) {
                    String msg = "\u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u044b \u0442\u0430\u043b\u0438\u0446\u044b " + MtdEngine.tryGetNodeName(replicationItem.tableId) + " " + NumberConverter.doubleToString(replicationItem.tableId);
                    throw ReplicationException.remake(msg, this.getLogInfo(), ex);
                }
            }
            this.channel.flush();
        }
        if (!this.metaList.isEmpty()) {
            String msg;
            this.stage = Stage.EXPORT_TABLE_NODE;
            this.host.putRequestStateInstruction("\u0420\u0435\u043f\u043b\u0438\u043a\u0430\u0446\u0438\u044f \u043c\u0435\u0442\u0430\u0434\u0430\u043d\u043d\u044b\u0445...");
            this.host.putRequestStateProgressMin(0);
            this.host.putRequestStateProgressMax(this.metaList.size());
            Collections.sort(this.metaList, new ItemComparator());
            int progress = 0;
            this.host.putRequestStateProgressPosition(progress);
            if (this.hasTableNodes) {
                this.putRequestStateLog("\u041c\u0435\u0442\u0430\u0434\u0430\u043d\u043d\u044b\u0435 \u0442\u0430\u0431\u043b\u0438\u0446:");
                out.putEmpty(16);
                for (MetaItem item : this.metaList) {
                    if (item.node.getType() != 12) continue;
                    try {
                        if (this.channel.backReceivingId != 0.0 && this.channel.backReceivingId == item.node.getReplNodeId() && this.isSyncMetadata() && item.syncChildren) {
                            this.replicationInfo(item.node);
                            this.replicateSyncChildren(item.node, out);
                            continue;
                        }
                        this.replicationInfo(item.node);
                        this.replicateMetadata(item.node, out, item.syncChildren, item.hasData, null);
                    }
                    catch (AgentConnection.RemoteAgentError ex) {
                        throw ReplicationException.remake(null, this.getLogInfo(), ex);
                    }
                    catch (Throwable ex) {
                        msg = "\u043c\u0435\u0442\u0430\u0434\u0430\u043d\u043d\u044b\u0435 \u0442\u0430\u0431\u043b\u0438\u0446\u044b " + item.node.getName() + " [" + NumberConverter.doubleToString(item.node.getId()) + "]";
                        throw ReplicationException.remake(msg, this.getLogInfo(), ex);
                    }
                    this.host.putRequestStateProgressPosition(++progress);
                }
            }
            this.stage = Stage.EXPORT_NODE;
            out.putEmpty(17);
            if (!this.metaList.isEmpty()) {
                this.putRequestStateLog("\u041c\u0435\u0442\u0430\u0434\u0430\u043d\u043d\u044b\u0435:");
            }
            block25: for (MetaItem item : this.metaList) {
                try {
                    switch (item.node.getType()) {
                        case 12: {
                            this.replicationInfo(item.node);
                            this.replicateMetadata(item.node, out, item.syncChildren, item.hasData, item);
                            break;
                        }
                        case 3: {
                            if (item.authenticationOnly && item.node instanceof UserNode) {
                                this.replicationInfo(item.node);
                                this.replicateAuthentication((UserNode)item.node, out, item.syncChildren);
                            } else {
                                if (this.channel.backReceivingId != 0.0 && this.channel.backReceivingId == item.node.getReplNodeId() && this.isSyncMetadata() && item.syncChildren) {
                                    this.replicationInfo(item.node);
                                    this.replicateSyncChildren(item.node, out);
                                    continue block25;
                                }
                                this.replicationInfo(item.node);
                                this.replicateMetadata(item.node, out, item.syncChildren, false, null);
                            }
                            this.host.putRequestStateProgressPosition(++progress);
                            break;
                        }
                        default: {
                            if (this.channel.backReceivingId != 0.0 && this.channel.backReceivingId == item.node.getReplNodeId() && this.isSyncMetadata() && item.syncChildren) {
                                this.replicationInfo(item.node);
                                this.replicateSyncChildren(item.node, out);
                                continue block25;
                            }
                            this.replicationInfo(item.node);
                            this.replicateMetadata(item.node, out, item.syncChildren, false, null);
                            this.host.putRequestStateProgressPosition(++progress);
                            break;
                        }
                    }
                }
                catch (AgentConnection.RemoteAgentError ex) {
                    throw ReplicationException.remake(null, this.getLogInfo(), ex);
                }
                catch (Throwable ex) {
                    msg = "\u043c\u0435\u0442\u0430\u0434\u0430\u043d\u043d\u044b\u0435 \u0443\u0437\u043b\u0430 " + item.node.getName() + " [" + NumberConverter.doubleToString(item.node.getId()) + "]";
                    throw ReplicationException.remake(msg, this.getLogInfo(), ex);
                }
            }
            this.channel.flush();
        }
        if (!this.dataList.isEmpty()) {
            this.stage = Stage.EXPORT_TABLE_DATA;
            out.setNotifySize(this.dataChunkSize);
            this.host.putRequestStateInstruction("\u0420\u0435\u043f\u043b\u0438\u043a\u0430\u0446\u0438\u044f \u0434\u0430\u043d\u043d\u044b\u0445...");
            this.host.putRequestStateProgressMin(0);
            this.host.putRequestStateProgressMax(this.dataList.size());
            int progress = 0;
            this.host.putRequestStateProgressPosition(progress);
            out.putEmpty(18);
            TableDataIO tableDataIO = new TableDataIO(this.ssContext, this.host, Core.serverTimeZoneHost);
            tableDataIO.setIdler(this);
            this.processedRows = 0;
            this.putRequestStateLog("\u0420\u0435\u043f\u043b\u0438\u043a\u0430\u0446\u0438\u044f \u0434\u0430\u043d\u043d\u044b\u0445");
            for (TableDataIO.ReplicationItem item : this.dataList) {
                TableDataIO.RowStats stats = null;
                TableDescriptor descriptor = null;
                long transferBegin = 0L;
                try {
                    this.replicationInfo(MtdEngine.getValidNode(item.tableId));
                    descriptor = TableDescriptor.get(item.tableId);
                    switch (descriptor.getKind()) {
                        case VIRTUAL: 
                        case VIEW: {
                            break;
                        }
                        default: {
                            if (item.useDataSlice && descriptor.getAuditType() == TableDescriptor.AuditType.NONE) {
                                StringBuilder msg = new StringBuilder();
                                msg.append('!');
                                msg.append(descriptor.getCaption()).append(" [").append(NumberConverter.doubleToString(descriptor.getNodeId())).append("]");
                                msg.append(" - \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d \u0430\u0443\u0434\u0438\u0442 \u0434\u0430\u043d\u043d\u044b\u0445");
                                this.putRequestStateLog(msg.toString());
                                Core.logger.info("export stage {} {}", (Object)this.stage, (Object)msg.toString());
                                break;
                            }
                            Core.logger.debug("\u0420\u0435\u043f\u043b\u0438\u043a\u0430\u0446\u0438\u044f \u0434\u0430\u043d\u043d\u044b\u0445 {} {}", NumberConverter.doubleToString(item.tableId), NumberConverter.doubleToString(item.includeFilter));
                            transferBegin = this.channel.getTransferSize();
                            if (this.updateDataParams(item)) {
                                stats = tableDataIO.replicate(item, this.dataParam, this.connectionManager, out);
                                break;
                            }
                            stats = emptyRowStats;
                            break;
                        }
                    }
                }
                catch (AgentConnection.RemoteAgentError ex) {
                    throw ReplicationException.remake(null, this.getLogInfo(), ex);
                }
                catch (Throwable ex) {
                    String msg = "\u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0434\u0430\u043d\u043d\u044b\u0445 " + MtdEngine.tryGetNodeName(item.tableId) + " " + NumberConverter.doubleToString(item.tableId);
                    throw ReplicationException.remake(msg, this.getLogInfo(), ex);
                }
                long transferEnd = this.channel.getTransferSize();
                if (stats != null) {
                    StringBuilder msg = new StringBuilder();
                    msg.append("  (").append(stats.modified).append(" \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u043d\u044b\u0445 ").append(stats.deleted).append(" \u0443\u0434\u0430\u043b\u0435\u043d\u043d\u044b\u0445 \u0441\u0442\u0440\u043e\u043a, ").append(transferEnd - transferBegin).append(" \u0431\u0430\u0439\u0442)");
                    this.putRequestStateLog(msg.toString());
                    msg = new StringBuilder();
                    if (descriptor != null) {
                        msg.append(descriptor.toString());
                    }
                    msg.append("  (\u043f\u0435\u0440\u0435\u0434\u0430\u043d\u043e: ").append(stats.modified).append(" \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u043d\u044b\u0445 ").append(stats.deleted).append(" \u0443\u0434\u0430\u043b\u0435\u043d\u043d\u044b\u0445 \u0441\u0442\u0440\u043e\u043a)");
                    Core.logger.info("export stage {} {}", (Object)this.stage, (Object)msg.toString());
                    this.processedRows += stats.deleted + stats.modified;
                }
                this.host.putRequestStateProgressPosition(++progress);
            }
        }
    }

    private void setMinApplyServerVersion(TaggedWriter out, long minApplyServerVersion) throws IOException {
        if (this.minApplyServerVersion < minApplyServerVersion) {
            this.minApplyServerVersion = minApplyServerVersion;
            out.putInt32(100, (int)minApplyServerVersion);
        }
    }

    private static class TransParams
    implements DoubleHash.Entry {
        final double databaseId;
        final double minTime;
        final double minEndTime;
        final double maxTime;

        private TransParams(double databaseId, double minChangesTime, double minEndTime, double maxEndTime) {
            this.databaseId = databaseId;
            this.minTime = minChangesTime;
            this.minEndTime = minEndTime;
            this.maxTime = maxEndTime;
        }

        @Override
        public double key() {
            return this.databaseId;
        }
    }

    private static class ScopeList
    implements Iterable<ScopeItem> {
        final DoubleHash<ScopeItem> hash = new DoubleHash();
        final ArrayList<ScopeItem> order = new ArrayList();

        private ScopeList() {
        }

        @Override
        public Iterator<ScopeItem> iterator() {
            return this.order.iterator();
        }

        public ScopeItem get(double id) {
            return this.hash.get(id);
        }

        public void put(ScopeItem s) {
            this.hash.add(s);
            this.order.add(s);
        }
    }

    private static class ScopeItem
    implements DoubleHash.Entry {
        final double id;
        double filterId;
        final IntegerSet fieldFilter;
        int scope;

        private ScopeItem(double id, double filterId, IntegerSet fieldFilter, int scope) {
            this.id = id;
            this.filterId = filterId;
            this.fieldFilter = fieldFilter;
            this.scope = scope;
        }

        @Override
        public double key() {
            return this.id;
        }
    }

    private static class ReplicationLock
    extends NodeLock {
        double userId;
        long time;

        ReplicationLock(double replNodeId, double channelId, double userId) {
            super(replNodeId, channelId);
            this.userId = userId;
            this.time = System.currentTimeMillis();
        }

        @Override
        public String getErrorText() {
            return "\u0420\u0435\u043f\u043b\u0438\u043a\u0430\u0446\u0438\u044f \"" + MtdEngine.tryGetNodeName(this.nodeId) + "\" [" + (long)this.nodeId + "] \u043f\u043e \u043a\u0430\u043d\u0430\u043b\u0443 \"" + MtdEngine.tryGetNodeName(this.lockId) + "\" [" + (long)this.lockId + "] \u0443\u0436\u0435 \u0432\u044b\u043f\u043e\u043b\u043d\u044f\u0435\u0442\u0441\u044f\n \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \"" + MtdEngine.tryGetUserName(this.userId) + "\" [" + (long)this.userId + "] \u0432\u0440\u0435\u043c\u044f \u043d\u0430\u0447\u0430\u043b\u0430 " + DateTime.toString(DateTime.fromUnixTime(this.time));
        }

        @Override
        public void throwError() {
            throw new ReplicationException(this.getErrorText(), null);
        }
    }

    private static class ItemComparator
    implements Comparator<MetaItem> {
        private ItemComparator() {
        }

        @Override
        public int compare(MetaItem o1, MetaItem o2) {
            if (o1.level != o2.level) {
                return o1.level - o2.level;
            }
            if (o1.node.getParentId() != o2.node.getParentId()) {
                if (o1.node.getParentId() < o2.node.getParentId()) {
                    return -1;
                }
                return 1;
            }
            return o1.node.getOrderNo() - o2.node.getOrderNo();
        }
    }

    static class DataParam {
        double periodBegin = 0.0;
        double periodEnd = 0.0;
        double minChangesTime = 0.0;
        double minTransEndTime = 0.0;
        double maxTransEndTime = 0.0;
        Constants constants = null;
        double backReceivingId = 0.0;
        boolean useFieldChanges = false;

        DataParam() {
        }
    }

    public static class MetaItem
    implements DoubleHash.Entry {
        final Node node;
        boolean syncChildren;
        boolean authenticationOnly;
        final int level;
        int difference = 0;
        double[] children = null;
        boolean hasData = false;

        MetaItem(Node node, boolean syncChildren, boolean authenticationOnly) throws InformException {
            this.node = node;
            this.syncChildren = syncChildren;
            this.authenticationOnly = authenticationOnly;
            this.level = node.calcLevel();
        }

        @Override
        public double key() {
            return this.node.getId();
        }
    }

    public static enum Stage {
        CONNECTING_TO_REMOTE_SERVER,
        CHECK_TABLES,
        EXPORT_TABLE_NODE,
        EXPORT_NODE,
        EXPORT_TABLE_DATA,
        PENDING_FINISH;

    }

    public static class ReplicaContext
    extends SSContext.Component {
        double channelId;
        public String type;

        ReplicaContext(SSContext parent) {
            super(parent, 6);
        }

        @Override
        public void store(TaggedWriter out) throws IOException {
            super.store(out);
            out.putDouble(12, this.channelId);
            out.putString(13, this.type);
        }
    }
}

