/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.replication;

import inform.adt.InformException;
import inform.adt.taggedio.TaggedReader;
import inform.agent.Core;
import inform.agent.ServerSideHost;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.Node;
import inform.agent.mtd.request.GetActualConstantsForAccount;
import inform.agent.replication.BlobChannel;
import inform.agent.replication.FileChannel;
import inform.agent.replication.NetChannel;
import inform.agent.replication.Replication;
import inform.agent.replication.ReplicationChannel;
import inform.agent.scripts.Constants;
import inform.agent.scripts.SSContext;
import inform.common.SmartScriptableObject;
import java.io.IOException;
import org.mozilla.javascript.Scriptable;

public class ScriptReplica
extends SmartScriptableObject {
    public final SSContext ssContext;
    private final ServerSideHost ssHost;
    private double channelId = 0.0;
    private double constantsChannelId = 0.0;
    private double sourceNodeId = 0.0;
    private String fileName = null;
    private double sliceDateBegin = 0.0;
    private double sliceDateEnd = 0.0;
    private String serverName = null;
    private String agentName = null;
    private String remoteLogin = null;
    private String remotePassword = null;
    private double receivingId = 0.0;
    private double backReceivingId = 0.0;
    private double userId = 0.0;
    private boolean enableAudit = true;
    private boolean replaceData = false;
    private boolean cancelIfNoData = false;
    private boolean fullReplica = false;
    private boolean syncMetadata = false;
    private Constants constants = null;
    private boolean useFieldChanges = false;
    private boolean showReplicationLog = true;
    private boolean blobReplication = false;
    private int maxChunkSize = -1;
    private boolean ignoreNoneAuditTables = false;
    private double maxRange = 0.0;
    private boolean deferredCheckConstraints = false;
    private boolean propsLoaded = false;
    private long replicaSize = 0L;
    protected double replicaId = 0.0;

    public ScriptReplica(Scriptable scope, ServerSideHost ssHost, SSContext context) {
        this.setParentScope(scope);
        this.ssHost = ssHost;
        this.ssContext = context;
    }

    @Override
    public String getClassName() {
        return "Replica";
    }

    @SmartScriptableObject.PropertyTag
    public double getChanelID() {
        return this.channelId;
    }

    public void setChanelID(double chanelId) {
        if (this.channelId != chanelId) {
            this.constants = null;
        }
        this.channelId = chanelId;
    }

    @SmartScriptableObject.PropertyTag
    public double getChannelID() {
        return this.channelId;
    }

    public void setChannelID(double channelId) {
        if (this.channelId != channelId) {
            this.constants = null;
        }
        this.channelId = channelId;
    }

    @SmartScriptableObject.PropertyTag
    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @SmartScriptableObject.PropertyTag
    public double getSourceID() {
        return this.sourceNodeId;
    }

    public void setSourceID(double sourceNodeId) {
        if (this.sourceNodeId != sourceNodeId) {
            this.propsLoaded = false;
        }
        this.sourceNodeId = sourceNodeId;
    }

    @SmartScriptableObject.PropertyTag
    public String getAgentName() {
        return this.agentName;
    }

    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }

    @SmartScriptableObject.PropertyTag
    public double getLoginID() {
        return this.userId;
    }

    public void setLoginID(double value) {
        this.userId = value;
    }

    @SmartScriptableObject.PropertyTag
    public boolean getCancelIfNoData() {
        return this.cancelIfNoData;
    }

    public void setCancelIfNoData(boolean cancelIfNoData) {
        this.cancelIfNoData = cancelIfNoData;
    }

    @SmartScriptableObject.PropertyTag
    public boolean getEnableAudit() {
        return this.enableAudit;
    }

    public void setEnableAudit(boolean enableAudit) {
        this.enableAudit = enableAudit;
    }

    @SmartScriptableObject.PropertyTag
    public boolean getFullReplica() {
        return this.fullReplica || this.syncMetadata;
    }

    public void setFullReplica(boolean fullReplica) {
        this.fullReplica = fullReplica;
    }

    @SmartScriptableObject.PropertyTag
    public boolean getUseFieldChanges() {
        return this.useFieldChanges;
    }

    public void setUseFieldChanges(boolean useFieldChanges) {
        this.useFieldChanges = useFieldChanges;
    }

    @SmartScriptableObject.PropertyTag
    public boolean getSyncMetadata() {
        return this.syncMetadata;
    }

    public void setSyncMetadata(boolean syncMetadata) {
        this.syncMetadata = syncMetadata;
    }

    @SmartScriptableObject.PropertyTag
    public boolean getReplaceData() {
        return this.replaceData;
    }

    public void setReplaceData(boolean replaceData) {
        this.replaceData = replaceData;
    }

    @SmartScriptableObject.PropertyTag
    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    @SmartScriptableObject.PropertyTag
    public String getLogin() {
        return this.remoteLogin;
    }

    public void setLogin(String remoteLogin) {
        this.remoteLogin = remoteLogin;
    }

    @SmartScriptableObject.PropertyTag
    public String getPassword() {
        return this.remotePassword;
    }

    public void setPassword(String remotePassword) {
        this.remotePassword = remotePassword;
    }

    @SmartScriptableObject.PropertyTag
    public double getBackReceivingID() {
        return this.backReceivingId;
    }

    public void setBackReceivingId(double backReceivingId) {
        this.backReceivingId = backReceivingId;
    }

    @SmartScriptableObject.PropertyTag
    public double getReceivingID() {
        return this.receivingId;
    }

    public void setReceivingId(double receivingId) {
        this.receivingId = receivingId;
    }

    @SmartScriptableObject.PropertyTag
    public double getSliceDateBegin() {
        return this.sliceDateBegin;
    }

    public void setSliceDateBegin(double sliceDateBegin) {
        this.sliceDateBegin = sliceDateBegin;
    }

    @SmartScriptableObject.PropertyTag
    public double getSliceDateEnd() {
        return this.sliceDateEnd;
    }

    public void setSliceDateEnd(double sliceDateEnd) {
        this.sliceDateEnd = sliceDateEnd;
    }

    @SmartScriptableObject.PropertyTag
    public boolean getBlobReplica() {
        return this.blobReplication;
    }

    public void setBlobReplica(boolean blobReplication) {
        this.blobReplication = blobReplication;
    }

    @SmartScriptableObject.PropertyTag
    public int getMaxChunkSize() {
        return this.maxChunkSize;
    }

    public void setMaxChunkSize(int maxChunkSize) {
        this.maxChunkSize = maxChunkSize;
    }

    @SmartScriptableObject.PropertyTag
    public Constants getConstants() throws InformException, IOException {
        if (this.constants == null || this.constantsChannelId != this.channelId) {
            if (this.channelId == 0.0) {
                throw new InformException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u043a\u0430\u043d\u0430\u043b \u0440\u0435\u043f\u043b\u0438\u043a\u0430\u0446\u0438\u0438");
            }
            this.constantsChannelId = this.channelId;
            this.constants = new Constants(0.0);
            this.constants.loadFromUser(0.0, MtdEngine.getNodeContent(3.0), GetActualConstantsForAccount.getActualConstants(this.channelId, this.ssHost));
        }
        return this.constants;
    }

    @SmartScriptableObject.PropertyTag
    public boolean getShowReplicaLog() {
        return this.showReplicationLog;
    }

    public void setShowReplicaLog(boolean showReplicationLog) {
        this.showReplicationLog = showReplicationLog;
    }

    @SmartScriptableObject.PropertyTag
    public long getReplicaSize() {
        return this.replicaSize;
    }

    @SmartScriptableObject.PropertyTag
    public double getReplicaID() {
        return this.replicaId;
    }

    @SmartScriptableObject.PropertyTag
    public boolean getIgnoreNoneAuditTables() {
        return this.ignoreNoneAuditTables;
    }

    public void setIgnoreNoneAuditTables(boolean ignoreNoneAuditTables) {
        this.ignoreNoneAuditTables = ignoreNoneAuditTables;
    }

    @SmartScriptableObject.PropertyTag
    public double getMaxRange() {
        return this.maxRange;
    }

    public void setMaxRange(double maxRange) {
        this.maxRange = maxRange;
    }

    @SmartScriptableObject.PropertyTag
    public boolean getDeferredCheckConstraints() throws IOException {
        this.loadProps();
        return this.deferredCheckConstraints;
    }

    public void setDeferredCheckConstraints(boolean deferredCheckConstraints) {
        this.deferredCheckConstraints = deferredCheckConstraints;
    }

    @SmartScriptableObject.FunctionTag
    public void execute() throws Throwable {
        ReplicationChannel channel;
        if (this.blobReplication) {
            channel = new BlobChannel(this.channelId, this.ssHost);
        } else if (this.fileName != null && !this.fileName.isEmpty()) {
            channel = new FileChannel(this.channelId, Core.mountfs.resolvePath(this.fileName), this.ssHost);
        } else {
            channel = new NetChannel(this.channelId, this.ssHost, this.userId);
            this.cancelIfNoData = false;
        }
        channel.load();
        if (this.constants != null) {
            channel.setModifiedConstants(this.constants);
        }
        if (channel instanceof NetChannel) {
            if (this.serverName != null) {
                ((NetChannel)channel).setServer(this.serverName);
            }
            if (this.agentName != null) {
                ((NetChannel)channel).setAgent(this.agentName);
            }
            if (this.remoteLogin != null) {
                ((NetChannel)channel).setLogin(this.remoteLogin);
            }
            if (this.remotePassword != null) {
                ((NetChannel)channel).setLogin(this.remotePassword);
            }
        }
        if (this.receivingId != 0.0) {
            channel.setReceivingId(this.receivingId);
        }
        if (this.backReceivingId != 0.0) {
            channel.setBackReceivingId(this.backReceivingId);
        }
        this.loadProps();
        Replication replication = new Replication(this.ssContext, this.ssHost, this.sourceNodeId, channel);
        if (this.fullReplica) {
            replication.setFullReplica();
        }
        if (this.cancelIfNoData) {
            replication.setCancelIfNoData();
        }
        if (!this.enableAudit) {
            replication.setDisableAudit();
        }
        if (this.replaceData) {
            replication.setReplaceData();
        }
        if (this.useFieldChanges) {
            replication.setUseFieldChanges(2);
        }
        if (this.maxChunkSize >= 0) {
            replication.setMaxChunkSize(this.maxChunkSize);
        }
        if (this.ignoreNoneAuditTables) {
            replication.setIgnoreNoneAuditTables();
        }
        if (this.maxRange > 0.0) {
            replication.setMaxRange(this.maxRange);
        }
        replication.setDeferrableCheckConstraints(this.deferredCheckConstraints);
        replication.setRequestStateLogEnabled(this.showReplicationLog);
        try {
            replication.execute(this.sliceDateBegin, this.sliceDateEnd);
            this.replicaSize = replication.getReplicaSize();
        }
        finally {
            this.replicaId = replication.getReplicaId();
            replication.close();
        }
    }

    private void loadProps() throws IOException {
        if (this.propsLoaded) {
            return;
        }
        this.propsLoaded = true;
        if (this.sourceNodeId == 0.0) {
            return;
        }
        this.deferredCheckConstraints = false;
        Node node = MtdEngine.getValidNode(this.sourceNodeId);
        if (node.getType() != 22) {
            MtdEngine.throwDetailError("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0443\u0437\u0435\u043b \u0440\u0435\u043f\u043b\u0438\u043a\u0430\u0446\u0438\u0438", this.sourceNodeId);
        }
        byte[] content = MtdEngine.getNodeContent(this.sourceNodeId);
        TaggedReader in = new TaggedReader(content);
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 33: {
                    this.deferredCheckConstraints = true;
                }
            }
        }
    }
}

