/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.replication.request;

import inform.adt.DateTime;
import inform.adt.InformException;
import inform.adt.NumberConverter;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.LittleEndianDataOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.RequestResult;
import inform.agent.db.connect.Connector;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.AccountNode;
import inform.agent.mtd.nodes.Node;
import inform.agent.mtd.nodes.UserRole;
import inform.agent.replication.DownloadParams;

public class DownloadNode
extends Request {
    public DownloadNode(RequestHeader rq) {
        super(rq, RequestDuration.MIDDLE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Throwable {
        if (this.security().role() != UserRole.ADMIN) {
            AccountNode.UserInterface ui = this.security().getUserInterface();
            if (!ui.canWritePex) {
                double userId = this.getUserID();
                String userName = MtdEngine.tryGetUserName(userId);
                throw new InformException("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044e " + userName + " [" + NumberConverter.doubleToString(userId) + "] \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e \u0432\u044b\u0433\u0440\u0443\u0436\u0430\u0442\u044c \u0432 \u043f\u0435\u043a\u0441");
            }
        }
        TaggedReader in = this.createRequestContentReader();
        DownloadParams params = new DownloadParams();
        params.parse(in);
        RequestResult result = new RequestResult(this);
        TaggedWriter out = result.getWriter();
        out.putInt32(22, DateTime.serverZoneOffset());
        double requestNodeId = this.getNodeID();
        Node node = MtdEngine.getValidNodeSync(this.ssContext, requestNodeId);
        ByteArrayOutputStream tagNodeHeader = new ByteArrayOutputStream();
        LittleEndianDataOutputStream data = new LittleEndianDataOutputStream(tagNodeHeader);
        data.writeDouble(node.getId());
        data.writeDouble(node.getParentId());
        data.writeInt(node.getType());
        data.writeInt(0);
        data.flush();
        out.putRaw(1, tagNodeHeader);
        if (params.isProcessAttributes()) {
            ByteArrayOutputStream attributes = new ByteArrayOutputStream();
            TaggedWriter writer = new TaggedWriter(attributes);
            writer.putInt32(123, DateTime.serverZoneOffset());
            try (Connector.Metabase connector = new Connector.Metabase();){
                double pinId = node.replicationStore(writer, 13, connector, this.client());
                connector.commit();
                if (pinId != 0.0) {
                    out.putDouble(19, pinId);
                }
            }
            writer.flush();
            out.putInt32(22, DateTime.serverZoneOffset());
            out.putRaw(2, attributes);
        }
        if (node.getType() == 12 && params.getProcessData() != 0) {
            throw new IllegalStateException("\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u0434\u0430\u043d\u043d\u044b\u0445 \u0434\u043e\u043b\u0436\u043d\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u044f\u0442\u044c\u0441\u044f \u043e\u0442\u0434\u0435\u043b\u044c\u043d\u044b\u043c \u0437\u0430\u043f\u0440\u043e\u0441\u043e\u043c");
        }
        result.sendResult();
    }
}

