/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes;

import inform.adt.DateTime;
import inform.adt.LittleEndian;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.schemes.EmbeddedText;
import inform.agent.schemes.PrimControlPoint;
import inform.agent.schemes.SchemeEngine;
import inform.agent.schemes.SchemeObjectsTypes;
import inform.agent.schemes.SchemePageNotes;
import inform.agent.schemes.SchemeParser;
import inform.agent.schemes.SchemeUtils;
import inform.agent.schemes.TextProps;
import inform.agent.schemes.TransformProps;
import inform.agent.schemes.effects.Glow;
import inform.agent.schemes.effects.Reflection;
import inform.agent.schemes.effects.Shadow;
import inform.agent.schemes.effects.SoftEdges;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseGraphic {
    private static final int version = LittleEndian.getInt(new byte[]{0, 0, 29, 2}, 0);
    private SchemePageNotes bgNotes;
    private List<PrimControlPoint> PrimControlPoints = null;
    public static double FloatTolerance = 1.0E-12;
    public static int NO_POINT = Integer.MAX_VALUE;
    public BaseGraphic ParentGB = null;
    public double Left = 0.0;
    public double Top = 0.0;
    public double Right = 0.0;
    public double Bottom = 0.0;
    public double OrgX = 0.0;
    public double OrgY = 0.0;
    public double ID = 0.0;
    public double LayerID = 0.0;
    public double ContainerID = 0.0;
    public double AngleRoundSize = 0.0;
    public boolean FixScaleX;
    public boolean FixScaleY;
    public boolean Hidden;
    public boolean isBadObject;
    public String Categories = null;
    public TransformProps TransProps = null;
    public TextProps StringProps = null;
    public List<GluePoint> GluePoints = null;
    public GluePoint DynamicGluePoint = null;
    public EmbeddedText EmbeddedText = null;
    public Reflection ReflectionEffect = Reflection.NO_EFFECT;
    public Glow GlowEffect = Glow.NO_EFFECT;
    public SoftEdges SoftEdgesEffect = SoftEdges.NO_EFFECT;
    public Shadow ShadowEffect = Shadow.NO_EFFECT;
    protected SchemeEngine Engine;

    public void assign(BaseGraphic Dest) throws IllegalAccessException, InstantiationException {
        Dest.Left = this.Left;
        Dest.Top = this.Top;
        Dest.Right = this.Right;
        Dest.Bottom = this.Bottom;
        Dest.OrgX = this.OrgX;
        Dest.OrgY = this.OrgY;
        Dest.ID = this.ID;
        Dest.LayerID = this.LayerID;
        Dest.ParentGB = this.ParentGB;
        if (this.TransProps != null) {
            Dest.TransProps = new TransformProps();
            Dest.TransProps.Angle = this.TransProps.Angle;
            Dest.TransProps.CenterX = this.TransProps.CenterX;
            Dest.TransProps.CenterY = this.TransProps.CenterY;
            Dest.TransProps.ScaleX = this.TransProps.ScaleX;
            Dest.TransProps.ScaleY = this.TransProps.ScaleY;
            Dest.TransProps.SkewX = this.TransProps.SkewX;
            Dest.TransProps.SkewY = this.TransProps.SkewY;
        } else {
            Dest.TransProps = null;
        }
        if (this.StringProps != null) {
            Dest.StringProps = new TextProps();
            Dest.StringProps.Caption = this.StringProps.Caption;
            Dest.StringProps.Hint = this.StringProps.Hint;
            Dest.StringProps.Name = this.StringProps.Name;
        } else {
            Dest.StringProps = null;
        }
    }

    protected void afterParse() {
    }

    protected void parse(SchemeParser Parser2, TaggedReader reader) throws IOException, TaggedReaderException {
        block29: while (reader.getNextTag() != 0) {
            switch (reader.getCurrentTag()) {
                case 4: {
                    byte[] tmpBytes = reader.getRaw();
                    this.OrgX = LittleEndian.getDouble(tmpBytes, 0);
                    this.OrgY = LittleEndian.getDouble(tmpBytes, 8);
                    break;
                }
                case 5: {
                    byte[] tmpBytes = reader.getRaw();
                    if (this.TransProps == null) {
                        this.TransProps = new TransformProps();
                    }
                    this.TransProps.CenterX = LittleEndian.getDouble(tmpBytes, 0);
                    this.TransProps.CenterY = LittleEndian.getDouble(tmpBytes, 8);
                    break;
                }
                case 6: {
                    byte[] tmpBytes = reader.getRaw();
                    this.Left = LittleEndian.getDouble(tmpBytes, 0);
                    this.Top = LittleEndian.getDouble(tmpBytes, 8);
                    this.Right = LittleEndian.getDouble(tmpBytes, 16);
                    this.Bottom = LittleEndian.getDouble(tmpBytes, 24);
                    break;
                }
                case 7: {
                    if (this.TransProps == null) {
                        this.TransProps = new TransformProps();
                    }
                    this.TransProps.Angle = reader.getDouble();
                    break;
                }
                case 8: {
                    if (this.TransProps == null) {
                        this.TransProps = new TransformProps();
                    }
                    this.TransProps.ScaleX = reader.getDouble();
                    break;
                }
                case 9: {
                    if (this.TransProps == null) {
                        this.TransProps = new TransformProps();
                    }
                    this.TransProps.ScaleY = reader.getDouble();
                    break;
                }
                case 10: {
                    if (this.TransProps == null) {
                        this.TransProps = new TransformProps();
                    }
                    this.TransProps.SkewX = reader.getDouble();
                    break;
                }
                case 11: {
                    if (this.TransProps == null) {
                        this.TransProps = new TransformProps();
                    }
                    this.TransProps.SkewY = reader.getDouble();
                    break;
                }
                case 112: {
                    if (this.StringProps == null) {
                        this.StringProps = new TextProps();
                    }
                    this.StringProps.Name = reader.getString();
                    break;
                }
                case 12: {
                    if (this.StringProps == null) {
                        this.StringProps = new TextProps();
                    }
                    this.StringProps.Caption = reader.getUnicode();
                    break;
                }
                case 13: {
                    if (this.StringProps == null) {
                        this.StringProps = new TextProps();
                    }
                    this.StringProps.Hint = reader.getUnicode();
                    break;
                }
                case 15: {
                    this.ID = reader.getDouble();
                    break;
                }
                case 17: {
                    this.LayerID = reader.getDouble();
                    break;
                }
                case 149: {
                    this.Hidden = reader.getBoolean();
                    break;
                }
                case 119: {
                    reader.skip();
                    TaggedReader stream = reader.getStreamReader(202);
                    while (stream.next()) {
                        this.readExtraTagged(Parser2, stream, stream.getCurrentTag());
                    }
                    continue block29;
                }
                case 21: {
                    if (this.GluePoints == null) {
                        this.GluePoints = new ArrayList<GluePoint>();
                    }
                    TaggedReader reader2 = reader.getStreamReader(21);
                    while (reader2.next()) {
                        switch (reader2.getCurrentTag()) {
                            case 22: {
                                TaggedReader reader3 = reader2.getStreamReader(22);
                                GluePoint gp = new GluePoint();
                                while (reader3.next()) {
                                    switch (reader3.getCurrentTag()) {
                                        case 23: {
                                            gp.flags = reader3.getByte();
                                            break;
                                        }
                                        case 24: {
                                            byte[] data = reader3.getRaw(24);
                                            gp.ptX = LittleEndian.getDouble(data, 0);
                                            gp.ptY = LittleEndian.getDouble(data, 8);
                                            break;
                                        }
                                        case 25: {
                                            gp.parentPointIdx = reader3.getInt();
                                            break;
                                        }
                                        case 26: {
                                            gp.vertIdx = reader3.getInt();
                                            break;
                                        }
                                        case 27: {
                                            gp.contactNumber = reader3.getInt();
                                            break;
                                        }
                                        case 28: {
                                            gp.joinId = reader3.getDouble();
                                        }
                                    }
                                }
                                if (gp.parentPointIdx < 0) {
                                    this.DynamicGluePoint = gp;
                                    break;
                                }
                                this.GluePoints.add(gp);
                                break;
                            }
                        }
                    }
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paint(Graphics2D g2d, SchemeEngine Engine2) throws IllegalAccessException, InstantiationException {
        if (Engine2.tmpLayer == null || Engine2.tmpLayer.getConfigVisible(Engine2.getLayersConfig())) {
            AffineTransform OldGTM = new AffineTransform();
            if (Engine2.UseGTM) {
                OldGTM.setTransform(Engine2.GTM);
                double OldAngle = Engine2.tmpAngle;
                if (this.TransProps != null && this.TransProps.Angle != 0.0) {
                    Engine2.tmpAngle += this.TransProps.Angle;
                }
                try {
                    Engine2.GTM.concatenate(SchemeEngine.GenTransform(this));
                    this.actualPaint(g2d, Engine2);
                }
                finally {
                    Engine2.GTM.setTransform(OldGTM);
                    Engine2.tmpAngle = OldAngle;
                }
            }
            OldGTM.setTransform(g2d.getTransform());
            try {
                SchemeEngine.Transform(g2d, this);
                this.actualPaint(g2d, Engine2);
            }
            finally {
                g2d.setTransform(OldGTM);
            }
        }
    }

    protected abstract void actualPaint(Graphics2D var1, SchemeEngine var2) throws IllegalAccessException, InstantiationException;

    public int shapeType() {
        return 201;
    }

    public int shapeVersion() {
        return version;
    }

    public ShapeClassInfo getShapeClassInfo() {
        ShapeClassInfo result = new ShapeClassInfo();
        result.shapeType = this.shapeType();
        result.version = this.shapeVersion();
        return result;
    }

    public void setCaption(String value) {
        if (this.StringProps == null) {
            this.StringProps = new TextProps();
        }
        this.StringProps.Caption = value;
    }

    public void setName(String value) {
        if (this.StringProps == null) {
            this.StringProps = new TextProps();
        }
        this.StringProps.Name = value;
    }

    public void setHint(String value) {
        if (this.StringProps == null) {
            this.StringProps = new TextProps();
        }
        this.StringProps.Hint = value;
    }

    public synchronized byte[] asBinary() throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        TaggedWriter writer = new TaggedWriter(os);
        this.writeBG(writer, false, false);
        return os.toByteArray();
    }

    public synchronized void writeBG(TaggedWriter writer, boolean clipboard, boolean simult) throws IOException {
        SchemeUtils.writeShapeClassInfo(writer, this.getShapeClassInfo());
        this.writeTaggedData(writer, clipboard, simult);
        writer.flush();
    }

    public synchronized void writeTaggedData(TaggedWriter writer, boolean clipboard, boolean simult) throws IOException {
        if (writer == null) {
            return;
        }
        if (this.ID == 0.0) {
            this.ID = Core.generateId();
        }
        SchemeUtils.writeDoubles(writer, 4, this.OrgX, this.OrgY);
        if (this.TransProps != null) {
            SchemeUtils.writeDoubles(writer, 5, this.TransProps.CenterX, this.TransProps.CenterY);
        }
        this.writeTaggedBounds(writer);
        if (this.TransProps != null) {
            if (Math.abs(this.TransProps.Angle) > FloatTolerance) {
                writer.putDouble(7, this.TransProps.Angle);
            }
            if (Math.abs(1.0 - this.TransProps.ScaleX) > FloatTolerance) {
                writer.putDouble(8, this.TransProps.ScaleX);
            }
            if (Math.abs(1.0 - this.TransProps.ScaleY) > FloatTolerance) {
                writer.putDouble(9, this.TransProps.ScaleY);
            }
            if (Math.abs(this.TransProps.SkewX) > FloatTolerance) {
                writer.putDouble(10, this.TransProps.SkewX);
            }
            if (Math.abs(this.TransProps.SkewY) > FloatTolerance) {
                writer.putDouble(11, this.TransProps.SkewY);
            }
        }
        if (this.StringProps != null) {
            if (this.StringProps.Name != null && !this.StringProps.Name.isEmpty()) {
                writer.putString(112, this.StringProps.Name);
            }
            if (this.StringProps.Caption != null && !this.StringProps.Caption.isEmpty()) {
                writer.putUnicode(12, this.StringProps.Caption);
            }
            if (this.StringProps.Hint != null && !this.StringProps.Hint.isEmpty()) {
                writer.putUnicode(13, this.StringProps.Hint);
            }
        }
        if (this.ID != 0.0) {
            writer.putDouble(15, this.ID);
        }
        this.writeTaggedGluePoints(writer);
        writer.putDouble(16, DateTime.currentDateTime());
        if (this.LayerID != 0.0) {
            writer.putDouble(17, this.LayerID);
        }
        if (this.Hidden) {
            writer.putBool(149, this.Hidden);
        }
        ByteArrayOutputStream extraOS = new ByteArrayOutputStream();
        TaggedWriter extraW = new TaggedWriter(extraOS);
        this.writeExtraTagged(extraW);
        extraW.flush();
        if (extraOS.size() > 0) {
            writer.putEmpty(119);
            writer.putRaw(202, extraOS);
        }
    }

    synchronized void writeTaggedBounds(TaggedWriter writer) throws IOException {
        SchemeUtils.writeDoubles(writer, 6, this.Left, this.Top, this.Right, this.Bottom);
    }

    synchronized void writeTaggedGluePoints(TaggedWriter writer) throws IOException {
        if (writer == null || this.DynamicGluePoint == null && (this.GluePoints == null || this.GluePoints.isEmpty())) {
            return;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        TaggedWriter w = new TaggedWriter(os);
        if (this.DynamicGluePoint != null) {
            this.writeTaggedGluePoint(w, this.DynamicGluePoint);
        }
        if (this.GluePoints != null) {
            for (GluePoint gp : this.GluePoints) {
                this.writeTaggedGluePoint(w, gp);
            }
        }
        w.flush();
        writer.putRaw(21, os);
    }

    synchronized void writeTaggedGluePoint(TaggedWriter w, GluePoint gp) throws IOException {
        assert (gp != null);
        ByteArrayOutputStream os1 = new ByteArrayOutputStream();
        TaggedWriter w1 = new TaggedWriter(os1);
        if (gp.flags != 0) {
            w1.putInt08(23, gp.flags);
        }
        if (gp.ptX != 0.0 || gp.ptY != 0.0) {
            SchemeUtils.writeDoubles(w1, 24, gp.ptX, gp.ptY);
        }
        if (gp.parentPointIdx != 0) {
            w1.putInt32(25, gp.parentPointIdx);
        }
        if (gp.vertIdx != 0) {
            w1.putInt32(26, gp.vertIdx);
        }
        if (gp.contactNumber != 0) {
            w1.putInt32(27, gp.contactNumber);
        }
        if (gp.joinId != 0.0) {
            w1.putDouble(28, gp.joinId);
        }
        w1.flush();
        w.putRaw(22, os1);
    }

    synchronized void writeCategoriesTagged(TaggedWriter writer) throws IOException {
        if (writer == null || this.Categories == null) {
            return;
        }
        if (!this.Categories.isEmpty()) {
            writer.putString(7, this.Categories);
        }
    }

    protected synchronized void readExtraTagged(SchemeParser parser, TaggedReader reader, int tag) throws IOException {
        switch (tag) {
            case 1: {
                this.ContainerID = reader.getDouble();
                break;
            }
            case 3: {
                if (this.TransProps == null) {
                    this.TransProps = new TransformProps();
                }
                this.FixScaleX = reader.getBoolean();
                break;
            }
            case 4: {
                if (this.TransProps == null) {
                    this.TransProps = new TransformProps();
                }
                this.FixScaleY = reader.getBoolean();
                break;
            }
            case 22: {
                this.AngleRoundSize = reader.getDouble();
                break;
            }
            case 7: {
                this.Categories = reader.getString();
                break;
            }
            case 20: {
                if (this.EmbeddedText == null) {
                    this.EmbeddedText = new EmbeddedText();
                }
                reader.skip();
                TaggedReader fieldReader = reader.getStreamReader(202);
                this.EmbeddedText.loadTags(fieldReader);
                this.EmbeddedText.LayerID = this.LayerID;
                this.EmbeddedText.ParentGB = this;
                break;
            }
            case 14: {
                byte[] content = reader.getRaw();
                if (content.length == 0) break;
                if (this.bgNotes == null) {
                    this.bgNotes = new SchemePageNotes();
                }
                this.bgNotes.load(new TaggedReader(content));
                break;
            }
        }
    }

    protected synchronized void writeExtraTagged(TaggedWriter writer) throws IOException {
        ByteArrayOutputStream os;
        byte[] bytes;
        if (this.ContainerID != 0.0) {
            writer.putDouble(1, this.ContainerID);
        }
        if (this.AngleRoundSize != 0.0) {
            writer.putDouble(22, this.AngleRoundSize);
        }
        if (this.FixScaleX) {
            writer.putBool(3, this.FixScaleX);
        }
        if (this.FixScaleY) {
            writer.putBool(4, this.FixScaleY);
        }
        this.writeCategoriesTagged(writer);
        if (this.containsNotes() && (bytes = this.bgNotes.asBinary()) != null && bytes.length > 0) {
            writer.putRaw(14, bytes);
        }
        if (this.EmbeddedText != null) {
            os = new ByteArrayOutputStream();
            TaggedWriter extraWriter = new TaggedWriter(os);
            this.EmbeddedText.storeTags(extraWriter);
            extraWriter.flush();
            if (os.size() > 0) {
                writer.putEmpty(20);
                writer.putRaw(202, os);
            }
        }
        if (this.hasEffects()) {
            os = new ByteArrayOutputStream();
            TaggedWriter effectsWriter = new TaggedWriter(os);
            this.writeTaggedEffects(effectsWriter);
            effectsWriter.flush();
            if (os.size() > 0) {
                writer.putEmpty(28);
                writer.putRaw(202, os);
            }
        }
    }

    private boolean hasEffects() {
        return this.ReflectionEffect.isEnabled() || this.GlowEffect.isEnabled() || this.ShadowEffect.isEnabled() || this.SoftEdgesEffect.isEnabled();
    }

    private void writeTaggedEffects(TaggedWriter effectsWriter) throws IOException {
        if (this.ReflectionEffect.isEnabled()) {
            this.ReflectionEffect.writeTaggedData(effectsWriter);
        }
        if (this.GlowEffect.isEnabled()) {
            this.GlowEffect.writeTaggedData(effectsWriter);
        }
        if (this.SoftEdgesEffect.isEnabled()) {
            this.SoftEdgesEffect.writeTaggedData(effectsWriter);
        }
        if (this.ShadowEffect.isEnabled()) {
            this.ShadowEffect.writeTaggedData(effectsWriter);
        }
    }

    protected abstract void calcOrgAndAjust(int var1, boolean var2);

    protected abstract int getVerticesCount();

    protected abstract double getVertexX(int var1);

    protected abstract double getVertexY(int var1);

    protected abstract void setVertex(int var1, double var2, double var4);

    public GluePoint getGluePoint(double x, double y) {
        if (this.GluePoints == null) {
            return null;
        }
        for (GluePoint p : this.GluePoints) {
            if (!SchemeUtils.isEqual(x, p.ptX) || !SchemeUtils.isEqual(y, p.ptY)) continue;
            return p;
        }
        return null;
    }

    public boolean addGluePoint(double x, double y) {
        GluePoint addPt = new GluePoint();
        addPt.ptX = x;
        addPt.ptY = y;
        addPt.flags = (byte)4;
        if (this.GluePoints == null) {
            this.GluePoints = new ArrayList<GluePoint>();
        }
        this.GluePoints.add(addPt);
        addPt.parentPointIdx = this.GluePoints.size() - 1;
        addPt.vertIdx = -1;
        addPt.contactNumber = (this.GluePoints.size() - 1) % 2 + 1;
        return true;
    }

    public void addDynamicGluePoint() {
        if (this.DynamicGluePoint != null) {
            return;
        }
        this.DynamicGluePoint = new GluePoint();
        this.DynamicGluePoint.flags = (byte)4;
        this.DynamicGluePoint.parentPointIdx = -1;
        this.DynamicGluePoint.vertIdx = -1;
    }

    public GluePoint glueByVertIdx(int index) {
        if (this.GluePoints == null) {
            return null;
        }
        for (GluePoint p : this.GluePoints) {
            if (p.vertIdx != index) continue;
            return p;
        }
        return null;
    }

    public boolean isVertexGluable(int index) {
        return true;
    }

    public static double initMaxX() {
        return -2.147483647E9;
    }

    public static double initMaxY() {
        return -2.147483647E9;
    }

    public static double initMinX() {
        return 2.147483647E9;
    }

    public static double initMinY() {
        return 2.147483647E9;
    }

    public boolean isCartographic() {
        return true;
    }

    public void minMaxPt(boolean ignoreInvisible, boolean ignoreGP) {
    }

    public void genDistRadius(boolean ignoreGP) {
    }

    public RealRect getMinMaxRect() {
        return new RealRect();
    }

    protected RealRect ptArrToRect(double[] points, int cntPoint) {
        if (points == null || points.length < 2) {
            return null;
        }
        RealRect rect = new RealRect();
        rect.Left = points[0];
        rect.Top = points[1];
        rect.Right = points[0];
        rect.Bottom = points[1];
        int i = 2;
        int cnt = points.length - 1;
        while (i < cnt && cntPoint > 0) {
            double x = points[i++];
            double y = points[i++];
            if (x > rect.Right) {
                rect.Right = x;
            }
            if (x < rect.Left) {
                rect.Left = x;
            }
            if (y > rect.Bottom) {
                rect.Bottom = y;
            }
            if (y < rect.Top) {
                rect.Top = y;
            }
            --cntPoint;
        }
        return rect;
    }

    public SchemeEngine getEngine() {
        return this.Engine;
    }

    public void setEngine(SchemeEngine engine) {
        this.Engine = engine;
    }

    public boolean needFixScale(RealPoint parentScale) {
        boolean vert;
        double a;
        boolean inInsert;
        parentScale.X = 1.0;
        parentScale.Y = 1.0;
        if (!this.FixScaleX && !this.FixScaleY) {
            return false;
        }
        if (this.ParentGB == null || this.ParentGB.ParentGB == null) {
            return false;
        }
        int parentType = this.ParentGB.ParentGB.shapeType();
        boolean bl = inInsert = parentType == 207;
        if (!inInsert && !SchemeObjectsTypes.ObjTypeIsLayer(parentType)) {
            return false;
        }
        double d = a = this.TransProps != null ? this.TransProps.Angle : 0.0;
        if (Math.abs(a - 90.0 * (double)((int)(a / 90.0))) > 0.5) {
            return false;
        }
        BaseGraphic parent = inInsert ? this.ParentGB.ParentGB : this.ParentGB;
        boolean bl2 = vert = Math.abs(a - 180.0 * (double)((int)(a / 180.0))) > 0.5;
        if (!vert) {
            if (this.FixScaleX) {
                parentScale.X = parent.scaleX0();
            }
            if (this.FixScaleY) {
                parentScale.Y = parent.scaleY0();
            }
        } else {
            if (this.FixScaleX) {
                parentScale.Y = parent.scaleX0();
            }
            if (this.FixScaleY) {
                parentScale.X = parent.scaleY0();
            }
        }
        return parentScale.X != 1.0 || parentScale.Y != 1.0;
    }

    public double scaleX() {
        double sp;
        RealPoint parentScale = new RealPoint();
        double d = sp = this.needFixScale(parentScale) ? parentScale.X : 1.0;
        if (parentScale.X != 1.0) {
            parentScale.X = 1.0;
        }
        if (Math.abs(sp) < 1.0E-12) {
            sp = 1.0;
        }
        return this.TransProps != null ? this.TransProps.ScaleX / sp : 1.0 / sp;
    }

    public double scaleY() {
        double sp;
        RealPoint parentScale = new RealPoint();
        double d = sp = this.needFixScale(parentScale) ? parentScale.Y : 1.0;
        if (Math.abs(sp) < 1.0E-12) {
            sp = 1.0;
        }
        return this.TransProps != null ? this.TransProps.ScaleY / sp : 1.0 / sp;
    }

    private double scaleX0() {
        return this.TransProps != null ? this.TransProps.ScaleX : 1.0;
    }

    private double scaleY0() {
        return this.TransProps != null ? this.TransProps.ScaleY : 1.0;
    }

    public boolean emText() {
        int type = this.shapeType();
        boolean supportEmText = type != 223 && type != 224 && type != 225 && type != 226 && type != 231 && type != 232 && type != 233 && type != 234;
        return supportEmText && this.EmbeddedText != null;
    }

    public boolean containsNotes() {
        return this.bgNotes != null && this.bgNotes.getNotes() != null && !this.bgNotes.getNotes().isEmpty();
    }

    public SchemePageNotes getBgNotes() {
        return this.bgNotes;
    }

    public void setBgNotes(SchemePageNotes value) {
        this.bgNotes = value;
    }

    public List<PrimControlPoint> getPrimControlPoints() {
        return this.PrimControlPoints;
    }

    public void setPrimControlPoints(List<PrimControlPoint> primControlPoints) {
        this.PrimControlPoints = primControlPoints;
    }

    public static class GluePoint {
        public double ptX = 0.0;
        public double ptY = 0.0;
        public byte flags = 0;
        int parentPointIdx = 0;
        int vertIdx = 0;
        public int contactNumber = 0;
        double joinId = 0.0;
    }

    public static class ShapeClassInfo {
        public int shapeType;
        public int version = 0;
    }

    public static class RealRect {
        public double Left = 0.0;
        public double Top = 0.0;
        public double Right = 0.0;
        public double Bottom = 0.0;
    }

    public static class RealPoints
    extends ArrayList<RealPoint> {
        public double[] getPoints() {
            int len = this.size();
            double[] result = new double[len * 2];
            int idx = 0;
            for (int i = 0; i < len; ++i) {
                RealPoint point = (RealPoint)this.get(i);
                result[idx++] = point.X;
                result[idx++] = point.Y;
            }
            return result;
        }
    }

    public static class RealPoint {
        public double X = 0.0;
        public double Y = 0.0;

        public RealPoint() {
        }

        public RealPoint(double x, double y) {
            this.X = x;
            this.Y = y;
        }

        public RealPoint(RealPoint p) {
            if (p != null) {
                this.X = p.X;
                this.Y = p.Y;
            }
        }

        public double[] getPoint() {
            return new double[]{this.X, this.Y};
        }
    }
}

