/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes;

import inform.adt.collections.DoubleList;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.schemes.GraphicBlock;
import inform.agent.schemes.SchemeParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class Container
extends GraphicBlock {
    private static final int TAG_LOCKED = 1;
    private static final int TAG_AUTOMATIC_RESIZE = 2;
    private static final int TAG_CATEGORIES = 3;
    private static final int TAG_REQUIRED_CATEGORIES = 4;
    private static final int TAG_EXCLUDED_CATEGORIES = 5;
    private static final int TAG_LIST = 6;
    private static final int TAG_LIST_REQUIRED_CATEGORIES = 7;
    private static final int TAG_LIST_EXCLUDED_CATEGORIES = 8;
    private static final int TAG_LIST_ALIGNMENT = 9;
    private static final int TAG_LIST_DIRECTION = 10;
    private static final int TAG_RELATION_ID = 11;
    private static final int TAG_HEADING_ID = 12;
    private static final int TAG_HEADING_EDGE = 13;
    private static final int TAG_MARGIN = 14;
    public boolean Locked = false;
    public double Margin = 0.0;
    public byte AutomaticResize = 1;
    public byte ListAlignment = 0;
    public byte ListDirection = (byte)2;
    public String RequiredCategories;
    public String ExcludedCategories;
    public boolean AsList = false;
    public String ListRequiredCategories;
    public String ListExcludedCategories;
    public DoubleList OrderRelationshipIds = new DoubleList(0);
    public List<HeadingContainer> Headings;

    public double getHeadingId() {
        if (this.Headings == null || this.Headings.isEmpty()) {
            return 0.0;
        }
        return this.Headings.get((int)0).id;
    }

    public byte getHeadingEdge() {
        if (this.Headings == null || this.Headings.isEmpty()) {
            return 0;
        }
        return this.Headings.get((int)0).edge;
    }

    @Override
    public int shapeType() {
        return 232;
    }

    @Override
    protected synchronized void readExtraTagged(SchemeParser parser, TaggedReader reader, int tag) throws IOException {
        if (tag == 2) {
            int headingsIndex = -1;
            TaggedReader subReader = reader.getStreamReader();
            block16: while (subReader.next()) {
                switch (subReader.getCurrentTag()) {
                    case 1: {
                        this.Locked = true;
                        continue block16;
                    }
                    case 2: {
                        this.AutomaticResize = subReader.getByte();
                        continue block16;
                    }
                    case 3: {
                        this.Categories = subReader.getString();
                        continue block16;
                    }
                    case 4: {
                        this.RequiredCategories = subReader.getString();
                        continue block16;
                    }
                    case 5: {
                        this.ExcludedCategories = subReader.getString();
                        continue block16;
                    }
                    case 6: {
                        this.AsList = true;
                        this.OrderRelationshipIds.clear();
                        continue block16;
                    }
                    case 7: {
                        this.ListRequiredCategories = subReader.getString();
                        continue block16;
                    }
                    case 8: {
                        this.ListExcludedCategories = subReader.getString();
                        continue block16;
                    }
                    case 9: {
                        this.ListAlignment = subReader.getByte();
                        continue block16;
                    }
                    case 10: {
                        this.ListDirection = subReader.getByte();
                        continue block16;
                    }
                    case 11: {
                        this.OrderRelationshipIds.add(subReader.getDouble());
                        continue block16;
                    }
                    case 12: {
                        double v = subReader.getDouble();
                        if (v == 0.0) continue block16;
                        HeadingContainer h = new HeadingContainer();
                        h.id = v;
                        if (this.Headings == null) {
                            this.Headings = new ArrayList<HeadingContainer>();
                        }
                        headingsIndex = this.Headings.size();
                        this.Headings.add(h);
                        continue block16;
                    }
                    case 13: {
                        if (this.Headings == null || headingsIndex < 0 || headingsIndex >= this.Headings.size()) continue block16;
                        this.Headings.get((int)headingsIndex).edge = subReader.getByte();
                        headingsIndex = -1;
                        continue block16;
                    }
                    case 14: {
                        this.Margin = subReader.getDouble();
                        continue block16;
                    }
                }
            }
        } else {
            super.readExtraTagged(parser, reader, tag);
        }
    }

    @Override
    protected synchronized void writeExtraTagged(TaggedWriter writer) throws IOException {
        super.writeExtraTagged(writer);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        TaggedWriter w = new TaggedWriter(os);
        if (this.Locked) {
            w.putEmpty(1);
        }
        if (this.AutomaticResize != 1) {
            w.putInt08(2, this.AutomaticResize);
        }
        if (this.Margin != 0.0) {
            w.putDouble(14, this.Margin);
        }
        if (this.Categories != null && !this.Categories.isEmpty()) {
            w.putString(3, this.Categories);
        }
        if (!this.AsList) {
            if (this.RequiredCategories != null && !this.RequiredCategories.isEmpty()) {
                w.putString(4, this.RequiredCategories);
            }
            if (this.ExcludedCategories != null && !this.ExcludedCategories.isEmpty()) {
                w.putString(5, this.ExcludedCategories);
            }
        }
        if (this.Headings != null) {
            for (HeadingContainer h : this.Headings) {
                if (h.id == 0.0) continue;
                w.putDouble(12, h.id);
                if (h.edge == 0) continue;
                w.putInt08(13, h.edge);
            }
        }
        if (this.AsList) {
            w.putEmpty(6);
            if (this.ListRequiredCategories != null && !this.ListRequiredCategories.isEmpty()) {
                w.putString(7, this.ListRequiredCategories);
            }
            if (this.ListExcludedCategories != null && !this.ListExcludedCategories.isEmpty()) {
                w.putString(8, this.ListExcludedCategories);
            }
            if (this.ListAlignment != 0) {
                w.putInt08(9, this.ListAlignment);
            }
            if (this.ListDirection != 2) {
                w.putInt08(10, this.ListDirection);
            }
            int cnt = this.OrderRelationshipIds.size();
            for (int i = 0; i < cnt; ++i) {
                w.putDouble(11, this.OrderRelationshipIds.get(i));
            }
        }
        w.flush();
        if (os.size() > 1) {
            writer.putRaw(2, os);
        }
    }

    @Override
    synchronized void writeCategoriesTagged(TaggedWriter writer) throws IOException {
    }

    public static class HeadingContainer {
        public double id = 0.0;
        public byte edge = 0;
    }
}

