/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes;

import inform.adt.NumberConverter;
import inform.adt.collections.DoubleHash;
import inform.agent.Core;
import inform.agent.ServerSideHost;
import inform.agent.db.connect.ConnectionManager;
import inform.agent.schemes.Attribute;
import inform.agent.schemes.AttributeDef;
import inform.agent.schemes.AttributeRef;
import inform.agent.schemes.BaseGraphic;
import inform.agent.schemes.BaseShape;
import inform.agent.schemes.Ellipse;
import inform.agent.schemes.GraphicBlock;
import inform.agent.schemes.Image;
import inform.agent.schemes.Paragraph;
import inform.agent.schemes.PhxGraphicInsert;
import inform.agent.schemes.PhxLayer;
import inform.agent.schemes.Pie;
import inform.agent.schemes.Polygon;
import inform.agent.schemes.Polyline;
import inform.agent.schemes.Primitive;
import inform.agent.schemes.RectTextLine;
import inform.agent.schemes.Rectangle;
import inform.agent.schemes.Region;
import inform.agent.schemes.Scheme;
import inform.agent.schemes.SchemeEngine;
import inform.agent.schemes.SchemeObject;
import inform.agent.schemes.SchemeObjectsTypes;
import inform.agent.schemes.SchemePage;
import inform.agent.schemes.SchemeUtils;
import inform.agent.schemes.Spline;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;

public class DxfWriter {
    private static final String CONTINUOUS_LINE = "Continuous";
    private static final String SOLID_LINE = "_SOLID";
    private static final String DASH_LINE = "_DASH";
    private static final String DOT_LINE = "_DOT";
    private static final String DASHDOT_LINE = "_DASHDOT";
    private static final String DASHDOTDOT_LINE = "_DASHDOTDOT";
    private static final String ACADISO06W100_LINE = "ACADISO06W100";
    private static final String LEP_LINE = "\u041b\u042d\u041f";
    private static final String V_PR_LINE = "\u0412\u043e\u0434\u043e\u043f\u0440\u043e\u0432\u043e\u0434";
    private static final String N_PR_LINE = "\u041d\u0435\u0444\u0442\u0435\u043f\u0440";
    private static final String P_PR_LINE = "\u041f\u0440\u043e\u0434\u0443\u043a\u0442\u043e\u043f\u0440.";
    private static final String OVR_LINE = "\u041e\u0432\u0440\u0430\u0433\u0438";
    private static final String SHT_LINE = "\u0428\u0422\u0420\u0418\u0425\u041e\u0412\u0410\u042f";
    private static final String AD_1MM_MLINE = "AD_1MM";
    private static final String OVR_1MM_MLINE = "OVR_1MM";
    private static final String GD_1MM_MLINE = "GD_1MM";
    private static final String LEP_PRIM_NAME = "lep";
    private static final String V_PR_PRIM_NAME = "v_pr";
    private static final String N_PR_PRIM_NAME = "n_pr";
    private static final String P_PR_PRIM_NAME = "p_pr";
    private static final String AD_PRIM_NAME = "ad";
    private static final String OVR_PRIM_NAME = "ovr";
    private static final String GD_PRIM_NAME = "gd";
    private static final String LEX_VALUE_1A = " 1A";
    private static final String LEX_VALUE_19 = " 19";
    private static final String LEX_VALUE_STANDARD = "STANDARD";
    private static final double FONT_TXT_HEIGHT_COEF = 1.3885;
    private static final double FONT_TXT_MARGIN_TOP_COEF = 0.14893;
    private static final double FONT_TXT_MARGIN_LEFT_COEF = 0.28219;
    private static final int[] DXF_TRANSPARENTS = new int[]{0x20000FF, 33554684, 33554681, 33554679, 33554676, 0x20000F2, 33554671, 33554669, 33554666, 33554664, 33554661, 0x20000E2, 0x20000E0, 0x20000DD, 33554651, 33554648, 33554646, 33554643, 33554641, 33554638, 0x20000CC, 33554633, 33554630, 33554628, 33554625, 33554623, 33554620, 33554618, 33554615, 33554613, 0x20000B2, 33554607, 33554605, 0x20000AA, 33554600, 33554597, 33554595, 0x20000A0, 33554590, 33554587, 0x2000099, 33554582, 33554579, 33554577, 33554574, 33554572, 33554569, 33554567, 33554564, 0x2000082, 33554559, 33554556, 33554554, 0x2000077, 33554549, 0x2000072, 0x2000070, 33554541, 33554539, 33554536, 0x2000066, 33554531, 0x2000060, 33554526, 33554523, 33554521, 33554518, 33554516, 33554513, 33554511, 33554508, 33554505, 33554503, 0x2000044, 0x2000042, 33554495, 33554493, 33554490, 33554488, 33554485, 0x2000033, 0x2000030, 0x200002D, 0x200002B, 0x2000028, 0x2000026, 0x2000023, 0x2000021, 33554462, 33554460, 33554457};
    private static final int DXF_BLACK = 7;
    private static final int DXF_WHITE = 255;
    private static final int DXF_BY_LAYER = 256;
    private static final int[] DXF_COLORS = new int[]{0, 255, 65535, 65280, 0xFFFF00, 0xFF0000, 0xFF00FF, 0xFFFFFF, 0x808080, 0xC0C0C0, 255, 0x7F7FFF, 204, 0x6666CC, 153, 0x4C4C99, 127, 0x3F3F7F, 76, 2500172, 16383, 0x7F9FFF, 13260, 6717388, 9881, 5005209, 8063, 4149119, 4940, 2502476, Short.MAX_VALUE, 0x7FBFFF, 26316, 0x6699CC, 19609, 5010073, 16255, 4153215, 9804, 2505036, 49151, 0x7FDFFF, 39372, 6730444, 29337, 5014937, 24447, 4157311, 14668, 2507340, 65535, 0x7FFFFF, 52428, 0x66CCCC, 39321, 0x4C9999, 32639, 0x3F7F7F, 19532, 2509900, 65471, 0x7FFFDF, 52377, 6737074, 39282, 5020037, 32607, 4161391, 19513, 2509890, 65407, 0x7FFFBF, 52326, 0x66CC99, 39244, 5020018, 32575, 4161375, 19494, 2509881, 65343, 0x7FFF9F, 52275, 6737023, 39206, 5019999, 32543, 4161359, 19475, 2509871, 65280, 0x7FFF7F, 52224, 0x66CC66, 39168, 0x4C994C, 32512, 0x3F7F3F, 19456, 2509862, 0x3FFF00, 0x9FFF7F, 0x33CC00, 8375398, 2529536, 6265164, 2064128, 5209919, 1264640, 3099686, 0x7FFF00, 0xBFFF7F, 0x66CC00, 0x99CC66, 5019904, 7510348, 4161280, 6258495, 2509824, 3755046, 0xBFFF00, 0xDFFF7F, 0x99CC00, 11717734, 7510272, 8755532, 6258432, 7307071, 3755008, 4344870, 0xFFFF00, 0xFFFF7F, 0xCCCC00, 0xCCCC66, 0x999900, 0x99994C, 0x7F7F00, 0x7F7F3F, 0x4C4C00, 5000230, 0xFFBF00, 0xFFDF7F, 0xCC9900, 13415014, 10056192, 10061132, 8347392, 8351551, 4995328, 4997670, 0xFF7F00, 0xFFBF7F, 0xCC6600, 0xCC9966, 10046464, 10056268, 8339200, 8347455, 4990464, 4995366, 0xFF3F00, 0xFF9F7F, 0xCC3300, 13401958, 10036736, 10051404, 8331008, 8343359, 4985600, 4992806, 0xFF0000, 0xFF7F7F, 0xCC0000, 0xCC6666, 0x990000, 0x994C4C, 0x7F0000, 0x7F3F3F, 0x4C0000, 4990502, 0xFF003F, 0xFF7F9F, 0xCC0033, 13395583, 10027046, 10046559, 8323103, 8339279, 4980755, 4990511, 0xFF007F, 0xFF7FBF, 0xCC0066, 0xCC6699, 10027084, 10046578, 8323135, 8339295, 4980774, 4990521, 0xFF00BF, 0xFF7FDF, 0xCC0099, 13395634, 10027122, 10046597, 8323167, 8339311, 4980793, 4990530, 0xFF00FF, 0xFF7FFF, 0xCC00CC, 0xCC66CC, 0x990099, 0x994C99, 0x7F007F, 0x7F3F7F, 0x4C004C, 4990540, 0xBF00FF, 0xDF7FFF, 0x9900CC, 11691724, 7471257, 8735897, 6226047, 7290751, 3735628, 4335180, 0x7F00FF, 0xBF7FFF, 0x6600CC, 0x9966CC, 4980889, 7490713, 4128895, 6242175, 2490444, 3745356, 0x3F00FF, 0x9F7FFF, 0x3300CC, 8349388, 2490521, 6245529, 2031743, 5193599, 1245260, 3089996, 0x333333, 0x5B5B5B, 0x848484, 0xADADAD, 0xD6D6D6, 0xFFFFFF};
    MLineStyle[] mLineStyles = null;
    private static final int[] DXF_LINE_WEIGHTS = new int[]{0, 5, 9, 13, 15, 18, 20, 25, 30, 35, 40, 50, 53, 60, 70, 80, 90, 100, 106, 120, 140, 158, 200, 211};
    private final DoubleHash<BlockEntry> blocksHash = new DoubleHash();
    private final Scheme s;
    private final SchemeEngine engine;
    private StringBuilder sb = null;
    private final StringBuilder sbHeader = new StringBuilder();
    private final StringBuilder sbProps = new StringBuilder();
    private final StringBuilder sbTablesLType = new StringBuilder();
    private final StringBuilder sbLTypes = new StringBuilder();
    private final StringBuilder sbTablesLayer = new StringBuilder();
    private final StringBuilder sbLayers = new StringBuilder();
    private final StringBuilder sbTablesStyle = new StringBuilder();
    private final StringBuilder sbTablesView = new StringBuilder();
    private final StringBuilder sbTablesDimStyle2000 = new StringBuilder();
    private final StringBuilder sbTablesBlockRecord = new StringBuilder();
    private final StringBuilder sbBlkRecs = new StringBuilder();
    private final StringBuilder sbBlocks = new StringBuilder();
    private final StringBuilder sbPhxBlocks = new StringBuilder();
    private final StringBuilder sbShapes = new StringBuilder();
    private final StringBuilder sbObjectsR2000 = new StringBuilder();
    private final StringBuilder sbMLineStyles = new StringBuilder();
    private final StringBuilder sbEndOfDxf = new StringBuilder();
    private int insertCounter = 0;
    int millimetres = 1;
    int handle = 32;
    String currentLayer = "";
    int layersCount = 0;
    boolean insertMode = false;
    double limMinX = 1.0E20;
    double limMinY = 1.0E20;
    double limMaxX = -1.0E20;
    double limMaxY = -1.0E20;
    private ServerSideHost stateHost;

    public DxfWriter(Scheme scheme) {
        this.s = scheme;
        this.engine = new SchemeEngine(this.s);
        this.engine.InitTmpProps();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToStream(ConnectionManager dbMgr, OutputStream out) throws Exception {
        this.putStateCaption("\u0412\u044b\u043f\u043e\u043b\u043d\u044f\u0435\u0442\u0441\u044f \u044d\u043a\u0441\u043f\u043e\u0440\u0442 \u0441\u0445\u0435\u043c\u044b");
        this.putStateText("\u0421\u0442\u0430\u0442\u0443\u0441: \u043e\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043f\u043e\u0434\u0433\u043e\u0442\u043e\u0432\u043a\u0430 \u043a \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0443 \u0432 DXF-\u0444\u0430\u0439\u043b");
        this.s.parse(dbMgr, true);
        this.s.sortObjects();
        this.putStateText("\u0421\u0442\u0430\u0442\u0443\u0441: \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0438\u0440\u0443\u044e\u0442\u0441\u044f \u0442\u0438\u043f\u044b \u043b\u0438\u043d\u0438\u0439");
        this.writeLTypes();
        this.putStateText("\u0421\u0442\u0430\u0442\u0443\u0441: \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0438\u0440\u0443\u0435\u0442\u0441\u044f \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a \u043c\u0443\u043b\u044c\u0442\u0438\u043b\u0438\u043d\u0438\u0439");
        this.writeMLineStyles();
        this.putStateProgressMax(this.s.SortShapes.size());
        this.putStateText("\u0421\u0442\u0430\u0442\u0443\u0441: \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0438\u0440\u0443\u044e\u0442\u0441\u044f \u0444\u0438\u0433\u0443\u0440\u044b");
        this.writeShapes();
        this.putStateText("\u0421\u0442\u0430\u0442\u0443\u0441: \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0438\u0440\u0443\u044e\u0442\u0441\u044f \u0441\u043b\u043e\u0438");
        this.writeLayers();
        this.putStateText("\u0421\u0442\u0430\u0442\u0443\u0441: \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0438\u0440\u0443\u0435\u0442\u0441\u044f \u0437\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a");
        this.writeHeader();
        this.putStateText("\u0421\u0442\u0430\u0442\u0443\u0441: \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0438\u0440\u0443\u044e\u0442\u0441\u044f \u0441\u0432\u043e\u0439\u0441\u0442\u0432\u0430");
        this.writeProps();
        this.putStateText("\u0421\u0442\u0430\u0442\u0443\u0441: \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0438\u0440\u0443\u0435\u0442\u0441\u044f \u0442\u0430\u0431\u043b\u0438\u0446\u0430 \u0442\u0438\u043f\u043e\u0432 \u043b\u0438\u043d\u0438\u0439");
        this.writeTablesLType();
        this.putStateText("\u0421\u0442\u0430\u0442\u0443\u0441: \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0438\u0440\u0443\u0435\u0442\u0441\u044f \u0442\u0430\u0431\u043b\u0438\u0446\u0430 \u0441\u043b\u043e\u0435\u0432");
        this.writeTablesLayer();
        this.putStateText("\u0421\u0442\u0430\u0442\u0443\u0441: \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0438\u0440\u0443\u0435\u0442\u0441\u044f \u0442\u0430\u0431\u043b\u0438\u0446\u0430 \u0441\u0442\u0438\u043b\u0435\u0439");
        this.writeTablesStyle();
        this.putStateText("\u0421\u0442\u0430\u0442\u0443\u0441: \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0438\u0440\u0443\u0435\u0442\u0441\u044f \u0442\u0430\u0431\u043b\u0438\u0446\u0430 \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u044f");
        this.writeTablesView();
        this.putStateText("\u0421\u0442\u0430\u0442\u0443\u0441: \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0438\u0440\u0443\u0435\u0442\u0441\u044f \u0442\u0430\u0431\u043b\u0438\u0446\u0430 \u0440\u0430\u0437\u043c\u0435\u0440\u043d\u044b\u0445 \u0441\u0442\u0438\u043b\u0435\u0439");
        this.writeTablesDimStyle2000();
        this.putStateText("\u0421\u0442\u0430\u0442\u0443\u0441: \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0438\u0440\u0443\u0435\u0442\u0441\u044f \u0442\u0430\u0431\u043b\u0438\u0446\u0430 \u0437\u0430\u043f\u0438\u0441\u0435\u0439 \u0431\u043b\u043e\u043a\u043e\u0432");
        this.writeTablesBlockRecord();
        this.putStateText("\u0421\u0442\u0430\u0442\u0443\u0441: \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0438\u0440\u0443\u044e\u0442\u0441\u044f \u0431\u043b\u043e\u043a\u0438");
        this.writeBlocks();
        this.putStateText("\u0421\u0442\u0430\u0442\u0443\u0441: \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0438\u0440\u0443\u0435\u0442\u0441\u044f \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u0435 \u0441\u0435\u043a\u0446\u0438\u0438");
        this.writeEndOfDxf();
        this.putStateText("\u0421\u0442\u0430\u0442\u0443\u0441: \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0438\u0440\u0443\u044e\u0442\u0441\u044f \u0441\u043b\u043e\u0432\u0430\u0440\u0438");
        this.writeObjectsR2000();
        try (PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(out, "Cp1251"), true);){
            pw.append(this.sbHeader);
            pw.append(this.sbProps);
            pw.append(this.sbTablesLType);
            pw.append(this.sbLTypes);
            pw.append(this.sbTablesLayer);
            pw.append(this.sbLayers);
            pw.append(this.sbTablesStyle);
            pw.append(this.sbTablesView);
            pw.append(this.sbTablesDimStyle2000);
            pw.append(this.sbTablesBlockRecord);
            pw.append(this.sbBlkRecs);
            pw.append(this.sbBlocks);
            pw.append(this.sbPhxBlocks);
            pw.append(this.sbShapes);
            pw.append(this.sbObjectsR2000);
            pw.append(this.sbMLineStyles);
            pw.append(this.sbEndOfDxf);
        }
        this.putStateProgressPosition(this.s.SortShapes.size());
        this.putStateText("\u0421\u0442\u0430\u0442\u0443\u0441: DXF-\u0444\u0430\u0439\u043b \u0441\u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d");
    }

    private void writeLex(String code, String value) {
        this.sb.append(code).append("\r\n");
        this.sb.append(value).append("\r\n");
    }

    private void writeLex(String code, int value) {
        this.sb.append(code).append("\r\n");
        this.sb.append(value).append("\r\n");
    }

    private void writeLex(String code, double value) {
        this.sb.append(code).append("\r\n");
        this.sb.append(value).append("\r\n");
    }

    private void writeHandle() {
        this.writeLex("  5", Integer.toHexString(this.handle));
        ++this.handle;
    }

    private int nextHandle() {
        return this.handle++;
    }

    private void writeName(String name, String sub, int transparent) {
        this.writeLex("  0", name);
        this.writeHandle();
        if (this.sb == this.sbLTypes || this.sb == this.sbBlkRecs) {
            this.writeLex("100", "AcDbSymbolTableRecord");
        } else {
            this.writeLex("100", "AcDbEntity");
            this.writeLex("  8", this.currentLayer);
            if (transparent > 0) {
                this.writeLex("440", this.getDxfTransparentCode(transparent));
            }
        }
        if (!sub.isEmpty()) {
            this.writeLex("100", sub);
        }
    }

    private void writeHeader() {
        this.sb = this.sbHeader;
        this.writeLex("  0", "SECTION");
        this.writeLex("  2", "HEADER");
    }

    private void writeProps() {
        this.sb = this.sbProps;
        this.writeLex("  9", "$ACADVER");
        this.writeLex("  1", "AC1015");
        this.writeLex("  9", "$DWGCODEPAGE");
        this.writeLex("  3", "ANSI_1251");
        this.writeLex("  9", "$HANDSEED");
        this.writeLex("  5", Integer.toHexString(this.handle + this.layersCount + this.blocksHash.size() + this.insertCounter + 1));
        this.writeLex("  9", "$LIMMIN");
        this.writeLex(" 10", this.limMinX);
        this.writeLex(" 20", this.limMinY);
        this.writeLex("  9", "$LIMMAX");
        this.writeLex(" 10", this.limMaxX);
        this.writeLex(" 20", this.limMaxY);
        this.writeLex("  9", "$MEASUREMENT");
        this.writeLex(" 70", this.millimetres);
    }

    private void writeTablesLType() {
        this.sb = this.sbTablesLType;
        this.writeLex("  0", "ENDSEC");
        this.writeLex("  0", "SECTION");
        this.writeLex("  2", "TABLES");
        this.writeLex("  0", "TABLE");
        this.writeLex("  2", "VPORT");
        this.writeLex("  5", "  1");
        this.writeLex("100", "AcDbSymbolTable");
        this.writeLex("  0", "ENDTAB");
        this.writeLex("  0", "TABLE");
        this.writeLex("  2", "LTYPE");
        this.writeLex("  5", "  2");
        this.writeLex("100", "AcDbSymbolTable");
        this.writeLex("  0", "LTYPE");
        this.writeLex("  5", "  3");
        this.writeLex("100", "AcDbSymbolTableRecord");
        this.writeLex("100", "AcDbLinetypeTableRecord");
        this.writeLex("  2", "BYBLOCK");
        this.writeLex(" 70", "     0");
        this.writeLex("  0", "LTYPE");
        this.writeLex("  5", "  4");
        this.writeLex("100", "AcDbSymbolTableRecord");
        this.writeLex("100", "AcDbLinetypeTableRecord");
        this.writeLex("  2", "BYLAYER");
        this.writeLex(" 70", "     0");
    }

    private void writeTablesLayer() {
        this.sb = this.sbTablesLayer;
        this.writeLex("  0", "ENDTAB");
        this.writeLex("  0", "TABLE");
        this.writeLex("  2", "LAYER");
        this.writeLex("  5", LEX_VALUE_1A);
        this.writeLex("330", "  0");
        this.writeLex("100", "AcDbSymbolTable");
    }

    private void writeTablesStyle() {
        this.sb = this.sbTablesStyle;
        this.writeLex("  0", "ENDTAB");
        this.writeLex("  0", "TABLE");
        this.writeLex("  2", "STYLE");
        this.writeLex("  5", "  5");
        this.writeLex("100", "AcDbSymbolTable");
        this.writeLex("  0", "STYLE");
        this.writeLex("  5", "  6");
        this.writeLex("100", "AcDbSymbolTableRecord");
        this.writeLex("100", "AcDbTextStyleTableRecord");
        this.writeLex("  2", LEX_VALUE_STANDARD);
        this.writeLex(" 70", "     0");
        this.writeLex(" 40", "0.0");
        this.writeLex(" 41", "1.0");
        this.writeLex(" 50", "0.0");
        this.writeLex(" 71", "     0");
        this.writeLex(" 42", "10.0");
        this.writeLex("  3", "txt");
        this.writeLex("  4", "");
    }

    private void writeTablesView() {
        this.sb = this.sbTablesView;
        this.writeLex("  0", "ENDTAB");
        this.writeLex("  0", "TABLE");
        this.writeLex("  2", "VIEW");
        this.writeLex("  5", "  7");
        this.writeLex("100", "AcDbSymbolTable");
        this.writeLex("  0", "ENDTAB");
        this.writeLex("  0", "TABLE");
        this.writeLex("  2", "UCS");
        this.writeLex("  5", "  8");
        this.writeLex("100", "AcDbSymbolTable");
        this.writeLex("  0", "ENDTAB");
        this.writeLex("  0", "TABLE");
        this.writeLex("  2", "APPID");
        this.writeLex("  5", "  9");
        this.writeLex("100", "AcDbSymbolTable");
        this.writeLex("  0", "APPID");
        this.writeLex("  5", "  A");
        this.writeLex("100", "AcDbSymbolTableRecord");
        this.writeLex("100", "AcDbRegAppTableRecord");
        this.writeLex("  2", "ACAD");
        this.writeLex(" 70", "0");
    }

    private void writeTablesDimStyle2000() {
        this.sb = this.sbTablesDimStyle2000;
        this.writeLex("  0", "ENDTAB");
        this.writeLex("  0", "TABLE");
        this.writeLex("  2", "DIMSTYLE");
        this.writeLex("  5", "  B");
        this.writeLex("100", "AcDbSymbolTable");
        this.writeLex(" 70", "     1");
        this.writeLex("100", "AcDbDimStyleTable");
        this.writeLex(" 71", "     0");
        this.writeLex("  0", "DIMSTYLE");
        this.writeLex("105", " 1B");
        this.writeLex("330", "B");
        this.writeLex("100", "AcDbSymbolTableRecord");
        this.writeLex("100", "AcDbDimStyleTableRecord");
        this.writeLex("  2", LEX_VALUE_STANDARD);
        this.writeLex(" 70", "    0");
        this.writeLex("340", "  6");
    }

    private void writeTablesBlockRecord() {
        this.sb = this.sbTablesBlockRecord;
        this.writeLex("  0", "ENDTAB");
        this.writeLex("  0", "TABLE");
        this.writeLex("  2", "BLOCK_RECORD");
        this.writeLex("  5", "  C");
        this.writeLex("100", "AcDbSymbolTable");
        this.writeLex("  0", "BLOCK_RECORD");
        this.writeLex("  5", "  D");
        this.writeLex("100", "AcDbSymbolTableRecord");
        this.writeLex("100", "AcDbBlockTableRecord");
        this.writeLex("  2", "*MODEL_SPACE");
        this.writeLex("  0", "BLOCK_RECORD");
        this.writeLex("  5", "  E");
        this.writeLex("100", "AcDbSymbolTableRecord");
        this.writeLex("100", "AcDbBlockTableRecord");
        this.writeLex("  2", "*PAPER_SPACE");
    }

    private void writeBlocks() {
        this.sb = this.sbBlocks;
        this.writeLex("  0", "ENDTAB");
        this.writeLex("  0", "ENDSEC");
        this.writeLex("  0", "SECTION");
        this.writeLex("  2", "BLOCKS");
        this.writeLex("  0", "BLOCK");
        this.writeLex("  5", "  F");
        this.writeLex("330", "  D");
        this.writeLex("100", "AcDbEntity");
        this.writeLex("  8", "0");
        this.writeLex("100", "AcDbBlockBegin");
        this.writeLex("  2", "*MODEL_SPACE");
        this.writeLex(" 70", "     0");
        this.writeLex("  0", "ENDBLK");
        this.writeLex("  5", " 10");
        this.writeLex("100", "AcDbEntity");
        this.writeLex("  8", "0");
        this.writeLex("100", "AcDbBlockEnd");
        this.writeLex("  0", "BLOCK");
        this.writeLex("  5", " 11");
        this.writeLex("330", "  E");
        this.writeLex("100", "AcDbEntity");
        this.writeLex("  8", "0");
        this.writeLex("100", "AcDbBlockBegin");
        this.writeLex("  2", "*PAPER_SPACE");
        this.writeLex(" 70", "     0");
        this.writeLex("  0", "ENDBLK");
        this.writeLex("  5", " 12");
        this.writeLex("100", "AcDbEntity");
        this.writeLex("  8", "0");
        this.writeLex("100", "AcDbBlockEnd");
    }

    private void writeObjectsR2000() {
        this.sb = this.sbObjectsR2000;
        this.writeLex("  0", "ENDSEC");
        this.writeLex("  0", "SECTION");
        this.writeLex("  2", "OBJECTS");
        this.writeLex("  0", "DICTIONARY");
        this.writeLex("  5", " 13");
        this.writeLex("330", "0");
        this.writeLex("100", "AcDbDictionary");
        this.writeLex("281", "     1");
        this.writeLex("  3", "ACAD_GROUP");
        this.writeLex("350", " 14");
        this.writeLex("  3", "ACAD_MLINESTYLE");
        this.writeLex("350", " 16");
        this.writeLex("  3", "ACAD_PLOTSETTINGS");
        this.writeLex("350", " 17");
        this.writeLex("  3", "ACAD_PLOTSTYLENAME");
        this.writeLex("350", " 18");
        this.writeLex("  0", "DICTIONARY");
        this.writeLex("  5", " 14");
        this.writeLex("330", " 13");
        this.writeLex("100", "AcDbDictionary");
        this.writeLex("281", "     1");
        this.writeLex("  0", "DICTIONARY");
        this.writeLex("  5", " 17");
        this.writeLex("102", "{ACAD_REACTORS");
        this.writeLex("330", " 13");
        this.writeLex("102", "}");
        this.writeLex("330", " 13");
        this.writeLex("100", "AcDbDictionary");
        this.writeLex("281", "     1");
        this.writeLex("  0", "ACDBDICTIONARYWDFLT");
        this.writeLex("  5", " 18");
        this.writeLex("102", "{ACAD_REACTORS");
        this.writeLex("330", " 13");
        this.writeLex("102", "}");
        this.writeLex("330", " 13");
        this.writeLex("100", "AcDbDictionary");
        this.writeLex("281", "     1");
        this.writeLex("  3", "Normal");
        this.writeLex("350", LEX_VALUE_19);
        this.writeLex("100", "AcDbDictionaryWithDefault");
        this.writeLex("340", LEX_VALUE_19);
        this.writeLex("  0", "ACDBPLACEHOLDER");
        this.writeLex("  5", LEX_VALUE_19);
        this.writeLex("102", "{ACAD_REACTORS");
        this.writeLex("330", " 18");
        this.writeLex("102", "}");
        this.writeLex("330", " 18");
    }

    private void writeEndOfDxf() {
        this.sb = this.sbEndOfDxf;
        this.writeLex("  0", "ENDSEC");
        this.writeLex("  0", "EOF");
    }

    private void writeLTypes() {
        this.sb = this.sbLTypes;
        for (int i = 0; i < 12; ++i) {
            int j;
            double[] parts;
            String name = "";
            String cap = "";
            String symb = "";
            switch (i) {
                case 0: {
                    name = SOLID_LINE;
                    parts = new double[]{5.0, 0.0};
                    break;
                }
                case 1: {
                    name = DASH_LINE;
                    parts = new double[]{5.0, -2.0};
                    break;
                }
                case 2: {
                    name = DOT_LINE;
                    parts = new double[]{2.0, -2.0};
                    break;
                }
                case 3: {
                    name = DASHDOT_LINE;
                    parts = new double[]{5.0, -2.0, 2.0, -2.0};
                    break;
                }
                case 4: {
                    name = DASHDOTDOT_LINE;
                    parts = new double[]{5.0, -2.0, 2.0, -2.0, 2.0, -2.0};
                    break;
                }
                case 5: {
                    name = ACADISO06W100_LINE;
                    parts = new double[]{24.0, -3.0, 0.0, -3.0, 0.0, -3.0, 0.0, -3.0};
                    break;
                }
                case 6: {
                    name = LEP_LINE;
                    parts = new double[]{0.4, -0.1, 0.05, 0.0, -0.05, -0.025, -0.1};
                    cap = "\u041b\u042d\u041f supply ---- W ---- W ---- W ----";
                    symb = "W";
                    break;
                }
                case 7: {
                    name = V_PR_LINE;
                    parts = new double[]{0.4, -0.1, 0.05, 0.0, -0.05, -0.025, -0.1};
                    cap = "\u0412\u043e\u0434\u0430 supply ---- \u0412 ---- \u0412 ---- \u0412 ----";
                    symb = "\u0412";
                    break;
                }
                case 8: {
                    name = N_PR_LINE;
                    parts = new double[]{0.4, -0.1, 0.05, 0.0, -0.05, -0.025, -0.1};
                    cap = "\u043d\u0435\u0444\u0442\u044c supply ---- \u041d ---- \u041d ---- \u041d ----";
                    symb = "\u041d";
                    break;
                }
                case 9: {
                    name = P_PR_LINE;
                    parts = new double[]{0.4, -0.1, 0.05, 0.0, -0.05, -0.025, -0.1};
                    cap = "\u041f\u0440\u043e\u0434\u0443\u043a\u0442 supply ---- \u041f ---- \u041f ---- \u041f ----";
                    symb = "\u041f";
                    break;
                }
                case 10: {
                    name = OVR_LINE;
                    parts = new double[]{1.0E-6, -0.3, 0.1, 0.0, -0.3, 0.0, -1.0E-6};
                    cap = "\u041e\u0432\u0440\u0430\u0433\u0438 >>>>>>>>>>>>>>";
                    symb = ">";
                    break;
                }
                case 11: {
                    name = SHT_LINE;
                    parts = new double[]{12.6, -6.3};
                    cap = "\u0428\u0442\u0440\u0438\u0445\u043e\u0432\u0430\u044f __ __ __ __ __ __ __ __ __ __ __ __ _";
                    break;
                }
                default: {
                    parts = new double[]{};
                }
            }
            this.writeName("LTYPE", "AcDbLinetypeTableRecord", 0);
            this.writeLex("  2", name);
            this.writeLex("  3", cap);
            this.writeLex(" 70", "0");
            this.writeLex(" 72", "65");
            if (i > 5) {
                if (i == 11) {
                    this.writeLex(" 73", "2");
                    this.writeLex(" 40", Math.abs(parts[0]) + Math.abs(parts[1]));
                } else {
                    this.writeLex(" 73", "3");
                    this.writeLex(" 40", Math.abs(parts[0]) + Math.abs(parts[1]) + Math.abs(parts[6]));
                }
                this.writeLex(" 49", parts[0]);
                this.writeLex(" 74", "0");
                this.writeLex(" 49", parts[1]);
                if (i == 11) {
                    this.writeLex(" 74", "0");
                    continue;
                }
                this.writeLex(" 74", "2");
                this.writeLex(" 75", "0");
                this.writeLex("340", " 6");
                this.writeLex(" 46", parts[2]);
                this.writeLex(" 50", parts[3]);
                this.writeLex(" 44", parts[4]);
                this.writeLex(" 45", parts[5]);
                this.writeLex("  9", symb);
                this.writeLex(" 49", parts[6]);
                this.writeLex(" 74", "0");
                continue;
            }
            int partsCount = parts.length;
            this.writeLex(" 73", partsCount);
            double total = 0.0;
            for (j = 0; j < partsCount; ++j) {
                total += Math.abs(parts[j]);
            }
            this.writeLex(" 40", total);
            for (j = 0; j < partsCount; ++j) {
                this.writeLex(" 49", parts[j]);
                this.writeLex(" 74", "0");
            }
        }
    }

    private void writeMLineStyles() {
        int i;
        this.sb = this.sbMLineStyles;
        double[] gdElements = new double[]{0.0, -0.1, -0.14, -0.2, -0.3, -0.4, -0.44, -0.5, -0.56, -0.6, -0.7, -0.8, -0.86, -0.9, -1.0};
        double[] gdShifts = new double[]{0.025, 0.02, 0.018, 0.015, 0.01, 0.005, 0.003, 0.0, -0.003, -0.005, -0.01, -0.015, -0.018, -0.02, -0.025};
        this.mLineStyles = new MLineStyle[]{new MLineStyle(AD_1MM_MLINE, "\u0430/\u0434\u043e\u0440\u043e\u0433\u0438 \u0446\u0432\u0435\u0442 13", 2, 13, 1.0, new double[]{0.0, -1.0}), new MLineStyle(OVR_1MM_MLINE, OVR_LINE, 3, 54, 10.0, new double[]{0.0, -1.0, -1.0}), new MLineStyle(GD_1MM_MLINE, "\u0416\u0414 h=1mm", 15, 256, 1.0, gdElements)};
        this.writeLex("  0", "DICTIONARY");
        this.writeLex("  5", " 16");
        this.writeLex("330", " 13");
        this.writeLex("100", "AcDbDictionary");
        this.writeLex("281", "     1");
        for (i = 0; i < 3; ++i) {
            this.writeLex("  3", this.mLineStyles[i].name);
            this.writeLex("350", this.mLineStyles[i].handle);
        }
        for (i = 0; i < 3; ++i) {
            this.writeLex("  0", "MLINESTYLE");
            this.writeLex("  5", this.mLineStyles[i].handle);
            this.writeLex("102", "{ACAD_REACTORS");
            this.writeLex("330", "16");
            this.writeLex("102", "}");
            this.writeLex("330", "16");
            this.writeLex("100", "AcDbMlineStyle");
            this.writeLex("  2", this.mLineStyles[i].name);
            this.writeLex(" 70", "     0");
            this.writeLex("  3", this.mLineStyles[i].desc);
            this.writeLex(" 62", "   256");
            this.writeLex(" 51", "90.0");
            this.writeLex(" 52", "90.0");
            this.writeLex(" 71", this.mLineStyles[i].elementsCount);
            int elementsCount = this.mLineStyles[i].elementsCount;
            for (int j = 0; j < elementsCount; ++j) {
                String lTypeName = CONTINUOUS_LINE;
                double shift = 0.0;
                switch (i) {
                    case 0: {
                        shift = j == 0 ? 0.025 : -0.025;
                        break;
                    }
                    case 1: {
                        if (j == 2) {
                            lTypeName = OVR_LINE;
                        }
                        if (j != 0) break;
                        shift = 0.05;
                        break;
                    }
                    case 2: {
                        if (j > 0 && j < 14) {
                            lTypeName = SHT_LINE;
                        }
                        shift = gdShifts[j];
                    }
                }
                this.writeLex(" 49", shift);
                this.writeLex(" 62", this.mLineStyles[i].color);
                this.writeLex("  6", lTypeName);
            }
        }
    }

    private static boolean checkSpecSymb(String str) {
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (ch != '<' && ch != '>' && ch != '/' && ch != '\\' && ch != '\"' && ch != ':' && ch != ';' && ch != '?' && ch != '*' && ch != '|' && ch != ',' && ch != '=' && ch != '`') continue;
            return true;
        }
        return false;
    }

    private static int colorToDxf(Color c) {
        if (c == null) {
            return 256;
        }
        if (c.equals(Color.WHITE)) {
            return 255;
        }
        if (c.equals(Color.BLACK)) {
            return 7;
        }
        int res = DxfWriter.getNearestDxfColor(c);
        if (res < 0 || res > 256) {
            res = 7;
        }
        return res;
    }

    private static int getNearestDxfColor(Color c) {
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        int idx = 0;
        int dMin = -1;
        int count = DXF_COLORS.length;
        for (int i = 0; i < count; ++i) {
            int c2 = DXF_COLORS[i];
            int r2 = c2 & 0xFF;
            int g2 = c2 >> 8 & 0xFF;
            int b2 = c2 >> 16 & 0xFF;
            int dr = r2 - r;
            int dg = g2 - g;
            int db = b2 - b;
            int d = dr * dr + dg * dg + db * db;
            if (i != 0 && d >= dMin) continue;
            idx = i;
            dMin = d;
        }
        return idx;
    }

    private void writeColor(Color c, boolean negative) {
        int dxfColor = DxfWriter.colorToDxf(c != null ? c : Color.BLACK);
        this.writeLex(" 62", negative ? -dxfColor : dxfColor);
        if (c != null && !c.equals(Color.BLACK) && !c.equals(Color.WHITE)) {
            this.writeLex("420", c.getRGB());
        }
    }

    private static String lineTypeByPattern(int pattern) {
        switch (pattern) {
            case 0: {
                return SOLID_LINE;
            }
            case 1: {
                return DASH_LINE;
            }
            case 2: {
                return DOT_LINE;
            }
            case 3: {
                return DASHDOT_LINE;
            }
            case 4: {
                return DASHDOTDOT_LINE;
            }
            case 5: {
                return "";
            }
        }
        return SOLID_LINE;
    }

    private String lineTypeByPrim(double primId, boolean isLayer) {
        if (primId <= 0.0) {
            return "";
        }
        Primitive prim = this.s.findPrimInLibsById(primId, 0.0);
        if (prim == null) {
            return "";
        }
        String primName = prim.Caption;
        if (!isLayer) {
            if (primName.equalsIgnoreCase(AD_PRIM_NAME)) {
                return AD_1MM_MLINE;
            }
            if (primName.equalsIgnoreCase(OVR_PRIM_NAME)) {
                return OVR_1MM_MLINE;
            }
            if (primName.equalsIgnoreCase(GD_PRIM_NAME)) {
                return GD_1MM_MLINE;
            }
        }
        if (primName.equalsIgnoreCase(LEP_PRIM_NAME)) {
            return LEP_LINE;
        }
        if (primName.equalsIgnoreCase(V_PR_PRIM_NAME)) {
            return V_PR_LINE;
        }
        if (primName.equalsIgnoreCase(N_PR_PRIM_NAME)) {
            return N_PR_LINE;
        }
        if (primName.equalsIgnoreCase(P_PR_PRIM_NAME)) {
            return P_PR_LINE;
        }
        return "";
    }

    private static int specLineDxfColor(String lineType) {
        if (lineType.equalsIgnoreCase(AD_1MM_MLINE)) {
            return 13;
        }
        if (lineType.equalsIgnoreCase(OVR_1MM_MLINE)) {
            return 54;
        }
        if (lineType.equalsIgnoreCase(GD_1MM_MLINE)) {
            return DxfWriter.colorToDxf(Color.BLACK);
        }
        if (lineType.equalsIgnoreCase(LEP_LINE)) {
            return DxfWriter.colorToDxf(Color.BLACK);
        }
        if (lineType.equalsIgnoreCase(V_PR_LINE) || lineType.equalsIgnoreCase(N_PR_LINE) || lineType.equalsIgnoreCase(P_PR_LINE)) {
            return 134;
        }
        return DxfWriter.colorToDxf(Color.BLACK);
    }

    private MLineStyle getMLineStyle(String lineType) {
        if (lineType.equalsIgnoreCase(AD_1MM_MLINE)) {
            return this.mLineStyles[0];
        }
        if (lineType.equalsIgnoreCase(OVR_1MM_MLINE)) {
            return this.mLineStyles[1];
        }
        if (lineType.equalsIgnoreCase(GD_1MM_MLINE)) {
            return this.mLineStyles[2];
        }
        return null;
    }

    private void writeThickness(double lWidth, String lineType) {
        if (!lineType.isEmpty()) {
            this.writeLex("  6", lineType);
        }
        int count = DXF_LINE_WEIGHTS.length;
        double t = Math.round(lWidth * 100.0);
        if (t < (double)DXF_LINE_WEIGHTS[1]) {
            return;
        }
        if (t > (double)DXF_LINE_WEIGHTS[count - 1]) {
            t = DXF_LINE_WEIGHTS[count - 1];
        } else {
            for (int i = 0; i < count; ++i) {
                if (!(t < (double)DXF_LINE_WEIGHTS[i])) continue;
                t = DXF_LINE_WEIGHTS[i - 1];
                break;
            }
        }
        this.writeLex("370", (int)t);
    }

    private void writePoint(double x, double y) {
        this.writeLex(" 10", x);
        this.writeLex(" 20", y);
        if (this.sb != this.sbShapes) {
            return;
        }
        if (this.limMinX > x) {
            this.limMinX = x;
        }
        if (this.limMinY > y) {
            this.limMinY = y;
        }
        if (this.limMaxX < x) {
            this.limMaxX = x;
        }
        if (this.limMaxY < y) {
            this.limMaxY = y;
        }
    }

    private void writeCodePoint(int code, double x, double y) {
        this.writeLex(DxfWriter.getCodeSpace(code) + Integer.toString(code), x);
        this.writeLex(DxfWriter.getCodeSpace(code += 10) + Integer.toString(code), y);
    }

    private static String getCodeSpace(int code) {
        if (code < 10) {
            return "  ";
        }
        if (code < 100) {
            return " ";
        }
        return "";
    }

    private String getLayerName(PhxLayer layer) {
        if (layer == null) {
            return "";
        }
        Object layerName = "";
        if (layer.StringProps != null && layer.StringProps.Caption != null) {
            layerName = layer.StringProps.Caption.trim();
        }
        if (((String)layerName).isEmpty() || ((String)layerName).equalsIgnoreCase("Defpoints") || DxfWriter.checkSpecSymb((String)layerName)) {
            layerName = "Phx_Layer_" + layer.ID;
        }
        return layerName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeLayers() {
        this.sb = this.sbLayers;
        this.writeLex("  0", "LAYER");
        this.writeHandle();
        this.writeLex("330", LEX_VALUE_1A);
        this.writeLex("100", "AcDbSymbolTableRecord");
        this.writeLex("100", "AcDbLayerTableRecord");
        this.writeLex("  2", "0");
        this.writeLex(" 70", 0);
        this.writeColor(Color.BLACK, false);
        this.writeLex("  6", CONTINUOUS_LINE);
        this.writeLex("370", -3);
        this.writeLex("390", LEX_VALUE_19);
        this.layersCount = 1;
        List<SchemeObject> sLayers = this.s.SortLayers;
        int count = sLayers.size();
        for (int i = 0; i < count; ++i) {
            SchemeObject o = sLayers.get(i);
            if (o == null) {
                Core.logger.info("DxfWriter.writeLayers: not found object by index {}. saveToStream(scheme:{}).", (Object)i, (Object)this.s.getSchemeId());
                continue;
            }
            SchemeObject schemeObject = o;
            synchronized (schemeObject) {
                if (o.BG == null) {
                    Core.logger.info("DxfWriter.writeLayers: object {} not parsed. saveToStream(scheme:{}).", (Object)o.getID(), (Object)this.s.getSchemeId());
                    continue;
                }
                assert (o.BG instanceof PhxLayer);
                PhxLayer layer = (PhxLayer)o.BG;
                if (!layer.Exportable) {
                    continue;
                }
                this.writeLex("  0", "LAYER");
                this.writeHandle();
                this.writeLex("330", LEX_VALUE_1A);
                this.writeLex("100", "AcDbSymbolTableRecord");
                this.writeLex("100", "AcDbLayerTableRecord");
                this.writeLex("  2", this.getLayerName(layer));
                if (layer.Selectable) {
                    this.writeLex(" 70", 0);
                } else {
                    this.writeLex(" 70", 4);
                }
                if (!layer.Visible) {
                    this.writeLex(" 60", 1);
                }
                this.writeColor(layer.pColor, !layer.Visible);
                String lineType = "";
                if (layer.PrimID > 0.0) {
                    lineType = this.lineTypeByPrim(layer.PrimID, true);
                }
                if (lineType.isEmpty()) {
                    lineType = DxfWriter.lineTypeByPattern(layer.PenPattern);
                }
                if (lineType.isEmpty()) {
                    lineType = DxfWriter.lineTypeByPattern(0);
                }
                this.writeLex("  6", lineType);
                this.writeLex("370", Math.round(layer.lWidth));
                this.writeLex("390", LEX_VALUE_19);
                ++this.layersCount;
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeShapes() throws Exception {
        this.sb = this.sbShapes;
        this.writeLex("  0", "ENDSEC");
        this.writeLex("  0", "SECTION");
        this.writeLex("  2", "ENTITIES");
        if (this.s.exportPageId == Scheme.INVISIBLE_PAGE_ID) {
            return;
        }
        List<SchemeObject> sShapes = this.s.SortShapes;
        int shapesCount = sShapes.size();
        SchemePage currentPage = null;
        if (!this.s.Pages.empty()) {
            currentPage = this.s.getPageById(this.s.exportPageId, true);
        }
        RealPoint offset = new RealPoint(0.0, 0.0);
        for (int i = 0; i < shapesCount; ++i) {
            SchemeObject o = sShapes.get(i);
            if (o == null) {
                Core.logger.info("DxfWriter.writeShapes: not found object by index {}. saveToStream(scheme:{}).", (Object)i, (Object)this.s.getSchemeId());
                continue;
            }
            SchemeObject schemeObject = o;
            synchronized (schemeObject) {
                BaseGraphic bg = o.BG;
                if (bg == null) {
                    Core.logger.info("DxfWriter.writeShapes: object {} not parsed. saveToStream(scheme:{}).", (Object)o.getID(), (Object)this.s.getSchemeId());
                    continue;
                }
                if (this.engine.tmpLayer == null || this.engine.tmpLayer.ID != bg.LayerID) {
                    this.engine.setTmpLayer(bg.LayerID);
                    this.currentLayer = this.getLayerName(this.engine.tmpLayer);
                }
                if (this.engine.tmpLayer == null || !this.engine.tmpLayer.Exportable) {
                    continue;
                }
                if (currentPage == null || currentPage.getNormalizeId() == this.engine.tmpLayer.PageId) {
                    this.writeShape(bg, offset);
                    this.putStateProgressPosition(i);
                }
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeShape(BaseGraphic bg, RealPoint offset) {
        if (bg.Hidden) {
            return;
        }
        AffineTransform OldGTM = new AffineTransform();
        OldGTM.setTransform(this.engine.GTM);
        double oldAngle = this.engine.tmpAngle;
        if (bg.TransProps != null && bg.TransProps.Angle != 0.0) {
            this.engine.tmpAngle += bg.TransProps.Angle;
        }
        if (bg.ParentGB != null && bg.TransProps != null && !SchemeObjectsTypes.ObjTypeIsText(bg.shapeType())) {
            boolean inInsert;
            boolean bl = inInsert = bg.ParentGB.ParentGB != null && bg.ParentGB.ParentGB.shapeType() == 207;
            if (inInsert || bg.ParentGB.ParentGB == null) {
                double parentScaleX = 1.0;
                double parentScaleY = 1.0;
                double a = bg.TransProps.Angle;
                if (Math.abs(a - 90.0 * (double)((int)(a / 90.0))) <= 0.5) {
                    boolean vert;
                    BaseGraphic parent = inInsert ? bg.ParentGB.ParentGB : bg.ParentGB;
                    boolean bl2 = vert = Math.abs(a - 180.0 * (double)((int)(a / 180.0))) > 0.5;
                    if (!vert) {
                        if (bg.FixScaleX && parent.TransProps != null) {
                            parentScaleX = parent.TransProps.ScaleX;
                        }
                        if (bg.FixScaleY && parent.TransProps != null) {
                            parentScaleY = parent.TransProps.ScaleY;
                        }
                    } else {
                        if (bg.FixScaleX && parent.TransProps != null) {
                            parentScaleY = parent.TransProps.ScaleX;
                        }
                        if (bg.FixScaleY && parent.TransProps != null) {
                            parentScaleX = parent.TransProps.ScaleY;
                        }
                    }
                    bg.TransProps.ScaleX /= parentScaleX;
                    bg.TransProps.ScaleY /= parentScaleY;
                }
            }
        }
        try {
            this.engine.GTM.concatenate(SchemeEngine.GenTransform(bg));
            if (bg instanceof PhxGraphicInsert) {
                PhxGraphicInsert insert = (PhxGraphicInsert)bg;
                int attCount = insert.Attributes == null ? 0 : insert.Attributes.size();
                boolean attNotConstant = false;
                for (int i = 0; i < attCount; ++i) {
                    AttributeRef att = (AttributeRef)insert.Attributes.get(i);
                    if (att == null || att.constant() || att.Lines == null || att.Lines.isEmpty()) continue;
                    attNotConstant = true;
                    break;
                }
                if (attNotConstant) {
                    this.writeInsertAsBlock((PhxGraphicInsert)bg, offset);
                } else {
                    this.writeInsert((PhxGraphicInsert)bg, offset);
                }
            } else if (bg instanceof GraphicBlock) {
                this.writeBlock((GraphicBlock)bg, offset);
            } else if (bg instanceof Polygon) {
                this.writePolygon((Polygon)bg, offset);
            } else if (bg instanceof Region) {
                this.writeRegion((Region)bg, offset);
            } else if (bg instanceof Spline) {
                this.writeSpline((Spline)bg, offset);
            } else if (bg instanceof Polyline) {
                this.writePolyline((Polyline)bg, offset);
            } else if (bg instanceof Pie) {
                this.writePie((Pie)bg, offset);
            } else if (bg instanceof Ellipse) {
                this.writeEllipse((Ellipse)bg, null, offset);
            } else if (bg instanceof AttributeDef) {
                this.writeAttributeDefAsParagraph((AttributeDef)bg, offset);
            } else if (bg instanceof Paragraph) {
                this.writeParagraph((Paragraph)bg, offset);
            } else if (bg instanceof Image) {
                this.writeImage((Image)bg, offset);
            } else if (bg instanceof Rectangle) {
                this.writeRectangle((Rectangle)bg, false, offset);
            }
            if (bg.emText()) {
                this.writeShape(bg.EmbeddedText, offset);
            }
        }
        finally {
            this.engine.GTM.setTransform(OldGTM);
            this.engine.tmpAngle = oldAngle;
        }
    }

    private void writePolyline(Polyline bg, RealPoint offset) {
        MLineStyle mLineStyle;
        String lineType;
        int pCount;
        int n = pCount = bg.Points != null ? bg.Points.length / 2 : 0;
        if (pCount < 2) {
            return;
        }
        int pPattern = !this.insertMode || bg.PenPattern != -1 ? bg.PenPattern : 0;
        double primId = !this.insertMode ? this.engine.getActualPrimID(pPattern, bg.PrimID) : 0.0;
        String specLineType = primId > 0.0 ? this.lineTypeByPrim(primId, false) : "";
        boolean isSpec = !specLineType.isEmpty();
        String string = lineType = isSpec ? specLineType : DxfWriter.lineTypeByPattern(this.engine.getActualPenPattern(pPattern));
        if (lineType.isEmpty()) {
            return;
        }
        int specLineColor = isSpec ? DxfWriter.specLineDxfColor(specLineType) : -1;
        double[] pts = this.engine.MulPoints(bg.Points);
        MLineStyle mLineStyle2 = mLineStyle = isSpec ? this.getMLineStyle(specLineType) : null;
        if (!isSpec || mLineStyle == null) {
            Color pColor = this.engine.getActualPColor(bg.pColor);
            double lWidth = this.engine.getActualLWidth(bg.lWidth);
            int[] pointsCounts = bg.PointsCounts;
            if (pointsCounts != null && pointsCounts.length > 0 && this.containsZero(pointsCounts)) {
                double[] arr = bg.PointsWithJump;
                int bias = 0;
                for (int pointsCount : pointsCounts) {
                    if (pointsCount == 0) continue;
                    pCount = pointsCount;
                    pts = new double[pCount * 2];
                    System.arraycopy(arr, bias, pts, 0, pCount * 2);
                    this.writePoly(bg, pts, 0, pCount, 0, lineType, lWidth, pColor, specLineColor, offset);
                    bias += pCount * 2;
                }
            } else {
                if (bg.PointsWithJump != null) {
                    pCount = bg.PointsWithJump.length / 2;
                    pts = bg.PointsWithJump;
                }
                this.writePoly(bg, pts, 0, pCount, 0, lineType, lWidth, pColor, specLineColor, offset);
            }
        } else {
            this.writeLex("  0", "MLINE");
            this.writeHandle();
            this.writeLex("100", "AcDbEntity");
            this.writeLex("  8", this.currentLayer);
            this.writeLex(" 48", mLineStyle.scaleFactor);
            this.writeLex("100", "AcDbMline");
            this.writeLex("  2", lineType);
            this.writeLex("340", mLineStyle.handle);
            this.writeLex(" 40", 20);
            this.writeLex(" 70", 0);
            this.writeLex(" 71", 1);
            this.writeLex(" 72", pCount);
            int elementsCount = mLineStyle.elementsCount;
            this.writeLex(" 73", elementsCount);
            double x = pts[0] + offset.x;
            double y = -pts[1] - offset.y;
            this.writePoint(x, y);
            this.writeCodePoint(210, 0.0, 0.0);
            RealPoint dir = new RealPoint(0.0, 0.0);
            RealPoint prevDir = new RealPoint(0.0, 0.0);
            RealPoint miter = new RealPoint(0.0, 0.0);
            for (int i = 0; i < pCount; ++i) {
                int idx = 2 * i;
                x = pts[idx] + offset.x;
                y = -pts[idx + 1] - offset.y;
                this.writeCodePoint(11, x, y);
                if (i < pCount - 1) {
                    double x2 = pts[idx + 2] + offset.x;
                    double y2 = -pts[idx + 3] - offset.y;
                    if (!DxfWriter.getDirVector(x, y, x2, y2, dir) && i > 0) {
                        dir.assign(prevDir);
                    }
                    if (i > 0) {
                        DxfWriter.getMiterVector(prevDir, dir, miter);
                    }
                } else {
                    dir.assign(prevDir);
                }
                if (i == 0 || i == pCount - 1) {
                    miter.x = -dir.y;
                    miter.y = dir.x;
                }
                prevDir.assign(dir);
                this.writeCodePoint(12, dir.x, dir.y);
                this.writeCodePoint(13, miter.x, miter.y);
                for (int j = 0; j < elementsCount; ++j) {
                    this.writeLex(" 74", 2);
                    this.writeLex(" 41", DxfWriter.getParam41(mLineStyle.elements[j], dir, miter));
                    this.writeLex(" 41", 0);
                    this.writeLex(" 75", 0);
                }
            }
        }
    }

    private boolean containsZero(int[] arr) {
        return IntStream.of(arr).anyMatch(x -> x == 0);
    }

    private void writePoly(BaseShape shape, double[] pts, int index, int count, int flags, String lineType, double lWidth, Color color, int specColor, RealPoint offset) {
        this.writeName("LWPOLYLINE", "AcDbPolyline", shape.TransparentBorder);
        if (specColor >= 0) {
            this.writeLex(" 62", specColor);
        } else {
            this.writeColor(color, false);
        }
        this.writeThickness(lWidth, lineType);
        if (specColor >= 0) {
            this.writeLex(" 48", 25);
        }
        this.writeLex(" 90", count);
        this.writeLex(" 70", flags);
        if (lWidth != 0.0) {
            this.writeLex(" 43", lWidth);
        }
        if (shape instanceof Polyline) {
            Polyline poly = (Polyline)shape;
            int[] pointsCounts = poly.PointsCounts;
            if (pointsCounts != null && pointsCounts.length > 0 && !this.containsZero(pointsCounts)) {
                int arrayOffset = 0;
                double[] pointsWithJump = poly.PointsWithJump;
                BaseGraphic.RealPoint rpLast = new BaseGraphic.RealPoint();
                for (int i = 0; i < pointsCounts.length; ++i) {
                    int pointCount = pointsCounts[i];
                    double[] segmentPoints = this.extractSegmentPoints(pointsWithJump, arrayOffset, pointCount);
                    if (i % 2 == 0) {
                        for (int j = 0; j < segmentPoints.length; j += 2) {
                            double x = segmentPoints[j] + offset.x;
                            double y = -segmentPoints[j + 1] - offset.y;
                            this.writePoint(x, y);
                        }
                    } else {
                        boolean needReverse = DxfWriter.f2d(segmentPoints[0]) != DxfWriter.f2d(rpLast.X) || DxfWriter.f2d(segmentPoints[1]) != DxfWriter.f2d(rpLast.Y);
                        this.appendArcSegment(segmentPoints, needReverse);
                    }
                    arrayOffset += pointCount * 2;
                    int length = segmentPoints.length;
                    rpLast.X = segmentPoints[length - 2];
                    rpLast.Y = segmentPoints[length - 1];
                }
                return;
            }
        }
        for (int i = 0; i < count; ++i) {
            int idx = 2 * (index + i);
            double x = pts[idx] + offset.x;
            double y = -pts[idx + 1] - offset.y;
            this.writePoint(x, y);
        }
    }

    private void appendArcSegment(double[] segmentPoints, boolean needReverse) {
        int count = segmentPoints.length;
        double beginX = needReverse ? segmentPoints[count - 2] : segmentPoints[0];
        double beginY = needReverse ? segmentPoints[count - 1] : segmentPoints[1];
        double endX = needReverse ? segmentPoints[0] : segmentPoints[count - 2];
        double endY = needReverse ? segmentPoints[1] : segmentPoints[count - 1];
        BaseGraphic.RealPoint rpBegin = new BaseGraphic.RealPoint(beginX, beginY);
        BaseGraphic.RealPoint rpEnd = new BaseGraphic.RealPoint(endX, endY);
        double angle = SchemeUtils.lineToAngle(rpBegin, rpEnd) - 90.0;
        boolean rotateCondition = angle > 90.0 && angle <= 180.0 || angle <= -90.0 && angle > -180.0;
        this.writeLex(" 42", rotateCondition ? 1 : -1);
    }

    private static double f2d(double value) {
        return NumberConverter.simpleRoundTo(value, -2);
    }

    private double[] extractSegmentPoints(double[] sourceArray, int offset, int pointCount) {
        double[] segmentPoints = new double[pointCount * 2];
        System.arraycopy(sourceArray, offset, segmentPoints, 0, pointCount * 2);
        return segmentPoints;
    }

    private static boolean getDirVector(double x1, double y1, double x2, double y2, RealPoint dir) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        double len = Math.sqrt(dx * dx + dy * dy);
        if (len > 1.0E-12) {
            dir.x = dx / len;
            dir.y = dy / len;
            return true;
        }
        dir.x = 1.0;
        dir.y = 0.0;
        return false;
    }

    private static void getMiterVector(RealPoint pt1, RealPoint pt2, RealPoint miter) {
        double miterX1 = -pt1.y;
        double miterX2 = -pt2.y;
        double dx = miterX1 + miterX2;
        double miterY1 = pt1.x;
        double miterY2 = pt2.x;
        double dy = miterY1 + miterY2;
        double len = Math.sqrt(dx * dx + dy * dy);
        boolean bool = len > 1.0E-12;
        miter.x = bool ? dx / len : miterX1;
        miter.y = bool ? dy / len : miterY1;
    }

    private static double getParam41(double s, RealPoint dir, RealPoint miter) {
        if (Math.abs(s) <= 1.0E-12) {
            return s;
        }
        double dx = dir.x - miter.x;
        double dy = dir.y - miter.y;
        double a = dx * dx + dy * dy;
        double del = a - a * a / 4.0;
        if (del <= 1.0E-12) {
            return s;
        }
        return s / Math.sqrt(del);
    }

    private void writeSpline(Spline bg, RealPoint offset) {
        int pCount;
        int n = pCount = bg.Points != null ? bg.Points.length / 2 : 0;
        if (pCount < 2) {
            return;
        }
        int pPattern = bg.PenPattern;
        String lineType = DxfWriter.lineTypeByPattern(this.engine.getActualPenPattern(pPattern));
        if (lineType.isEmpty()) {
            return;
        }
        double[] pts = this.engine.MulPoints(bg.Points);
        Color pColor = this.engine.getActualPColor(bg.pColor);
        double lWidth = this.engine.getActualLWidth(bg.lWidth);
        this.writeCurve(pts, 0, pCount, lineType, lWidth, pColor, offset, bg.TransparentBorder, false);
    }

    private void writeCurve(double[] pts, int index, int count, String lineType, double lWidth, Color color, RealPoint offset, int transparent, boolean closedCurve) {
        if ((count - 4) % 3 != 0) {
            return;
        }
        int cpCount = count - 1 + count / 3;
        this.writeName("SPLINE", "AcDbSpline", transparent);
        this.writeColor(color, false);
        this.writeThickness(lWidth, lineType);
        this.writeCodePoint(210, 0.0, 0.0);
        this.writeLex(" 70", closedCurve ? 9 : 8);
        this.writeLex(" 71", 3);
        this.writeLex(" 72", cpCount + 4);
        this.writeLex(" 73", cpCount);
        this.writeLex(" 74", 0);
        this.writeLex(" 42", 1.0E-7);
        this.writeLex(" 43", 1.0E-7);
        this.writeCurveKnots(pts, index, count, cpCount, offset);
    }

    private void writeCurveKnots(double[] pts, int index, int count, int cpCount, RealPoint offset) {
        int j;
        double vInc = 1.0 / (double)cpCount;
        double vKnot = 0.0;
        for (int k = 0; k < cpCount; k += 4) {
            for (j = 0; j < 4; ++j) {
                this.writeLex(" 40", vKnot);
            }
            vKnot += vInc;
        }
        vKnot = 1.0;
        for (j = 0; j < 4; ++j) {
            this.writeLex(" 40", vKnot);
        }
        for (int i = 0; i < count; ++i) {
            int idx = 2 * (index + i);
            double x = pts[idx] + offset.x;
            double y = -pts[idx + 1] - offset.y;
            this.writePoint(x, y);
            if (i % 3 != 0 || i == 0 || i == count - 1) continue;
            this.writePoint(x, y);
        }
    }

    private void writePolygon(Polygon bg, RealPoint offset) {
        this.writeAsPolygon(bg, bg.Points, bg.Counts, false, offset);
    }

    private void writeAsPolygon(BaseShape bg, double[] points, int[] counts, boolean onlyLine, RealPoint offset) {
        boolean isPen;
        int pPattern;
        int pCount;
        int n = pCount = points != null ? points.length / 2 : 0;
        if (pCount < 2) {
            return;
        }
        ASMOHatchType hatchType = null;
        if (!onlyLine && this.engine.isNeedFill(bg.BrushPattern) && (hatchType = ASMOHatchType.hatchTypeById(bg.BrushPattern)) == null) {
            hatchType = ASMOHatchType.Solid;
        }
        String lineType = (pPattern = this.engine.getActualPenPattern(bg.PenPattern)) != 5 ? DxfWriter.lineTypeByPattern(pPattern) : "";
        boolean bl = isPen = !lineType.isEmpty();
        if (hatchType == null && !isPen) {
            return;
        }
        Color bColor = this.engine.getActualBColor(bg.bColor);
        double[] pts = this.engine.MulPoints(points);
        if (hatchType != null) {
            this.writeHatch(HatchBoundType.Polyline, pts, counts, bColor, 0.0, offset, bg.Transparent, hatchType, Math.max(Math.abs(bg.Right - bg.Left), Math.abs(bg.Bottom - bg.Top)));
        }
        if (isPen) {
            Color pColor = this.engine.getActualPColor(bg.pColor);
            double lWidth = this.engine.getActualLWidth(bg.lWidth);
            if (hatchType == ASMOHatchType.Solid && pColor.equals(bColor) && lWidth == 0.0) {
                return;
            }
            int sectCount = counts != null ? counts.length : 1;
            int vCount = pCount;
            int counter = 0;
            for (int i = 0; i < sectCount; ++i) {
                if (sectCount > 1) {
                    vCount = counter + counts[i] <= pCount ? counts[i] : pCount - counter;
                }
                this.writePoly(bg, pts, counter, vCount, 1, lineType, lWidth, pColor, -1, offset);
                counter += vCount;
            }
        }
    }

    private void writeHatch(HatchBoundType boundType, double[] pts, int[] counts, Color color, double ratio, RealPoint offset, int transparent, ASMOHatchType hatchType, double maxRectDim) {
        int pCount = pts.length / 2;
        if (pCount < 2) {
            return;
        }
        boolean isPatternFill = hatchType.isPatternFill();
        this.writeName("HATCH", "AcDbHatch", transparent);
        this.writeColor(color, false);
        this.writeLex(" 10", 0);
        this.writeLex(" 20", 0);
        this.writeLex(" 30", 0);
        this.writeLex("210", 0);
        this.writeLex("220", 0);
        this.writeLex("230", 1);
        this.writeLex("  2", hatchType.toString());
        this.writeLex(" 70", isPatternFill ? 0 : 1);
        this.writeLex(" 71", 1);
        if (boundType == HatchBoundType.Ellipse) {
            this.writeLex(" 91", 1);
            this.writeLex(" 92", 1);
            this.writeLex(" 93", 1);
            this.writeLex(" 72", 3);
            this.writeCodePoint(10, pts[0], pts[1]);
            this.writeCodePoint(11, pts[2], pts[3]);
            this.writeLex(" 40", ratio);
            this.writeLex(" 50", 0);
            this.writeLex(" 51", 360);
            this.writeLex(" 73", 1);
            this.writeLex(" 97", 0);
        } else {
            int sectCount = counts != null ? counts.length : 1;
            this.writeLex(" 91", sectCount);
            int vCount = pCount;
            int counter = 0;
            switch (boundType) {
                case Polyline: {
                    for (int i = 0; i < sectCount; ++i) {
                        if (sectCount > 1) {
                            vCount = counter + counts[i] <= pCount ? counts[i] : pCount - counter;
                        }
                        this.writeLex(" 92", 1);
                        this.writeLex(" 93", vCount);
                        for (int j = 0; j < vCount; ++j) {
                            this.writeLex(" 72", 1);
                            int idx = 2 * (counter + j);
                            double x = pts[idx] + offset.x;
                            double y = -pts[idx + 1] - offset.y;
                            this.writeCodePoint(10, x, y);
                            idx = j < vCount - 1 ? idx + 2 : 2 * counter;
                            x = pts[idx] + offset.x;
                            y = -pts[idx + 1] - offset.y;
                            this.writeCodePoint(11, x, y);
                        }
                        this.writeLex(" 97", 0);
                        counter += vCount;
                    }
                    break;
                }
                case Curve: {
                    for (int i = 0; i < sectCount; ++i) {
                        if (sectCount > 1) {
                            int n = vCount = counter + counts[i] <= pCount ? counts[i] : pCount - counter;
                        }
                        if ((vCount - 4) % 3 != 0) continue;
                        int cpCount = vCount - 1 + vCount / 3;
                        this.writeLex(" 92", 1);
                        this.writeLex(" 93", 1);
                        this.writeLex(" 72", 4);
                        this.writeLex(" 94", 3);
                        this.writeLex(" 73", 0);
                        this.writeLex(" 74", 0);
                        this.writeLex(" 95", cpCount + 4);
                        this.writeLex(" 96", cpCount);
                        this.writeCurveKnots(pts, counter, vCount, cpCount, offset);
                        this.writeLex(" 97", 0);
                        counter += vCount;
                    }
                    break;
                }
            }
        }
        this.writeLex(" 75", 0);
        this.writeLex(" 76", 1);
        if (isPatternFill) {
            double rectDim = Double.compare(maxRectDim, 0.0) == 0 ? 1.0 : maxRectDim;
            this.writeLex(" 52", hatchType.hatchAngle);
            this.writeLex(" 41", rectDim * (double)hatchType.targetPatternScale);
            this.writeLex(" 77", 0);
            this.writeLex(" 78", 1);
            this.writeLex(" 53", hatchType.patternAngle);
            this.writeLex(" 43", 0.0);
            this.writeLex(" 44", 0.0);
            this.writeLex(" 45", rectDim * (double)hatchType.patternLineOffsetX);
            this.writeLex(" 46", rectDim * (double)hatchType.patternLineOffsetY);
            this.writeLex(" 79", 0);
        }
        this.writeLex(" 98", 0);
    }

    private void writeRegion(Region bg, RealPoint offset) {
        boolean isPen;
        int pPattern;
        int pCount;
        int n = pCount = bg.Points != null ? bg.Points.length / 2 : 0;
        if (pCount < 2) {
            return;
        }
        ASMOHatchType hatchType = null;
        if (this.engine.isNeedFill(bg.BrushPattern) && (hatchType = ASMOHatchType.hatchTypeById(bg.BrushPattern)) == null) {
            hatchType = ASMOHatchType.Solid;
        }
        String lineType = (pPattern = this.engine.getActualPenPattern(bg.PenPattern)) != 5 ? DxfWriter.lineTypeByPattern(pPattern) : "";
        boolean bl = isPen = !lineType.isEmpty();
        if (hatchType == null && !isPen) {
            return;
        }
        Color bColor = this.engine.getActualBColor(bg.bColor);
        double[] pts = this.engine.MulPoints(bg.Points);
        if (hatchType != null) {
            this.writeHatch(HatchBoundType.Curve, pts, bg.Counts, bColor, 2.0, offset, bg.Transparent, hatchType, Math.max(Math.abs(bg.Right - bg.Left), Math.abs(bg.Bottom - bg.Top)));
        }
        if (isPen) {
            Color pColor = this.engine.getActualPColor(bg.pColor);
            double lWidth = this.engine.getActualLWidth(bg.lWidth);
            if (hatchType == ASMOHatchType.Solid && pColor.equals(bColor) && lWidth == 0.0) {
                return;
            }
            int sectCount = bg.Counts != null ? bg.Counts.length : 1;
            int vCount = pCount;
            int counter = 0;
            for (int i = 0; i < sectCount; ++i) {
                if (sectCount > 1) {
                    vCount = counter + bg.Counts[i] <= pCount ? bg.Counts[i] : pCount - counter;
                }
                this.writeCurve(pts, counter, vCount, lineType, lWidth, pColor, offset, bg.TransparentBorder, true);
                counter += vCount;
            }
        }
    }

    private void writeRectangle(Rectangle bg, boolean onlyLine, RealPoint offset) {
        this.writeAsPolygon(bg, bg.getRectPoints(), null, onlyLine, offset);
    }

    private void writeImage(Image bg, RealPoint offset) {
        this.writeRectangle(bg, false, offset);
    }

    private void writeEllipse(Ellipse bg, RealPoint pieAngle, RealPoint offset) {
        boolean isPen;
        int pPattern;
        double sideX = Math.abs(bg.SideX);
        double sideY = Math.abs(bg.SideY);
        double halfW = 0.5 * sideX;
        double halfH = 0.5 * sideY;
        double[] points = new double[]{0.0, 0.0, halfW, 0.0, 0.0, halfH, halfW * Math.cos(0.7853981633974483), halfH * Math.sin(0.7853981633974483)};
        double[] pts = this.engine.MulPoints(points);
        double x0 = pts[0];
        double y0 = pts[1];
        for (int i = 1; i < 4; ++i) {
            int n = 2 * i;
            pts[n] = pts[n] - x0;
            int n2 = 2 * i + 1;
            pts[n2] = pts[n2] - y0;
        }
        RealPoint axis = new RealPoint(0.0, 0.0);
        double radiusRatio = 1.0E-6;
        if (SchemeEngine.checkEllipseOnLine(pts[2], pts[3], pts[4], pts[5], pts[6], pts[7])) {
            points = SchemeEngine.SidesToEllipse(sideX, sideY, bg.Slices);
            pts = this.engine.MulPoints(points);
            int count = pts.length / 2;
            double dMax = 0.0;
            int idx = 0;
            for (int i = 0; i < count; ++i) {
                double dx = pts[2 * i] - x0;
                double dy = pts[2 * i + 1] - y0;
                double d = dx * dx + dy * dy;
                if (!(dMax < d)) continue;
                dMax = d;
                idx = i;
            }
            axis = new RealPoint(pts[2 * idx] - x0, pts[2 * idx + 1] - y0);
        } else {
            radiusRatio = DxfWriter.calcEllipse(new RealPoint(pts[2], pts[3]), new RealPoint(pts[4], pts[5]), new RealPoint(pts[6], pts[7]), axis);
        }
        if (Math.sqrt(axis.x * axis.x + axis.y * axis.y) < 1.0E-6) {
            axis = new RealPoint(1.0E-6, 0.0);
        }
        ASMOHatchType hatchType = null;
        if (pieAngle == null && this.engine.isNeedFill(bg.BrushPattern) && (hatchType = ASMOHatchType.hatchTypeById(bg.BrushPattern)) == null) {
            hatchType = ASMOHatchType.Solid;
        }
        String lineType = (pPattern = this.engine.getActualPenPattern(bg.PenPattern)) != 5 ? DxfWriter.lineTypeByPattern(pPattern) : "";
        boolean bl = isPen = !lineType.isEmpty();
        if (hatchType == null && !isPen) {
            return;
        }
        Color bColor = null;
        if (hatchType != null) {
            bColor = this.engine.getActualBColor(bg.bColor);
            double[] axisPts = new double[]{x0 + offset.x, -y0 - offset.y, axis.x + offset.x, -axis.y - offset.y};
            this.writeHatch(HatchBoundType.Ellipse, axisPts, null, bColor, radiusRatio, offset, bg.Transparent, hatchType, Math.max(Math.abs(bg.Right - bg.Left), Math.abs(bg.Bottom - bg.Top)));
        }
        if (isPen) {
            Color pColor = this.engine.getActualPColor(bg.pColor);
            double lWidth = this.engine.getActualLWidth(bg.lWidth);
            if (hatchType == ASMOHatchType.Solid && pColor.equals(bColor) && lWidth == 0.0) {
                return;
            }
            this.writeName("ELLIPSE", "AcDbEllipse", bg.TransparentBorder);
            this.writeColor(pColor, false);
            this.writeThickness(lWidth, lineType);
            double x = x0 + offset.x;
            double y = -y0 - offset.y;
            this.writeCodePoint(10, x, y);
            this.writeCodePoint(11, axis.x, -axis.y);
            this.writeLex(" 40", radiusRatio);
            if (pieAngle != null && Math.abs(pieAngle.x - pieAngle.y) > 1.0E-6) {
                this.writeLex(" 41", Math.PI * 2 - pieAngle.x);
                this.writeLex(" 42", Math.PI * 2 - pieAngle.y);
            }
        }
    }

    public static double calcEllipse(RealPoint p1, RealPoint p2, RealPoint p3, RealPoint axis) {
        double x1 = 0.0;
        double y1 = 0.0;
        double x2 = 0.0;
        double y2 = 0.0;
        double x3 = 0.0;
        double y3 = 0.0;
        double a = 0.0;
        double x11 = 0.0;
        double x22 = 0.0;
        double x1y2 = 0.0;
        double x2y1 = 0.0;
        double x1y3 = 0.0;
        double x3y1 = 0.0;
        for (int i = 0; i < 4; ++i) {
            switch (i) {
                case 0: {
                    x1 = p1.x;
                    y1 = p1.y;
                    x2 = p2.x;
                    y2 = p2.y;
                    x3 = p3.x;
                    y3 = p3.y;
                    break;
                }
                case 1: {
                    x1 = p2.x;
                    y1 = p2.y;
                    x2 = p1.x;
                    y2 = p1.y;
                    x3 = p3.x;
                    y3 = p3.y;
                    break;
                }
                case 2: {
                    x1 = p3.x;
                    y1 = p3.y;
                    x2 = p2.x;
                    y2 = p2.y;
                    x3 = p1.x;
                    y3 = p1.y;
                    break;
                }
                case 3: {
                    x1 = p1.x;
                    y1 = p1.y;
                    x2 = p3.x;
                    y2 = p3.y;
                    x3 = p2.x;
                    y3 = p2.y;
                }
            }
            x11 = x1 * x1;
            x22 = x2 * x2;
            x1y2 = x1 * y2;
            x2y1 = x2 * y1;
            x1y3 = x1 * y3;
            x3y1 = x3 * y1;
            a = 2.0 * x1 * (x2 * (x3 * x3 - x11) * (x1y2 - x2y1) + x3 * (x22 - x11) * (x3y1 - x1y3));
            if (Math.abs(a) > 1.0E-12) break;
        }
        if (Math.abs(a) < 1.0E-12) {
            a = 1.0E-12;
        }
        a = ((x22 - x11) * (x3y1 * x3y1 - x1y3 * x1y3) + (x3 * x3 - x11) * (x1y2 * x1y2 - x2y1 * x2y1)) / a;
        double b = 0.0;
        for (int i = 0; i < 3; ++i) {
            switch (i) {
                case 0: {
                    x1 = p1.x;
                    y1 = p1.y;
                    x2 = p2.x;
                    y2 = p2.y;
                    break;
                }
                case 1: {
                    x1 = p1.x;
                    y1 = p1.y;
                    x2 = p3.x;
                    y2 = p3.y;
                    break;
                }
                case 2: {
                    x1 = p2.x;
                    y1 = p2.y;
                    x2 = p3.x;
                    y2 = p3.y;
                }
            }
            b = x2 * x2 - x1 * x1;
            if (Math.abs(b) > 1.0E-12) break;
        }
        if (Math.abs(b) < 1.0E-12) {
            b = 1.0E-12;
        }
        b = (Math.pow(x2 * (y1 - a * x1), 2.0) - Math.pow(x1 * (y2 - a * x2), 2.0)) / b;
        double c = 0.0;
        for (int i = 0; i < 3; ++i) {
            switch (i) {
                case 0: {
                    x1 = p1.x;
                    y1 = p1.y;
                    break;
                }
                case 1: {
                    x1 = p2.x;
                    y1 = p2.y;
                    break;
                }
                case 2: {
                    x1 = p3.x;
                    y1 = p3.y;
                }
            }
            c = x1 * x1;
            if (Math.abs(c) > 1.0E-12) break;
        }
        if (Math.abs(c) < 1.0E-12) {
            c = 1.0E-12;
        }
        c = Math.abs(b - Math.pow(y1 - a * x1, 2.0)) / c;
        double d = a * a + c + 1.0;
        double k = d + Math.sqrt(Math.abs(d * d - 4.0 * c));
        double fi = Math.abs(k - 1.0) < 1.0E-12 ? 1.5707963267948966 : Math.atan(a * (k /= Math.abs(c) < 1.0E-12 ? 1.0E-12 : 2.0 * c) / (k - 1.0));
        double a_ = Math.sqrt(Math.abs(k * b));
        double kc = k * Math.sqrt(Math.abs(c));
        double b_ = Math.abs(kc) < 1.0E-12 ? a_ / 1.0E-12 : Math.abs(a_ / kc);
        axis.x = a_ * Math.cos(fi);
        axis.y = a_ * Math.sin(fi);
        double radiusRatio = Math.abs(a_) < 1.0E-12 || b_ >= a_ ? 1.0 : b_ / a_;
        return Math.max(radiusRatio, 1.0E-6);
    }

    private void writePie(Pie bg, RealPoint offset) {
        byte pieType = bg.PieType;
        double startAngle = bg.StartAngle;
        double endAngle = bg.EndAngle;
        if (pieType == 0) {
            this.writeEllipse(bg, new RealPoint(startAngle, endAngle), offset);
            return;
        }
        double sideX = Math.abs(bg.SideX);
        double sideY = Math.abs(bg.SideY);
        double[] points = SchemeEngine.SidesToPie(sideX, sideY, bg.Slices + 1, pieType, startAngle, endAngle);
        int count = points.length / 2;
        for (int i = 0; i < count; ++i) {
            int idx = 2 * i + 1;
            points[idx] = -points[idx];
        }
        this.writeAsPolygon(bg, points, null, false, offset);
    }

    private static AffineTransform getParagraphPaintMatrix(BaseGraphic bg) {
        AffineTransform transform = SchemeEngine.GenTransform(bg);
        bg = bg.ParentGB;
        while (bg != null) {
            transform.concatenate(SchemeEngine.GenTransform(bg));
            bg = bg.ParentGB;
        }
        return transform;
    }

    private static void fixParagraphFontHeightAndWidthScale(Paragraph bg, AffineTransform transform) {
        RealPoint[] points;
        double width = bg.SideX;
        double height = bg.SideY;
        for (RealPoint point : points = new RealPoint[]{new RealPoint(-0.5 * width, 0.5 * height), new RealPoint(-0.5 * width, -0.5 * height), new RealPoint(0.5 * width, 0.5 * height)}) {
            transform.transform(point, point);
        }
        double scaleX = transform.getScaleX();
        double scaleY = transform.getScaleY();
        double k = 1.0;
        if (Double.compare(scaleY, 1.0) != 0) {
            double newHeight = Math.sqrt(Math.pow(points[1].x - points[0].x, 2.0) + Math.pow(points[1].y - points[0].y, 2.0));
            if (newHeight > 0.0) {
                k = height / newHeight;
            }
            bg.lfHeight *= k;
        }
        if (Double.compare(scaleX, scaleY) == 0 || (double)Double.compare(scaleX, 1.0) == 0.0) {
            return;
        }
        double newWidth = Math.sqrt(Math.pow(points[2].x - points[0].x, 2.0) + Math.pow(points[2].y - points[0].y, 2.0));
        if (newWidth > 0.0) {
            k = width / newWidth;
        }
        bg.WidthScale *= k;
    }

    private static RealPoint getParagraphInsertionPoint(Paragraph paragraph, HorizontalAlign hAlign, VerticalAlign vAlign) {
        RealPoint insertionPoint = new RealPoint(0.0, 0.0);
        switch (hAlign) {
            case Left: {
                insertionPoint.x = -0.5 * paragraph.SideX;
                break;
            }
            case Right: {
                insertionPoint.x = 0.5 * paragraph.SideX;
                break;
            }
        }
        switch (vAlign) {
            case Top: {
                insertionPoint.y = -0.5 * paragraph.SideY;
                break;
            }
            case Bottom: {
                insertionPoint.y = 0.5 * paragraph.SideY;
                break;
            }
        }
        return insertionPoint;
    }

    private double[] transformPoint(RealPoint point) {
        double[] rawPoint = new double[]{point.x, point.y};
        return this.engine.MulPoints(rawPoint);
    }

    private static RealPoint realPoint(double[] rawPoint, boolean invertY) {
        assert (rawPoint.length >= 2);
        return new RealPoint(rawPoint[0], invertY ? -rawPoint[1] : rawPoint[1]);
    }

    private static byte getParagraphAttachmentPoint(HorizontalAlign hAlign, VerticalAlign vAlign) {
        return (byte)(hAlign.autoCadAlignTypeId + vAlign.autoCadAlignType);
    }

    private void writeParagraphData(Paragraph paragraph) {
        HorizontalAlign hAlign = HorizontalAlign.hAlignFromAsmoHAlign(paragraph.Align);
        VerticalAlign vAlign = VerticalAlign.vAlignFromAsmoVAlign(paragraph.VertAlign);
        RealPoint insertionPoint = DxfWriter.realPoint(this.transformPoint(DxfWriter.getParagraphInsertionPoint(paragraph, hAlign, vAlign)), true);
        RectTextLine line = (RectTextLine)paragraph.Lines.get(0);
        this.writeName("MTEXT", "AcDbMText", paragraph.Transparent);
        this.writeColor(this.engine.getActualFontColor(line.FontColor), false);
        this.writePoint(insertionPoint.x, insertionPoint.y);
        this.writeLex(" 40", DxfWriter.calcCapHeightByFontHeight(paragraph.lfHeight < 1.0E-12 ? 2.0 * line.SideY / 3.0 : paragraph.lfHeight));
        if (!paragraph.AutoSize) {
            this.writeLex(" 41", paragraph.SideX);
        }
        this.writeLex(" 71", DxfWriter.getParagraphAttachmentPoint(hAlign, vAlign));
        this.writeLex("  1", this.getText(paragraph));
        if (this.engine.tmpAngle != 0.0) {
            this.writeLex(" 50", -this.engine.tmpAngle);
        }
        this.writeLex(" 73", 2);
        this.writeLex(" 44", Math.max(0.25, Math.min(4.0, Math.abs(paragraph.LineSpacing))));
    }

    private void writeParagraph(Paragraph bg, RealPoint offset) {
        if (bg.ShowBackground) {
            this.writeRectangle(bg, Color.WHITE.equals(this.engine.getActualBColor(bg.bColor)), offset);
        }
        if (bg.Lines == null || bg.Lines.isEmpty()) {
            return;
        }
        DxfWriter.fixParagraphFontHeightAndWidthScale(bg, DxfWriter.getParagraphPaintMatrix(bg));
        this.writeParagraphData(bg);
    }

    private void writeAttributeDefAsParagraph(AttributeDef bg, RealPoint offset) {
        if (bg.ShowBackground) {
            this.writeRectangle(bg, Color.WHITE.equals(this.engine.getActualBColor(bg.bColor)), offset);
        }
        if (bg.Lines == null || bg.Lines.isEmpty()) {
            return;
        }
        DxfWriter.fixParagraphFontHeightAndWidthScale(bg, DxfWriter.getParagraphPaintMatrix(bg));
        this.writeParagraphData(bg);
        if (bg.invisible()) {
            this.writeLex(" 60", 1);
        }
    }

    private boolean hasPartsText(RectTextLine line) {
        return line != null && line.Parts != null && !line.Parts.isEmpty();
    }

    private String getPartsText(RectTextLine line) {
        assert (line != null);
        StringBuilder sb = new StringBuilder();
        if (line.Parts != null) {
            for (RectTextLine.PartTextLine partLine : line.Parts) {
                sb.append(partLine.text);
            }
        }
        return sb.toString();
    }

    private String getText(Paragraph bg) {
        String lb;
        if (bg.Lines == null || bg.Lines.isEmpty()) {
            return "";
        }
        int count = bg.Lines.size();
        double widthScale = bg.WidthScale;
        RectTextLine line = (RectTextLine)bg.Lines.get(0);
        String fontName = line.FontName != null && !line.FontName.isEmpty() ? line.FontName.trim() : "Arial";
        byte fontStyle = line.FontStyle;
        StringBuilder text = new StringBuilder();
        String lu = (fontStyle & 4) != 0 ? ";\\L" : ";";
        String li = (fontStyle & 2) != 0 ? "i1" : "i0";
        String string = lb = (fontStyle & 1) != 0 ? "b1" : "b0";
        String text0 = this.hasPartsText(line) ? this.getPartsText(line) : (line.Text != null ? line.Text : "");
        text.append("{\\W").append(widthScale).append(';');
        text.append("\\f").append(fontName).append('|').append(lb).append('|').append(li).append('|').append(lu).append(text0);
        for (int i = 1; i < count; ++i) {
            line = (RectTextLine)bg.Lines.get(i);
            text.append("\\P");
            text.append(this.hasPartsText(line) ? this.getPartsText(line) : (line.Text != null ? line.Text : ""));
        }
        text.append('}');
        return text.toString();
    }

    private RealPoint correctParagraphInsPoint(Paragraph bg, double fh, boolean top) {
        double x0 = -0.5 * Math.abs(bg.SideX);
        double y0 = -0.5 * Math.abs(bg.SideY);
        double x = x0 + DxfWriter.calcMarginLeftByFontHeight(fh) * bg.WidthScale;
        double y = -(y0 + bg.SideY - DxfWriter.calcTopAndCapHeightByFontHeight(fh));
        if (top) {
            y -= DxfWriter.calcCapHeightByFontHeight(fh);
        }
        return new RealPoint(x, y);
    }

    private static double calcCapHeightByFontHeight(double fh) {
        return fh / 1.3885;
    }

    private static double calcTopAndCapHeightByFontHeight(double fh) {
        return fh * 0.8691316564638099;
    }

    private static double calcMarginLeftByFontHeight(double fh) {
        return fh * 0.28219;
    }

    private void writeAttributeDef(AttributeDef bg, RealPoint offset) {
        this.writeName("ATTDEF", "AcDbText", 0);
        this.writeAttribute(bg, false, "AcDbAttributeDefinition", this.getAttValue(bg), offset);
    }

    private String getAttValue(Attribute bg) {
        if (bg.Lines.isEmpty()) {
            return "";
        }
        int count = bg.Lines.size();
        StringBuilder text = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            RectTextLine line = (RectTextLine)bg.Lines.get(i);
            text.append("\\P").append(line.Text != null ? line.Text : "");
        }
        return text.toString();
    }

    private void writeAttribute(Attribute bg, boolean isAttRef, String className, String text, RealPoint offset) {
        int flags;
        double angle;
        double[] points = new double[]{bg.TransProps != null ? -bg.TransProps.CenterX : 0.0, bg.TransProps != null ? -bg.TransProps.CenterY : 0.0};
        double[] pts = this.engine.MulPoints(points);
        double x = pts[0] + offset.x;
        double y = -pts[1] - offset.y;
        this.writePoint(x, y);
        RectTextLine line = (RectTextLine)bg.Lines.get(0);
        double lfHeight = bg.lfHeight < 1.0E-12 ? 2.0 * line.SideY / 3.0 : bg.lfHeight;
        double exportHeight = DxfWriter.calcCapHeightByFontHeight(lfHeight);
        this.writeLex(" 40", exportHeight);
        this.writeLex("  1", text);
        double d = angle = bg.TransProps != null ? -bg.TransProps.Angle : 0.0;
        if (isAttRef) {
            double halfW = 0.5 * bg.SideX;
            double halfH = 0.5 * bg.SideY;
            points = new double[]{-halfW, -halfH, halfW, -halfH};
            pts = this.engine.MulPoints(points);
            angle = Math.atan2(pts[1] - pts[3], pts[2] - pts[0]);
        }
        if (angle != 0.0) {
            this.writeLex(" 50", angle * 180.0 / Math.PI);
        }
        if (bg.WidthScale != 0.0) {
            this.writeLex(" 41", bg.WidthScale);
        }
        this.writeLex("100", className);
        String caption = bg.StringProps != null && bg.StringProps.Caption != null ? bg.StringProps.Caption : "";
        this.writeLex("  2", caption);
        if (!isAttRef) {
            this.writeLex("  3", caption);
        }
        int n = flags = bg.invisible() ? 1 : 0;
        if (bg.constant()) {
            flags += 2;
        }
        this.writeLex(" 70", flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeBlock(GraphicBlock block, RealPoint offset) {
        if (block.Objects == null || block.Objects.isEmpty()) {
            return;
        }
        AffineTransform OldGTM = new AffineTransform();
        OldGTM.setTransform(this.engine.GTM);
        double oldAngle = this.engine.tmpAngle;
        this.engine.tmpAngle = 0.0;
        try {
            this.engine.GTM.setToIdentity();
            BlockEntry blockEntry = this.blocksHash.get(block.ID);
            if (blockEntry == null) {
                StringBuilder prevSb = this.sb;
                try {
                    blockEntry = this.writeBeginBlock(block.ID, null);
                    int count = block.Objects.size();
                    for (int i = 0; i < count; ++i) {
                        BaseGraphic bg = block.Objects.get(i);
                        if (bg == null) continue;
                        this.writeShape(bg, offset);
                    }
                }
                finally {
                    this.writeEndBlock();
                    this.sb = prevSb;
                }
            }
            if (blockEntry != null) {
                this.writeBlockInsert(block, blockEntry.name, null, false, offset);
            }
        }
        finally {
            this.engine.GTM.setTransform(OldGTM);
            this.engine.tmpAngle = oldAngle;
        }
    }

    private void writeBlockInsert(GraphicBlock block, String name, RealPoint center, boolean withAtt, RealPoint offset) {
        RealPoint org = new RealPoint(0.0, 0.0);
        RealPoint scale = new RealPoint(1.0, 1.0);
        double angle = this.calcInsertParams(block, center, org, scale);
        this.writeName("INSERT", "AcDbBlockReference", 0);
        if (withAtt) {
            this.writeLex(" 66", 1);
        }
        this.writeLex("  2", name);
        this.writePoint(org.x + offset.x, -org.y - offset.y);
        this.writeColor(Color.BLACK, false);
        if (scale.x != 1.0) {
            this.writeLex(" 41", scale.x);
        }
        if (scale.y != 1.0) {
            this.writeLex(" 42", scale.y);
        }
        if (angle != 0.0) {
            this.writeLex(" 50", -angle);
        }
    }

    private BlockEntry writeBeginBlock(double id, String name) {
        if (name == null || ((String)name).isEmpty()) {
            name = "Phx_block_" + String.format("%.0f", id);
        }
        BlockEntry blockEntry = new BlockEntry(id, (String)name);
        this.sb = this.sbBlkRecs;
        this.writeName("BLOCK_RECORD", "AcDbBlockTableRecord", 0);
        this.writeLex("  2", (String)name);
        this.blocksHash.add(blockEntry);
        this.sb = blockEntry.sb;
        this.writeName("BLOCK", "AcDbBlockBegin", 0);
        this.writeLex("  2", (String)name);
        this.writeLex(" 10", "0");
        this.writeLex(" 20", "0");
        this.writeLex(" 70", "0");
        return blockEntry;
    }

    private void writeBeginInsertBlock(String name) {
        assert (name != null && !name.isEmpty());
        this.sb = this.sbBlkRecs;
        this.writeName("BLOCK_RECORD", "AcDbBlockTableRecord", 0);
        this.writeLex("  2", name);
        this.sb = new StringBuilder();
        this.writeName("BLOCK", "AcDbBlockBegin", 0);
        this.writeLex("  2", name);
        this.writeLex(" 10", "0");
        this.writeLex(" 20", "0");
        this.writeLex(" 70", "0");
    }

    private void writeEndBlock() {
        this.writeName("ENDBLK", "AcDbBlockEnd", 0);
        this.sbPhxBlocks.append((CharSequence)this.sb);
    }

    private double calcInsertParams(GraphicBlock block, RealPoint center, RealPoint org, RealPoint scale) {
        double angle;
        boolean isCenter = center != null;
        boolean isTrans = block.TransProps != null;
        scale.x = isTrans ? block.TransProps.ScaleX : 1.0;
        scale.y = isTrans ? block.TransProps.ScaleY : 1.0;
        double d = angle = isTrans ? block.TransProps.Angle : 0.0;
        if (!isCenter && (!isTrans || Math.abs(block.TransProps.CenterX) <= 1.0E-12 && Math.abs(block.TransProps.CenterY) <= 1.0E-12)) {
            org.x = block.OrgX;
            org.y = block.OrgY;
            return angle;
        }
        org.x = isCenter ? -center.x : 0.0;
        org.y = isCenter ? -center.y : 0.0;
        double[] points = new double[]{org.x, org.y};
        AffineTransform tm = SchemeEngine.GenTransform(block);
        double[] pts = SchemeEngine.MulPointsTM(tm, points);
        org.x = pts[0];
        org.y = pts[1];
        return angle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeInsert(PhxGraphicInsert insert, RealPoint offset) {
        AttributeRef att;
        RealPoint center;
        GraphicBlock block;
        BlockEntry blockEntry;
        block23: {
            blockEntry = this.blocksHash.get(insert.SourceID);
            block = null;
            if (blockEntry == null) {
                Primitive prim = this.s.findPrimInLibsById(insert.SourceID, insert.LibID);
                if (prim == null || prim.BG == null) {
                    return;
                }
                block = (GraphicBlock)prim.BG;
                if (insert.getInternalPrimGraphicBlock() != null) {
                    block = insert.getInternalPrimGraphicBlock();
                }
                if (block == null || block.Objects == null || block.Objects.isEmpty()) {
                    return;
                }
                AffineTransform OldGTM = new AffineTransform();
                OldGTM.setTransform(this.engine.GTM);
                double oldAngle = this.engine.tmpAngle;
                this.engine.tmpAngle = 0.0;
                this.insertMode = true;
                try {
                    this.engine.GTM.setToIdentity();
                    StringBuilder prevSb = this.sb;
                    try {
                        blockEntry = this.writeBeginBlock(prim.key(), prim.Caption);
                        blockEntry.centerX = prim.BG.TransProps != null ? prim.BG.TransProps.CenterX : 0.0;
                        blockEntry.centerY = prim.BG.TransProps != null ? prim.BG.TransProps.CenterY : 0.0;
                        center = new RealPoint(blockEntry.centerX, blockEntry.centerY);
                        int count = block.Objects.size();
                        for (int i = 0; i < count; ++i) {
                            BaseGraphic bg = block.Objects.get(i);
                            if (bg == null || bg instanceof AttributeDef) continue;
                            this.writeShape(bg, center);
                        }
                        break block23;
                    }
                    finally {
                        this.writeEndBlock();
                        this.sb = prevSb;
                    }
                }
                finally {
                    this.engine.GTM.setTransform(OldGTM);
                    this.engine.tmpAngle = oldAngle;
                    this.insertMode = false;
                }
            }
            center = new RealPoint(blockEntry.centerX, blockEntry.centerY);
        }
        int attCount = insert.Attributes != null ? insert.Attributes.size() : 0;
        boolean attNotConstant = false;
        for (int i = 0; i < attCount; ++i) {
            att = (AttributeRef)insert.Attributes.get(i);
            if (att == null || att.constant() || att.Lines == null || att.Lines.isEmpty()) continue;
            attNotConstant = true;
            break;
        }
        if (blockEntry == null) {
            return;
        }
        if (attNotConstant) {
            this.writeBlockInsert(insert, blockEntry.name, center, true, offset);
            AffineTransform OldGTM = new AffineTransform();
            OldGTM.setTransform(this.engine.GTM);
            double oldAngle = this.engine.tmpAngle;
            this.engine.tmpAngle = insert.TransProps != null ? insert.TransProps.Angle : 0.0;
            try {
                this.engine.GTM.setTransform(SchemeEngine.GenTransform(insert));
                for (int i = 0; i < attCount; ++i) {
                    att = (AttributeRef)insert.Attributes.get(i);
                    if (att == null || att.constant() || att.Lines == null || att.Lines.isEmpty()) continue;
                    if (att.Inscribe && block != null) {
                        if (att.getEngine() == null) {
                            att.setEngine(this.engine);
                        }
                        double oldSideX = att.SideX;
                        att.setInscribeExt(block, true, false, false);
                        if (oldSideX < att.SideX) {
                            double scaleX = insert.TransProps == null ? 1.0 : insert.TransProps.ScaleX;
                            double scaleY = insert.TransProps == null ? 1.0 : insert.TransProps.ScaleY;
                            double attCenterX = att.SideX * 0.5;
                            double attCenterY = att.SideY * 0.5;
                            if (att.TransProps != null) {
                                att.TransProps.CenterX = attCenterX;
                                att.TransProps.CenterY = attCenterY;
                            }
                            att.OrgX = -attCenterX / scaleX;
                            att.OrgY = -attCenterY / scaleY;
                        }
                    }
                    this.writeAttributeRef(att, offset);
                }
            }
            finally {
                this.engine.GTM.setTransform(OldGTM);
                this.engine.tmpAngle = oldAngle;
            }
            this.writeName("SEQEND", "", 0);
        } else {
            this.writeBlockInsert(insert, blockEntry.name, center, false, offset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeInsertAsBlock(PhxGraphicInsert insert, RealPoint offset) {
        Primitive prim = this.s.findPrimInLibsById(insert.SourceID, insert.LibID);
        if (prim == null || prim.BG == null) {
            return;
        }
        GraphicBlock block = insert.getInternalPrimGraphicBlock();
        if (block == null) {
            block = (GraphicBlock)prim.BG;
        }
        if (block == null || block.Objects == null || block.Objects.isEmpty()) {
            return;
        }
        AffineTransform OldGTM = new AffineTransform();
        OldGTM.setTransform(this.engine.GTM);
        double oldAngle = this.engine.tmpAngle;
        ++this.insertCounter;
        String blockName = "Phx_insert_" + this.insertCounter;
        this.engine.tmpAngle = 0.0;
        try {
            this.engine.GTM.setToIdentity();
            StringBuilder prevSb = this.sb;
            try {
                this.writeBeginInsertBlock(blockName);
                int count = block.Objects.size();
                int idxAtt = 0;
                int cntAtt = insert.Attributes == null ? 0 : insert.Attributes.size();
                for (int i = 0; i < count; ++i) {
                    BaseGraphic att;
                    BaseGraphic bg = block.Objects.get(i);
                    if (bg == null) continue;
                    if (bg instanceof AttributeDef && idxAtt < cntAtt && (att = insert.Attributes.get(idxAtt++)) instanceof AttributeRef) {
                        AttributeRef ref = new AttributeRef();
                        try {
                            att.assign(ref);
                            bg = ref;
                        }
                        catch (Exception ex) {
                            bg = att;
                        }
                    }
                    if (bg instanceof Attribute && ((Attribute)bg).invisible()) continue;
                    this.writeShape(bg, offset);
                }
            }
            finally {
                this.writeEndBlock();
                this.sb = prevSb;
            }
            this.writeBlockInsert(insert, blockName, null, false, offset);
        }
        finally {
            this.engine.GTM.setTransform(OldGTM);
            this.engine.tmpAngle = oldAngle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeAttributeRef(AttributeRef bg, RealPoint offset) {
        AffineTransform OldGTM = new AffineTransform();
        OldGTM.setTransform(this.engine.GTM);
        double oldAngle = this.engine.tmpAngle;
        if (bg.TransProps != null && bg.TransProps.Angle != 0.0) {
            this.engine.tmpAngle += bg.TransProps.Angle;
        }
        try {
            this.engine.GTM.concatenate(SchemeEngine.GenTransform(bg));
            this.writeName("ATTRIB", "AcDbText", 0);
            RectTextLine line = (RectTextLine)bg.Lines.get(0);
            Color fontColor = this.engine.getActualFontColor(line.FontColor);
            this.writeColor(fontColor, false);
            this.writeAttribute(bg, true, "AcDbAttribute", this.getAttValue(bg), new RealPoint(0.0, 0.0));
        }
        finally {
            this.engine.GTM.setTransform(OldGTM);
            this.engine.tmpAngle = oldAngle;
        }
    }

    private String getDxfTransparentCode(int transparent) {
        int index = transparent;
        if (index < 0) {
            index = 0;
        }
        if (index > 90) {
            index = 90;
        }
        return " " + String.valueOf(DXF_TRANSPARENTS[index]);
    }

    public void setStateHost(ServerSideHost host) {
        this.stateHost = host;
    }

    private void putStateCaption(String caption) throws Exception {
        if (this.stateHost == null) {
            return;
        }
        this.stateHost.putRequestStateCaption(caption);
    }

    private void putStateText(String value) throws Exception {
        if (this.stateHost == null) {
            return;
        }
        this.stateHost.putRequestStateText(value);
    }

    private void putStateInstruction(String value) throws Exception {
        if (this.stateHost == null) {
            return;
        }
        this.stateHost.putRequestStateInstruction(value);
    }

    private void putStateLog(String value) {
        if (this.stateHost == null) {
            return;
        }
        try {
            this.stateHost.putRequestStateLog(value);
        }
        catch (Exception ex) {
            Core.logger.error("", ex);
        }
    }

    private void putStateProgressMin(int value) throws Exception {
        if (this.stateHost == null) {
            return;
        }
        this.stateHost.putRequestStateProgressMin(value);
    }

    private void putStateProgressMax(int value) throws Exception {
        if (this.stateHost == null) {
            return;
        }
        this.stateHost.putRequestStateProgressMax(value);
    }

    private void putStateProgressPosition(int value) throws Exception {
        if (this.stateHost == null) {
            return;
        }
        this.stateHost.putRequestStateProgressPosition(value);
    }

    private static enum VerticalAlign {
        Top(0, 1),
        Bottom(1, 7),
        Center(2, 4);

        public final byte asmoAlignTypeId;
        public final byte autoCadAlignType;

        private VerticalAlign(byte asmoAlignTypeId, byte autoCadAlignType) {
            this.asmoAlignTypeId = asmoAlignTypeId;
            this.autoCadAlignType = autoCadAlignType;
        }

        public static VerticalAlign vAlignFromAsmoVAlign(int asmoAlign) {
            for (VerticalAlign vAlign : VerticalAlign.values()) {
                if (vAlign.asmoAlignTypeId != asmoAlign) continue;
                return vAlign;
            }
            return Top;
        }
    }

    private static enum HorizontalAlign {
        Left(0, 0),
        Right(1, 2),
        Center(2, 1),
        ByWidth(3, HorizontalAlign.Right.autoCadAlignTypeId);

        public final byte asmoAlignTypeId;
        public final byte autoCadAlignTypeId;

        private HorizontalAlign(byte asmoAlignTypeId, byte autoCadAlignTypeId) {
            this.asmoAlignTypeId = asmoAlignTypeId;
            this.autoCadAlignTypeId = autoCadAlignTypeId;
        }

        public static HorizontalAlign hAlignFromAsmoHAlign(int asmoAlign) {
            for (HorizontalAlign hAlign : HorizontalAlign.values()) {
                if (hAlign.asmoAlignTypeId != asmoAlign) continue;
                return hAlign;
            }
            return Left;
        }
    }

    private static enum HatchBoundType {
        Polyline,
        Curve,
        Ellipse;

    }

    private static enum ASMOHatchType {
        Horizontal(15, 0.01f, 135.0f, 0.0f, 0.0f, 0.03f),
        HorizontalBold(16, 0.01f, 135.0f, 0.0f, 0.0f, 0.03f),
        HorizontalNarrow(17, 0.01f, 135.0f, 0.0f, 0.0f, 0.02f),
        HorizontalNarrowBold(18, 0.01f, 135.0f, 0.0f, 0.0f, 0.02f),
        HorizontalUltraNarrow(19, 0.01f, 135.0f, 0.0f, 0.0f, 0.015f),
        Vertical(20, 0.01f, 45.0f, 90.0f, -0.03f, 0.0f),
        VerticalBold(21, 0.01f, 45.0f, 90.0f, -0.03f, 0.0f),
        VerticalNarrow(22, 0.01f, 45.0f, 90.0f, -0.02f, 0.0f),
        VerticalNarrowBold(23, 0.01f, 45.0f, 90.0f, -0.02f, 0.0f),
        VerticalUltraNarrow(24, 0.01f, 45.0f, 90.0f, -0.015f, 0.0f),
        DiagonalUp(25, 0.01f, 0.0f, 45.0f, -0.03f, 0.03f),
        DiagonalUpBold(26, 0.01f, 0.0f, 45.0f, -0.03f, 0.03f),
        DiagonalUpNarrow(27, 0.01f, 0.0f, 45.0f, -0.02f, 0.02f),
        DiagonalUpNarrowBold(28, 0.01f, 0.0f, 45.0f, -0.02f, 0.02f),
        DiagonalUpUltraNarrow(29, 0.01f, 0.0f, 45.0f, -0.015f, 0.015f),
        DiagonalDown(30, 0.01f, 90.0f, 135.0f, 0.03f, 0.03f),
        DiagonalDownBold(31, 0.01f, 90.0f, 135.0f, 0.03f, 0.03f),
        DiagonalDownNarrow(32, 0.01f, 90.0f, 135.0f, 0.02f, 0.02f),
        DiagonalDownNarrowBold(33, 0.01f, 90.0f, 135.0f, 0.02f, 0.02f),
        DiagonalDownUltraNarrow(34, 0.01f, 90.0f, 135.0f, 0.015f, 0.015f),
        Solid(-1, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f);

        public final int asmoHatchTypeId;
        public final float targetPatternScale;
        public final float hatchAngle;
        public final float patternAngle;
        public final float patternLineOffsetX;
        public final float patternLineOffsetY;
        private static Map<Integer, ASMOHatchType> ById;

        private ASMOHatchType(int asmoHatchTypeId, float targetPatternScale, float hatchAngle, float patternAngle, float patternLineOffsetX, float patternLineOffsetY) {
            this.asmoHatchTypeId = asmoHatchTypeId;
            this.targetPatternScale = targetPatternScale;
            this.hatchAngle = hatchAngle;
            this.patternAngle = patternAngle;
            this.patternLineOffsetX = patternLineOffsetX;
            this.patternLineOffsetY = patternLineOffsetY;
        }

        public static ASMOHatchType hatchTypeById(int asmoHatchTypeId) {
            if (ById == null) {
                ById = new HashMap<Integer, ASMOHatchType>();
                for (ASMOHatchType type : ASMOHatchType.values()) {
                    ById.put(type.asmoHatchTypeId, type);
                }
                ById.put(7, Horizontal);
                ById.put(6, Vertical);
                ById.put(5, DiagonalDown);
                ById.put(4, DiagonalUp);
            }
            return ById.get(asmoHatchTypeId);
        }

        public String toString() {
            switch (this) {
                case Solid: {
                    return "SOLID";
                }
                case Horizontal: 
                case HorizontalBold: 
                case HorizontalNarrow: 
                case HorizontalNarrowBold: 
                case HorizontalUltraNarrow: 
                case Vertical: 
                case VerticalBold: 
                case VerticalNarrow: 
                case VerticalNarrowBold: 
                case VerticalUltraNarrow: 
                case DiagonalUp: 
                case DiagonalUpBold: 
                case DiagonalUpNarrow: 
                case DiagonalUpNarrowBold: 
                case DiagonalUpUltraNarrow: 
                case DiagonalDown: 
                case DiagonalDownBold: 
                case DiagonalDownNarrow: 
                case DiagonalDownNarrowBold: 
                case DiagonalDownUltraNarrow: {
                    return "ANSI31";
                }
            }
            return Solid.toString();
        }

        public boolean isPatternFill() {
            switch (this) {
                case Horizontal: 
                case HorizontalBold: 
                case HorizontalNarrow: 
                case HorizontalNarrowBold: 
                case HorizontalUltraNarrow: 
                case Vertical: 
                case VerticalBold: 
                case VerticalNarrow: 
                case VerticalNarrowBold: 
                case VerticalUltraNarrow: 
                case DiagonalUp: 
                case DiagonalUpBold: 
                case DiagonalUpNarrow: 
                case DiagonalUpNarrowBold: 
                case DiagonalUpUltraNarrow: 
                case DiagonalDown: 
                case DiagonalDownBold: 
                case DiagonalDownNarrow: 
                case DiagonalDownNarrowBold: 
                case DiagonalDownUltraNarrow: {
                    return true;
                }
            }
            return false;
        }

        static {
            ById = null;
        }
    }

    private static class BlockEntry
    implements DoubleHash.Entry {
        private final double id;
        private final String name;
        private double centerX = 0.0;
        private double centerY = 0.0;
        private final StringBuilder sb = new StringBuilder();

        public BlockEntry(double id, String name) {
            this.id = id;
            this.name = name;
        }

        @Override
        public double key() {
            return this.id;
        }
    }

    class MLineStyle {
        private final String handle;
        private final String name;
        private final String desc;
        private final int elementsCount;
        private final int color;
        private final double scaleFactor;
        private final double[] elements;

        public MLineStyle(String name, String desc, int elementsCount, int color, double scaleFactor, double[] elements) {
            this.handle = Integer.toHexString(DxfWriter.this.nextHandle());
            this.name = name;
            this.desc = desc;
            this.elementsCount = elementsCount;
            this.color = color;
            this.scaleFactor = scaleFactor;
            this.elements = elements;
        }
    }

    public static class RealPoint
    extends Point2D {
        private double x = 0.0;
        private double y = 0.0;

        public RealPoint(double x, double y) {
            this.x = x;
            this.y = y;
        }

        public void assign(RealPoint source) {
            this.x = source.x;
            this.y = source.y;
        }

        @Override
        public double getX() {
            return this.x;
        }

        @Override
        public double getY() {
            return this.y;
        }

        @Override
        public void setLocation(double x, double y) {
            this.x = x;
            this.y = y;
        }
    }
}

