/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes;

import inform.adt.LittleEndian;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.schemes.BaseGraphic;
import inform.agent.schemes.Rectangle;
import inform.agent.schemes.SchemeEngine;
import inform.agent.schemes.SchemeParser;
import inform.agent.schemes.SchemeUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class Image
extends Rectangle {
    public int BmpWidth = 0;
    public int BmpHeight = 0;
    public Color TranspColor = null;
    public int Align = 0;
    public double[] ClipPoints = null;
    public double[] ReperPoints = null;
    public int ImageSize = 0;
    public byte[] Bmp = null;
    public byte PixelFormat = (byte)6;
    public int[] Pallete = null;
    public double LeftCropPercentage;
    public double TopCropPercentage;
    public double RightCropPercentage;
    public double BottomCropPercentage;
    private static final int TAG_LEFT_CROP_PERCENTAGE = 1;
    private static final int TAG_TOP_CROP_PERCENTAGE = 2;
    private static final int TAG_RIGHT_CROP_PERCENTAGE = 3;
    private static final int TAG_BOTTOM_CROP_PERCENTAGE = 4;
    private static final double EPSILON = 1.0E-7;
    private static final int version = LittleEndian.getInt(new byte[]{0, 0, 29, 7}, 0);

    @Override
    public void assign(BaseGraphic Dest) throws IllegalAccessException, InstantiationException {
        int i;
        super.assign(Dest);
        Image shape = (Image)Dest;
        shape.BmpWidth = this.BmpWidth;
        shape.BmpHeight = this.BmpHeight;
        shape.TranspColor = this.TranspColor;
        shape.Align = this.Align;
        shape.ImageSize = this.ImageSize;
        shape.PixelFormat = this.PixelFormat;
        int count = this.ClipPoints.length;
        shape.ClipPoints = new double[count];
        for (i = 0; i < count; ++i) {
            shape.ClipPoints[i] = this.ClipPoints[i];
        }
        count = this.ReperPoints.length;
        shape.ReperPoints = new double[count];
        for (i = 0; i < count; ++i) {
            shape.ReperPoints[i] = this.ReperPoints[i];
        }
        count = this.Bmp.length;
        shape.Bmp = new byte[count];
        for (i = 0; i < count; ++i) {
            shape.Bmp[i] = this.Bmp[i];
        }
        count = this.Pallete.length;
        shape.Pallete = new int[count];
        for (i = 0; i < count; ++i) {
            shape.Pallete[i] = this.Pallete[i];
        }
    }

    @Override
    protected void parse(SchemeParser Parser2, TaggedReader reader) throws IOException, TaggedReaderException {
        TaggedReader StreamReader = null;
        while (reader.getNextTag() != 0) {
            switch (reader.getCurrentTag()) {
                case 3: {
                    StreamReader = reader.getStreamReader();
                    if (StreamReader == null) break;
                    super.parse(Parser2, StreamReader);
                    break;
                }
                case 41: {
                    this.BmpWidth = reader.getInt();
                    break;
                }
                case 42: {
                    this.BmpHeight = reader.getInt();
                    break;
                }
                case 43: {
                    this.TranspColor = SchemeParser.parseColor(reader.getInt());
                    break;
                }
                case 45: {
                    this.Align = reader.getInt();
                    break;
                }
                case 49: {
                    this.ClipPoints = LittleEndian.toDoubleArray(reader.getRaw());
                    break;
                }
                case 50: {
                    this.ReperPoints = LittleEndian.toDoubleArray(reader.getRaw());
                    break;
                }
                case 44: {
                    this.ImageSize = reader.getInt();
                    break;
                }
                case 46: {
                    this.Bmp = reader.getRaw();
                    break;
                }
                case 47: {
                    this.PixelFormat = reader.getByte();
                    break;
                }
                case 48: {
                    this.Pallete = LittleEndian.toIntArray(reader.getRaw());
                }
            }
        }
    }

    @Override
    protected synchronized void readExtraTagged(SchemeParser parser, TaggedReader reader, int tag) throws IOException {
        if (tag != 15) {
            super.readExtraTagged(parser, reader, tag);
            return;
        }
        TaggedReader subReader = reader.getStreamReader();
        if (subReader != null) {
            block6: while (subReader.getNextTag() != 0) {
                switch (subReader.getCurrentTag()) {
                    case 1: {
                        this.LeftCropPercentage = subReader.getDouble();
                        continue block6;
                    }
                    case 2: {
                        this.TopCropPercentage = subReader.getDouble();
                        continue block6;
                    }
                    case 3: {
                        this.RightCropPercentage = subReader.getDouble();
                        continue block6;
                    }
                    case 4: {
                        this.BottomCropPercentage = subReader.getDouble();
                        continue block6;
                    }
                }
            }
        }
    }

    @Override
    protected void actualPaint(Graphics2D g2d, SchemeEngine Engine2) throws IllegalAccessException, InstantiationException {
    }

    void initClipPoints() {
        if (this.ClipPoints == null) {
            this.ClipPoints = new double[8];
        }
        assert (this.ClipPoints.length == 8);
        this.ClipPoints[0] = 0.0;
        this.ClipPoints[1] = 0.0;
        this.ClipPoints[2] = this.BmpWidth;
        this.ClipPoints[3] = 0.0;
        this.ClipPoints[4] = this.BmpWidth;
        this.ClipPoints[5] = this.BmpHeight;
        this.ClipPoints[6] = 0.0;
        this.ClipPoints[7] = this.BmpHeight;
    }

    @Override
    public synchronized void writeTaggedData(TaggedWriter writer, boolean clipboard, boolean simult) throws IOException {
        if (writer == null) {
            return;
        }
        inform.adt.taggedio.ByteArrayOutputStream os = new inform.adt.taggedio.ByteArrayOutputStream();
        TaggedWriter subWriter = new TaggedWriter(os);
        super.writeTaggedData(subWriter, clipboard, simult);
        subWriter.flush();
        if (os.size() > 0) {
            writer.putRaw(3, os);
        }
        writer.putInt32(41, this.BmpWidth);
        writer.putInt32(42, this.BmpHeight);
        if (this.TranspColor != null && this.TranspColor != Color.WHITE) {
            SchemeUtils.writeColor(writer, 43, this.TranspColor);
        }
        if (this.Align != 0) {
            writer.putInt32(45, this.Align);
        }
        if (this.ClipPoints != null && this.ClipPoints.length > 0) {
            writer.putRaw(49, LittleEndian.doubleArrayToBinary(this.ClipPoints));
        }
        if (this.ReperPoints != null && this.ReperPoints.length == 4 && (this.ReperPoints[0] != 0.0 || this.ReperPoints[1] != 0.0 || this.ReperPoints[2] != 0.0 || this.ReperPoints[3] != 0.0)) {
            writer.putRaw(50, LittleEndian.doubleArrayToBinary(this.ReperPoints));
        }
        writer.putInt32(44, this.ImageSize);
        writer.putRaw(46, this.Bmp, this.ImageSize);
        if (this.PixelFormat != 6) {
            writer.putInt08(47, this.PixelFormat);
        }
        if (this.Pallete != null && this.Pallete.length > 0) {
            writer.putRaw(48, LittleEndian.intArrayToBinary(this.Pallete, this.Pallete.length));
        }
    }

    @Override
    protected synchronized void writeExtraTagged(TaggedWriter writer) throws IOException {
        super.writeExtraTagged(writer);
        inform.adt.taggedio.ByteArrayOutputStream os = new inform.adt.taggedio.ByteArrayOutputStream();
        TaggedWriter cropInfo = new TaggedWriter(os);
        if (!SchemeUtils.isEqual(this.LeftCropPercentage, 1.0E-7)) {
            cropInfo.putDouble(1, this.LeftCropPercentage);
        }
        if (!SchemeUtils.isEqual(this.TopCropPercentage, 1.0E-7)) {
            cropInfo.putDouble(2, this.TopCropPercentage);
        }
        if (!SchemeUtils.isEqual(this.RightCropPercentage, 1.0E-7)) {
            cropInfo.putDouble(3, this.RightCropPercentage);
        }
        if (!SchemeUtils.isEqual(this.BottomCropPercentage, 1.0E-7)) {
            cropInfo.putDouble(4, this.BottomCropPercentage);
        }
        cropInfo.flush();
        if (os.size() > 0) {
            writer.putRaw(15, os);
        }
    }

    @Override
    public int shapeType() {
        return 217;
    }

    @Override
    public int shapeVersion() {
        return version;
    }

    public void saveBitmapToStream(ByteArrayOutputStream out) throws IOException {
        if (out == null) {
            return;
        }
        int BITMAPFILEHEADER_SIZE = 14;
        int BITMAPINFOHEADER_SIZE = 40;
        byte[] bfType = new byte[]{66, 77};
        int bfSize = 0;
        int bfReserved1 = 0;
        int bfReserved2 = 0;
        int bfOffBits = BITMAPFILEHEADER_SIZE + BITMAPINFOHEADER_SIZE;
        int biSize = BITMAPINFOHEADER_SIZE;
        int biWidth = this.BmpWidth;
        int biHeight = this.BmpHeight;
        int biPlanes = 1;
        short biBitCount = Image.pixelFormatToColorSize(this.PixelFormat);
        int biCompression = 0;
        int biSizeImage = this.ImageSize;
        int biXPelsPerMeter = 0;
        int biYPelsPerMeter = 0;
        int biClrUsed = 0;
        int biClrImportant = 0;
        if (this.Pallete != null) {
            bfOffBits += this.Pallete.length;
        }
        bfSize = bfOffBits + this.ImageSize;
        out.write(bfType);
        out.write(Image.intToDWord(bfSize));
        out.write(Image.intToWord(bfReserved1));
        out.write(Image.intToWord(bfReserved2));
        out.write(Image.intToDWord(bfOffBits));
        out.write(Image.intToDWord(biSize));
        out.write(Image.intToDWord(biWidth));
        out.write(Image.intToDWord(biHeight));
        out.write(Image.intToWord(biPlanes));
        out.write(Image.intToWord(biBitCount));
        out.write(Image.intToDWord(biCompression));
        out.write(Image.intToDWord(biSizeImage));
        out.write(Image.intToDWord(biXPelsPerMeter));
        out.write(Image.intToDWord(biYPelsPerMeter));
        out.write(Image.intToDWord(biClrUsed));
        out.write(Image.intToDWord(biClrImportant));
        if (this.Pallete != null && biBitCount < 16 && this.PixelFormat != 1) {
            out.write(LittleEndian.intArrayToBinary(this.Pallete, this.Pallete.length));
        }
        out.write(this.Bmp);
        out.flush();
    }

    private static byte[] intToWord(int parValue) {
        byte[] retValue = new byte[]{(byte)(parValue & 0xFF), (byte)(parValue >> 8 & 0xFF)};
        return retValue;
    }

    private static byte[] intToDWord(int parValue) {
        byte[] retValue = new byte[]{(byte)(parValue & 0xFF), (byte)(parValue >> 8 & 0xFF), (byte)(parValue >> 16 & 0xFF), (byte)(parValue >> 24 & 0xFF)};
        return retValue;
    }

    public static short pixelFormatToColorSize(int pixelFormat) {
        switch (pixelFormat) {
            case 1: {
                return 1;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 8;
            }
            case 4: {
                return 16;
            }
            case 5: {
                return 16;
            }
            case 6: {
                return 24;
            }
        }
        return 32;
    }
}

