/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes;

import inform.adt.Strings;
import inform.agent.Core;
import inform.agent.ServerSideHost;
import inform.agent.db.connect.ConnectionManager;
import inform.agent.schemes.Attribute;
import inform.agent.schemes.AttributeDef;
import inform.agent.schemes.AttributeRef;
import inform.agent.schemes.BaseGraphic;
import inform.agent.schemes.BaseShape;
import inform.agent.schemes.Ellipse;
import inform.agent.schemes.EmbeddedText;
import inform.agent.schemes.GraphicBlock;
import inform.agent.schemes.Image;
import inform.agent.schemes.Paragraph;
import inform.agent.schemes.PhxGraphicInsert;
import inform.agent.schemes.PhxImage;
import inform.agent.schemes.PhxLayer;
import inform.agent.schemes.Pie;
import inform.agent.schemes.Polygon;
import inform.agent.schemes.Polyline;
import inform.agent.schemes.Primitive;
import inform.agent.schemes.RectTextLine;
import inform.agent.schemes.Rectangle;
import inform.agent.schemes.Region;
import inform.agent.schemes.Scheme;
import inform.agent.schemes.SchemeEngine;
import inform.agent.schemes.SchemeObject;
import inform.agent.schemes.SchemePage;
import inform.agent.schemes.SchemePageLayout;
import inform.agent.schemes.SchemeUtils;
import inform.agent.schemes.Spline;
import inform.agent.schemes.Table;
import inform.agent.schemes.TableCell;
import inform.agent.schemes.TransformProps;
import inform.agent.schemes.converters.odg.content.OdgProperties;
import inform.agent.schemes.converters.odg.content.OdgStyleGraphicsProperties;
import inform.agent.schemes.converters.odg.content.OdgStyleParagraphProperties;
import inform.agent.schemes.converters.odg.content.OdgStyleTextProperties;
import inform.agent.schemes.converters.odg.content.OdgTable;
import inform.agent.schemes.converters.odg.content.OdgUtils;
import inform.agent.web.utils.ImageInfo;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.image4j.codec.ico.ICODecoder;
import net.sf.image4j.codec.ico.ICOImage;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class OdgWriter {
    private final Scheme _scheme;
    private final SchemeEngine _engine;
    private OutputStream out;
    private ServerSideHost stateHost;
    private ZipOutputStream _zipOutputStream;
    private final StringBuilder _Xml = new StringBuilder();
    private final StringBuilder _contentXml = new StringBuilder();
    private final StringBuilder _automaticStylesContent = new StringBuilder();
    private final StringBuilder _fontFaceDeclsContent = new StringBuilder();
    private final StringBuilder _bodyContent = new StringBuilder();
    private final List<OdgItem> _pictureList = new ArrayList<OdgItem>();
    private final StringBuilder _stylesXml = new StringBuilder();
    private final StringBuilder _officeStyles = new StringBuilder();
    private final StringBuilder _officeMasterStyles = new StringBuilder();
    private final StringBuilder _automaticStylesStyles = new StringBuilder();
    private final ArrayList<String> fonts = new ArrayList();
    private final ArrayList<BaseGraphic.RealPoint> origins = new ArrayList();
    private OdgStyleGraphicsProperties gStyle = null;
    private PhxGraphicInsert curInsert = null;
    private double[] scales;
    private double scale = 1.0;
    private double schemeScale = 1.0;
    private double originX;
    private double originY;
    private double height;
    private double width;
    private int countGradientStyles;
    private int countGraphicStyles;
    private int countParagraphStyles;
    private int countTextStyles;
    private int countTableColumnStyles;
    private int countTableRowStyles;
    private int countTableCellStyles;
    private int countFigures = 1;
    private int marginTop;
    private int marginBottom;
    private int marginLeft;
    private int marginRight;
    private boolean isFlatXml;
    private boolean insertMode;
    private static final int VIEWBOX_COEFF = 1000;
    private static final double MAX_PAGE_SIZE = 6000.0;
    private final LinkedHashMap<Double, PhxLayer> layerById = new LinkedHashMap();
    private final LinkedHashMap<String, List<Double>> uniqueLayerName = new LinkedHashMap();
    private final LinkedHashMap<Double, String> layerNameById = new LinkedHashMap();
    private final LinkedList<String> layerName = new LinkedList();
    private final LinkedHashMap<Double, OdgConnect> connectMap = new LinkedHashMap();
    private final LinkedHashMap<Double, Integer> shapeMap = new LinkedHashMap();

    public OdgWriter(Scheme scheme) {
        this._scheme = scheme;
        this._engine = new SchemeEngine(scheme);
        this._engine.InitTmpProps();
    }

    public void setStateHost(ServerSideHost host) {
        this.stateHost = host;
    }

    private void putStateCaption(String caption) throws Exception {
        if (this.stateHost == null) {
            return;
        }
        this.stateHost.putRequestStateCaption(caption);
    }

    private void putStateText(String value) throws Exception {
        if (this.stateHost == null) {
            return;
        }
        this.stateHost.putRequestStateText(value);
    }

    private void putStateProgressPosition(int value) throws Exception {
        if (this.stateHost == null) {
            return;
        }
        this.stateHost.putRequestStateProgressPosition(value);
    }

    public void saveToStream(ConnectionManager dbMgr, OutputStream out, boolean isFlatXml) throws Exception {
        this.out = out;
        this.isFlatXml = isFlatXml;
        this._scheme.parse(dbMgr, true);
        this._scheme.sortObjectsWithConnPoints();
        this._scheme.calcSchemeBounds();
        this.putStateCaption("\u0412\u044b\u043f\u043e\u043b\u043d\u044f\u0435\u0442\u0441\u044f \u044d\u043a\u0441\u043f\u043e\u0440\u0442 \u0441\u0445\u0435\u043c\u044b");
        this.putStateText("\u0421\u0442\u0430\u0442\u0443\u0441: \u043f\u043e\u0434\u0433\u043e\u0442\u0430\u0432\u043b\u0438\u0432\u0430\u0435\u0442\u0441\u044f \u0444\u0430\u0439\u043b");
        if (!isFlatXml) {
            this._zipOutputStream = new ZipOutputStream(out);
            this._zipOutputStream.setMethod(8);
            this.prepareODGFile();
            this.writeDocuments();
            this.finishODGFile();
        } else {
            this.writeDocument();
            this.finishFODGFile();
        }
        this.putStateText("\u0421\u0442\u0430\u0442\u0443\u0441: \u0444\u0430\u0439\u043b \u0441\u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d");
    }

    private void prepareODGFile() throws Exception {
        String[] configFolders = new String[]{"accelerator", "floater", "images", "menubar", "popupmenu", "progressbar", "statusbar", "toolbar", "toolpanel"};
        String MIMETYPE = "application/vnd.oasis.opendocument.graphics";
        this._zipOutputStream.putNextEntry(new ZipEntry("Configurations2/"));
        for (String folder : configFolders) {
            this._zipOutputStream.putNextEntry(new ZipEntry("Configurations2/" + folder + "/"));
        }
        this._zipOutputStream.putNextEntry(new ZipEntry("mimetype"));
        this._zipOutputStream.write("application/vnd.oasis.opendocument.graphics".getBytes(StandardCharsets.UTF_8));
        this._zipOutputStream.putNextEntry(new ZipEntry("meta.xml"));
        this._zipOutputStream.write(this.fillMeta().getBytes(StandardCharsets.UTF_8));
        this._zipOutputStream.putNextEntry(new ZipEntry("settings.xml"));
        this._zipOutputStream.write(this.fillSettings().getBytes(StandardCharsets.UTF_8));
    }

    private void writeDocuments() throws IOException {
        this.writePageLayout();
        this.writeMasterStyles();
        this.writePage();
        this._zipOutputStream.putNextEntry(new ZipEntry("Pictures/"));
        for (OdgItem item : this._pictureList) {
            this._zipOutputStream.putNextEntry(new ZipEntry("Pictures/" + item.name));
            this._zipOutputStream.write(item.bytes);
        }
        this._zipOutputStream.putNextEntry(new ZipEntry("META-INF/"));
        this._zipOutputStream.putNextEntry(new ZipEntry("META-INF/manifest.xml"));
        this._zipOutputStream.write(this.fillManifest().getBytes(StandardCharsets.UTF_8));
    }

    private void writeDocument() {
        this.writePageLayout();
        this.writeMasterStyles();
        this.writePage();
        this._Xml.append(this.meta());
        this._Xml.append(this.setting());
        this._Xml.append("<office:scripts/>");
        this._Xml.append("<office:font-face-decls>").append((CharSequence)this._fontFaceDeclsContent).append("</office:font-face-decls>");
        this._Xml.append("<office:styles>").append((CharSequence)this._officeStyles).append("</office:styles>");
        this._Xml.append("<office:automatic-styles>").append((CharSequence)this._automaticStylesStyles).append((CharSequence)this._automaticStylesContent).append("</office:automatic-styles>");
        this._Xml.append("<office:master-styles>").append((CharSequence)this._officeMasterStyles).append("</office:master-styles>");
        this._Xml.append("<office:body>").append((CharSequence)this._bodyContent).append("</office:body>");
    }

    private void writeStyles() {
        this._stylesXml.append("<office:font-face-decls>").append((CharSequence)this._fontFaceDeclsContent).append("</office:font-face-decls>");
        this._stylesXml.append("<office:styles>").append((CharSequence)this._officeStyles).append("</office:styles>");
        this._stylesXml.append("<office:automatic-styles>").append((CharSequence)this._automaticStylesStyles).append("</office:automatic-styles>");
        this._stylesXml.append("<office:master-styles>").append((CharSequence)this._officeMasterStyles).append("</office:master-styles>");
    }

    private void writeContent() {
        this._contentXml.append("<office:scripts/>");
        this._contentXml.append("<office:font-face-decls>").append((CharSequence)this._fontFaceDeclsContent).append("</office:font-face-decls>");
        this._contentXml.append("<office:automatic-styles>").append((CharSequence)this._automaticStylesContent).append("</office:automatic-styles>");
        this._contentXml.append("<office:body>").append((CharSequence)this._bodyContent).append("</office:body>");
    }

    private void writePage() {
        this._bodyContent.append("<office:drawing>");
        if (this._scheme.Pages.empty()) {
            this._bodyContent.append("<draw:page draw:name=\"page1\" draw:style-name=\"dp1\" draw:master-page-name=\"\u041e\u0431\u044b\u0447\u043d\u044b\u0439\">");
            this.writeObject(null);
            this._bodyContent.append("</draw:page>");
        } else {
            int size = this._scheme.Pages.size();
            block0: for (int idx = 0; idx < size; ++idx) {
                for (SchemePage page : this._scheme.Pages) {
                    if (idx != page.getOrder()) continue;
                    this.scale = this.scales[idx];
                    BaseGraphic.RealPoint point = this.origins.get(idx);
                    this.originX = OdgUtils.asCentimeters(point.X) * this.scale;
                    this.originY = OdgUtils.asCentimeters(point.Y) * this.scale;
                    String drawPage = "<draw:page draw:name=\"%s\" draw:master-page-name=\"PM%d\">";
                    this._bodyContent.append(String.format("<draw:page draw:name=\"%s\" draw:master-page-name=\"PM%d\">", page.getCaption(), idx));
                    this.writeObject(page);
                    this._bodyContent.append("</draw:page>");
                    continue block0;
                }
            }
        }
        this._bodyContent.append("</office:drawing>");
    }

    private void writeObject(SchemePage page) {
        Core.logger.info(String.format("\u0421\u0442\u0430\u0442\u0443\u0441: \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0438\u0440\u0443\u0435\u0442\u0441\u044f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430 '%s'", page == null ? "\u0421\u0442\u0440\u0430\u043d\u0438\u0446\u0430 1" : page.getCaption()));
        List<SchemeObject> schemeObjects = this._scheme.SortShapes;
        if (schemeObjects.size() != 0) {
            for (SchemeObject object : schemeObjects) {
                if (object.BG == null) continue;
                BaseGraphic bg = object.BG;
                SchemeObject layerObj = this._scheme.layerById(bg.LayerID);
                if (layerObj == null || !(layerObj.BG instanceof PhxLayer) || page != null && ((PhxLayer)layerObj.BG).PageId != page.getNormalizeId()) continue;
                this.writeShape(bg, new OdgParent(1.0, 1.0, 1.0, 1.0));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeShape(BaseGraphic bg, OdgParent parent) {
        SchemeObject obj = this._scheme.layerById(bg.LayerID);
        if (obj == null) {
            if (this.curInsert != null) {
                obj = this._scheme.layerById(this.curInsert.LayerID);
            }
            if (obj == null) {
                Core.logger.info("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u043f\u0438\u0441\u0438 \u0444\u0438\u0433\u0443\u0440\u044b");
                return;
            }
        }
        PhxLayer layer = (PhxLayer)obj.BG;
        if (!layer.Exportable || bg.Hidden) {
            return;
        }
        AffineTransform OldGTM = new AffineTransform();
        OldGTM.setTransform(this._engine.GTM);
        double oldAngle = this._engine.tmpAngle;
        if (bg.TransProps != null && bg.TransProps.Angle != 0.0) {
            this._engine.tmpAngle += bg.TransProps.Angle;
        }
        try {
            if (bg.ParentGB == null || !(bg instanceof AttributeRef) || !((AttributeRef)bg).Inscribe) {
                this._engine.GTM.concatenate(SchemeEngine.GenTransform(bg));
            }
            if (bg instanceof Polygon) {
                this.writePolygon((Polygon)bg, parent);
            } else if (bg instanceof Region) {
                this.writeRegion((Region)bg, parent);
            } else if (bg instanceof Spline) {
                this.writeSpline((Spline)bg, parent);
            } else if (bg instanceof Polyline) {
                this.writePolyline((Polyline)bg, parent);
            } else if (bg instanceof Pie) {
                this.writePie((Pie)bg, parent);
            } else if (bg instanceof Ellipse) {
                this.writeEllipse((Ellipse)bg, parent);
            } else if (bg instanceof Attribute) {
                this.writeAttribute((Attribute)bg, parent);
            } else if (bg instanceof Paragraph) {
                this.writeParagraph((Paragraph)bg, parent);
            } else if (bg instanceof Image) {
                this.writeImage((Image)bg, parent);
            } else if (bg instanceof Rectangle) {
                this.writeRectangle((Rectangle)bg, parent);
            } else if (bg instanceof Table) {
                this.writeTable((Table)bg, parent);
            } else if (bg instanceof PhxGraphicInsert) {
                this.writeGraphicInsert((PhxGraphicInsert)bg, parent);
            } else if (bg instanceof GraphicBlock) {
                this.writeGraphicBlock((GraphicBlock)bg, parent);
            }
            if (bg.emText()) {
                EmbeddedText et = bg.EmbeddedText;
                if (!et.Inscribe || bg instanceof GraphicBlock) {
                    et.LayerID = bg.LayerID;
                    this.writeShape(et, parent);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this._engine.GTM.setTransform(OldGTM);
            this._engine.tmpAngle = oldAngle;
            this.gStyle = null;
        }
    }

    private void writeTable(Table table, OdgParent parent) {
        int i;
        String template = "<draw:frame %s %s>%s</draw:frame>";
        String tableTemplate = "<table:table>%s</table:table>";
        String tableColumnTemplate = "<table:table-column table:style-name=\"%s\"/>";
        String tableRowTemplate = "<table:table-row table:style-name=\"%s\">%s</table:table-row>";
        String drawTransform = this.getTransform(table, parent, 0.0, null);
        PhxLayer layer = this.layerById.get(table.LayerID);
        if (layer == null && this.curInsert != null) {
            SchemeObject obj = this._scheme.layerById(this.curInsert.LayerID);
            layer = (PhxLayer)obj.BG;
        }
        StringBuilder gen = new StringBuilder();
        int cnt = table.widths.size();
        for (i = 0; i < cnt; ++i) {
            double width = table.widths.get(i);
            String columnStyleName = this.getStyleName(OdgStyleFamily.COLUMN, new OdgTable.OdgStyleTableColumnProperties(width, this.scale));
            gen.append(String.format(tableColumnTemplate, columnStyleName));
        }
        cnt = table.rows.size();
        for (i = 0; i < cnt; ++i) {
            ArrayList<TableCell> tableCells = table.rows.get(i);
            double height = table.heights.get(i);
            String rowStyleName = this.getStyleName(OdgStyleFamily.ROW, new OdgTable.OdgStyleTableRowProperties(height, this.scale));
            StringBuilder cells = new StringBuilder();
            for (TableCell tableCell : tableCells) {
                if (!tableCell.spanning) {
                    OdgProperties[] properties = new OdgProperties[]{new OdgStyleGraphicsProperties(tableCell, layer, this.scale), new OdgStyleParagraphProperties(table, this.scale)};
                    String cellStyleName = this.getStyleName(OdgStyleFamily.CELL, properties);
                    String cellTemplate = "<table:table-cell table:style-name=\"%s\" %s>%s</table:table-cell>";
                    Object spanned = "";
                    if (tableCell.rowSpan != 1) {
                        spanned = (String)spanned + String.format("table:number-rows-spanned=\"%s\" ", tableCell.rowSpan);
                    }
                    if (tableCell.colSpan != 1) {
                        spanned = (String)spanned + String.format("table:number-columns-spanned=\"%s\"", tableCell.colSpan);
                    }
                    String text = !tableCell.Lines.isEmpty() ? this.getParagraph(tableCell) : "";
                    cells.append(String.format(cellTemplate, cellStyleName, ((String)spanned).trim(), text));
                    continue;
                }
                String cellTemplate = "<table:covered-table-cell/>";
                cells.append(cellTemplate);
            }
            gen.append(String.format(tableRowTemplate, rowStyleName, cells));
        }
        String tableTable = String.format(tableTemplate, gen);
        String drawNames = this.getBaseAttr(table, false);
        this._bodyContent.append(String.format(template, drawNames, drawTransform, tableTable));
    }

    private String getParagraph(TableCell cell) {
        String textSpanTemplate = "<text:span text:style-name=\"%s\">%s</text:span>";
        String textPTemplate = "<text:p text:style-name=\"%s\">%s</text:p>";
        String textSTemplate = "<text:s text:c=\"%s\"/>";
        PhxLayer layer = this.layerById.get(cell.LayerID);
        StringBuilder textP = new StringBuilder();
        StringBuilder textBox = new StringBuilder();
        int cnt = cell.Lines.size();
        for (int i = 0; i < cnt; ++i) {
            RectTextLine line = (RectTextLine)cell.Lines.get(i);
            String styleTextLineName = this.getStyleName(OdgStyleFamily.PARAGRAPH, new OdgStyleParagraphProperties(cell));
            String styleTextName = this.getStyleName(OdgStyleFamily.TEXT, new OdgStyleTextProperties(cell, layer, this.scale));
            if (line.Parts.isEmpty()) {
                String text = this.correctText(line.Text);
                String format = String.format(textSpanTemplate, styleTextName, text);
                textP.append(format);
            } else {
                for (RectTextLine.PartTextLine ptl : line.Parts) {
                    String format;
                    String stylePartTextName = this.getStyleName(OdgStyleFamily.TEXT, new OdgStyleTextProperties(ptl, this.scale));
                    String text = this.correctText(ptl.text);
                    if (text.equals(" ")) {
                        format = String.format(textSpanTemplate, stylePartTextName, "");
                    } else if (text.equals("\t")) {
                        format = "<text:tab/>";
                    } else if (text.isBlank()) {
                        String textS = String.format(textSTemplate, text.length());
                        format = String.format(textSpanTemplate, stylePartTextName, textS);
                    } else {
                        StringBuilder subtextBuilder = new StringBuilder();
                        StringBuilder textPBuilder = new StringBuilder();
                        int spaceCount = 0;
                        for (char c : text.toCharArray()) {
                            if (c == ' ') {
                                if (subtextBuilder.length() != 0) {
                                    textPBuilder.append((CharSequence)subtextBuilder);
                                    subtextBuilder.setLength(0);
                                }
                                ++spaceCount;
                                continue;
                            }
                            subtextBuilder.append(c);
                            if (spaceCount > 1) {
                                textPBuilder.append(String.format(textSTemplate, spaceCount));
                            } else if (spaceCount == 1) {
                                textPBuilder.append(" ");
                            }
                            spaceCount = 0;
                        }
                        if (subtextBuilder.length() != 0) {
                            textPBuilder.append((CharSequence)subtextBuilder);
                            subtextBuilder.setLength(0);
                        }
                        format = String.format(textSpanTemplate, stylePartTextName, textPBuilder);
                    }
                    textP.append(format);
                }
            }
            textBox.append(String.format(textPTemplate, styleTextLineName, textP));
            textP.setLength(0);
        }
        return textBox.toString();
    }

    private void writeGraphicInsert(PhxGraphicInsert phx, OdgParent parent) {
        String xCaption;
        Primitive prim = this._scheme.findPrimInLibsById(phx.SourceID, phx.LibID);
        if (prim == null || prim.BG == null) {
            return;
        }
        this.curInsert = phx;
        GraphicBlock primBlock = (GraphicBlock)prim.BG;
        if (phx.getInternalPrimGraphicBlock() != null) {
            primBlock = phx.getInternalPrimGraphicBlock();
        }
        if (primBlock == null || primBlock.Objects == null || primBlock.Objects.isEmpty()) {
            return;
        }
        if (phx.TransProps != null) {
            if (primBlock.TransProps == null) {
                primBlock.TransProps = new TransformProps();
            }
            primBlock.TransProps.ScaleX *= phx.TransProps.ScaleX;
            primBlock.TransProps.ScaleY *= phx.TransProps.ScaleY;
        }
        String template = "<draw:g%s>";
        String string = xCaption = phx.StringProps == null ? "" : this.correctText(phx.StringProps.Caption);
        if (!xCaption.equals("")) {
            String str = " draw:name=\"%s\"";
            xCaption = String.format(str, xCaption);
        }
        this._bodyContent.append(String.format(template, xCaption));
        if (primBlock.BlockParams.isEmpty()) {
            primBlock.BlockParams = prim.PrimParams;
        }
        double pwcScaleX = parent.parentWidthCoeff;
        double pwcScaleY = parent.parentHeightCoeff;
        OdgParent newParent = new OdgParent(pwcScaleX, pwcScaleY);
        this.insertMode = true;
        this.writeGraphicBlock(primBlock, newParent);
        this.insertMode = false;
        this._bodyContent.append("</draw:g>");
        ArrayList<BaseGraphic> Attributes2 = phx.Attributes;
        if (Attributes2 != null && !Attributes2.isEmpty()) {
            for (BaseGraphic attribute : Attributes2) {
                Attribute attr = (Attribute)attribute;
                if (attr.invisible() || attr.getText().isEmpty()) continue;
                if (attr.Inscribe && !attr.AutoSize) {
                    if (attr.getEngine() == null) {
                        attr.setEngine(this._engine);
                    }
                    attr.setInscribeExt(phx, true, true, false);
                }
                this.writeShape(attr, new OdgParent(1.0, 1.0, 1.0, 1.0));
            }
        }
    }

    private void writeGraphicBlock(GraphicBlock block, OdgParent parent) {
        BaseGraphic child;
        int i;
        String xCaption;
        if (block.Objects == null || block.Objects.isEmpty()) {
            return;
        }
        String template = "<draw:g%s>";
        String string = xCaption = block.StringProps == null ? "" : this.correctText(block.StringProps.Caption);
        if (!xCaption.equals("")) {
            String str = " draw:name=\"%s\"";
            xCaption = String.format(str, xCaption);
        }
        this._bodyContent.append(String.format(template, xCaption));
        int cnt = block.Objects.size();
        for (i = 0; i < cnt; ++i) {
            child = block.Objects.get(i);
            if (child instanceof AttributeDef || child instanceof AttributeRef) continue;
            if (child.TransProps == null) {
                child.TransProps = new TransformProps();
            }
            double pwcScaleX = parent.parentWidthCoeff;
            double pwcScaleY = parent.parentHeightCoeff;
            OdgParent newParent = new OdgParent(pwcScaleX, pwcScaleY);
            this.writeShape(child, newParent);
        }
        this._bodyContent.append("</draw:g>");
        cnt = block.Objects.size();
        for (i = 0; i < cnt; ++i) {
            AttributeDef attr;
            child = block.Objects.get(i);
            if (child == null || !(child instanceof AttributeDef) || this.insertMode || (attr = (AttributeDef)child).invisible() || attr.getText().isEmpty()) continue;
            if (attr.Inscribe && !attr.AutoSize && attr.getEngine() == null) {
                attr.setEngine(this._engine);
            }
            this.writeShape(child, new OdgParent(1.0, 1.0, 1.0, 1.0));
        }
    }

    private void writeImage(Image image, OdgParent parent) throws Exception {
        String drawImage;
        String drawImageTemplate;
        byte[] content = image instanceof PhxImage ? ((PhxImage)image).Content : image.Bmp;
        if (content == null || content.length <= 0) {
            this.writeRectangle(image, parent);
            return;
        }
        double angle = image.TransProps == null ? 0.0 : image.TransProps.Angle;
        String template = "<draw:frame draw:style-name=\"%s\" %s %s>%s%s</draw:frame>";
        String drawTransform = this.getTransform(image, parent, angle, null);
        String drawGluePoints = this.getGluePoints(image);
        String drawText = this.getEmbeddedText(image);
        String drawNames = this.getBaseAttr(image, true);
        PhxLayer layer = this.layerById.get(image.LayerID);
        if (layer == null && this.curInsert != null) {
            SchemeObject obj = this._scheme.layerById(this.curInsert.LayerID);
            layer = (PhxLayer)obj.BG;
        }
        ByteArrayInputStream in = new ByteArrayInputStream(content);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ImageInfo ii = new ImageInfo();
        ii.setInput(in);
        String fileformat = null;
        if (ii.check()) {
            out.write(content);
            fileformat = ii.getFormatName().toLowerCase();
        } else {
            ByteArrayInputStream bis;
            List images;
            boolean isICO = false;
            int idReserved = this.getShortLittleEndian(content, 0);
            int idType = this.getShortLittleEndian(content, 2);
            if (idReserved == 0 && idType == 1 && !(images = ICODecoder.readExt((InputStream)(bis = new ByteArrayInputStream(content)))).isEmpty()) {
                fileformat = "png";
                isICO = true;
                ICOImage img = (ICOImage)images.get(0);
                if (!img.isPngCompressed()) {
                    img.setPngCompressed(true);
                }
                ImageIO.write((RenderedImage)img.getImage(), fileformat, out);
            }
            if (!isICO) {
                fileformat = "bmp";
                image.saveBitmapToStream(out);
            }
        }
        if (SchemeUtils.hasCrop(image)) {
            String fileFormat = ii.getFormatName().toLowerCase();
            out = SchemeUtils.cropImage(out.toByteArray(), image, fileFormat);
        }
        content = out.toByteArray();
        if (this.isFlatXml) {
            drawImageTemplate = "<draw:image draw:mime-type=\"image/%s\"><office:binary-data>%s</office:binary-data>%s</draw:image>";
            String encode = Base64.getEncoder().encodeToString(content);
            String[] parts = encode.split("(?<=\\G.{72})");
            StringBuilder base64text = new StringBuilder();
            for (String part : parts) {
                base64text.append(part).append(" ");
            }
            drawImage = String.format(drawImageTemplate, fileformat, base64text, drawText);
        } else {
            drawImageTemplate = "<draw:image xlink:href=\"%s\" xlink:type=\"simple\" xlink:show=\"embed\" xlink:actuate=\"onLoad\" draw:mime-type=\"image/%s\">%s</draw:image>";
            String filename = "image" + (this._pictureList.size() + 1) + "." + fileformat;
            OdgItem item = new OdgItem();
            item.setBytes(content);
            item.setName(filename);
            item.setFormat(fileformat);
            this._pictureList.add(item);
            drawImage = String.format(drawImageTemplate, "Pictures/" + filename, fileformat, drawText);
        }
        String drawFrame = String.format(template, this.getStyleName(OdgStyleFamily.GRAPHIC, new OdgStyleGraphicsProperties(image, layer)), drawNames, drawTransform, drawImage, drawGluePoints);
        this._bodyContent.append(drawFrame);
    }

    private int getShortLittleEndian(byte[] a, int offs) {
        return a[offs] & 0xFF | (a[offs + 1] & 0xFF) << 8;
    }

    private void correctAttributes(Attribute attr) {
        double scaleX = 1.0;
        double scaleY = 1.0;
        BaseGraphic tmpBG = attr;
        while (tmpBG.ParentGB != null) {
            tmpBG = tmpBG.ParentGB;
            if (tmpBG.TransProps == null) {
                tmpBG.TransProps = new TransformProps();
            }
            scaleX *= tmpBG.TransProps.ScaleX;
            scaleY *= tmpBG.TransProps.ScaleY;
        }
        if (attr.Inscribe) {
            int type = attr.ParentGB.shapeType();
            if (type != 202) {
                return;
            }
            GraphicBlock gb = (GraphicBlock)attr.ParentGB;
            attr.SideX = (gb.MaxPtX - gb.MinPtX) * scaleX;
            attr.SideY = (gb.MaxPtY - gb.MinPtY) * scaleY;
        }
        AffineTransform tm = new AffineTransform();
        tm.setToScale(1.0 / scaleX, 1.0 / scaleY);
        this._engine.GTM.concatenate(tm);
    }

    private void writeAttribute(Attribute attribute, OdgParent parent) {
        if (attribute.invisible()) {
            return;
        }
        if (attribute.ParentGB != null) {
            this.correctAttributes(attribute);
            if (attribute.AutoSize && attribute.Inscribe) {
                attribute.VertAlign = 2;
            }
        }
        this.writeParagraph(attribute, parent);
    }

    private void writeParagraph(Paragraph paragraph, OdgParent parent) {
        if (paragraph.Lines == null) {
            return;
        }
        if (paragraph.Lines.isEmpty()) {
            return;
        }
        double angle = paragraph.TransProps == null ? 0.0 : paragraph.TransProps.Angle;
        String template = "<draw:frame draw:style-name=\"%s\" draw:text-style-name=\"%s\" %s %s>%s%s</draw:frame>";
        String textBoxTemplate = "<draw:text-box>%s</draw:text-box>";
        String textSTemplate = "<text:s text:c=\"%s\"/>";
        String textSpanTemplate = "<text:span text:style-name=\"%s\">%s</text:span>";
        String textPTemplate = "<text:p text:style-name=\"%s\">%s</text:p>";
        PhxLayer layer = this.layerById.get(paragraph.LayerID);
        if (layer == null && this.curInsert != null) {
            SchemeObject obj = this._scheme.layerById(this.curInsert.LayerID);
            layer = (PhxLayer)obj.BG;
        }
        StringBuilder textP = new StringBuilder();
        StringBuilder textBox = new StringBuilder();
        int cnt = paragraph.Lines.size();
        for (int i = 0; i < cnt; ++i) {
            RectTextLine line = (RectTextLine)paragraph.Lines.get(i);
            line.parentParagraph = paragraph;
            String styleTextLineName = this.getStyleName(OdgStyleFamily.PARAGRAPH, new OdgStyleParagraphProperties(line, this.schemeScale));
            String styleTextName = this.getStyleName(OdgStyleFamily.TEXT, new OdgStyleTextProperties(paragraph, layer, this.scale));
            if (line.Parts.isEmpty()) {
                String text = this.correctText(line.Text);
                String format = String.format(textSpanTemplate, styleTextName, text);
                textP.append(format);
            } else {
                for (RectTextLine.PartTextLine ptl : line.Parts) {
                    String format;
                    String stylePartTextName = this.getStyleName(OdgStyleFamily.TEXT, new OdgStyleTextProperties(ptl, this.scale));
                    String text = this.correctText(ptl.text);
                    if (text.equals(" ")) {
                        format = String.format(textSpanTemplate, stylePartTextName, " ");
                    } else if (text.equals("\t")) {
                        format = "<text:tab/>";
                    } else if (text.isBlank()) {
                        String textS = String.format(textSTemplate, text.length());
                        format = String.format(textSpanTemplate, stylePartTextName, textS);
                    } else {
                        StringBuilder subtextBuilder = new StringBuilder();
                        StringBuilder textPBuilder = new StringBuilder();
                        int spaceCount = 0;
                        for (char c : text.toCharArray()) {
                            if (c == ' ') {
                                if (subtextBuilder.length() != 0) {
                                    textPBuilder.append((CharSequence)subtextBuilder);
                                    subtextBuilder.setLength(0);
                                }
                                ++spaceCount;
                                continue;
                            }
                            subtextBuilder.append(c);
                            if (spaceCount > 1) {
                                textPBuilder.append(String.format(textSTemplate, spaceCount));
                            } else if (spaceCount == 1) {
                                textPBuilder.append(" ");
                            }
                            spaceCount = 0;
                        }
                        if (spaceCount > 1) {
                            textPBuilder.append(String.format(textSTemplate, spaceCount));
                        } else if (spaceCount == 1) {
                            textPBuilder.append(" ");
                        }
                        if (subtextBuilder.length() != 0) {
                            textPBuilder.append((CharSequence)subtextBuilder);
                            subtextBuilder.setLength(0);
                        }
                        format = String.format(textSpanTemplate, stylePartTextName, textPBuilder);
                    }
                    textP.append(format);
                }
            }
            textBox.append(String.format(textPTemplate, styleTextLineName, textP));
            textP.setLength(0);
        }
        String styleParagraphName = this.getStyleName(OdgStyleFamily.PARAGRAPH, new OdgStyleParagraphProperties(paragraph));
        OdgStyleGraphicsProperties gStyle = new OdgStyleGraphicsProperties(paragraph, layer, this.scale * this.schemeScale);
        String styleGraphicName = this.getStyleName(OdgStyleFamily.GRAPHIC, gStyle);
        this.gStyle = gStyle;
        String drawTransform = this.getTransform(paragraph, parent, angle, null);
        String drawNames = this.getBaseAttr(paragraph, true);
        String drawGluePoints = this.getGluePoints(paragraph);
        String drawTextBox = String.format(textBoxTemplate, textBox);
        String drawFrame = String.format(template, styleGraphicName, styleParagraphName, drawNames, drawTransform, drawTextBox, drawGluePoints);
        this._bodyContent.append(drawFrame);
    }

    private String correctText(String text) {
        if (Strings.isVoid(text)) {
            return " ";
        }
        StringBuilder tmp = new StringBuilder();
        block7: for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '\"': {
                    tmp.append("&quot;");
                    continue block7;
                }
                case '&': {
                    tmp.append("&amp;");
                    continue block7;
                }
                case '<': {
                    tmp.append("&lt;");
                    continue block7;
                }
                case '>': {
                    tmp.append("&gt;");
                    continue block7;
                }
                case '\u2028': {
                    tmp.append('\n');
                    continue block7;
                }
                default: {
                    tmp.append(c);
                }
            }
        }
        return tmp.toString();
    }

    private void writePie(Pie pie, OdgParent parent) {
        double angle = pie.TransProps == null ? 0.0 : pie.TransProps.Angle;
        String template = null;
        switch (pie.PieType) {
            case 0: {
                template = "<draw:circle draw:style-name=\"%s\" %s %s draw:kind=\"arc\" draw:start-angle=\"%s\" draw:end-angle=\"%s\">%s%s</draw:circle>";
                break;
            }
            case 1: {
                this.writeMsoSpt100(pie, parent);
                return;
            }
            case 2: {
                template = "<draw:ellipse draw:style-name=\"%s\" %s %s draw:kind=\"cut\" draw:start-angle=\"%s\" draw:end-angle=\"%s\">%s%s</draw:ellipse>";
                break;
            }
        }
        if (template == null) {
            return;
        }
        String drawTransform = this.getTransform(pie, parent, angle, null);
        String drawGluePoints = this.getGluePoints(pie);
        String drawText = this.getEmbeddedText(pie);
        String drawNames = this.getBaseAttr(pie, true);
        PhxLayer layer = this.layerById.get(pie.LayerID);
        if (layer == null && this.curInsert != null) {
            SchemeObject obj = this._scheme.layerById(this.curInsert.LayerID);
            layer = (PhxLayer)obj.BG;
        }
        double startAngle = Math.ceil(Math.toDegrees(Math.PI * 2 - pie.StartAngle));
        double endAngle = Math.ceil(Math.toDegrees(Math.PI * 2 - pie.EndAngle));
        String drawCustomShape = String.format(template, this.getStyleName(OdgStyleFamily.GRAPHIC, new OdgStyleGraphicsProperties(pie, layer, this.scale)), drawNames, drawTransform, startAngle, endAngle, drawGluePoints, drawText);
        this._bodyContent.append(drawCustomShape);
    }

    private void writeMsoSpt100(Pie pie, OdgParent parent) {
        String enhancedGeometryTemplate = "<draw:enhanced-geometry svg:viewBox=\"0 0 21600 21600\" draw:type=\"mso-spt100\" draw:modifiers=\"%s %s\" draw:enhanced-path=\"V 0 0 21600 21600 ?f5 ?f7 ?f1 ?f3 L 10800 10800 Z N\"><draw:equation draw:name=\"f0\" draw:formula=\"10800*cos($0 *(pi/180))\"/><draw:equation draw:name=\"f1\" draw:formula=\"?f0 +10800\"/><draw:equation draw:name=\"f2\" draw:formula=\"10800*sin($0 *(pi/180))\"/><draw:equation draw:name=\"f3\" draw:formula=\"?f2 +10800\"/><draw:equation draw:name=\"f4\" draw:formula=\"10800*cos($1 *(pi/180))\"/><draw:equation draw:name=\"f5\" draw:formula=\"?f4 +10800\"/><draw:equation draw:name=\"f6\" draw:formula=\"10800*sin($1 *(pi/180))\"/><draw:equation draw:name=\"f7\" draw:formula=\"?f6 +10800\"/><draw:handle draw:handle-position=\"10800 $0\" draw:handle-polar=\"10800 10800\" draw:handle-radius-range-minimum=\"10800\" draw:handle-radius-range-maximum=\"10800\"/><draw:handle draw:handle-position=\"10800 $1\" draw:handle-polar=\"10800 10800\" draw:handle-radius-range-minimum=\"10800\" draw:handle-radius-range-maximum=\"10800\"/></draw:enhanced-geometry>";
        if (pie.StartAngle > Math.PI) {
            pie.StartAngle -= Math.PI * 2;
        }
        if (pie.EndAngle > Math.PI) {
            pie.EndAngle -= Math.PI * 2;
        }
        double startAngle = Math.toDegrees(pie.StartAngle);
        double engAngle = Math.toDegrees(pie.EndAngle);
        this.writeCustomShape(pie, String.format(enhancedGeometryTemplate, startAngle, engAngle), parent);
    }

    private void writeRectangle(Rectangle rectangle, OdgParent parent) {
        String enhancedGeometryTemplate = "<draw:enhanced-geometry svg:viewBox=\"0 0 21600 21600\" draw:type=\"rectangle\" draw:enhanced-path=\"M 0 0 L 21600 0 21600 21600 0 21600 0 0 Z N\"/>";
        this.writeCustomShape(rectangle, enhancedGeometryTemplate, parent);
    }

    private void writeEllipse(Ellipse ellipse, OdgParent parent) {
        String enhancedGeometryTemplate = "<draw:enhanced-geometry svg:viewBox=\"0 0 21600 21600\" draw:type=\"ellipse\" draw:enhanced-path=\"U 10800 10800 10800 10800 0 360 Z N\"/>";
        this.writeCustomShape(ellipse, enhancedGeometryTemplate, parent);
    }

    private void writeCustomShape(Rectangle rectangle, String enhancedGeometry, OdgParent parent) {
        double angle = rectangle.TransProps == null ? 0.0 : rectangle.TransProps.Angle;
        String template = "<draw:custom-shape draw:style-name=\"%s\" %s %s>%s%s%s</draw:custom-shape>";
        String drawTransform = this.getTransform(rectangle, parent, angle, null);
        String drawGluePoints = this.getGluePoints(rectangle);
        String drawText = this.getEmbeddedText(rectangle);
        String drawNames = this.getBaseAttr(rectangle, true);
        PhxLayer layer = this.layerById.get(rectangle.LayerID);
        if (layer == null && this.curInsert != null) {
            SchemeObject obj = this._scheme.layerById(this.curInsert.LayerID);
            layer = (PhxLayer)obj.BG;
        }
        String drawCustomShape = String.format(template, this.getStyleName(OdgStyleFamily.GRAPHIC, new OdgStyleGraphicsProperties(rectangle, layer, this.scale)), drawNames, drawTransform, drawGluePoints, drawText, enhancedGeometry);
        this._bodyContent.append(drawCustomShape);
    }

    private void writePolygon(Polygon polygon, OdgParent parent) {
        double[] points = polygon.Points;
        double[] pts = SchemeEngine.MulPointsTM(this._engine.GTM, points);
        double angle = polygon.TransProps == null ? 0.0 : polygon.TransProps.Angle;
        String template = "<draw:path draw:style-name=\"%s\" %s %s>%s%s</draw:path>";
        String drawTransform = this.getTransform(polygon, parent, angle, pts);
        String drawGluePoints = this.getGluePoints(polygon);
        String drawText = this.getEmbeddedText(polygon);
        String drawNames = this.getBaseAttr(polygon, true);
        PhxLayer layer = this.layerById.get(polygon.LayerID);
        if (layer == null && this.curInsert != null) {
            SchemeObject obj = this._scheme.layerById(this.curInsert.LayerID);
            layer = (PhxLayer)obj.BG;
        }
        String drawPolygon = String.format(template, this.getStyleName(OdgStyleFamily.GRAPHIC, new OdgStyleGraphicsProperties(polygon, layer, this.scale)), drawNames, drawTransform, drawGluePoints, drawText);
        this._bodyContent.append(drawPolygon);
    }

    private void writeSpline(Spline spline, OdgParent parent) {
        double[] points = spline.Points;
        double[] pts = SchemeEngine.MulPointsTM(this._engine.GTM, points);
        double angle = spline.TransProps == null ? 0.0 : spline.TransProps.Angle;
        String template = "<draw:path draw:style-name=\"%s\" %s %s>%s<text:p/></draw:path>";
        String drawTransform = this.getTransform(spline, parent, angle, pts);
        String drawGluePoints = this.getGluePoints(spline);
        String drawText = this.getEmbeddedText(spline);
        String drawNames = this.getBaseAttr(spline, true);
        PhxLayer layer = this.layerById.get(spline.LayerID);
        if (layer == null && this.curInsert != null) {
            SchemeObject obj = this._scheme.layerById(this.curInsert.LayerID);
            layer = (PhxLayer)obj.BG;
        }
        String drawSpline = String.format(template, this.getStyleName(OdgStyleFamily.GRAPHIC, new OdgStyleGraphicsProperties(spline, layer, this.scale)), drawNames, drawTransform, drawGluePoints, drawText);
        this._bodyContent.append(drawSpline);
    }

    private void writeRegion(Region region, OdgParent parent) {
        double[] points = region.Points;
        double[] pts = SchemeEngine.MulPointsTM(this._engine.GTM, points);
        double angle = region.TransProps == null ? 0.0 : region.TransProps.Angle;
        String template = "<draw:path draw:style-name=\"%s\" %s %s>%s<text:p/></draw:path>";
        String drawTransform = this.getTransform(region, parent, angle, pts);
        String drawGluePoints = this.getGluePoints(region);
        String drawText = this.getEmbeddedText(region);
        String drawNames = this.getBaseAttr(region, true);
        PhxLayer layer = this.layerById.get(region.LayerID);
        if (layer == null && this.curInsert != null) {
            SchemeObject obj = this._scheme.layerById(this.curInsert.LayerID);
            layer = (PhxLayer)obj.BG;
        }
        String drawRegion = String.format(template, this.getStyleName(OdgStyleFamily.GRAPHIC, new OdgStyleGraphicsProperties(region, layer, this.scale)), drawNames, drawTransform, drawGluePoints, drawText);
        this._bodyContent.append(drawRegion);
    }

    private void writePolyline(Polyline polyline, OdgParent parent) {
        double[] points = polyline.Points;
        double[] pts = SchemeEngine.MulPointsTM(this._engine.GTM, points);
        double angle = polyline.TransProps == null ? 0.0 : polyline.TransProps.Angle;
        PhxLayer layer = this.layerById.get(polyline.LayerID);
        if (layer == null && this.curInsert != null) {
            SchemeObject obj = this._scheme.layerById(this.curInsert.LayerID);
            layer = (PhxLayer)obj.BG;
        }
        String drawText = this.getEmbeddedText(polyline);
        if (polyline.ConnectorView != 0 && polyline.GluePoints != null) {
            OdgConnect connect;
            OdgConnect connect2;
            String drawTransform = this.getTransform(polyline, OdgDraw.CONNECTOR, parent, angle, pts);
            Object drawConnect = "";
            BaseGraphic.GluePoint startPoint = (BaseGraphic.GluePoint)polyline.GluePoints.get(0);
            if (startPoint.joinId != 0.0 && (connect2 = this.connectMap.get(startPoint.joinId)) != null) {
                Integer id = this.shapeMap.get(connect2.shapeId);
                String startShapeTemplate = " draw:start-shape=\"id%s\" draw:start-glue-point=\"%s\"";
                drawConnect = (String)drawConnect + String.format(startShapeTemplate, id, connect2.index);
            }
            BaseGraphic.GluePoint endPoint = (BaseGraphic.GluePoint)polyline.GluePoints.get(1);
            if (endPoint.joinId != 0.0 && (connect = this.connectMap.get(endPoint.joinId)) != null) {
                Integer id = this.shapeMap.get(connect.shapeId);
                String endShapeTemplate = " draw:end-shape=\"id%s\" draw:end-glue-point=\"%s\"";
                drawConnect = (String)drawConnect + String.format(endShapeTemplate, id, connect.index);
            }
            String drawNames = this.getBaseAttr(polyline, false);
            String template = "<draw:connector draw:style-name=\"%s\" %s %s %s>%s</draw:connector>";
            String drawConnector = String.format(template, this.getStyleName(OdgStyleFamily.GRAPHIC, new OdgStyleGraphicsProperties(polyline, layer, this.scale)), drawNames, drawTransform, drawConnect, drawText);
            this._bodyContent.append(drawConnector);
        } else if (pts.length == 4) {
            String drawTransform = this.getTransform(polyline, OdgDraw.LINE, parent, angle, pts);
            String drawGluePoints = this.getGluePoints(polyline);
            String drawNames = this.getBaseAttr(polyline, true);
            String template = "<draw:line draw:style-name=\"%s\" %s %s>%s%s</draw:line>";
            String drawLine = String.format(template, this.getStyleName(OdgStyleFamily.GRAPHIC, new OdgStyleGraphicsProperties(polyline, layer, this.scale)), drawNames, drawTransform, drawGluePoints, drawText);
            this._bodyContent.append(drawLine);
        } else {
            String drawTransform = this.getTransform(polyline, parent, angle, pts);
            String drawGluePoints = this.getGluePoints(polyline);
            String drawNames = this.getBaseAttr(polyline, true);
            String template = "<draw:polyline draw:style-name=\"%s\" %s %s>%s%s</draw:polyline>";
            String drawPolyline = String.format(template, this.getStyleName(OdgStyleFamily.GRAPHIC, new OdgStyleGraphicsProperties(polyline, layer, this.scale)), drawNames, drawTransform, drawGluePoints, drawText);
            this._bodyContent.append(drawPolyline);
        }
    }

    private String getEmbeddedText(BaseGraphic bg) {
        if (!bg.emText() || !bg.EmbeddedText.Inscribe) {
            return "<text:p/>";
        }
        EmbeddedText et = bg.EmbeddedText;
        String textSTemplate = "<text:s text:c=\"%s\"/>";
        String textSpanTemplate = "<text:span text:style-name=\"%s\">%s</text:span>";
        String textPTemplate = "<text:p text:style-name=\"%s\">%s</text:p>";
        StringBuilder textP = new StringBuilder();
        StringBuilder textBox = new StringBuilder();
        PhxLayer layer = this.layerById.get(bg.LayerID);
        int cnt = et.Lines.size();
        for (int i = 0; i < cnt; ++i) {
            RectTextLine line = (RectTextLine)et.Lines.get(i);
            line.parentParagraph = et;
            String styleTextLineName = this.getStyleName(OdgStyleFamily.PARAGRAPH, new OdgStyleParagraphProperties(line, this.schemeScale));
            String styleTextName = this.getStyleName(OdgStyleFamily.TEXT, new OdgStyleTextProperties(et, layer, this.scale));
            if (line.Parts.isEmpty()) {
                String text = this.correctText(line.Text);
                String format = String.format(textSpanTemplate, styleTextName, text);
                textP.append(format);
            } else {
                for (RectTextLine.PartTextLine ptl : line.Parts) {
                    String format;
                    String stylePartTextName = this.getStyleName(OdgStyleFamily.TEXT, new OdgStyleTextProperties(ptl, this.scale));
                    String text = this.correctText(ptl.text);
                    if (text.equals(" ")) {
                        format = String.format(textSpanTemplate, stylePartTextName, " ");
                    } else if (text.equals("\t")) {
                        format = "<text:tab/>";
                    } else if (text.isBlank()) {
                        String textS = String.format(textSTemplate, text.length());
                        format = String.format(textSpanTemplate, stylePartTextName, textS);
                    } else {
                        StringBuilder subtextBuilder = new StringBuilder();
                        StringBuilder textPBuilder = new StringBuilder();
                        int spaceCount = 0;
                        for (char c : text.toCharArray()) {
                            if (c == ' ') {
                                if (subtextBuilder.length() != 0) {
                                    textPBuilder.append((CharSequence)subtextBuilder);
                                    subtextBuilder.setLength(0);
                                }
                                ++spaceCount;
                                continue;
                            }
                            subtextBuilder.append(c);
                            if (spaceCount > 1) {
                                textPBuilder.append(String.format(textSTemplate, spaceCount));
                            } else if (spaceCount == 1) {
                                textPBuilder.append(" ");
                            }
                            spaceCount = 0;
                        }
                        if (spaceCount > 1) {
                            textPBuilder.append(String.format(textSTemplate, spaceCount));
                        } else if (spaceCount == 1) {
                            textPBuilder.append(" ");
                        }
                        if (subtextBuilder.length() != 0) {
                            textPBuilder.append((CharSequence)subtextBuilder);
                            subtextBuilder.setLength(0);
                        }
                        format = String.format(textSpanTemplate, stylePartTextName, textPBuilder);
                    }
                    textP.append(format);
                }
            }
            textBox.append(String.format(textPTemplate, styleTextLineName, textP));
            textP.setLength(0);
        }
        return textBox.toString();
    }

    private String getGluePoints(BaseShape shape) {
        if (shape.GluePoints == null) {
            return "";
        }
        if (shape.TransProps == null) {
            shape.TransProps = new TransformProps();
        }
        String template = "<draw:glue-point draw:id=\"%s\" svg:x=\"%scm\" svg:y=\"%scm\"/>";
        StringBuilder builder = new StringBuilder();
        int defaultPoint = 4;
        AffineTransform emptyTm = new AffineTransform();
        if (shape.TransProps != null) {
            double angle = SchemeEngine.NormAngle(shape.TransProps.Angle) * Math.PI / 180.0;
            angle = this.transformRadian(angle);
            emptyTm.rotate(angle);
        }
        for (BaseGraphic.GluePoint point : shape.GluePoints) {
            this.connectMap.put(point.joinId, new OdgConnect(shape.ID, defaultPoint));
            double[] pts = SchemeEngine.MulPointsTM(emptyTm, new double[]{point.ptX, point.ptY});
            double pointX = pts[0] * 100.0 / this.width;
            double pointY = pts[1] * 100.0 / this.height;
            String value = String.format(template, defaultPoint++, OdgUtils.asCentimeters(pointX), OdgUtils.asCentimeters(pointY));
            builder.append(value);
        }
        if (shape.DynamicGluePoint != null) {
            BaseGraphic.GluePoint point = shape.DynamicGluePoint;
            this.connectMap.put(point.joinId, new OdgConnect(shape.ID, -1));
        }
        return builder.toString();
    }

    private String getBaseAttr(BaseGraphic shape, boolean hasConnection) {
        String caption;
        String layerName = this.layerNameById.getOrDefault(shape.LayerID, "layout");
        StringBuilder layerTemplate = new StringBuilder(String.format("draw:layer=\"%s\"", layerName));
        if (shape.StringProps != null && (caption = this.correctText(shape.StringProps.Caption)) != null) {
            layerTemplate.append(String.format(" draw:name=\"%s\"", caption));
        }
        if (hasConnection && (shape.GluePoints != null || shape.DynamicGluePoint != null)) {
            layerTemplate.append(String.format(" xml:id=\"id%d\" draw:id=\"id%d\"", this.countFigures, this.countFigures));
            this.shapeMap.put(shape.ID, this.countFigures);
            ++this.countFigures;
        }
        return layerTemplate.toString();
    }

    private String getTransform(BaseGraphic graphic, OdgParent parent, double angle, double[] points) {
        return this.getTransform(graphic, OdgDraw.NONE, parent, angle, points);
    }

    private double normalizeParagraphSizeX(double sideX, Paragraph para) {
        double naturalSide = para.LeftMargin + para.RightMargin + para.exportSidesX;
        if (sideX < naturalSide) {
            sideX = naturalSide;
        }
        return sideX;
    }

    private double normalizeParagraphSizeY(double sideY, Paragraph para) {
        if (para.VertAlign == 0) {
            if (sideY < para.TopMargin) {
                sideY = para.TopMargin + para.exportSidesY;
            }
            if (sideY < para.BottomMargin + para.TopMargin) {
                sideY += para.BottomMargin + para.exportSidesY;
            }
        } else {
            double naturalSide = para.BottomMargin + para.TopMargin + para.exportSidesY;
            if (sideY < naturalSide) {
                sideY = naturalSide;
            }
        }
        return sideY;
    }

    private String getTransform(BaseGraphic graphic, OdgDraw draw, OdgParent parent, double angle, double[] points) {
        BaseShape shape;
        double scaleX = graphic.TransProps == null ? 1.0 : graphic.TransProps.ScaleX;
        double scaleY = graphic.TransProps == null ? 1.0 : graphic.TransProps.ScaleY;
        parent.scaleX *= scaleX;
        parent.scaleY *= scaleY;
        StringBuilder builder = new StringBuilder();
        if (points != null) {
            shape = (BaseShape)graphic;
            for (int i = 0; i < points.length - 1; i += 2) {
                double coeffPointX = OdgUtils.asCentimeters(points[i]) * parent.parentWidthCoeff * this.scale;
                points[i] = coeffPointX - this.originX;
                double coeffPointY = OdgUtils.asCentimeters(points[i + 1]) * parent.parentHeightCoeff * this.scale;
                points[i + 1] = coeffPointY - this.originY;
            }
            String value = this.getPoints(shape, draw, (double[])points.clone());
            builder.append(value);
            String figureName = draw.name;
            if (figureName.equals(OdgDraw.CONNECTOR.name) || figureName.equals(OdgDraw.LINE.name)) {
                return builder.toString();
            }
        }
        if (graphic instanceof Rectangle) {
            Rectangle rectangle = (Rectangle)graphic;
            double sideX = rectangle.SideX;
            double sideY = rectangle.SideY;
            if (graphic instanceof Paragraph) {
                Paragraph para = (Paragraph)graphic;
                sideX = this.normalizeParagraphSizeX(sideX, para);
                sideY = this.normalizeParagraphSizeY(sideY, para);
            }
            this.width = sideX;
            this.height = sideY;
            String str = this.generateTransform(rectangle, parent, angle);
            builder.append(str);
        } else if (points == null) {
            Table table = (Table)graphic;
            this.width = table.SideX;
            this.height = table.SideY;
            double[] pts = new double[]{-0.5 * table.SideX, -0.5 * table.SideY};
            pts = SchemeEngine.MulPointsTM(this._engine.GTM, pts);
            pts[0] = OdgUtils.asCentimeters(pts[0]);
            pts[1] = OdgUtils.asCentimeters(pts[1]);
            String template = String.format(" svg:x=\"%scm\" svg:y=\"%scm\" ", pts[0] - this.originX, pts[1] - this.originY);
            builder.append(template);
        } else {
            shape = (BaseShape)graphic;
            OdgSides sides = this.getSides(shape, points);
            double sideX = OdgUtils.asMillimeters(Math.abs(sides.SideX));
            double sideY = OdgUtils.asMillimeters(Math.abs(sides.SideY));
            this.width = sideX;
            this.height = sideY;
            if (graphic instanceof Spline) {
                Spline spline = (Spline)graphic;
                points = SchemeEngine.MulPointsTM(this._engine.GTM, spline.calcPoints());
                for (int i = 0; i < points.length - 1; i += 2) {
                    points[i] = OdgUtils.asCentimeters(points[i]) * this.scale - this.originX;
                    points[i + 1] = OdgUtils.asCentimeters(points[i + 1]) * this.scale - this.originY;
                }
            }
            BaseGraphic.RealPoint point = SchemeUtils.getMinPts(points);
            String template = String.format(" svg:x=\"%scm\" svg:y=\"%scm\" ", point.X, point.Y);
            builder.append(template);
        }
        Object hw = "svg:width=\"%scm\" svg:height=\"%scm\"";
        this.width *= this.scale;
        this.height *= this.scale;
        if (!(graphic instanceof Rectangle) && !(graphic instanceof Table)) {
            String viewBox = " svg:viewBox=\"%d %d %d %d\"";
            String format = String.format(viewBox, 0, 0, (int)(OdgUtils.asCentimeters(this.width) * 1000.0), (int)(OdgUtils.asCentimeters(this.height) * 1000.0));
            hw = (String)hw + format;
        }
        builder.append(String.format((String)hw, OdgUtils.asCentimeters(this.width), OdgUtils.asCentimeters(this.height)));
        return builder.toString();
    }

    private OdgSides getSides(BaseShape shape, double[] points) {
        if (shape instanceof Spline) {
            Spline spline = (Spline)shape;
            OdgSides sides = new OdgSides(spline.calcPoints());
            sides.SideX = OdgUtils.asCentimeters(sides.SideX);
            sides.SideY = OdgUtils.asCentimeters(sides.SideY);
            return sides;
        }
        return new OdgSides(points);
    }

    private String getPoints(BaseShape shape, OdgDraw draw, double[] points) {
        StringBuilder builder = new StringBuilder();
        double firstPointX = points[0];
        double firstPointY = points[1];
        double lastPointX = points[points.length - 2];
        double lastPointY = points[points.length - 1];
        this.width = OdgUtils.asMillimeters(Math.abs(lastPointX - firstPointX));
        this.height = OdgUtils.asMillimeters(Math.abs(lastPointY - firstPointY));
        if (draw.name.equals(OdgDraw.LINE.name)) {
            return String.format("svg:x1=\"%scm\" svg:y1=\"%scm\" svg:x2=\"%scm\" svg:y2=\"%scm\"", firstPointX, firstPointY, lastPointX, lastPointY);
        }
        if (draw.name.equals(OdgDraw.CONNECTOR.name)) {
            String template;
            Object svg = "svg:viewBox=\"%d %d %d %d\" svg:x1=\"%scm\" svg:y1=\"%scm\" svg:x2=\"%scm\" svg:y2=\"%scm\" svg:d=\"%s\" ";
            Polyline polyline = (Polyline)shape;
            if (polyline.ConnectorView == 1) {
                template = "draw:type=\"line\" ";
                svg = (String)svg + template;
            }
            if (polyline.Points.length >= 6) {
                double skewY;
                double skewX;
                template = "draw:line-skew=\"%scm\" ";
                if (polyline.Points.length == 6) {
                    skewX = (firstPointX - lastPointX) / 2.0;
                    skewY = (firstPointY - lastPointY) / 2.0;
                    boolean con = Math.abs(skewX) > Math.abs(skewY);
                    svg = (String)svg + String.format(template, con ? skewX : -skewY);
                } else {
                    skewX = (firstPointX + lastPointX) / 2.0;
                    skewY = (firstPointY + lastPointY) / 2.0;
                    double secondPointX = points[2];
                    double secondPointY = points[3];
                    double threePointX = points[4];
                    double threePointY = points[5];
                    double dx = (threePointX + secondPointX) / 2.0;
                    double dy = (threePointY + secondPointY) / 2.0;
                    double dist = SchemeUtils.distance(dx, dy, skewX, skewY);
                    svg = (String)svg + String.format(template, skewY > dy || skewX > dx ? -dist : dist);
                }
            }
            StringBuilder loc = new StringBuilder();
            for (int i = 0; i < points.length - 1; i += 2) {
                int pointX = (int)(points[i] * 1000.0);
                int pointY = (int)(points[i + 1] * 1000.0);
                if (i == 0) {
                    loc.append(String.format("M%d %dL", pointX, pointY));
                    continue;
                }
                loc.append(pointX).append(pointY < 0 ? "" : " ").append(pointY);
                loc.append(" ");
            }
            return String.format((String)svg, 0, 0, (int)(OdgUtils.asCentimeters(Math.abs(this.width)) * 1000.0), (int)(OdgUtils.asCentimeters(Math.abs(this.height)) * 1000.0), firstPointX, firstPointY, lastPointX, lastPointY, loc);
        }
        if (!(shape instanceof Spline)) {
            this.shiftCoordinates(points);
        }
        if (shape instanceof Polygon) {
            Polygon polygon = (Polygon)shape;
            StringBuilder bdr = new StringBuilder();
            boolean isBreak = true;
            int to = 0;
            for (int i = 0; i < polygon.Counts.length; ++i) {
                int from = to;
                to = from + polygon.Counts[i] * 2;
                for (int j = from; j < to; j += 2) {
                    int pointX = (int)(points[j] * 1000.0);
                    int pointY = (int)(points[j + 1] * 1000.0);
                    if (isBreak) {
                        bdr.append(String.format("M%d %dL", pointX, pointY));
                        isBreak = false;
                        if (j + 2 != to) continue;
                        int length = bdr.length();
                        bdr.delete(length - 1, length);
                        continue;
                    }
                    bdr.append(pointX).append(pointY < 0 ? "" : " ").append(pointY);
                    bdr.append(" ");
                }
                bdr.append("z");
                isBreak = true;
            }
            builder.append(String.format(" svg:d=\"%s\" ", bdr.toString().trim()));
        } else if (shape instanceof Region) {
            Region region = (Region)shape;
            StringBuilder bdr = new StringBuilder();
            boolean isBreak = true;
            int to = 0;
            for (int i = 0; i < region.Counts.length; ++i) {
                int from = to;
                to = from + region.Counts[i] * 2;
                for (int j = from; j < to; j += 2) {
                    int pointX = (int)(points[j] * 1000.0);
                    int pointY = (int)(points[j + 1] * 1000.0);
                    if (isBreak) {
                        bdr.append(String.format("M%d %dC", pointX, pointY));
                        isBreak = false;
                        continue;
                    }
                    bdr.append(pointX).append(pointY < 0 ? "" : " ").append(pointY);
                    bdr.append(" ");
                }
                bdr.append("z");
                isBreak = true;
            }
            builder.append(String.format(" svg:d=\"%s\" ", bdr.toString().trim()));
        } else if (shape instanceof Spline) {
            StringBuilder bdr = new StringBuilder();
            for (int i = 0; i < points.length - 1; i += 2) {
                int pointX = (int)(points[i] * 1000.0);
                int pointY = (int)(points[i + 1] * 1000.0);
                if (i == 0) {
                    bdr.append(String.format("M%d %dC", pointX, pointY));
                    continue;
                }
                bdr.append(pointX).append(pointY < 0 ? "" : " ").append(pointY);
                bdr.append(" ");
            }
            builder.append(String.format(" svg:d=\"%s\" ", bdr.toString().trim()));
        } else {
            StringBuilder bdr = new StringBuilder();
            for (int i = 0; i < points.length - 1; i += 2) {
                int pointX = (int)(points[i] * 1000.0);
                int pointY = (int)(points[i + 1] * 1000.0);
                bdr.append(pointX).append(",").append(pointY);
                bdr.append(" ");
            }
            builder.append(String.format(" draw:points=\"%s\" ", bdr.toString().trim()));
        }
        return builder.toString();
    }

    private void shiftCoordinates(double[] points) {
        BaseGraphic.RealPoint point = SchemeUtils.getMinPts(points);
        for (int i = 0; i < points.length; i += 2) {
            int n = i;
            points[n] = points[n] - point.X;
            int n2 = i + 1;
            points[n2] = points[n2] - point.Y;
        }
    }

    private int getOppositePoint(int index, double scaleX, double scaleY) {
        int opposite = 0;
        if (scaleX >= 0.0 && scaleY >= 0.0 || scaleX < 0.0 && scaleY < 0.0) {
            switch (index) {
                case 0: {
                    opposite = 3;
                    break;
                }
                case 1: {
                    opposite = 0;
                    break;
                }
                case 2: {
                    opposite = 1;
                    break;
                }
                case 3: {
                    opposite = 2;
                }
            }
        } else {
            switch (index) {
                case 0: {
                    opposite = 1;
                    break;
                }
                case 1: {
                    opposite = 2;
                    break;
                }
                case 2: {
                    opposite = 3;
                    break;
                }
                case 3: {
                    opposite = 0;
                }
            }
        }
        return opposite;
    }

    private int getIndexNearestPoint(double[] points) {
        double y;
        int i;
        double minY = Double.MAX_VALUE;
        int minIndexY1 = 0;
        int minIndexY2 = 0;
        for (i = 0; i < points.length - 1; i += 2) {
            y = points[i + 1];
            if (!(minY > y)) continue;
            minY = y;
            minIndexY1 = i / 2;
        }
        minY = Double.MAX_VALUE;
        for (i = 0; i < points.length - 1; i += 2) {
            y = points[i + 1];
            if (!(minY > y) || i / 2 == minIndexY1) continue;
            minY = y;
            minIndexY2 = i / 2;
        }
        if (points[minIndexY1 * 2] > points[minIndexY2 * 2]) {
            return minIndexY2;
        }
        return minIndexY1;
    }

    private String generateTransform(Rectangle rect, OdgParent parent, double angle) {
        double rad;
        double[] pts = rect.getRectPoints();
        if (this.gStyle != null && rect instanceof Paragraph) {
            Paragraph paragraph = (Paragraph)rect;
            double biasX = this.calculateBiasX(paragraph);
            double biasY = this.calculateBiasY(paragraph);
            for (int i = 0; i < pts.length; i += 2) {
                int n = i;
                pts[n] = pts[n] + biasX;
                int n2 = i + 1;
                pts[n2] = pts[n2] + biasY;
            }
        }
        pts = SchemeEngine.MulPointsTM(this._engine.GTM, pts);
        int i = 0;
        while (i < pts.length) {
            int n = i++;
            pts[n] = pts[n] * this.scale;
        }
        StringBuilder transformBuilder = new StringBuilder();
        double skewX = rect.TransProps == null ? 0.0 : rect.TransProps.SkewX;
        double skewY = rect.TransProps == null ? 0.0 : rect.TransProps.SkewY;
        String drawTransform = " draw:transform=\"%s\" ";
        Object drawTransformSkewX = "";
        Object drawTransformRotate = "";
        if (rect.ParentGB == null && skewX == 0.0 && skewY == 0.0) {
            rad = -SchemeEngine.NormAngle(angle) * Math.PI / 180.0;
        } else {
            double x1 = pts[0];
            double y1 = pts[1];
            double x2 = pts[2];
            double y2 = pts[3];
            double agl = Math.toDegrees(Math.atan2(y2 - y1, x2 - x1));
            rad = -SchemeEngine.NormAngle(agl) * Math.PI / 180.0;
        }
        rad = this.transformRadian(rad);
        if (rad != 0.0) {
            drawTransformRotate = " rotate (" + rad + ")";
        }
        String drawTransformTranslate = " translate (%scm %scm)";
        AffineTransform emptyTransform = new AffineTransform();
        emptyTransform.rotate(rad);
        double[] rotatePts = SchemeEngine.MulPointsTM(emptyTransform, pts);
        for (int i2 = 0; i2 < rotatePts.length; ++i2) {
            BigDecimal bd = BigDecimal.valueOf(rotatePts[i2]);
            rotatePts[i2] = bd.setScale(10, RoundingMode.HALF_UP).doubleValue();
        }
        int index = this.getIndexNearestPoint(rotatePts);
        double translateX = pts[index * 2];
        double translateY = pts[index * 2 + 1];
        if (!(rect instanceof AttributeDef)) {
            if (rect.ParentGB != null || skewY != 0.0) {
                double ax = rotatePts[6] - rotatePts[0];
                double ay = rotatePts[7] - rotatePts[1];
                double bx = rotatePts[4] - rotatePts[0];
                double by = rotatePts[5] - rotatePts[1];
                double cx = rotatePts[4] - rotatePts[6];
                double cy = rotatePts[5] - rotatePts[7];
                double dx = rotatePts[2] - rotatePts[6];
                double dy = rotatePts[3] - rotatePts[7];
                double a = Math.sqrt(Math.pow(ax, 2.0) + Math.pow(ay, 2.0));
                double b = Math.sqrt(Math.pow(bx, 2.0) + Math.pow(by, 2.0));
                double c = Math.sqrt(Math.pow(cx, 2.0) + Math.pow(cy, 2.0));
                double d = Math.sqrt(Math.pow(dx, 2.0) + Math.pow(dy, 2.0));
                b = Math.min(d, b);
                double p = (a + b + c) / 2.0;
                if (c != 0.0) {
                    this.height = 2.0 * Math.sqrt(p * (p - a) * (p - b) * (p - c)) / c;
                    this.width = c;
                    this.height /= this.scale;
                    this.width /= this.scale;
                }
            } else {
                this.width *= Math.abs(parent.scaleX);
                this.height *= Math.abs(parent.scaleY);
            }
        }
        if (!(skewX == 0.0 && skewY == 0.0 || rect instanceof Paragraph)) {
            int opposite = this.getOppositePoint(index, parent.scaleX, parent.scaleY);
            double oppositeDx = rotatePts[index * 2] - rotatePts[opposite * 2];
            double oppositeDy = rotatePts[index * 2 + 1] - rotatePts[opposite * 2 + 1];
            if (oppositeDy != 0.0) {
                double odgSkewX = -Math.atan(oppositeDx / oppositeDy);
                odgSkewX = this.transformRadian(odgSkewX);
                drawTransformSkewX = " skewX (" + odgSkewX + ")";
            }
        }
        transformBuilder.append((String)drawTransformSkewX);
        transformBuilder.append((String)drawTransformRotate);
        transformBuilder.append(String.format(drawTransformTranslate, OdgUtils.asCentimeters(translateX) - this.originX, OdgUtils.asCentimeters(translateY) - this.originY));
        String trimValue = transformBuilder.toString().trim();
        return String.format(drawTransform, trimValue);
    }

    private double calculateBiasY(Paragraph paragraph) {
        if (this.gStyle.hasAttributes("draw:textarea-vertical-align")) {
            String area = this.gStyle.getStyles("draw:textarea-vertical-align");
            double dy = paragraph.BottomMargin + paragraph.TopMargin + paragraph.exportSidesY;
            if (dy > paragraph.SideY) {
                double bias = -dy + paragraph.SideY;
                switch (area) {
                    case "bottom": {
                        return bias;
                    }
                    case "middle": {
                        return bias / 2.0;
                    }
                }
            }
        }
        return 0.0;
    }

    private double calculateBiasX(Paragraph paragraph) {
        if (this.gStyle.hasAttributes("draw:textarea-horizontal-align")) {
            String area = this.gStyle.getStyles("draw:textarea-horizontal-align");
            double dx = paragraph.LeftMargin + paragraph.RightMargin + paragraph.exportSidesX;
            if (dx > paragraph.SideX) {
                double bias = -dx + paragraph.SideX;
                switch (area) {
                    case "right": {
                        return bias;
                    }
                    case "center": {
                        return bias / 2.0;
                    }
                }
            }
        }
        return 0.0;
    }

    private double transformRadian(double rad) {
        if (rad > Math.PI) {
            rad -= Math.PI * 2;
        }
        if (rad < -Math.PI) {
            rad += Math.PI * 2;
        }
        return rad;
    }

    private void writePageLayout() {
        if (this._scheme.Pages.empty()) {
            return;
        }
        int width = 0;
        int height = 0;
        int size = this._scheme.Pages.size();
        this.scales = new double[size];
        block0: for (int idx = 0; idx < size; ++idx) {
            for (SchemePage page : this._scheme.Pages) {
                if (idx != page.getOrder()) continue;
                SchemePageLayout layout = page.pageLayout == null ? this._scheme.getPageLayout() : page.pageLayout;
                this.schemeScale = this.getPageScaleByPageLayout(layout);
                if (idx == 0) {
                    this.marginTop = layout.getTopField();
                    this.marginBottom = layout.getBottomField();
                    this.marginRight = layout.getRightField();
                    this.marginLeft = layout.getLeftField();
                } else if (!this.needMargin(layout)) {
                    this.marginTop = 0;
                    this.marginBottom = 0;
                    this.marginRight = 0;
                    this.marginLeft = 0;
                }
                page.calcPageDimensions(layout, this.schemeScale);
                this.originX = layout.getWidth() * page.i1x;
                this.originY = layout.getHeight() * page.i1y;
                double fieldsX = layout.getLeftField() + layout.getRightField();
                double fieldsY = layout.getTopField() + layout.getBottomField();
                if (page.i1x != 0) {
                    this.originX -= fieldsX * (double)page.i1x;
                }
                this.originY -= (double)(layout.getTopField() * 2);
                if (page.i1y != 0) {
                    this.originY -= fieldsY * (double)page.i1y;
                }
                int pageWidth = page.getPageWidth();
                int pageHeight = page.getPageHeight();
                width = Math.max(width, pageWidth);
                height = Math.max(height, pageHeight);
                this.scales[idx] = this.scale;
                if ((double)pageWidth > 6000.0 || (double)pageHeight > 6000.0) {
                    this.scales[idx] = 6000.0 / (double)Math.max(pageWidth, pageHeight);
                }
                this.origins.add(new BaseGraphic.RealPoint(this.originX, this.originY));
                continue block0;
            }
        }
        if ((double)width > 6000.0 || (double)height > 6000.0) {
            this.scale = 6000.0 / (double)Math.max(width, height);
        }
        String orientation = (height = (int)((double)height * this.scale)) > (width = (int)((double)width * this.scale)) ? "portrait" : "landscape";
        String pageLayoutProperties = "<style:page-layout style:name=\"PM0\"><style:page-layout-properties fo:margin-top=\"%scm\"  fo:margin-bottom=\"%scm\"  fo:margin-left=\"%scm\"  fo:margin-right=\"%scm\"  fo:page-width=\"%scm\"  fo:page-height=\"%scm\"  style:print-orientation=\"%s\"/></style:page-layout>";
        String format = String.format(pageLayoutProperties, OdgUtils.asCentimeters(this.marginTop), OdgUtils.asCentimeters(this.marginBottom), OdgUtils.asCentimeters(this.marginLeft), OdgUtils.asCentimeters(this.marginRight), OdgUtils.asCentimeters(width), OdgUtils.asCentimeters(height), orientation);
        this._automaticStylesStyles.append(format);
    }

    private double getPageScaleByPageLayout(SchemePageLayout pageLayout) {
        if (pageLayout == null || pageLayout.getScalePageType() == 0) {
            return 1.0;
        }
        if (pageLayout.getScalePageType() == 1) {
            switch (pageLayout.getScalePage()) {
                case 0: {
                    return 0.001;
                }
                case 1: {
                    return 0.002;
                }
                case 2: {
                    return 0.005;
                }
                case 3: {
                    return 0.01;
                }
                case 4: {
                    return 0.02;
                }
                case 5: {
                    return 0.04;
                }
                case 6: {
                    return 0.05;
                }
                case 7: {
                    return 0.1;
                }
                case 8: {
                    return 0.2;
                }
                case 9: {
                    return 0.4;
                }
                case 10: {
                    return 0.5;
                }
                case 12: {
                    return 10.0;
                }
                case 13: {
                    return 20.0;
                }
                case 14: {
                    return 50.0;
                }
            }
            return 1.0;
        }
        double scaleFloat = pageLayout.getScaleFloat();
        if (scaleFloat < 0.001) {
            scaleFloat = 0.001;
        }
        return 1.0 / scaleFloat;
    }

    private boolean needMargin(SchemePageLayout layout) {
        return this.marginTop == layout.getTopField() && this.marginBottom == layout.getBottomField() && this.marginRight == layout.getRightField() && this.marginLeft == layout.getLeftField();
    }

    private void writeMasterStyles() {
        this.writeLayer();
        int cnt = this._scheme.Pages.size();
        for (int countPage = 0; countPage < cnt; ++countPage) {
            String masterPage = String.format("<style:master-page style:name=\"PM%d\" style:page-layout-name=\"PM0\"/>", countPage);
            this._officeMasterStyles.append(masterPage);
        }
    }

    private void writeLayer() {
        String[] mandatoryLayers = new String[]{"layout", "background", "backgroundobjects", "controls", "measurelines"};
        int cnt = this._scheme.SortLayers.size();
        for (int i = 0; i < cnt; ++i) {
            List<Double> list;
            PhxLayer phxLayer = (PhxLayer)this._scheme.SortLayers.get((int)i).BG;
            if (!phxLayer.Exportable) continue;
            String caption = this.correctText(phxLayer.StringProps.Caption);
            this.layerById.put(phxLayer.ID, phxLayer);
            if (this.uniqueLayerName.get(caption) == null) {
                ArrayList<Double> ids = new ArrayList<Double>();
                ids.add(phxLayer.ID);
                this.uniqueLayerName.put(caption, ids);
                continue;
            }
            boolean isExist = false;
            for (Map.Entry<String, List<Double>> map : this.uniqueLayerName.entrySet()) {
                double id = map.getValue().get(0);
                PhxLayer existLayer = this.layerById.get(id);
                assert (existLayer != null);
                if (!this.equals(phxLayer, existLayer)) continue;
                isExist = true;
                List<Double> list2 = map.getValue();
                list2.add(phxLayer.ID);
                this.uniqueLayerName.put(map.getKey(), list2);
                break;
            }
            if (isExist || (list = this.uniqueLayerName.get(caption)) == null) continue;
            int index = list.size();
            String indexStr = String.valueOf(index);
            ArrayList<Double> ids = new ArrayList<Double>();
            ids.add(phxLayer.ID);
            String template = "%s - %s";
            String name = String.format(template, caption, indexStr);
            this.uniqueLayerName.put(name, ids);
        }
        this._officeMasterStyles.append("<draw:layer-set>");
        for (Map.Entry<String, List<Double>> map : this.uniqueLayerName.entrySet()) {
            String name;
            for (Double id : map.getValue()) {
                name = map.getKey();
                this.layerName.add(name);
                this.layerNameById.put(id, name);
            }
            double id = map.getValue().get(0);
            name = map.getKey();
            PhxLayer layer = this.layerById.get(id);
            if (layer == null) continue;
            String drawDisplay = layer.Visible ? "always" : "none";
            boolean drawProtected = !layer.Selectable;
            String templateLayer = "<draw:layer draw:name=\"%s\" draw:display=\"%s\" draw:protected=\"%s\"/>";
            String drawLayer = String.format(templateLayer, name, drawDisplay, drawProtected);
            this._officeMasterStyles.append(drawLayer);
        }
        for (String layer : mandatoryLayers) {
            if (this.layerName.contains(layer)) continue;
            String templateLayer = "<draw:layer draw:name=\"%s\"/>";
            String drawLayer = String.format(templateLayer, layer);
            this._officeMasterStyles.append(drawLayer);
        }
        this._officeMasterStyles.append("</draw:layer-set>");
    }

    private boolean equals(PhxLayer layer1, PhxLayer layer2) {
        return layer1.Visible == layer2.Visible && layer1.Selectable == layer2.Selectable && Objects.equals(layer1.Description, layer2.Description);
    }

    private String getStyleName(OdgStyleFamily family, OdgProperties ... properties) {
        String styleName;
        String template = "<style:style style:name=\"%s\" style:family=\"%s\">%s</style:style>";
        switch (family) {
            case COLUMN: {
                styleName = "co" + ++this.countTableColumnStyles;
                break;
            }
            case ROW: {
                styleName = "ro" + ++this.countTableRowStyles;
                break;
            }
            case CELL: {
                styleName = "ce" + ++this.countTableCellStyles;
                break;
            }
            case GRAPHIC: {
                styleName = "gr" + ++this.countGraphicStyles;
                break;
            }
            case PARAGRAPH: {
                styleName = "P" + ++this.countParagraphStyles;
                break;
            }
            default: {
                styleName = "T" + ++this.countTextStyles;
            }
        }
        StringBuilder styles = new StringBuilder();
        for (OdgProperties obj : properties) {
            Object prop = obj instanceof OdgTable.OdgStyleTableColumnProperties ? "<style:table-column-properties %s />" : (obj instanceof OdgTable.OdgStyleTableRowProperties ? "<style:table-row-properties %s />" : (obj instanceof OdgStyleGraphicsProperties ? (OdgStyleFamily.CELL == family ? "<loext:graphic-properties %s />" : "<style:graphic-properties %s />") : (obj instanceof OdgStyleTextProperties ? "<style:text-properties %s />" : "<style:paragraph-properties %s />")));
            StringBuilder list = new StringBuilder();
            HashMap<String, String> map = obj.getStyles();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String style = entry.getKey();
                String value = entry.getValue();
                if (style.equals("style:position")) {
                    String tabTemplate = "<style:tab-stops><style:tab-stop style:position=\"%s\"/></style:tab-stops>";
                    String paragraphTemplate = String.format(tabTemplate, value);
                    prop = "<style:paragraph-properties %s>" + paragraphTemplate + "</style:paragraph-properties>";
                    continue;
                }
                list.append(style).append("=\"").append(value).append("\"");
                list.append(" ");
                if (style.equals("style:font-name")) {
                    String fontTemplate = "<style:font-face style:name=\"%s\" svg:font-family=\"'%s'\" style:font-family-generic=\"roman\" style:font-pitch=\"variable\"/>";
                    if (!this.fonts.contains(value)) {
                        this.fonts.add(value);
                        this._fontFaceDeclsContent.append(String.format(fontTemplate, value, value));
                    }
                }
                if (!style.equals("draw:fill") || !value.equals("gradient")) continue;
                BaseShape shape = obj.getShape();
                String gradientName = this.getGradientName(shape);
                String drawFillGradientName = "draw:fill-gradient-name=\"%s\"";
                list.append(String.format(drawFillGradientName, gradientName));
                list.append(" ");
            }
            String style = String.format((String)prop, list);
            styles.append(style);
        }
        String styleStyle = String.format(template, styleName, family.name, styles);
        this._automaticStylesContent.append(styleStyle);
        return styleName;
    }

    private String getGradientName(BaseShape shape) {
        String templateGradient = "<draw:gradient draw:name=\"%s\" draw:style=\"%s\" draw:cx=\"50%%\" draw:cy=\"50%%\" draw:start-color=\"%s\" draw:end-color=\"%s\" draw:start-intensity=\"100%%\" draw:end-intensity=\"100%%\" draw:angle=\"%sdeg\" draw:border=\"0%%\"/>";
        double gradientAngle = this.initGradientAngle(shape.BrushPattern);
        double angle = Math.toDegrees(gradientAngle);
        String style = this.initGradientDirection(shape.BrushPattern);
        String startColor = OdgUtils.getColorGradient(shape.BkColor);
        String endColor = OdgUtils.getColorGradient(shape.bColor);
        String styleName = "gradient" + ++this.countGradientStyles;
        String gradient = String.format(templateGradient, styleName, style, startColor, endColor, angle);
        this._officeStyles.append(gradient);
        return styleName;
    }

    private String initGradientDirection(int fillPattern) {
        switch (fillPattern) {
            case 10019: {
                return "radial";
            }
            case 10012: 
            case 10014: 
            case 10016: 
            case 10018: {
                return "axial";
            }
        }
        return "linear";
    }

    private double initGradientAngle(int fillPattern) {
        switch (fillPattern) {
            case 10001: {
                return 5.235987755982989;
            }
            case 10002: 
            case 10012: {
                return 1.5707963267948966;
            }
            case 10003: 
            case 10014: {
                return Math.PI;
            }
            case 10005: 
            case 10016: {
                return 2.356194490192345;
            }
            case 10006: 
            case 10018: {
                return 3.9269908169872414;
            }
            case 10007: {
                return 0.7853981633974483;
            }
            case 10008: {
                return 5.497787143782138;
            }
        }
        return 0.0;
    }

    private void finishODGFile() throws Exception {
        this.writeStyles();
        this._zipOutputStream.putNextEntry(new ZipEntry("styles.xml"));
        String wrapper = this.fillDocument("office:document-styles").toString();
        String style = String.format(wrapper, this._stylesXml);
        this._zipOutputStream.write(style.getBytes(StandardCharsets.UTF_8));
        this.writeContent();
        this._zipOutputStream.putNextEntry(new ZipEntry("content.xml"));
        wrapper = this.fillDocument("office:document-content").toString();
        String content = String.format(wrapper, this._contentXml);
        this._zipOutputStream.write(content.getBytes(StandardCharsets.UTF_8));
        this._zipOutputStream.finish();
        this.putStateProgressPosition(this._scheme.SortShapes.size());
    }

    private void finishFODGFile() throws Exception {
        String wrapper = this.fillOffice("office:document").toString();
        String office = String.format(wrapper, this._Xml);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(new InputSource(new StringReader(office)));
        DOMSource source = new DOMSource(doc);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        StreamResult result = new StreamResult(this.out);
        transformer.transform(source, result);
        this.putStateProgressPosition(this._scheme.SortShapes.size());
    }

    public String fillMeta() {
        return String.format("<office:document-meta xmlns:office=\"urn:oasis:names:tc:opendocument:xmlns:office:1.0\" xmlns:ooo=\"http://openoffice.org/2004/office\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:meta=\"urn:oasis:names:tc:opendocument:xmlns:meta:1.0\" xmlns:grddl=\"http://www.w3.org/2003/g/data-view#\" xmlns:presentation=\"urn:oasis:names:tc:opendocument:xmlns:presentation:1.0\" xmlns:smil=\"urn:oasis:names:tc:opendocument:xmlns:smil-compatible:1.0\" xmlns:anim=\"urn:oasis:names:tc:opendocument:xmlns:animation:1.0\" xmlns:officeooo=\"http://openoffice.org/2009/office\" office:version=\"1.3\">%s</office:document-meta>", this.meta());
    }

    public String meta() {
        return "<office:meta><meta:creation-date/><meta:generation/><dc:date/><meta:editing-duration/><meta:editing-cycles/></office:meta>";
    }

    public String fillSettings() {
        return String.format("<office:document-settings xmlns:office=\"urn:oasis:names:tc:opendocument:xmlns:office:1.0\" xmlns:ooo=\"http://openoffice.org/2004/office\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xmlns:config=\"urn:oasis:names:tc:opendocument:xmlns:config:1.0\" xmlns:presentation=\"urn:oasis:names:tc:opendocument:xmlns:presentation:1.0\" xmlns:smil=\"urn:oasis:names:tc:opendocument:xmlns:smil-compatible:1.0\" xmlns:anim=\"urn:oasis:names:tc:opendocument:xmlns:animation:1.0\" xmlns:officeooo=\"http://openoffice.org/2009/office\" office:version=\"1.3\">%s</office:document-settings>", this.setting());
    }

    public String setting() {
        return "<office:settings><config:config-item-set config:name=\"ooo:view-settings\"/><config:config-item-set config:name=\"ooo:configuration-settings\"/></office:settings>";
    }

    public String fillManifest() {
        String manifest = "<manifest:manifest xmlns:manifest=\"urn:oasis:names:tc:opendocument:xmlns:manifest:1.0\" xmlns:loext=\"urn:org:documentfoundation:names:experimental:office:xmlns:loext:1.0\" manifest:version=\"1.3\"> <manifest:file-entry manifest:full-path=\"/\" manifest:version=\"1.3\" manifest:media-type=\"application/vnd.oasis.opendocument.graphics\"/> <manifest:file-entry manifest:full-path=\"Configurations2/\" manifest:media-type=\"application/vnd.sun.xml.ui.configuration\"/> <manifest:file-entry manifest:full-path=\"styles.xml\" manifest:media-type=\"text/xml\"/> <manifest:file-entry manifest:full-path=\"content.xml\" manifest:media-type=\"text/xml\"/> <manifest:file-entry manifest:full-path=\"Thumbnails/thumbnail.png\" manifest:media-type=\"image/png\"/> %s<manifest:file-entry manifest:full-path=\"settings.xml\" manifest:media-type=\"text/xml\"/> <manifest:file-entry manifest:full-path=\"meta.xml\" manifest:media-type=\"text/xml\"/> </manifest:manifest>";
        StringBuilder manifestImage = new StringBuilder();
        for (OdgItem item : this._pictureList) {
            String filepath = "Pictures/" + item.name;
            String manifestFileEntry = "<manifest:file-entry manifest:full-path=\"%s\" manifest:media-type=\"image/%s\"/>";
            manifestImage.append(String.format(manifestFileEntry, filepath, item.format));
        }
        return String.format(manifest, manifestImage);
    }

    public StringBuilder fillDocument(String rootTag) {
        StringBuilder fill = new StringBuilder();
        fill.append("<").append(rootTag).append(" xmlns:office=\"urn:oasis:names:tc:opendocument:xmlns:office:1.0\" xmlns:ooo=\"http://openoffice.org/2004/office\" xmlns:fo=\"urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:meta=\"urn:oasis:names:tc:opendocument:xmlns:meta:1.0\" xmlns:style=\"urn:oasis:names:tc:opendocument:xmlns:style:1.0\" xmlns:text=\"urn:oasis:names:tc:opendocument:xmlns:text:1.0\" xmlns:rpt=\"http://openoffice.org/2005/report\" xmlns:draw=\"urn:oasis:names:tc:opendocument:xmlns:drawing:1.0\" xmlns:dr3d=\"urn:oasis:names:tc:opendocument:xmlns:dr3d:1.0\" xmlns:svg=\"urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0\" xmlns:chart=\"urn:oasis:names:tc:opendocument:xmlns:chart:1.0\" xmlns:table=\"urn:oasis:names:tc:opendocument:xmlns:table:1.0\" xmlns:number=\"urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0\" xmlns:ooow=\"http://openoffice.org/2004/writer\" xmlns:oooc=\"http://openoffice.org/2004/calc\" xmlns:of=\"urn:oasis:names:tc:opendocument:xmlns:of:1.2\" xmlns:xforms=\"http://www.w3.org/2002/xforms\" xmlns:tableooo=\"http://openoffice.org/2009/table\" xmlns:calcext=\"urn:org:documentfoundation:names:experimental:calc:xmlns:calcext:1.0\" xmlns:drawooo=\"http://openoffice.org/2010/draw\" xmlns:xhtml=\"http://www.w3.org/1999/xhtml\" xmlns:loext=\"urn:org:documentfoundation:names:experimental:office:xmlns:loext:1.0\" xmlns:field=\"urn:openoffice:names:experimental:ooo-ms-interop:xmlns:field:1.0\" xmlns:math=\"http://www.w3.org/1998/Math/MathML\" xmlns:form=\"urn:oasis:names:tc:opendocument:xmlns:form:1.0\" xmlns:script=\"urn:oasis:names:tc:opendocument:xmlns:script:1.0\" xmlns:formx=\"urn:openoffice:names:experimental:ooxml-odf-interop:xmlns:form:1.0\" xmlns:dom=\"http://www.w3.org/2001/xml-events\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:grddl=\"http://www.w3.org/2003/g/data-view#\" xmlns:css3t=\"http://www.w3.org/TR/css3-text/\" xmlns:presentation=\"urn:oasis:names:tc:opendocument:xmlns:presentation:1.0\" xmlns:smil=\"urn:oasis:names:tc:opendocument:xmlns:smil-compatible:1.0\" xmlns:anim=\"urn:oasis:names:tc:opendocument:xmlns:animation:1.0\" xmlns:officeooo=\"http://openoffice.org/2009/office\" office:version=\"1.3\">").append("%s").append("</").append(rootTag).append(">");
        return fill;
    }

    public StringBuilder fillOffice(String rootTag) {
        StringBuilder fill = new StringBuilder();
        fill.append("<").append(rootTag).append(" xmlns:office=\"urn:oasis:names:tc:opendocument:xmlns:office:1.0\" xmlns:ooo=\"http://openoffice.org/2004/office\" xmlns:fo=\"urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xmlns:config=\"urn:oasis:names:tc:opendocument:xmlns:config:1.0\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:meta=\"urn:oasis:names:tc:opendocument:xmlns:meta:1.0\" xmlns:style=\"urn:oasis:names:tc:opendocument:xmlns:style:1.0\" xmlns:text=\"urn:oasis:names:tc:opendocument:xmlns:text:1.0\" xmlns:rpt=\"http://openoffice.org/2005/report\" xmlns:draw=\"urn:oasis:names:tc:opendocument:xmlns:drawing:1.0\" xmlns:dr3d=\"urn:oasis:names:tc:opendocument:xmlns:dr3d:1.0\" xmlns:svg=\"urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0\" xmlns:chart=\"urn:oasis:names:tc:opendocument:xmlns:chart:1.0\" xmlns:table=\"urn:oasis:names:tc:opendocument:xmlns:table:1.0\" xmlns:number=\"urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0\" xmlns:ooow=\"http://openoffice.org/2004/writer\" xmlns:oooc=\"http://openoffice.org/2004/calc\" xmlns:of=\"urn:oasis:names:tc:opendocument:xmlns:of:1.2\" xmlns:xforms=\"http://www.w3.org/2002/xforms\" xmlns:tableooo=\"http://openoffice.org/2009/table\" xmlns:calcext=\"urn:org:documentfoundation:names:experimental:calc:xmlns:calcext:1.0\" xmlns:drawooo=\"http://openoffice.org/2010/draw\" xmlns:loext=\"urn:org:documentfoundation:names:experimental:office:xmlns:loext:1.0\" xmlns:field=\"urn:openoffice:names:experimental:ooo-ms-interop:xmlns:field:1.0\" xmlns:math=\"http://www.w3.org/1998/Math/MathML\" xmlns:form=\"urn:oasis:names:tc:opendocument:xmlns:form:1.0\" xmlns:script=\"urn:oasis:names:tc:opendocument:xmlns:script:1.0\" xmlns:formx=\"urn:openoffice:names:experimental:ooxml-odf-interop:xmlns:form:1.0\" xmlns:dom=\"http://www.w3.org/2001/xml-events\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xhtml=\"http://www.w3.org/1999/xhtml\" xmlns:grddl=\"http://www.w3.org/2003/g/data-view#\" xmlns:css3t=\"http://www.w3.org/TR/css3-text/\" xmlns:presentation=\"urn:oasis:names:tc:opendocument:xmlns:presentation:1.0\" xmlns:smil=\"urn:oasis:names:tc:opendocument:xmlns:smil-compatible:1.0\" xmlns:anim=\"urn:oasis:names:tc:opendocument:xmlns:animation:1.0\" xmlns:officeooo=\"http://openoffice.org/2009/office\" office:version=\"1.3\" office:mimetype=\"application/vnd.oasis.opendocument.graphics\">").append("%s").append("</").append(rootTag).append(">");
        return fill;
    }

    static enum OdgStyleFamily {
        GRAPHIC("graphic"),
        TEXT("text"),
        PARAGRAPH("paragraph"),
        COLUMN("table-column"),
        ROW("table-row"),
        CELL("table-cell");

        public final String name;

        private OdgStyleFamily(String name) {
            this.name = name;
        }
    }

    static enum OdgDraw {
        LINE("draw:line"),
        CONNECTOR("draw:connector"),
        NONE("none");

        public final String name;

        private OdgDraw(String name) {
            this.name = name;
        }
    }

    static class OdgParent {
        public double scaleX;
        public double scaleY;
        public double parentWidthCoeff;
        public double parentHeightCoeff;

        public OdgParent(double parentWidthCoeff, double parentHeightCoeff) {
            this(1.0, 1.0, parentWidthCoeff, parentHeightCoeff);
        }

        public OdgParent(double scaleX, double scaleY, double parentWidthCoeff, double parentHeightCoeff) {
            this.scaleX = scaleX;
            this.scaleY = scaleY;
            this.parentWidthCoeff = parentWidthCoeff;
            this.parentHeightCoeff = parentHeightCoeff;
        }
    }

    static class OdgItem {
        public String name = null;
        public String format = null;
        public byte[] bytes = null;

        OdgItem() {
        }

        public String getFormat() {
            return this.format;
        }

        public void setFormat(String format) {
            this.format = format;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public byte[] getBytes() {
            return this.bytes;
        }

        public void setBytes(byte[] bytes) {
            this.bytes = bytes;
        }
    }

    static class OdgSides {
        double SideX;
        double SideY;

        public OdgSides(double[] points) {
            if (points == null) {
                this.SideX = 0.0;
                this.SideY = 0.0;
                return;
            }
            if (points.length / 2 < 2) {
                this.SideX = 0.0;
                this.SideY = 0.0;
                return;
            }
            double xmin = points[0];
            double ymin = points[1];
            double xmax = points[0];
            double ymax = points[1];
            for (int i = 0; i < points.length; i += 2) {
                if (xmin > points[i]) {
                    xmin = points[i];
                }
                if (xmax < points[i]) {
                    xmax = points[i];
                }
                if (ymin > points[i + 1]) {
                    ymin = points[i + 1];
                }
                if (!(ymax < points[i + 1])) continue;
                ymax = points[i + 1];
            }
            this.SideX = xmax - xmin;
            this.SideY = ymin - ymax;
        }
    }

    static class OdgConnect {
        double shapeId;
        int index;

        public OdgConnect(double shapeId, int index) {
            this.shapeId = shapeId;
            this.index = index;
        }
    }
}

