/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes;

import inform.adt.InformException;
import inform.adt.LittleEndian;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.schemes.BaseGraphic;
import inform.agent.schemes.Image;
import inform.agent.schemes.SchemeEngine;
import inform.agent.schemes.SchemeParser;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;

public class PhxImage
extends Image {
    public double Node = 0.0;
    public boolean StoreImage = false;
    public byte[] Content = null;
    public static final double DefaultBrightness = 50.0;
    public static final double DefaultContrast = 50.0;
    public static final double DefaultGamma = 1.0;
    public double Brightness = 50.0;
    public double Contrast = 50.0;
    public double Gamma = 1.0;
    private static final int version = LittleEndian.getInt(new byte[]{0, 0, 29, 7}, 0);

    @Override
    public void assign(BaseGraphic Dest) throws IllegalAccessException, InstantiationException {
        super.assign(Dest);
        PhxImage shape = (PhxImage)Dest;
        shape.Node = this.Node;
        shape.StoreImage = this.StoreImage;
        int count = this.Content.length;
        shape.Content = new byte[count];
        for (int i = 0; i < count; ++i) {
            shape.Content[i] = this.Content[i];
        }
    }

    @Override
    protected void parse(SchemeParser Parser2, TaggedReader reader) throws IOException, TaggedReaderException, InformException {
        TaggedReader StreamReader = null;
        while (reader.getNextTag() != 0) {
            switch (reader.getCurrentTag()) {
                case 3: {
                    StreamReader = reader.getStreamReader();
                    if (StreamReader == null) break;
                    super.parse(Parser2, StreamReader);
                    break;
                }
                case 51: {
                    this.Node = reader.getDouble();
                    break;
                }
                case 113: {
                    this.StoreImage = reader.getBoolean();
                    break;
                }
                case 114: {
                    this.Content = this.getAsBmpContent(reader.getRaw());
                    break;
                }
                case 29: {
                    reader.skip();
                    StreamReader = reader.getStreamReader(202);
                    this.readTaggedImageFormat(StreamReader);
                }
            }
        }
    }

    void readTaggedImageFormat(TaggedReader reader) throws IOException {
        if (reader == null) {
            return;
        }
        while (reader.next()) {
            switch (reader.getCurrentTag()) {
                case 1: {
                    this.Brightness = reader.getDouble();
                    break;
                }
                case 2: {
                    this.Contrast = reader.getDouble();
                    break;
                }
                case 3: {
                    this.Gamma = reader.getDouble();
                }
            }
        }
    }

    private byte[] getAsBmpContent(byte[] data) throws IOException, InformException {
        if (data == null) {
            return null;
        }
        byte[] TIFF1 = new byte[]{73, 73, 42, 0};
        byte[] TIFF2 = new byte[]{77, 77, 0, 42};
        if (data.length < 4) {
            return data;
        }
        if (!(TIFF1[0] == data[0] && TIFF1[1] == data[1] && TIFF1[2] == data[2] && TIFF1[3] == data[3] || TIFF2[0] == data[0] && TIFF2[1] == data[1] && TIFF2[2] == data[2] && TIFF2[3] == data[3])) {
            return data;
        }
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        BufferedImage image = ImageIO.read(in);
        if (image == null) {
            throw new InformException("Java 8 not supported. Need version from Java 9");
        }
        BufferedImage convertedImage = new BufferedImage(image.getWidth(), image.getHeight(), 1);
        convertedImage.createGraphics().drawRenderedImage(image, null);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)convertedImage, "bmp", out);
        return out.toByteArray();
    }

    @Override
    protected void actualPaint(Graphics2D g2d, SchemeEngine Engine2) throws IllegalAccessException, InstantiationException {
    }

    @Override
    public int shapeType() {
        return 218;
    }

    @Override
    public int shapeVersion() {
        return version;
    }

    @Override
    public synchronized void writeTaggedData(TaggedWriter writer, boolean clipboard, boolean simult) throws IOException {
        if (writer == null) {
            return;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        TaggedWriter subWriter = new TaggedWriter(os);
        if (this.StoreImage && this.Content != null) {
            int oldImageSize = this.ImageSize;
            int oldBmpWidth = this.BmpWidth;
            int oldBmpHeight = this.BmpHeight;
            this.ImageSize = 1;
            this.BmpWidth = 1;
            this.BmpHeight = 1;
            super.writeTaggedData(subWriter, clipboard, simult);
            this.ImageSize = oldImageSize;
            this.BmpWidth = oldBmpWidth;
            this.BmpHeight = oldBmpHeight;
        } else {
            super.writeTaggedData(subWriter, clipboard, simult);
        }
        subWriter.flush();
        if (os.size() > 0) {
            writer.putRaw(3, os);
        }
        if (this.StoreImage) {
            writer.putBool(113, this.StoreImage);
            if (this.Content != null) {
                writer.putRaw(114, this.Content);
            }
            os = new ByteArrayOutputStream();
            subWriter = new TaggedWriter(os);
            this.writeTaggedImageFormat(subWriter);
            subWriter.flush();
            if (os.size() > 0) {
                writer.putEmpty(29);
                writer.putRaw(202, os);
            }
        }
        writer.flush();
    }

    private synchronized void writeTaggedImageFormat(TaggedWriter writer) throws IOException {
        if (this.Brightness != 50.0) {
            writer.putDouble(1, this.Brightness);
        }
        if (this.Contrast != 50.0) {
            writer.putDouble(2, this.Contrast);
        }
        if (this.Gamma != 1.0) {
            writer.putDouble(3, this.Gamma);
        }
    }
}

