/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes;

import inform.adt.InformException;
import inform.adt.NumberConverter;
import inform.adt.collections.DoubleHash;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.Ini;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.TableDescriptor;
import inform.agent.db.connect.BlobStream;
import inform.agent.db.connect.ConnectionManager;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.connect.ResultSet;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.BasicNode;
import inform.agent.mtd.nodes.Node;
import inform.agent.schemes.Primitive;
import inform.agent.schemes.Scheme;
import inform.agent.schemes.SchemeKeepSettings;
import inform.agent.schemes.SchemeParser;
import inform.agent.scripts.SSContext;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;

public class PrimLibrary
implements DoubleHash.Entry {
    private double ID = 0.0;
    private double recordID = 0.0;
    public LinkedHashMap<Double, Primitive> Primitives = new LinkedHashMap();

    @Override
    public double key() {
        return this.ID;
    }

    public PrimLibrary(double ID) {
        this.ID = ID;
    }

    protected void Parse(SSContext ssContext, ConnectionManager dbMgr, SchemeParser Parser2, Scheme s) throws IOException, TaggedReaderException, InformException, SQLException {
        if (!this.LoadFromTable(ssContext, dbMgr, Parser2, s)) {
            this.LoadFromNode(Parser2);
        }
    }

    protected boolean checkKeepSettings(SchemeKeepSettings keepSettings) {
        return keepSettings != null && keepSettings.getPrimLibTable() != 0.0 && keepSettings.getPrimLibID() != 0 && keepSettings.getPrimLibBlob() != 0 && keepSettings.getPrimTable() != 0.0 && keepSettings.getPrimID() != 0 && keepSettings.getPrimName() != 0 && keepSettings.getPrimLib() != 0 && keepSettings.getPrimBlob() != 0 && keepSettings.getPrimFolder() != 0 && keepSettings.getPrimParent() != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean LoadFromTable(SSContext ssContext, ConnectionManager dbMgr, SchemeParser Parser2, Scheme s) throws IOException, TaggedReaderException, InformException, SQLException {
        this.recordID = 0.0;
        SchemeKeepSettings keepSettings = s.getKeepSettings();
        if (!(keepSettings != null && this.checkKeepSettings(keepSettings) || (keepSettings = s.getLibKeepSettings()) != null && this.checkKeepSettings(keepSettings))) {
            return false;
        }
        TableDescriptor primLibTableDesc = TableDescriptor.getIfExists(keepSettings.getPrimLibTable());
        if (primLibTableDesc == null) {
            return false;
        }
        DatabaseDescriptor dbDesc = primLibTableDesc.getDatabaseDescriptor();
        if (dbDesc == null) {
            return false;
        }
        ArrayList<FieldDescriptor> primaryFields = primLibTableDesc.getPrimaryKeyFields();
        if (primaryFields.size() < 1) {
            throw new InformException("\u0412 \u0442\u0430\u0431\u043b\u0438\u0446\u0435 \u0431\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a \u043f\u0440\u0438\u043c\u0438\u0442\u0438\u0432\u043e\u0432 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043f\u0435\u0440\u0432\u0438\u0447\u043d\u044b\u0439 \u043a\u043b\u044e\u0447");
        }
        FieldDescriptor primaryKeyFieldDesc = primaryFields.get(0);
        if (primaryKeyFieldDesc == null) {
            return false;
        }
        FieldDescriptor primLibIDFieldDesc = primLibTableDesc.getFieldDescriptor(keepSettings.getPrimLibID());
        if (primLibIDFieldDesc == null) {
            return false;
        }
        Object schemeStr = "";
        if (dbDesc.getScheme() != null) {
            schemeStr = dbDesc.getScheme() + ".";
        }
        try (DatabaseConnection conn = primLibTableDesc.getDatabaseDescriptor().connect(dbMgr.getSSHost(), "PrimLibrary::LoadFromTable");){
            block17: {
                String sql = String.format("SELECT %s, %s FROM %s%s WHERE %s = %s", primaryKeyFieldDesc.getRawName(), primLibIDFieldDesc.getRawName(), schemeStr, primLibTableDesc.getRawName(), primLibIDFieldDesc.getRawName(), this.ID);
                try (PreparedStatement stmt = conn.prepareStatement(sql);){
                    ResultSet result = stmt.executeQuery(ssContext);
                    if (result == null) break block17;
                    try {
                        if (result.next()) {
                            this.recordID = result.getDouble(2);
                        }
                    }
                    finally {
                        result.close();
                    }
                }
            }
            conn.commit();
        }
        this.LoadPrimitivesFromTable(ssContext, dbMgr, Parser2, s);
        return this.recordID != 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean LoadPrimitivesFromTable(SSContext ssContext, ConnectionManager dbMgr, SchemeParser Parser2, Scheme s) throws IOException, TaggedReaderException, InformException, SQLException {
        if (this.recordID == 0.0) {
            return false;
        }
        SchemeKeepSettings keepSettings = s.getKeepSettings();
        if (!(keepSettings != null && this.checkKeepSettings(keepSettings) || (keepSettings = s.getLibKeepSettings()) != null && this.checkKeepSettings(keepSettings))) {
            return false;
        }
        TableDescriptor primTableDesc = TableDescriptor.getIfExists(keepSettings.getPrimTable());
        if (primTableDesc == null) {
            return false;
        }
        DatabaseDescriptor dbDesc = primTableDesc.getDatabaseDescriptor();
        if (dbDesc == null) {
            return false;
        }
        FieldDescriptor primIDFieldDesc = primTableDesc.getFieldDescriptor(keepSettings.getPrimID());
        if (primIDFieldDesc == null) {
            return false;
        }
        FieldDescriptor primNameFieldDesc = primTableDesc.getFieldDescriptor(keepSettings.getPrimName());
        if (primNameFieldDesc == null) {
            return false;
        }
        FieldDescriptor primLibFieldDesc = primTableDesc.getFieldDescriptor(keepSettings.getPrimLib());
        if (primLibFieldDesc == null) {
            return false;
        }
        FieldDescriptor primBlobFieldDesc = primTableDesc.getFieldDescriptor(keepSettings.getPrimBlob());
        if (primBlobFieldDesc == null) {
            return false;
        }
        FieldDescriptor primParentFieldDesc = primTableDesc.getFieldDescriptor(keepSettings.getPrimParent());
        if (primParentFieldDesc == null) {
            return false;
        }
        Object schemeStr = "";
        if (dbDesc.getScheme() != null) {
            schemeStr = dbDesc.getScheme() + ".";
        }
        int PrimCount = 0;
        long t1 = System.currentTimeMillis();
        try (DatabaseConnection conn = primTableDesc.getDatabaseDescriptor().connect(dbMgr.getSSHost(), "PrimLibrary::LoadPrimitivesFromTable");){
            String sql = String.format("SELECT %s, %s, %s, %s, %s FROM %s%s WHERE %s = %s", primIDFieldDesc.getRawName(), primNameFieldDesc.getRawName(), primLibFieldDesc.getRawName(), primBlobFieldDesc.getRawName(), primParentFieldDesc.getRawName(), schemeStr, primTableDesc.getRawName(), primLibFieldDesc.getRawName(), this.recordID);
            try (PreparedStatement stmt = conn.prepareStatement(sql);
                 ResultSet result = stmt.executeQuery(ssContext);){
                BlobStream blobStream = null;
                TaggedReader Reader2 = null;
                while (result.next()) {
                    Primitive Prim = new Primitive();
                    blobStream = result.getBlobStream(4);
                    if (blobStream == null) continue;
                    Reader2 = new TaggedReader(blobStream);
                    Prim.parse(Parser2, Reader2);
                    if (this.Primitives.get(Prim.key()) != null) continue;
                    Prim.Caption = result.getString(2);
                    Prim.ClassificationID = result.getDouble(5);
                    this.Primitives.put(Prim.key(), Prim);
                    ++PrimCount;
                }
            }
            conn.commit();
        }
        long t2 = System.currentTimeMillis();
        Core.logger.info("\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u0438 \u043f\u0430\u0440\u0441\u0438\u043d\u0433 \u043f\u0440\u0438\u043c\u0438\u0442\u0438\u0432\u043e\u0432 ({}) \u0431\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u0438 {} \u0438\u0437 \u0442\u0430\u0431\u043b\u0438\u0446\u044b: {}ms", PrimCount, NumberConverter.doubleToString(this.ID), t2 - t1);
        return PrimCount > 0;
    }

    protected boolean LoadFromNode(SchemeParser Parser2) throws IOException, TaggedReaderException, InformException {
        boolean res = false;
        BasicNode node = null;
        Node n = null;
        if (!Ini.libraryMode) {
            n = MtdEngine.getNode(this.ID);
        }
        if (n != null) {
            node = n.getRealNode();
        }
        if (node == null) {
            Core.logger.info("\u0427\u0442\u0435\u043d\u0438\u0435 \u0431\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u0438 \u043f\u0440\u0438\u043c\u0438\u0442\u0438\u0432\u043e\u0432 {}: \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0443\u0437\u0435\u043b \u043c\u0435\u0442\u0430\u0434\u0430\u043d\u043d\u044b\u0445", (Object)NumberConverter.doubleToString(this.ID));
        } else if (node.getType() != 27) {
            Core.logger.info("\u0427\u0442\u0435\u043d\u0438\u0435 \u0431\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u0438 \u043f\u0440\u0438\u043c\u0438\u0442\u0438\u0432\u043e\u0432 {}: \u043d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0442\u0438\u043f \u0443\u0437\u043b\u0430 \u043c\u0435\u0442\u0430\u0434\u0430\u043d\u043d\u044b\u0445 {}", (Object)NumberConverter.doubleToString(this.ID), (Object)node.getType());
        } else {
            int PrimCount = 0;
            long t1 = System.currentTimeMillis();
            byte[] content = node.getContent();
            long t2 = System.currentTimeMillis();
            Core.logger.info("\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u0431\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u0438 \u043f\u0440\u0438\u043c\u0438\u0442\u0438\u0432\u043e\u0432 {}: {}ms", (Object)NumberConverter.doubleToString(this.ID), (Object)(t2 - t1));
            t1 = System.currentTimeMillis();
            if (content.length > 0) {
                TaggedReader StreamReader = null;
                TaggedReader StreamReader1 = null;
                TaggedReader reader = new TaggedReader(content);
                while (reader.getNextTag() != 0) {
                    switch (reader.getCurrentTag()) {
                        case 1: {
                            StreamReader = reader.getStreamReader();
                            if (StreamReader == null) break;
                            while (StreamReader.getNextTag() != 0) {
                                switch (StreamReader.getCurrentTag()) {
                                    case 2: {
                                        StreamReader1 = StreamReader.getStreamReader();
                                        if (StreamReader1 == null) break;
                                        Primitive Prim = new Primitive();
                                        Prim.parse(Parser2, StreamReader1);
                                        if (this.Primitives.get(Prim.key()) != null) break;
                                        this.Primitives.put(Prim.key(), Prim);
                                        ++PrimCount;
                                    }
                                }
                            }
                            break;
                        }
                    }
                }
            }
            t2 = System.currentTimeMillis();
            Core.logger.info("\u041f\u0430\u0440\u0441\u0438\u043d\u0433 \u043f\u0440\u0438\u043c\u0438\u0442\u0438\u0432\u043e\u0432 ({}) \u0431\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u0438 {}: {}ms", PrimCount, NumberConverter.doubleToString(this.ID), t2 - t1);
            res = true;
        }
        return res;
    }

    protected synchronized void store(TaggedWriter writer) throws IOException {
        if (writer == null) {
            return;
        }
        writer.putEmpty(150);
        writer.putDouble(151, this.ID);
        double folderId = 0.0;
        String folderName = "";
        ByteArrayOutputStream folderStream = new ByteArrayOutputStream();
        TaggedWriter folderWriter = new TaggedWriter(folderStream);
        folderWriter.putDouble(23, folderId);
        folderWriter.putString(24, folderName);
        if (!this.Primitives.isEmpty()) {
            ByteArrayOutputStream folderChildrenStream = new ByteArrayOutputStream();
            TaggedWriter folderChildrenWriter = new TaggedWriter(folderChildrenStream);
            for (Primitive p : this.Primitives.values()) {
                folderChildrenWriter.putDouble(2, p.key());
            }
            folderChildrenWriter.flush();
            if (folderChildrenStream.size() > 0) {
                folderWriter.putRaw(26, folderChildrenStream);
            }
        }
        folderWriter.flush();
        if (folderStream.size() > 0) {
            writer.putRaw(22, folderStream);
        }
        if (!this.Primitives.isEmpty()) {
            ByteArrayOutputStream primitivesStream = new ByteArrayOutputStream();
            TaggedWriter primitivesWriter = new TaggedWriter(primitivesStream);
            for (Primitive p : this.Primitives.values()) {
                ByteArrayOutputStream primitiveStream = new ByteArrayOutputStream();
                TaggedWriter primitiveWriter = new TaggedWriter(primitiveStream);
                p.store(primitiveWriter);
                primitiveWriter.flush();
                if (primitiveStream.size() <= 0) continue;
                primitivesWriter.putRaw(2, primitiveStream);
            }
            primitivesWriter.flush();
            if (primitivesStream.size() > 0) {
                writer.putRaw(1, primitivesStream);
            }
        }
    }
}

