/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes;

import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import java.io.IOException;

public class SchemePageLayout {
    private static final int DEFAULT_PAGE_MARGIN = 6;
    private boolean active;
    private boolean portrait = true;
    private int format = 5;
    private int width;
    private int height;
    private int leftField = 6;
    private int rightField = 6;
    private int topField = 6;
    private int bottomField = 6;
    private int hPageCount = 1;
    private int vPageCount = 1;
    private boolean fitOnPages;
    private byte scalePageType = 0;
    private byte scalePage = (byte)11;
    private double scaleFloat = 1.0;
    private static final int TAG_PAGE_LAYOUT_ACTIVE = 1;
    private static final int TAG_PAGE_LAYOUT_PORTRAIT = 2;
    private static final int TAG_PAGE_LAYOUT_FORMAT = 3;
    private static final int TAG_PAGE_LAYOUT_WIDTH = 4;
    private static final int TAG_PAGE_LAYOUT_HEIGHT = 5;
    private static final int TAG_PAGE_LAYOUT_LEFT_FIELD = 6;
    private static final int TAG_PAGE_LAYOUT_RIGHT_FIELD = 7;
    private static final int TAG_PAGE_LAYOUT_TOP_FIELD = 8;
    private static final int TAG_PAGE_LAYOUT_BOTTOM_FIELD = 9;
    private static final int TAG_PAGE_LAYOUT_PAGE_COUNT_H = 10;
    private static final int TAG_PAGE_LAYOUT_PAGE_COUNT_V = 11;
    private static final int TAG_PAGE_LAYOUT_FIT_ON_PAGES = 12;
    private static final int TAG_PAGE_LAYOUT_SCALE_TYPE = 13;
    private static final int TAG_PAGE_LAYOUT_SCALE_PRE = 14;
    private static final int TAG_PAGE_LAYOUT_SCALE_FLOAT = 15;

    public void load(TaggedReader reader) throws IOException {
        while (reader.getNextTag() != 0) {
            switch (reader.getCurrentTag()) {
                case 1: {
                    this.active = reader.getBoolean();
                    break;
                }
                case 2: {
                    this.portrait = reader.getBoolean();
                    break;
                }
                case 3: {
                    this.format = reader.getInt();
                    break;
                }
                case 4: {
                    this.width = reader.getInt();
                    break;
                }
                case 5: {
                    this.height = reader.getInt();
                    break;
                }
                case 6: {
                    this.leftField = reader.getInt();
                    break;
                }
                case 7: {
                    this.rightField = reader.getInt();
                    break;
                }
                case 8: {
                    this.topField = reader.getInt();
                    break;
                }
                case 9: {
                    this.bottomField = reader.getInt();
                    break;
                }
                case 10: {
                    this.hPageCount = reader.getInt();
                    break;
                }
                case 11: {
                    this.vPageCount = reader.getInt();
                    break;
                }
                case 12: {
                    this.fitOnPages = true;
                    break;
                }
                case 13: {
                    this.scalePageType = reader.getByte();
                    break;
                }
                case 14: {
                    this.scalePage = reader.getByte();
                    break;
                }
                case 15: {
                    this.scaleFloat = reader.getDouble();
                }
            }
        }
    }

    public void store(TaggedWriter writer) throws IOException {
        writer.putBool(1, this.active);
        writer.putBool(2, this.portrait);
        writer.putInt32(3, this.format);
        writer.putInt32(4, this.width);
        writer.putInt32(5, this.height);
        writer.putInt32(6, this.leftField);
        writer.putInt32(7, this.rightField);
        writer.putInt32(8, this.topField);
        writer.putInt32(9, this.bottomField);
        if (this.hPageCount > 1) {
            writer.putInt32(10, this.hPageCount);
        }
        if (this.vPageCount > 1) {
            writer.putInt32(11, this.vPageCount);
        }
        if (this.fitOnPages) {
            writer.putEmpty(12);
        }
        if (this.scalePageType != 0) {
            writer.putInt08(13, this.scalePageType);
            if (this.scalePageType == 1) {
                writer.putInt08(14, this.scalePage);
            } else if (this.scalePageType == 2) {
                writer.putDouble(15, this.scaleFloat);
            }
        }
    }

    public boolean getActive() {
        return this.active;
    }

    public boolean getPortrait() {
        return this.portrait;
    }

    public int getFormat() {
        return this.format;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getLeftField() {
        return this.leftField;
    }

    public int getRightField() {
        return this.rightField;
    }

    public int getTopField() {
        return this.topField;
    }

    public int getBottomField() {
        return this.bottomField;
    }

    public boolean getFitOnPages() {
        return this.fitOnPages;
    }

    public int getHPageCount() {
        return this.hPageCount;
    }

    public int getVPageCount() {
        return this.vPageCount;
    }

    public byte getScalePageType() {
        return this.scalePageType;
    }

    public byte getScalePage() {
        return this.scalePage;
    }

    public double getScaleFloat() {
        return this.scaleFloat;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void setPortrait(boolean portrait) {
        this.portrait = portrait;
    }

    public void setFormat(int format) {
        this.format = format;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setLeftField(int leftField) {
        this.leftField = leftField;
    }

    public void setRightField(int rightField) {
        this.rightField = rightField;
    }

    public void setTopField(int topField) {
        this.topField = topField;
    }

    public void setBottomField(int bottomField) {
        this.bottomField = bottomField;
    }

    public void sethPageCount(int hPageCount) {
        this.hPageCount = hPageCount;
    }

    public void setvPageCount(int vPageCount) {
        this.vPageCount = vPageCount;
    }

    public void setFitOnPages(boolean fitOnPages) {
        this.fitOnPages = fitOnPages;
    }

    public void setScalePageType(byte scalePageType) {
        this.scalePageType = scalePageType;
    }

    public void setScalePage(byte scalePage) {
        this.scalePage = scalePage;
    }

    public void setScaleFloat(double scaleFloat) {
        this.scaleFloat = scaleFloat;
    }

    public int getPagePrintWidth() {
        return this.width - this.leftField - this.rightField;
    }

    public int getPagePrintHeight() {
        return this.height - this.topField - this.bottomField;
    }

    public void clearFields() {
        this.topField = 0;
        this.leftField = 0;
        this.rightField = 0;
        this.bottomField = 0;
    }
}

