/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes;

import inform.adt.DateTime;
import inform.adt.InformException;
import inform.adt.NumberConverter;
import inform.adt.collections.DoubleHash;
import inform.adt.collections.IntegerSet;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.agent.Core;
import inform.agent.Ini;
import inform.agent.Request;
import inform.agent.ServerSideHost;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.TableDescriptor;
import inform.agent.db.commit.AuditModification;
import inform.agent.db.commit.TableDataAudit;
import inform.agent.db.connect.ConnectionManager;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.connect.ResultSet;
import inform.agent.db.utils.SqlStringBuilder;
import inform.agent.files.FileCache;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.BasicNode;
import inform.agent.schemes.Scheme;
import inform.agent.schemes.SchemeKeepSettings;
import inform.agent.schemes.SchemeObject;
import inform.agent.schemes.SchemeObjectFilter;
import inform.agent.scripts.SSContext;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;

public class SchemesManager {
    private static final FileCache CACHE;
    private static final HashMap<String, String> FONT_HASH_MAP;
    private static final long SAVE_CRITICAL_TIME = 5000L;
    private static SchemeObjectFilter aliveObjectsFilter;
    private static DoubleHash<NodeSchemeDescriptor> nodeSchemes;
    private static Vector<BlobSchemeDescriptor> tableSchemes;

    public static synchronized byte[] getFontFileContent(String fontName) throws IOException {
        return CACHE.get(FONT_HASH_MAP.get(fontName.toLowerCase()), 0L);
    }

    public static synchronized void loadFontsFromReader(TaggedReader reader) throws TaggedReaderException, IOException {
        String fileName = null;
        FONT_HASH_MAP.clear();
        while (reader.next()) {
            switch (reader.getCurrentTag()) {
                case 2: {
                    fileName = reader.getAnsi();
                    break;
                }
                case 3: {
                    CACHE.put(fileName, reader.getRaw());
                    break;
                }
                case 4: {
                    FONT_HASH_MAP.put(reader.getAnsi().toLowerCase(), fileName);
                }
            }
        }
    }

    static synchronized byte[] openScheme(double nodeID) throws InformException {
        byte[] b = null;
        if (!Ini.libraryMode) {
            b = MtdEngine.getNodeContent(nodeID);
        }
        return b;
    }

    static synchronized byte[] openScheme(SSContext ssContext, ConnectionManager dbMgr, double tableID, double recordID, int fieldID) throws Exception {
        TableDescriptor tableDesc = TableDescriptor.get(tableID);
        if (tableDesc.getRecordIdField() == null) {
            return null;
        }
        FieldDescriptor fieldDesc = tableDesc.getFieldDescriptor(fieldID);
        try (DatabaseConnection db = dbMgr.getConnection(tableDesc.getDbId(), "SchemesManager::openScheme");){
            String sql = new SqlStringBuilder().append("select ").append(fieldDesc).append(" from ").append(tableDesc).append(" where ").append(tableDesc.getRecordIdField()).append(" = ?").toString();
            PreparedStatement stmt = db.prepareStatement("openScheme", sql);
            try {
                stmt.setQueryTimeout();
                stmt.setDouble(1, recordID);
                try (ResultSet result = stmt.executeQuery(ssContext);){
                    if (result.next()) {
                        byte[] byArray = result.getBlobBytes(1);
                        return byArray;
                    }
                    throw new InformException(String.format("\u0421\u0445\u0435\u043c\u0430 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435 %s, \u0437\u0430\u043f\u0438\u0441\u0438 %s, \u043f\u043e\u043b\u0435 %d", NumberConverter.doubleToString(tableID), NumberConverter.doubleToString(recordID), fieldID));
                }
            }
            finally {
                try {
                    stmt.close();
                    db.commit();
                }
                catch (Throwable ex) {
                    Core.logger.error(null, ex);
                }
            }
        }
    }

    static synchronized Scheme getScheme(BasicNode node, ServerSideHost ssHost, SchemeKeepSettings newKeepSettings) throws Exception {
        return SchemesManager.getScheme(node, true, ssHost, newKeepSettings);
    }

    static synchronized Scheme getScheme(BasicNode node, boolean putIntoCache, ServerSideHost ssHost, SchemeKeepSettings newKeepSettings) throws Exception {
        Scheme schemeObj = null;
        NodeSchemeDescriptor schemeDesc = nodeSchemes.get(node.getId());
        if (schemeDesc != null) {
            schemeObj = schemeDesc.schemeRef.get();
            if (schemeObj != null && node.getContentSize() == schemeDesc.schemeSize) {
                return schemeObj;
            }
            nodeSchemes.remove(node.getId());
        }
        schemeDesc = new NodeSchemeDescriptor();
        schemeDesc.nodeID = node.getId();
        byte[] nodeContent = node.getContent();
        schemeObj = new Scheme(ssHost, new ByteArrayInputStream(nodeContent), node.getId(), newKeepSettings);
        if (schemeObj != null) {
            schemeDesc.schemeRef = new SoftReference<Scheme>(schemeObj);
            schemeDesc.schemeSize = nodeContent.length;
            schemeObj.schemeSize = schemeDesc.schemeSize;
            if (putIntoCache) {
                nodeSchemes.add(schemeDesc);
            }
            schemeObj.updateStartTime();
        }
        return schemeObj;
    }

    public static synchronized Scheme getScheme(double id, byte[] content, ServerSideHost ssHost, SchemeKeepSettings keepSettings) throws Exception {
        Scheme schemeObj = new Scheme(ssHost, new ByteArrayInputStream(content), id, null);
        schemeObj.schemeSize = content.length;
        if (schemeObj.getKeepSettings() == null) {
            schemeObj.setKeepSettings(keepSettings);
        }
        schemeObj.updateStartTime();
        return schemeObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SchemeSizeDate getBlobSchemeSize(SSContext ssContext, DatabaseConnection connection, TableDescriptor table, FieldDescriptor field, FieldDescriptor dateField, double recordID) throws InformException, SQLException {
        SchemeSizeDate res = new SchemeSizeDate();
        String lengthFunc = connection.getDescriptor().getDatabaseType().caps().blobLengthFunction;
        if (lengthFunc == null) {
            throw new InformException(String.format("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u0441 BLOB \u043f\u043e\u043b\u044f\u043c\u0438 \u0434\u043b\u044f \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u0442\u0438\u043f\u0430 \u0411\u0414 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f: %d", Core.getMetadataDBKind()));
        }
        SqlStringBuilder sql = new SqlStringBuilder();
        sql.append("select ");
        if (dateField != null) {
            sql.append(dateField).append(',');
        }
        sql.append(lengthFunc).append('(').append(field).append(") as len");
        sql.append(" from ").append(table).append(" where ").append(table.getRecordIdField()).append(" = ?");
        PreparedStatement stmt = connection.prepareStatement("getBlobSchemeSize", sql.toString());
        try {
            stmt.setQueryTimeout();
            stmt.setDouble(1, recordID);
            try (ResultSet result = stmt.executeQuery(ssContext);){
                if (result.next()) {
                    if (dateField != null) {
                        res.schemeDate = result.getDateTime(1);
                    }
                    res.schemeSize = result.getLong(result.findColumn("len"));
                    SchemeSizeDate schemeSizeDate = res;
                    return schemeSizeDate;
                }
            }
            res.schemeSize = -1L;
            SchemeSizeDate schemeSizeDate = res;
            return schemeSizeDate;
        }
        finally {
            try {
                stmt.close();
            }
            catch (Throwable ex) {
                Core.logger.error(null, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SchemeSizeDate getBlobSchemeSize(SSContext ssContext, ConnectionManager dbMgr, double tableID, double recordID, int fieldID, int dateFieldID) throws InformException, Exception {
        SchemeSizeDate res = new SchemeSizeDate();
        TableDescriptor tableDesc = TableDescriptor.get(tableID);
        if (tableDesc.getRecordIdField() == null) {
            return res;
        }
        FieldDescriptor fieldDesc = tableDesc.getFieldDescriptor(fieldID);
        FieldDescriptor dateFieldDesc = tableDesc.getFieldDescriptor(dateFieldID);
        try (DatabaseConnection db = dbMgr.getConnection(tableDesc.getDbId(), "SchemesManager::getBlobSchemeSize");){
            res = SchemesManager.getBlobSchemeSize(ssContext, db, tableDesc, fieldDesc, dateFieldDesc, recordID);
            db.commit();
            SchemeSizeDate schemeSizeDate = res;
            return schemeSizeDate;
        }
    }

    static synchronized Scheme getScheme(SSContext ssContext, ConnectionManager dbMgr, double tableID, double recordID, int fieldID, int dateFieldID, SchemeKeepSettings newKeepSettings) throws InformException, Exception {
        return SchemesManager.getScheme(ssContext, dbMgr, tableID, recordID, fieldID, dateFieldID, true, false, newKeepSettings);
    }

    /*
     * Exception decompiling
     */
    public static synchronized Scheme getScheme(SSContext ssContext, ConnectionManager dbMgr, double tableID, double recordID, int fieldID, int dateFieldID, boolean putIntoCache, boolean fromOpenRequest, SchemeKeepSettings newKeepSettings) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK], 17[CATCHBLOCK]], but top level block is 9[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void doSaveScheme(SSContext ssContext, ConnectionManager dbMgr, Request request, Scheme scheme) throws InformException, Exception {
        for (NodeSchemeDescriptor nodeSchemeDescriptor : nodeSchemes) {
            if (nodeSchemeDescriptor == null || nodeSchemeDescriptor.schemeRef.get() != scheme) continue;
            SchemesManager.saveScheme(request, nodeSchemeDescriptor);
            return;
        }
        for (BlobSchemeDescriptor blobSchemeDescriptor : tableSchemes) {
            if (blobSchemeDescriptor == null || blobSchemeDescriptor.scheme.get() != scheme) continue;
            SchemesManager.saveScheme(ssContext, dbMgr, request, blobSchemeDescriptor);
            return;
        }
        throw new InformException("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u0430\u044f \u0441\u0445\u0435\u043c\u0430!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean trySaveScheme(SSContext ssContext, ConnectionManager dbMgr, Request request, Scheme scheme) throws InformException, Exception {
        boolean saved = false;
        if (scheme.tryAcquireForSaving()) {
            try {
                SchemesManager.doSaveScheme(ssContext, dbMgr, request, scheme);
                saved = true;
            }
            finally {
                try {
                    scheme.releaseFromSaving();
                }
                catch (Throwable ex) {
                    Core.logger.error(null, ex);
                }
            }
        }
        return saved;
    }

    private static boolean internalGenerateGeneratedField(char initComma, TableDescriptor tableInfo, IntegerSet modifiedFields, StringBuilder fieldsSql, StringBuilder valuesSql, boolean checkAllGenerators, ArrayList<Double> outValues) {
        int COMMA = 44;
        boolean result = false;
        int sqlComma = initComma;
        for (FieldDescriptor field : tableInfo.getFields()) {
            FieldDescriptor.AutoValueGenerator generatorType = field.getAutoValueGenerator();
            if (generatorType != FieldDescriptor.AutoValueGenerator.TIMESTAMP || !checkAllGenerators && field.isCalcValueGeneratorForInsertOnly() || modifiedFields != null && field.getValueGeneratorField() != 0 && !modifiedFields.contains(field.getValueGeneratorField())) continue;
            fieldsSql.append((char)sqlComma).append(field.getRawName());
            if (valuesSql == null) {
                fieldsSql.append("=?");
            } else {
                valuesSql.append((char)sqlComma).append('?');
            }
            sqlComma = 44;
            outValues.add(DateTime.currentDateTime());
            result = true;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveScheme(SSContext ssContext, ConnectionManager dbMgr, Request request, BlobSchemeDescriptor schemeDesc) throws Exception {
        Scheme scheme = schemeDesc.scheme.get();
        if (scheme != null) {
            boolean NeedClearCache = true;
            TableDescriptor tableDesc = TableDescriptor.get(schemeDesc.tableID);
            if (tableDesc.getRecordIdField() == null) {
                return;
            }
            FieldDescriptor fieldDesc = tableDesc.getFieldDescriptor(schemeDesc.fieldID);
            DatabaseConnection db = dbMgr.getConnection(tableDesc.getDbId(), "SchemesManager::saveScheme");
            try {
                long t1 = new Date().getTime();
                long SchemeSize = schemeDesc.schemeSize;
                double schDate = schemeDesc.schemeDate;
                FieldDescriptor schemeDateDesc = null;
                if (scheme.getKeepSettings() != null) {
                    schemeDateDesc = tableDesc.getFieldDescriptor(scheme.getKeepSettings().getSchemeDate());
                }
                SqlStringBuilder sql = new SqlStringBuilder();
                sql.append("update ").append(tableDesc).append(" set ").append(fieldDesc).append(" = ?");
                if (schemeDateDesc != null) {
                    sql.append(',').append(schemeDateDesc).append(" = ?");
                }
                ArrayList<Double> generatedValues = new ArrayList<Double>();
                IntegerSet modifiedFields = new IntegerSet();
                modifiedFields.add(schemeDesc.fieldID);
                boolean areGeneratedFields = SchemesManager.internalGenerateGeneratedField(',', tableDesc, modifiedFields, sql.getBuilder(), null, false, generatedValues);
                sql.append(" where ").append(tableDesc.getRecordIdField()).append(" = ?");
                PreparedStatement stmt = db.prepareStatement("saveScheme", sql.toString());
                try {
                    stmt.setQueryTimeout();
                    int paramIndex = 0;
                    int DefSchemeSize = 32768;
                    if (SchemeSize > (long)DefSchemeSize) {
                        DefSchemeSize = (int)(1.1 * (double)SchemeSize);
                    }
                    ByteArrayOutputStream outStream = new ByteArrayOutputStream(DefSchemeSize);
                    scheme.save(outStream, aliveObjectsFilter, schemeDesc.recordID, request, db);
                    outStream.close();
                    SchemeSize = outStream.size();
                    stmt.setBlob(++paramIndex, outStream.internalBuffer(), (int)SchemeSize);
                    if (areGeneratedFields) {
                        for (int j = 0; j < generatedValues.size(); ++j) {
                            stmt.setDateTime(++paramIndex, generatedValues.get(j));
                        }
                    }
                    if (schemeDateDesc != null) {
                        schDate = DateTime.currentDateTime();
                        schDate = (double)((int)schDate) + (double)((int)((schDate - (double)((int)schDate)) * 86400.0)) / 86400.0;
                        stmt.setDateTime(++paramIndex, schDate);
                        stmt.setDouble(++paramIndex, schemeDesc.recordID);
                    } else {
                        stmt.setDouble(++paramIndex, schemeDesc.recordID);
                    }
                    stmt.executeUpdate(ssContext);
                }
                finally {
                    try {
                        stmt.close();
                    }
                    catch (Throwable ex) {
                        Core.logger.error(null, ex);
                    }
                }
                TableDataAudit audit = db.getTableDataAudit();
                if (audit == null) {
                    audit = new TableDataAudit(dbMgr.context, db, request == null ? 0.0 : request.getUserID(), request == null ? 0.0 : request.getEffectiveUserID(), 0.0, 0.0, request == null ? 0.0 : request.getSessionID());
                }
                audit.registrateModification(tableDesc, schemeDesc.recordID, AuditModification.MODIFY);
                audit.flush();
                if (request != null) {
                    request.idle();
                }
                db.commit();
                long t2 = new Date().getTime();
                if (t2 - t1 > 5000L) {
                    Core.logger.warn("Too long saving to blob: {} msec", (Object)(t2 - t1));
                }
                Core.notifyRecordChanged(schemeDesc.tableID, schemeDesc.recordID);
                scheme.schemeSize = schemeDesc.schemeSize = SchemeSize;
                scheme.schemeDate = schemeDesc.schemeDate = schDate;
                NeedClearCache = false;
            }
            finally {
                if (NeedClearCache) {
                    schemeDesc.scheme.clear();
                    tableSchemes.remove(schemeDesc);
                }
                db.close();
            }
            scheme = null;
        }
    }

    private static void saveScheme(Request request, NodeSchemeDescriptor schemeDesc) throws Exception, InformException, SQLException {
        Scheme scheme = schemeDesc.schemeRef.get();
        if (scheme != null && !Ini.libraryMode) {
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            long t1 = new Date().getTime();
            scheme.save(outStream, aliveObjectsFilter, schemeDesc.nodeID);
            long t2 = new Date().getTime();
            MtdEngine.setNodeContent(request.getSSContext(), request, schemeDesc.nodeID, 0L, outStream.toByteArray(), null, request.getUserID(), request.getSessionID(), request.security());
            long t3 = new Date().getTime();
            if (t2 - t1 > 5000L) {
                Core.logger.warn("Too long saving to byte stream: {} msec", (Object)(t2 - t1));
            }
            if (t3 - t2 > 5000L) {
                Core.logger.warn("Too long storing node content: {} msec", (Object)(t3 - t2));
            }
            if (t3 - t1 > 5000L) {
                Core.logger.warn("Too long saving node-scheme: {} msec", (Object)(t3 - t1));
            }
            schemeDesc.schemeSize = outStream.size();
            scheme.schemeSize = schemeDesc.schemeSize;
        }
    }

    static {
        String tempDirProp = Core.getTempDir();
        if (tempDirProp == null) {
            throw new InformException("Can not determine temp directory path");
        }
        File dir = new File(tempDirProp, "PHA_CACHE/FONTS");
        if (!dir.exists() && !dir.mkdirs()) {
            throw new InformException("Cannot create directory:" + dir);
        }
        CACHE = new FileCache(dir, 1024, 0x40000000L);
        FONT_HASH_MAP = new HashMap();
        aliveObjectsFilter = new SchemeObjectFilter(){

            @Override
            public boolean fits(SchemeObject object) {
                return !object.isDeleted();
            }
        };
        nodeSchemes = new DoubleHash();
        tableSchemes = new Vector();
    }

    public static class SchemeSizeDate {
        public long schemeSize = 0L;
        public double schemeDate = 0.0;
    }

    private static class BlobSchemeDescriptor {
        private double tableID;
        private double recordID;
        private int fieldID;
        private SoftReference<Scheme> scheme;
        private long schemeSize;
        private double schemeDate;

        private BlobSchemeDescriptor() {
        }
    }

    private static class NodeSchemeDescriptor
    implements DoubleHash.Entry {
        private double nodeID;
        private SoftReference<Scheme> schemeRef;
        private int schemeSize;

        private NodeSchemeDescriptor() {
        }

        @Override
        public double key() {
            return this.nodeID;
        }
    }
}

