/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes;

import inform.adt.NumberConverter;
import inform.adt.Strings;
import inform.agent.Core;
import inform.agent.ServerSideHost;
import inform.agent.db.connect.ConnectionManager;
import inform.agent.schemes.Attribute;
import inform.agent.schemes.AttributeDef;
import inform.agent.schemes.AttributeRef;
import inform.agent.schemes.BaseGraphic;
import inform.agent.schemes.BaseShape;
import inform.agent.schemes.Ellipse;
import inform.agent.schemes.EmbeddedText;
import inform.agent.schemes.GraphicBlock;
import inform.agent.schemes.Image;
import inform.agent.schemes.Paragraph;
import inform.agent.schemes.PdfWriter;
import inform.agent.schemes.PhxGraphicInsert;
import inform.agent.schemes.PhxImage;
import inform.agent.schemes.Pie;
import inform.agent.schemes.Polygon;
import inform.agent.schemes.Polyline;
import inform.agent.schemes.PrimParam;
import inform.agent.schemes.Primitive;
import inform.agent.schemes.RectTextLine;
import inform.agent.schemes.Rectangle;
import inform.agent.schemes.Region;
import inform.agent.schemes.Scheme;
import inform.agent.schemes.SchemeEngine;
import inform.agent.schemes.SchemeObject;
import inform.agent.schemes.SchemeObjectsTypes;
import inform.agent.schemes.SchemePage;
import inform.agent.schemes.SchemePageLayout;
import inform.agent.schemes.SchemeUtils;
import inform.agent.schemes.Spline;
import inform.agent.schemes.TransformProps;
import inform.agent.scripts.FileSystemLibrary;
import inform.agent.web.utils.HtmlUtils;
import inform.agent.web.utils.ImageInfo;
import inform.common.Base64BinString;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.IntStream;
import javax.imageio.ImageIO;
import net.sf.image4j.codec.ico.ICODecoder;
import net.sf.image4j.codec.ico.ICOImage;

public class SvgWriter {
    private final Scheme s;
    private final SchemeEngine engine;
    private double schemeScale = 1.0;
    private GraphicBlock primBlock;
    private PrintWriter pw;
    private boolean insertMode;
    private static final int BOUNDS_OFFSET = 0;
    private static final double DISPLACE_COEFF = 1.5;
    private final StringBuilder _gradients = new StringBuilder();
    private final StringBuilder _patterns = new StringBuilder();
    private final StringBuilder _styles = new StringBuilder();
    private final StringBuilder _content = new StringBuilder();
    private final HashMap<Integer, String> mapStyles = new HashMap();
    private ServerSideHost stateHost;
    private static final int PATTERN_SIZE = 16;
    private static final String horizImage = "                                                                                                XXXXXXXXXXXXXXXX                                                                                                                XXXXXXXXXXXXXXXX                ";
    private static final String vertImage = "     X       X       X       X       X       X       X       X       X       X       X       X       X       X       X       X       X       X       X       X       X       X       X       X       X       X       X       X       X       X       X       X  ";
    private static final String diagRevertImage = "X       X        X       X        X       X        X       X        X       X        X       X        X       X        X       XX       X        X       X        X       X        X       X        X       X        X       X        X       X        X       X";
    private static final String diagImage = "   X       X      X       X      X       X      X       X              X       X      X       X      X       X      X       X      X       X      X       X      X       X      X       X              X       X      X       X      X       X      X       X   ";
    private static final String cellImage = "     X       X       X       X       X       X       X       X       X       X       X       X  XXXXXXXXXXXXXXXX     X       X       X       X       X       X       X       X       X       X       X       X       X       X  XXXXXXXXXXXXXXXX     X       X  ";
    private static final String diagCellImage = "X  X    X  X     XX      XX      XX      XX     X  X    X  X        X  X    X  X     XX      XX      XX      XX     X  X    X  XX  X    X  X     XX      XX      XX      XX     X  X    X  X        X  X    X  X     XX      XX      XX      XX     X  X    X  X";
    private static final String dotImage = "XXXXXXXXXXXXXXXXXXXX XXXXXXX XXXXXXXXXXXXXXXXXXX XXXXXXX XXXXXXXXXXXXXXXXXXXXXXXXXXX XXXXXXX XXXXXXXXXXXXXXXXXXX XXXXXXX XXXXXXXXXXXXXXXXXXXXXXXXXXX XXXXXXX XXXXXXXXXXXXXXXXXXX XXXXXXX XXXXXXXXXXXXXXXXXXXXXXXXXXX XXXXXXX XXXXXXXXXXXXXXXXXXX XXXXXXX XXXXXXX";
    private static final String dot2Image = "XXXXXXXXXXXXXXXXXXX XXX XXX XXX XXXXXXXXXXXXXXXXX XXX XXX XXX XXXXXXXXXXXXXXXXXXXXX XXX XXX XXX XXXXXXXXXXXXXXXXX XXX XXX XXX XXXXXXXXXXXXXXXXXXXXX XXX XXX XXX XXXXXXXXXXXXXXXXX XXX XXX XXX XXXXXXXXXXXXXXXXXXXXX XXX XXX XXX XXXXXXXXXXXXXXXXX XXX XXX XXX XX";
    private static final String dot3Image = "XX XXX XXX XXX X XXX XXX XXX XXXXX XXX XXX XXX X XXX XXX XXX XXXXX XXX XXX XXX X XXX XXX XXX XXXXX XXX XXX XXX X XXX XXX XXX XXXXX XXX XXX XXX X XXX XXX XXX XXXXX XXX XXX XXX X XXX XXX XXX XXXXX XXX XXX XXX X XXX XXX XXX XXXXX XXX XXX XXX X XXX XXX XXX XXX";
    private static final String dot4Image = "X X X X X X X X  X X X X X X X XX X X X X X X X  X X X X X X X XX X X X X X X X  X X X X X X X XX X X X X X X X  X X X X X X X XX X X X X X X X  X X X X X X X XX X X X X X X X  X X X X X X X XX X X X X X X X  X X X X X X X XX X X X X X X X  X X X X X X X X";
    private static final String dot5Image = "  X   X   X   X X   X   X   X     X   X   X   X X   X   X   X     X   X   X   X X   X   X   X     X   X   X   X X   X   X   X     X   X   X   X X   X   X   X     X   X   X   X X   X   X   X     X   X   X   X X   X   X   X     X   X   X   X X   X   X   X   ";
    private static final String dot6Image = "                 X   X   X   X                     X   X   X   X                 X   X   X   X                     X   X   X   X                 X   X   X   X                     X   X   X   X                 X   X   X   X                     X   X   X   X";
    private static final String dot7Image = "                  X       X                           X       X                   X       X                           X       X                   X       X                           X       X                   X       X                           X       X ";
    private static final String horiz2Image = "                                                                                XXXXXXXXXXXXXXXX                                                                                                                XXXXXXXXXXXXXXXX                                ";
    private static final String doubleHorizImage = "                                                                                XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX                                                                                                XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX                ";
    private static final String horiz3Image = "                                XXXXXXXXXXXXXXXX                                                XXXXXXXXXXXXXXXX                                                XXXXXXXXXXXXXXXX                                                XXXXXXXXXXXXXXXX                ";
    private static final String doubleHoriz2Image = "                XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX                                XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX                                XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX                                XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX                ";
    private static final String horiz4Image = "XXXXXXXXXXXXXXXX                XXXXXXXXXXXXXXXX                XXXXXXXXXXXXXXXX                XXXXXXXXXXXXXXXX                XXXXXXXXXXXXXXXX                XXXXXXXXXXXXXXXX                XXXXXXXXXXXXXXXX                XXXXXXXXXXXXXXXX                ";
    private static final String vert2Image = "X       X       X       X       X       X       X       X       X       X       X       X       X       X       X       X       X       X       X       X       X       X       X       X       X       X       X       X       X       X       X       X       ";
    private static final String doubleVertImage = "XX      XX      XX      XX      XX      XX      XX      XX      XX      XX      XX      XX      XX      XX      XX      XX      XX      XX      XX      XX      XX      XX      XX      XX      XX      XX      XX      XX      XX      XX      XX      XX      ";
    private static final String vert3Image = "  X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X ";
    private static final String doubleVert2Image = "  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX";
    private static final String vert4Image = "X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X ";
    private static final String diag2Image = "     X       X      X       X      X       X      X       X      X       X      X       X              X       X      X       X      X       X      X       X      X       X      X       X      X       X      X       X              X       X      X       X ";
    private static final String doubleDiagImage = "      XX      XX     XX      XX     XX      XX     XX      XX     XX      XX     XX      XX     XX      XX      X      XX      X      XX      XX     XX      XX     XX      XX     XX      XX     XX      XX     XX      XX     XX      XX      X      XX      X";
    private static final String diag3Image = "   X   X   X   X  X   X   X   X  X   X   X   X  X   X   X   X      X   X   X   X  X   X   X   X  X   X   X   X  X   X   X   X      X   X   X   X  X   X   X   X  X   X   X   X  X   X   X   X      X   X   X   X  X   X   X   X  X   X   X   X  X   X   X   X   ";
    private static final String doubleDiag2Image = "XX  XX  XX  XX  X  XX  XX  XX  X  XX  XX  XX  XX XX  XX  XX  XX XX  XX  XX  XX  X  XX  XX  XX  X  XX  XX  XX  XX XX  XX  XX  XX XX  XX  XX  XX  X  XX  XX  XX  X  XX  XX  XX  XX XX  XX  XX  XX XX  XX  XX  XX  X  XX  XX  XX  X  XX  XX  XX  XX XX  XX  XX  XX ";
    private static final String tripleDiagImage = "X XXX XXX XXX XX XXX XXX XXX XXXXXX XXX XXX XXX XX XXX XXX XXX XX XXX XXX XXX XX XXX XXX XXX XXXXXX XXX XXX XXX XX XXX XXX XXX XX XXX XXX XXX XX XXX XXX XXX XXXXXX XXX XXX XXX XX XXX XXX XXX XX XXX XXX XXX XX XXX XXX XXX XXXXXX XXX XXX XXX XX XXX XXX XXX X";
    private static final String diagRevert2Image = "   X       X        X       X        X       X        X       X        X       XX       X        X       X        X       X        X       X        X       X        X       X        X       X        X       XX       X        X       X        X       X     ";
    private static final String doubleDiagRevertImage = "   XX      XX       XX      XX       XX      XX       XX      XXX      XX      XXX      XX       XX      XX       XX      XX       XX      XX       XX      XX       XX      XX       XX      XXX      XX      XXX      XX       XX      XX       XX      XX    ";
    private static final String diagRevert3Image = "X   X   X   X    X   X   X   X    X   X   X   X    X   X   X   XX   X   X   X    X   X   X   X    X   X   X   X    X   X   X   XX   X   X   X    X   X   X   X    X   X   X   X    X   X   X   XX   X   X   X    X   X   X   X    X   X   X   X    X   X   X   X";
    private static final String doubleDiagRevert2Image = "XX  XX  XX  XX   XX  XX  XX  XX   XX  XX  XX  XXX  XX  XX  XX  XXX  XX  XX  XX   XX  XX  XX  XX   XX  XX  XX  XXX  XX  XX  XX  XXX  XX  XX  XX   XX  XX  XX  XX   XX  XX  XX  XXX  XX  XX  XX  XXX  XX  XX  XX   XX  XX  XX  XX   XX  XX  XX  XXX  XX  XX  XX  X";
    private static final String tripleDiagRevertImage = "XX XXX XXX XXX XXXX XXX XXX XXX  XXX XXX XXX XXXX XXX XXX XXX XXXX XXX XXX XXX XXXX XXX XXX XXX  XXX XXX XXX XXXX XXX XXX XXX XXXX XXX XXX XXX XXXX XXX XXX XXX  XXX XXX XXX XXXX XXX XXX XXX XXXX XXX XXX XXX XXXX XXX XXX XXX  XXX XXX XXX XXXX XXX XXX XXX XX";
    private static final String cell2Image = "XXXXXXXXXXXXXXXX       X       X       X       X       X       X       X       X       X       X       X       X       X       XXXXXXXXXXXXXXXXX       X       X       X       X       X       X       X       X       X       X       X       X       X       X";
    private static final String doubleCellImage = "XXXXXXXXXXXXXXXXX      XX      XX      XX      XX      XX      XX      XX      XX      XX      XX      XX      XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX      XX      XX      XX      XX      XX      XX      XX      XX      XX      XX      XX      XXXXXXXXXXXXXXXXX";
    private static final String cell3Image = "  X   X   X   X   X   X   X   X   X   X   X   X XXXXXXXXXXXXXXXX  X   X   X   X   X   X   X   X   X   X   X   X XXXXXXXXXXXXXXXX  X   X   X   X   X   X   X   X   X   X   X   X XXXXXXXXXXXXXXXX  X   X   X   X   X   X   X   X   X   X   X   X XXXXXXXXXXXXXXXX";
    private static final String doubleCell2Image = "XXXXXXXXXXXXXXXX XX  XX  XX  XX  XX  XX  XX  XX XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX XX  XX  XX  XX  XX  XX  XX  XX XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX XX  XX  XX  XX  XX  XX  XX  XX XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX XX  XX  XX  XX  XX  XX  XX  XX XXXXXXXXXXXXXXXX";
    private static final String cell4Image = "XXXXXXXXXXXXXXXX X X X X X X X XXXXXXXXXXXXXXXXX X X X X X X X XXXXXXXXXXXXXXXXX X X X X X X X XXXXXXXXXXXXXXXXX X X X X X X X XXXXXXXXXXXXXXXXX X X X X X X X XXXXXXXXXXXXXXXXX X X X X X X X XXXXXXXXXXXXXXXXX X X X X X X X XXXXXXXXXXXXXXXXX X X X X X X X X";
    private static final String diagCell2Image = "   X   X   X   X    X X     X X      X       X      X X     X X    X   X   X   XX X     X X      X       X      X X     X X        X   X   X   X    X X     X X      X       X      X X     X X    X   X   X   XX X     X X      X       X      X X     X X     ";
    private static final String doubleDiagCellImage = "X  XX  XX  XX  X    XXXX    XXXX     XX      XX     XXXX    XXXXX  XX  XX  XX  XXXXX    XXXX     XX      XX     XXXX    XXXX    X  XX  XX  XX  X    XXXX    XXXX     XX      XX     XXXX    XXXX   XX  XX  XX  XX XX    XXXX     XX      XX     XXXX    XXXX    ";
    private static final String diagCell3Image = " X   X   X   X  X X X X X X X X    X   X   X   XX X X X X X X X  X   X   X   X  X X X X X X X X    X   X   X   XX X X X X X X X  X   X   X   X  X X X X X X X X    X   X   X   XX X X X X X X X  X   X   X   X  X X X X X X X X    X   X   X   XX X X X X X X X ";
    private static final String doubleDiagCell2Image = "  XX  XX  XX  XX  XX  XX  XX  XXXX  XX  XX  XX  XX  XX  XX  XX    XX  XX  XX  XX  XX  XX  XX  XXXX  XX  XX  XX  XX  XX  XX  XX    XX  XX  XX  XX  XX  XX  XX  XXXX  XX  XX  XX  XX  XX  XX  XX    XX  XX  XX  XX  XX  XX  XX  XXXX  XX  XX  XX  XX  XX  XX  XX  ";
    private static final String pattern1Image = "     XX      XX XX   XX XX   XX XX XX   XX XX      XX      XX   X      XX      XX   XX XX   XX X XX XX   XX XX   XX      XX          XX      XX XX   XX XX   XX XX XX   XX XX      XX      XX   X      XX      XX   XX XX   XX X XX XX   XX XX   XX      XX     ";
    private static final String pattern2Image = "      X       X  X       X          X       X   X       X            X       X    X       X            X       X   X       X          X       X  X       X          X       X   X       X            X       X    X       X            X       X   X       X    ";
    private static final String pattern3Image = "                X X X X X X X X                 X X X X X X X X                 X X X X X X X X                 X X X X X X X X                 X X X X X X X X                 X X X X X X X X                 X X X X X X X X                 X X X X X X X X ";
    private static final String pattern4Image = "  X       X        X       X                           X       X      X       X      X       X                   X       X        X       X        X       X                           X       X      X       X      X       X                   X       X      ";
    private static final String pattern5Image = "                                    X       X                                                   X       X                                                           X       X                                                   X       X                       ";
    private static final String pattern6Image = "                                     X       X                                                                                                                       X       X                                                                                  ";
    private static final String pattern7Image = "X  XXX  X  XXX    X   X   X   X  X     X X     XX       X       X       X       X       X        X     X X     X  X   X   X   X X  XXX  X  XXX    X   X   X   X  X     X X     XX       X       X       X       X       X        X     X X     X  X   X   X   X ";
    private static final String pattern8Image = " X   X   X   X    X XXX   X XXX    XXXXX   XXXXXX   XXX X   XXX  X   X   X   X  XXX X   XXX X   XXXX   XXXXX   XXXX   X XXX   X  X   X   X   X    X XXX   X XXX    XXXXX   XXXXXX   XXX X   XXX  X   X   X   X  XXX X   XXX X   XXXX   XXXXX   XXXX     XXX   X ";
    private static final String pattern9Image = " X       X       X       X       X X X X X X X X    X X     X X      X       X       X       X   X X X X X X X XX X     X X      X       X       X       X       X X X X X X X X    X X     X X      X       X       X       X   X X X X X X X XX X     X X     ";
    private static final String pattern10Image = "   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X    X X     X X      X       X   X       X      X X     X X        X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X    X X     X X      X       X   X       X      X X     X X     ";
    private static final String pattern11Image = "XXXXXXX XXXXXXX XXXXXXX XXXXXXX XX    X XX    X XX    X XX    X XX    X XX    X XX    X XX    X XXXXXXX XXXXXXX                 XXXXXXX XXXXXXX XXXXXXX XXXXXXX XX    X XX    X XX    X XX    X XX    X XX    X XX    X XX    X XXXXXXX XXXXXXX                 ";
    private static final String pattern12Image = "     X       X       X       X  XXXXXXXXXXXXXXXX X       X       X       X       X       X      XXXXXXXXXXXXXXXX     X       X       X       X       X       X  XXXXXXXXXXXXXXXX X       X       X       X       X       X      XXXXXXXXXXXXXXXX     X       X  ";
    private static final String pattern13Image = "                X   X   X   X                       X       X                   X X X X X X X X                     X       X                   X   X   X   X                       X       X                   X X X X X X X X                     X       X   ";
    private static final String pattern14Image = "  XXX     XXX      X       X      X       X      X       X      X       X              X       XX     XXX     XX X   X   X   X    XXX     XXX      X       X      X       X      X       X      X       X              X       XX     XXX     XX X   X   X   X  ";
    private static final String pattern15Image = " X X     X X      X   X   X   X                 X X X X X X X X                   X   X   X   X      X X     X XX   X   X   X    X X     X X      X   X   X   X                 X X X X X X X X                   X   X   X   X      X X     X XX   X   X   X   ";
    private static final String pattern16Image = "                      X       X      X X     X X                                  X       X      X X     X X                                          X       X      X X     X X                                  X       X      X X     X X                    ";
    private static final String pattern17Image = "  XX      XX        XX      XX        X       X        X       X       X       X      XX      XXX    X  X    X   X  X    X  X     XX      XX        XX      XX        X       X        X       X       X       X      XX      XXX    X  X    X   X  X    X  X   ";
    private static final String pattern18Image = " XXXXX   XXXXX     X       X       X       X      X X     X X   XX   XXXXX   XXX       X       X       X       XX     X X     X  XXXXX   XXXXX     X       X       X       X      X X     X X   XX   XXXXX   XXX       X       X       X       XX     X X     X ";
    private static final String pattern19Image = "X X X X X X X X XXXXXXXXXXXXXXXX    X       X      X       X      X       X      X       X      X       X        X X   X X X   XX X X X X X X X XXXXXXXXXXXXXXXX    X       X      X       X      X       X      X       X      X       X        X X   X X X   X";
    private static final String pattern20Image = " XXXXX   XXXXX  X XXX XXX XXX XXXX   X XXX   X  XX   XXXXX   XXXXX   XXXXX   XXXX XXX XXX XXX XX X  XX   X  XX   XXXXX   XXXXX   XXXXX   XXXXX  X XXX XXX XXX XXXX   X XXX   X  XX   XXXXX   XXXXX   XXXXX   XXXX XXX XXX XXX XX X  XX   X  XX   XXXXX   XXXXX  ";
    private static final String pattern21Image = " X X X X X X X XX X   X X X   X  X     X X     XX       X                       X       X        X     X X     XX X   X X X   X  X X X X X X X XX X   X X X   X  X     X X     XX       X                       X       X        X     X X     XX X   X X X   X ";
    private static final String pattern22Image = "X  X  XXX  X  XX  X  XXX  X  XXX X X  X  X X  X X   X   X   X        X X     X XX     X X     X  X   X   X   X    X X  X  X X  XX  X  XXX  X  XX  X  XXX  X  XXX X X  X  X X  X X   X   X   X        X X     X XX     X X     X  X   X   X   X    X X  X  X X  X";
    private static final String pattern23Image = "   XX      XX      XX      XX      XX      XX                   X      XX      XX      XX      XX      XX      X                   XX      XX      XX      XX      XX      XX                   X      XX      XX      XX      XX      XX      X                ";
    private static final String pattern24Image = "X   X   X   X   X   X   X   X   X   X   X   X   XXXXX   XXXXX   X   X   X   X   X   X   X   X   X   X   X   X   X   XXXXX   XXXXX   X   X   X   X   X   X   X   X   X   X   X   XXXXX   XXXXX   X   X   X   X   X   X   X   X   X   X   X   X   X   XXXXX   XXXX";

    public SvgWriter(Scheme scheme) {
        this.s = scheme;
        this.engine = new SchemeEngine(this.s);
        this.engine.InitTmpProps();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToStream(ConnectionManager dbMgr, OutputStream out) throws Exception {
        this.putStateCaption("\u0412\u044b\u043f\u043e\u043b\u043d\u044f\u0435\u0442\u0441\u044f \u044d\u043a\u0441\u043f\u043e\u0440\u0442 \u0441\u0445\u0435\u043c\u044b");
        this.putStateText("\u0421\u0442\u0430\u0442\u0443\u0441: \u043e\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043f\u043e\u0434\u0433\u043e\u0442\u043e\u0432\u043a\u0430 \u043a \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0443 \u0432 SVG-\u0444\u0430\u0439\u043b");
        this.s.parse(dbMgr, true);
        this.s.sortObjects();
        if (this.s.SortLayers.isEmpty()) {
            return;
        }
        this.s.calcSchemeBounds();
        double sw = this.s.getSchemeWidth() + 0.0;
        double sh = this.s.getSchemeHeight() + 0.0;
        double sl = -this.s.getSchemeLeft() + 0.0;
        double st = -this.s.getSchemeTop() + 0.0;
        this.pw = new PrintWriter((Writer)new OutputStreamWriter(out, StandardCharsets.UTF_8), true);
        try {
            SchemePage currentPage = null;
            SchemePage backPage = null;
            if (this.s.exportPageId != Scheme.INVISIBLE_PAGE_ID && !this.s.Pages.empty() && (currentPage = this.s.getPageById(this.s.exportPageId, true)) != null) {
                sw = currentPage.SchemePageWidth + 0.0;
                sh = currentPage.SchemePageHeight + 0.0;
                sl = -currentPage.SchemePageLeft + 0.0;
                st = -currentPage.SchemePageTop + 0.0;
                if (currentPage.backPageId >= 0.0) {
                    backPage = this.s.getPageById(currentPage.backPageId, true);
                }
            }
            this.writeShapes();
            Color BkColor = currentPage == null ? this.s.BkColor : (backPage == null ? currentPage.BkColor : backPage.BkColor);
            String bgColorStr = BkColor == null || BkColor.equals(Color.WHITE) ? "" : String.format(" style=\"background-color:%s\"", SvgWriter.strColor(BkColor));
            this.pw.println("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>");
            this.pw.println("<svg xmlns=\"http://www.w3.org/2000/svg\" version=\"1.2\" baseProfile=\"tiny\"");
            this.pw.println("  xmlns:xlink=\"http://www.w3.org/1999/xlink\"");
            this.pw.println("  xmlns:v=\"http://schemas.microsoft.com/visio/2003/SVGExtensions/\"");
            this.pw.println(String.format("  width=\"%smm\" height=\"%smm\" viewBox=\"%s %s %s %s\"%s>", SvgWriter.f2(sw * this.schemeScale), SvgWriter.f2(sh * this.schemeScale), SvgWriter.f2(0.0), SvgWriter.f2(0.0), SvgWriter.f2(currentPage == null ? this.s.getSchemeWidth() : currentPage.SchemePageWidth * this.schemeScale), SvgWriter.f2(currentPage == null ? this.s.getSchemeHeight() : currentPage.SchemePageHeight * this.schemeScale), bgColorStr));
            this.pw.println(String.format("<style type=\"text/css\">\n<![CDATA[\n%s]]>\n</style>", this._styles));
            this.pw.println(String.format("<g transform=\"translate(%s, %s)\">", SvgWriter.f2(sl * this.schemeScale), SvgWriter.f2(st * this.schemeScale)));
            this.putStateProgressMax(this.s.SortShapes.size());
            this.putStateText("\u0421\u0442\u0430\u0442\u0443\u0441: \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0438\u0440\u0443\u044e\u0442\u0441\u044f \u0444\u0438\u0433\u0443\u0440\u044b");
            this.pw.println(this._content.toString().replaceAll("><(?!tspan)", ">\n<"));
            this.pw.println("</g>");
            this.pw.println("<defs>");
            this.pw.println(this._patterns);
            this.pw.println(this._gradients);
            this.pw.println("</defs>");
            this.pw.println("</svg>");
        }
        finally {
            this.pw.close();
        }
        this.putStateProgressPosition(this.s.SortShapes.size());
        this.putStateText("\u0421\u0442\u0430\u0442\u0443\u0441: SVG-\u0444\u0430\u0439\u043b \u0441\u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d");
    }

    private static String f2(double value) {
        return Double.toString(NumberConverter.simpleRoundTo(value, -2));
    }

    private static double f2d(double value) {
        return NumberConverter.simpleRoundTo(value, -2);
    }

    private static String f5(double value) {
        return Double.toString(NumberConverter.simpleRoundTo(value, -5));
    }

    private String strId(double value) {
        return String.format("id=\"%.0f\"", value);
    }

    private String strPath(Region region, double[] points) {
        StringBuilder bdr = new StringBuilder();
        boolean isBreak = true;
        int to = 0;
        for (int i = 0; i < region.Counts.length; ++i) {
            int from = to;
            to = from + region.Counts[i] * 2;
            for (int j = from; j < to; j += 2) {
                double pointX = points[j] * this.schemeScale;
                double pointY = points[j + 1] * this.schemeScale;
                if (isBreak) {
                    bdr.append(String.format("M%s %sC", SvgWriter.f2(pointX), SvgWriter.f2(pointY)));
                    isBreak = false;
                    continue;
                }
                bdr.append(SvgWriter.f2(pointX)).append(pointY < 0.0 ? "" : " ").append(SvgWriter.f2(pointY));
                bdr.append(" ");
            }
            bdr.append("z");
            isBreak = true;
        }
        return bdr.toString().trim();
    }

    private String strPath(Polygon polygon, double[] points) {
        StringBuilder bdr = new StringBuilder();
        boolean isBreak = true;
        int to = 0;
        for (int i = 0; i < polygon.Counts.length; ++i) {
            int from = to;
            to = from + polygon.Counts[i] * 2;
            for (int j = from; j < to; j += 2) {
                double pointX = points[j] * this.schemeScale;
                double pointY = points[j + 1] * this.schemeScale;
                if (isBreak) {
                    bdr.append(String.format("M%s %sL", SvgWriter.f2(pointX), SvgWriter.f2(pointY)));
                    isBreak = false;
                    if (j + 2 != to) continue;
                    int length = bdr.length();
                    bdr.delete(length - 1, length);
                    continue;
                }
                bdr.append(SvgWriter.f2(pointX)).append(pointY < 0.0 ? "" : " ").append(SvgWriter.f2(pointY));
                bdr.append(" ");
            }
            bdr.append("z");
            isBreak = true;
        }
        return bdr.toString().trim();
    }

    private String strPoints(double[] pts, int index, int count) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            if (i > 0) {
                str.append(' ');
            }
            int idx = 2 * (index + i);
            double dx = pts[idx] * this.schemeScale;
            double dy = pts[idx + 1] * this.schemeScale;
            str.append(SvgWriter.f2(dx)).append(',').append(SvgWriter.f2(dy));
        }
        return str.toString();
    }

    private String strMatrix(BaseGraphic bg) {
        StringBuilder str = new StringBuilder();
        str.append("matrix(");
        AffineTransform tm = SchemeEngine.GenTransform(bg);
        if (bg instanceof EmbeddedText) {
            tm = SchemeEngine.GenTransform(bg.ParentGB);
            EmbeddedText et = (EmbeddedText)bg;
            if (!et.Inscribe) {
                tm.concatenate(SchemeEngine.GenTransform(bg));
            }
        }
        if (SchemeObjectsTypes.ObjTypeIsText(bg.shapeType())) {
            double scaleX = 1.0;
            double scaleY = 1.0;
            BaseGraphic tmpBG = bg;
            while (tmpBG.ParentGB != null) {
                tmpBG = tmpBG.ParentGB;
                if (tmpBG.TransProps == null) {
                    tmpBG.TransProps = new TransformProps();
                }
                double tmpAngle = tmpBG.TransProps.Angle;
                tmpBG.TransProps.Angle = 0.0;
                AffineTransform tmpTM = SchemeEngine.GenTransform(tmpBG);
                if (tmpTM.getScaleX() == 0.0 || tmpTM.getScaleY() == 0.0) break;
                tmpBG.TransProps.Angle = tmpAngle;
                scaleX /= tmpTM.getScaleX();
                scaleY /= tmpTM.getScaleY();
            }
            tm.scale(scaleX, scaleY);
        }
        double[] arr = new double[6];
        tm.getMatrix(arr);
        for (int i = 0; i < 6; ++i) {
            if (i > 0) {
                str.append(' ');
            }
            if (i > 3) {
                int n = i;
                arr[n] = arr[n] * this.schemeScale;
            }
            str.append(SvgWriter.f5(arr[i]));
        }
        str.append(')');
        return str.toString();
    }

    private String strTransform(BaseGraphic bg, String addStr) {
        return String.format(" transform=\"%s%s\"", this.strMatrix(bg), addStr);
    }

    private static String strColor(Color c) {
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        return String.format("#%02x%02x%02x", r, g, b);
    }

    private String strStyle(BaseShape bs, boolean closed, boolean spec) {
        int pPattern;
        StringBuilder str = new StringBuilder();
        int n = pPattern = spec ? 0 : this.engine.getActualPenPattern(bs.PenPattern);
        if (pPattern == 5) {
            str.append(" stroke=\"none\"");
        } else {
            Color pColor = this.engine.getActualPColor(bs.pColor);
            str.append(" stroke=\"").append(SvgWriter.strColor(pColor)).append("\"");
            double lWidth = this.engine.getActualLWidth(bs.lWidth * this.schemeScale);
            if (lWidth == 0.0) {
                str.append(" vector-effect=\"non-scaling-stroke\" style=\"stroke-width: 1px\"");
            } else {
                String strokeWidth = " vector-effect=\"non-scaling-stroke\" stroke-width=\"%smm\"";
                str.append(String.format(strokeWidth, SvgWriter.f2(lWidth)));
            }
            switch (pPattern) {
                case 1: {
                    str.append(" stroke-dasharray=\"7, 3\"");
                    break;
                }
                case 2: {
                    str.append(" stroke-dasharray=\"2, 2\"");
                    break;
                }
                case 3: {
                    str.append(" stroke-dasharray=\"6, 3, 2, 3\"");
                    break;
                }
                case 4: {
                    str.append(" stroke-dasharray=\"6, 2, 2, 2, 2, 2\"");
                }
            }
        }
        switch (bs.LineCap) {
            case 0: {
                str.append(" stroke-linecap=\"butt\"");
                break;
            }
            case 1: {
                str.append(" stroke-linecap=\"round\"");
                break;
            }
            case 2: {
                str.append(" stroke-linecap=\"square\"");
            }
        }
        str.append(" stroke-linejoin=\"bevel\"");
        if (closed) {
            int bPattern = this.engine.getActualBrushPattern(bs.BrushPattern);
            if (bPattern == 1) {
                str.append(" fill=\"none\"");
            } else {
                Color bColor = this.engine.getActualBColor(bs.bColor);
                if (bPattern < 1) {
                    str.append(" fill=\"").append(SvgWriter.strColor(bColor)).append("\"");
                } else {
                    Color bkColor = this.engine.getActualBkColor(bs.BkColor);
                    if (bPattern < 10000) {
                        str.append(" fill=\"").append("url(#").append(this.putTextureTemplate(bs.ID, bPattern, SvgWriter.strColor(bColor), SvgWriter.strColor(bkColor))).append(")").append("\"");
                    } else {
                        str.append(" fill=\"").append("url(#").append(this.putGradientTemplate(bs.ID, bPattern, SvgWriter.strColor(bColor), SvgWriter.strColor(bkColor))).append(")").append("\"");
                    }
                }
            }
        } else {
            str.append(" fill=\"none\"");
        }
        if (bs.Transparent != 0) {
            str.append(" fill-opacity=\"").append(SvgWriter.f2((256.0 - (double)bs.Transparent) / 255.0)).append("\"");
        }
        if (bs.TransparentBorder != 0) {
            str.append(" stroke-opacity=\"").append(SvgWriter.f2((256.0 - (double)bs.TransparentBorder) / 255.0)).append("\"");
        }
        return str.toString();
    }

    private String strStyleForArrow(BaseShape bs, boolean fill, int lineCap, boolean useRoundJoin) {
        StringBuilder str = new StringBuilder();
        Color pColor = this.engine.getActualPColor(bs.pColor);
        int pPattern = this.engine.getActualPenPattern(bs.PenPattern);
        if (pPattern == 5) {
            str.append(" stroke=\"none\"");
        } else {
            str.append(" stroke=\"").append(SvgWriter.strColor(pColor)).append("\"");
            double lWidth = fill ? 0.0 : bs.lWidth;
            double actualLWidth = this.engine.getActualLWidth(lWidth) * this.schemeScale;
            if (actualLWidth == 0.0) {
                str.append(" vector-effect=\"non-scaling-stroke\" style=\"stroke-width: 1px\"");
            } else {
                String strokeWidth = " vector-effect=\"non-scaling-stroke\" stroke-width=\"%smm\"";
                str.append(String.format(strokeWidth, SvgWriter.f2(actualLWidth)));
            }
        }
        if (fill) {
            int bPattern = this.engine.getActualBrushPattern(bs.BrushPattern);
            if (bPattern == 1) {
                str.append(" fill=\"none\"");
            } else {
                str.append(" fill=\"").append(SvgWriter.strColor(pColor)).append("\"");
            }
        } else {
            str.append(" fill=\"none\"");
        }
        switch (lineCap) {
            case 0: {
                str.append(" stroke-linecap=\"butt\"");
                break;
            }
            case 1: {
                str.append(" stroke-linecap=\"round\"");
                break;
            }
            case 2: {
                str.append(" stroke-linecap=\"square\"");
            }
        }
        if (useRoundJoin) {
            str.append(" stroke-linejoin=\"round\"");
        } else {
            str.append(" stroke-linejoin=\"miter\"");
        }
        if (bs.Transparent != 0) {
            str.append(" fill-opacity=\"").append(SvgWriter.f2((256.0 - (double)bs.Transparent) / 255.0)).append("\"");
        }
        if (bs.TransparentBorder != 0) {
            str.append(" stroke-opacity=\"").append(SvgWriter.f2((256.0 - (double)bs.TransparentBorder) / 255.0)).append("\"");
        }
        return str.toString();
    }

    private String putGradientTemplate(double id, int pattern, String color1, String color2) {
        String strGradId = String.format("gradient%.0f", id);
        switch (pattern) {
            case 10001: {
                this._gradients.append(String.format("<linearGradient id=\"%s\" x1=\"0\" y1=\"0\" x2=\"100%%\" y2=\"0\">", strGradId));
                this._gradients.append(String.format("  <stop offset=\"0%%\" stop-color=\"%s\" />", color1));
                this._gradients.append(String.format("  <stop offset=\"100%%\" stop-color=\"%s\" />", color2));
                this._gradients.append("</linearGradient>");
                break;
            }
            case 10002: {
                this._gradients.append(String.format("<linearGradient id=\"%s\" x1=\"100%%\" y1=\"0\" x2=\"0\" y2=\"0\">", strGradId));
                this._gradients.append(String.format("  <stop offset=\"0%%\" stop-color=\"%s\" />", color1));
                this._gradients.append(String.format("  <stop offset=\"100%%\" stop-color=\"%s\" />", color2));
                this._gradients.append("</linearGradient>");
                break;
            }
            case 10003: {
                this._gradients.append(String.format("<linearGradient id=\"%s\" x1=\"0\" y1=\"0\" x2=\"0\" y2=\"100%%\">", strGradId));
                this._gradients.append(String.format("  <stop offset=\"0%%\" stop-color=\"%s\" />", color1));
                this._gradients.append(String.format("  <stop offset=\"100%%\" stop-color=\"%s\" />", color2));
                this._gradients.append("</linearGradient>");
                break;
            }
            case 10004: {
                this._gradients.append(String.format("<linearGradient id=\"%s\" x1=\"0\" y1=\"100%%\" x2=\"0\" y2=\"0\">", strGradId));
                this._gradients.append(String.format("  <stop offset=\"0%%\" stop-color=\"%s\" />", color1));
                this._gradients.append(String.format("  <stop offset=\"100%%\" stop-color=\"%s\" />", color2));
                this._gradients.append("</linearGradient>");
                break;
            }
            case 10005: {
                this._gradients.append(String.format("<linearGradient id=\"%s\" x1=\"100%%\" y1=\"0\" x2=\"0\" y2=\"100%%\">", strGradId));
                this._gradients.append(String.format("  <stop offset=\"0%%\" stop-color=\"%s\" />", color1));
                this._gradients.append(String.format("  <stop offset=\"100%%\" stop-color=\"%s\" />", color2));
                this._gradients.append("</linearGradient>");
                break;
            }
            case 10006: {
                this._gradients.append(String.format("<linearGradient id=\"%s\" x1=\"0\" y1=\"100%%\" x2=\"100%%\" y2=\"0\">", strGradId));
                this._gradients.append(String.format("  <stop offset=\"0%%\" stop-color=\"%s\" />", color1));
                this._gradients.append(String.format("  <stop offset=\"100%%\" stop-color=\"%s\" />", color2));
                this._gradients.append("</linearGradient>");
                break;
            }
            case 10007: {
                this._gradients.append(String.format("<linearGradient id=\"%s\" x1=\"100%%\" y1=\"100%%\" x2=\"0\" y2=\"0\">", strGradId));
                this._gradients.append(String.format("  <stop offset=\"0%%\" stop-color=\"%s\" />", color1));
                this._gradients.append(String.format("  <stop offset=\"100%%\" stop-color=\"%s\" />", color2));
                this._gradients.append("</linearGradient>");
                break;
            }
            case 10008: {
                this._gradients.append(String.format("<linearGradient id=\"%s\" x1=\"0\" y1=\"0\" x2=\"100%%\" y2=\"100%%\">", strGradId));
                this._gradients.append(String.format("  <stop offset=\"0%%\" stop-color=\"%s\" />", color1));
                this._gradients.append(String.format("  <stop offset=\"100%%\" stop-color=\"%s\" />", color2));
                this._gradients.append("</linearGradient>");
                break;
            }
            case 10011: {
                this._gradients.append(String.format("<linearGradient id=\"%s\" x1=\"0\" y1=\"0\" x2=\"100%%\" y2=\"0\">", strGradId));
                this._gradients.append(String.format("  <stop offset=\"0%%\" stop-color=\"%s\" />", color2));
                this._gradients.append(String.format("  <stop offset=\"50%%\" stop-color=\"%s\" />", color1));
                this._gradients.append(String.format("  <stop offset=\"100%%\" stop-color=\"%s\" />", color2));
                this._gradients.append("</linearGradient>");
                break;
            }
            case 10012: {
                this._gradients.append(String.format("<linearGradient id=\"%s\" x1=\"0\" y1=\"0\" x2=\"100%%\" y2=\"0\">", strGradId));
                this._gradients.append(String.format("  <stop offset=\"0%%\" stop-color=\"%s\" />", color1));
                this._gradients.append(String.format("  <stop offset=\"50%%\" stop-color=\"%s\" />", color2));
                this._gradients.append(String.format("  <stop offset=\"100%%\" stop-color=\"%s\" />", color1));
                this._gradients.append("</linearGradient>");
                break;
            }
            case 10013: {
                this._gradients.append(String.format("<linearGradient id=\"%s\" x1=\"0\" y1=\"0\" x2=\"0\" y2=\"100%%\">", strGradId));
                this._gradients.append(String.format("  <stop offset=\"0%%\" stop-color=\"%s\" />", color2));
                this._gradients.append(String.format("  <stop offset=\"50%%\" stop-color=\"%s\" />", color1));
                this._gradients.append(String.format("  <stop offset=\"100%%\" stop-color=\"%s\" />", color2));
                this._gradients.append("</linearGradient>");
                break;
            }
            case 10014: {
                this._gradients.append(String.format("<linearGradient id=\"%s\" x1=\"0\" y1=\"0\" x2=\"0\" y2=\"100%%\">", strGradId));
                this._gradients.append(String.format("  <stop offset=\"0%%\" stop-color=\"%s\" />", color1));
                this._gradients.append(String.format("  <stop offset=\"50%%\" stop-color=\"%s\" />", color2));
                this._gradients.append(String.format("  <stop offset=\"100%%\" stop-color=\"%s\" />", color1));
                this._gradients.append("</linearGradient>");
                break;
            }
            case 10015: {
                this._gradients.append(String.format("<linearGradient id=\"%s\" x1=\"100%%\" y1=\"0\" x2=\"0\" y2=\"100%%\">", strGradId));
                this._gradients.append(String.format("  <stop offset=\"0%%\" stop-color=\"%s\" />", color2));
                this._gradients.append(String.format("  <stop offset=\"50%%\" stop-color=\"%s\" />", color1));
                this._gradients.append(String.format("  <stop offset=\"100%%\" stop-color=\"%s\" />", color2));
                this._gradients.append("</linearGradient>");
                break;
            }
            case 10016: {
                this._gradients.append(String.format("<linearGradient id=\"%s\" x1=\"100%%\" y1=\"0\" x2=\"0\" y2=\"100%%\">", strGradId));
                this._gradients.append(String.format("  <stop offset=\"0%%\" stop-color=\"%s\" />", color1));
                this._gradients.append(String.format("  <stop offset=\"50%%\" stop-color=\"%s\" />", color2));
                this._gradients.append(String.format("  <stop offset=\"100%%\" stop-color=\"%s\" />", color1));
                this._gradients.append("</linearGradient>");
                break;
            }
            case 10017: {
                this._gradients.append(String.format("<linearGradient id=\"%s\" x1=\"100%%\" y1=\"100%%\" x2=\"0\" y2=\"0\">", strGradId));
                this._gradients.append(String.format("  <stop offset=\"0%%\" stop-color=\"%s\" />", color2));
                this._gradients.append(String.format("  <stop offset=\"50%%\" stop-color=\"%s\" />", color1));
                this._gradients.append(String.format("  <stop offset=\"100%%\" stop-color=\"%s\" />", color2));
                this._gradients.append("</linearGradient>");
                break;
            }
            case 10018: {
                this._gradients.append(String.format("<linearGradient id=\"%s\" x1=\"100%%\" y1=\"100%%\" x2=\"0\" y2=\"0\">", strGradId));
                this._gradients.append(String.format("  <stop offset=\"0%%\" stop-color=\"%s\" />", color1));
                this._gradients.append(String.format("  <stop offset=\"50%%\" stop-color=\"%s\" />", color2));
                this._gradients.append(String.format("  <stop offset=\"100%%\" stop-color=\"%s\" />", color1));
                this._gradients.append("</linearGradient>");
                break;
            }
            case 10019: {
                this._gradients.append(String.format("<radialGradient id=\"%s\">", strGradId));
                this._gradients.append(String.format("  <stop offset=\"0%%\" stop-color=\"%s\" />", color1));
                this._gradients.append(String.format("  <stop offset=\"100%%\" stop-color=\"%s\" />", color2));
                this._gradients.append("</radialGradient>");
                break;
            }
            case 10020: {
                this._gradients.append(String.format("<radialGradient id=\"%s\">", strGradId));
                this._gradients.append(String.format("  <stop offset=\"0%%\" stop-color=\"%s\" />", color2));
                this._gradients.append(String.format("  <stop offset=\"100%%\" stop-color=\"%s\" />", color1));
                this._gradients.append("</radialGradient>");
            }
        }
        return strGradId;
    }

    private String putTextureTemplate(double id, int pattern, String color1, String color2) {
        String strPatternId = String.format("pattern%.0f", id);
        String buffStr = SvgWriter.getPatternStringById(pattern);
        if (buffStr != null) {
            this._patterns.append(String.format("<pattern id=\"%s\" width=\"4\" height=\"4\" viewBox=\"0 0 16 16\" patternUnits=\"userSpaceOnUse\">", strPatternId));
            this._patterns.append(String.format("<rect x=\"0\" y=\"0\" width=\"16\" height=\"16\" fill=\"%s\"/>", color2));
            int idx = 0;
            for (int x = 0; x < 16; ++x) {
                for (int y = 0; y < 16; ++y) {
                    if (buffStr.charAt(idx) == 'X') {
                        this._patterns.append(String.format("<rect x=\"%s\" y=\"%s\" width=\"1\" height=\"1\" fill=\"%s\"/>", SvgWriter.f2(x), SvgWriter.f2(y), color1));
                    }
                    ++idx;
                }
            }
            this._patterns.append("</pattern>");
        }
        return strPatternId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeShapes() throws Exception {
        BaseGraphic bg;
        SchemeObject o;
        if (this.s.exportPageId == Scheme.INVISIBLE_PAGE_ID) {
            return;
        }
        List<SchemeObject> sShapes = this.s.SortShapes;
        int shapesCount = sShapes.size();
        SchemePage currentPage = null;
        SchemePage backPage = null;
        double backPageScale = 1.0;
        if (!this.s.Pages.empty()) {
            SchemePageLayout xPageLayoutSettings;
            currentPage = this.s.getPageById(this.s.exportPageId, true);
            SchemePageLayout schemePageLayout = xPageLayoutSettings = currentPage == null || currentPage.pageLayout == null ? this.s.getPageLayout() : currentPage.pageLayout;
            if (xPageLayoutSettings.getActive()) {
                this.schemeScale = this.getPageScaleByPageLayout(xPageLayoutSettings);
            }
            if (currentPage != null && currentPage.backPageId >= 0.0) {
                backPage = this.s.getPageById(currentPage.backPageId, true);
            }
            if (backPage != null) {
                double backScale = 1.0;
                SchemePageLayout schemePageLayout2 = xPageLayoutSettings = backPage.pageLayout == null ? this.s.getPageLayout() : backPage.pageLayout;
                if (xPageLayoutSettings.getActive()) {
                    backScale = this.getPageScaleByPageLayout(xPageLayoutSettings);
                }
                backPageScale = backScale / this.schemeScale;
            }
        }
        if (backPage != null) {
            int i;
            StringBuilder str = new StringBuilder();
            str.append("matrix(");
            AffineTransform tm = new AffineTransform();
            tm.scale(backPageScale, backPageScale);
            double[] arr = new double[6];
            tm.getMatrix(arr);
            for (i = 0; i < 6; ++i) {
                if (i > 0) {
                    str.append(' ');
                }
                if (i > 3) {
                    int n = i;
                    arr[n] = arr[n] * this.schemeScale;
                }
                str.append(SvgWriter.f5(arr[i]));
            }
            str.append(')');
            this._content.append(String.format("<g transform=\"%s\">", str));
            for (i = 0; i < shapesCount; ++i) {
                o = sShapes.get(i);
                if (o == null) {
                    Core.logger.info("SvgWriter.writeShapes: not found object by index {}. saveToStream(scheme:{}).", (Object)i, (Object)this.s.getSchemeId());
                    continue;
                }
                SchemeObject schemeObject = o;
                synchronized (schemeObject) {
                    bg = o.BG;
                    if (bg == null) {
                        Core.logger.info("SvgWriter.writeShapes: object {} not parsed. saveToStream(scheme:{}).", (Object)o.getID(), (Object)this.s.getSchemeId());
                        continue;
                    }
                    if (this.engine.tmpLayer == null || this.engine.tmpLayer.ID != bg.LayerID) {
                        this.engine.setTmpLayer(bg.LayerID);
                    }
                    if (this.engine.tmpLayer == null || !this.engine.tmpLayer.Exportable || !this.engine.tmpLayer.Visible) {
                        continue;
                    }
                    if (backPage.getNormalizeId() == this.engine.tmpLayer.PageId) {
                        this.writeShape(bg);
                    }
                    continue;
                }
            }
            this._content.append("</g>");
        }
        for (int i = 0; i < shapesCount; ++i) {
            o = sShapes.get(i);
            if (o == null) {
                Core.logger.info("SvgWriter.writeShapes: not found object by index {}. saveToStream(scheme:{}).", (Object)i, (Object)this.s.getSchemeId());
                continue;
            }
            SchemeObject schemeObject = o;
            synchronized (schemeObject) {
                bg = o.BG;
                if (bg == null) {
                    Core.logger.info("SvgWriter.writeShapes: object {} not parsed. saveToStream(scheme:{}).", (Object)o.getID(), (Object)this.s.getSchemeId());
                    continue;
                }
                if (this.engine.tmpLayer == null || this.engine.tmpLayer.ID != bg.LayerID) {
                    this.engine.setTmpLayer(bg.LayerID);
                }
                if (this.engine.tmpLayer == null || !this.engine.tmpLayer.Exportable || !this.engine.tmpLayer.Visible) {
                    continue;
                }
                if (currentPage == null || currentPage.getNormalizeId() == this.engine.tmpLayer.PageId) {
                    this.writeShape(bg);
                    this.putStateProgressPosition(i);
                }
                continue;
            }
        }
    }

    private double getPageScaleByPageLayout(SchemePageLayout pageLayout) {
        if (pageLayout == null || pageLayout.getScalePageType() == 0) {
            return 1.0;
        }
        if (pageLayout.getScalePageType() == 1) {
            switch (pageLayout.getScalePage()) {
                case 0: {
                    return 0.001;
                }
                case 1: {
                    return 0.002;
                }
                case 2: {
                    return 0.005;
                }
                case 3: {
                    return 0.01;
                }
                case 4: {
                    return 0.02;
                }
                case 5: {
                    return 0.04;
                }
                case 6: {
                    return 0.05;
                }
                case 7: {
                    return 0.1;
                }
                case 8: {
                    return 0.2;
                }
                case 9: {
                    return 0.4;
                }
                case 10: {
                    return 0.5;
                }
                case 12: {
                    return 10.0;
                }
                case 13: {
                    return 20.0;
                }
                case 14: {
                    return 50.0;
                }
            }
            return 1.0;
        }
        double scaleFloat = pageLayout.getScaleFloat();
        if (scaleFloat < 0.001) {
            scaleFloat = 0.001;
        }
        return 1.0 / scaleFloat;
    }

    private void writeShape(BaseGraphic bg) throws Exception {
        if (bg.Hidden) {
            return;
        }
        if (bg.ParentGB != null && bg.TransProps != null && !SchemeObjectsTypes.ObjTypeIsText(bg.shapeType())) {
            boolean inInsert;
            boolean bl = inInsert = bg.ParentGB.ParentGB != null && bg.ParentGB.ParentGB.shapeType() == 207;
            if (inInsert || bg.ParentGB.ParentGB == null) {
                double parentScaleX = 1.0;
                double parentScaleY = 1.0;
                double a = bg.TransProps.Angle;
                if (Math.abs(a - 90.0 * (double)((int)(a / 90.0))) <= 0.5) {
                    boolean vert;
                    BaseGraphic parent = inInsert ? bg.ParentGB.ParentGB : bg.ParentGB;
                    boolean bl2 = vert = Math.abs(a - 180.0 * (double)((int)(a / 180.0))) > 0.5;
                    if (!vert) {
                        if (bg.FixScaleX && parent.TransProps != null) {
                            parentScaleX = parent.TransProps.ScaleX;
                        }
                        if (bg.FixScaleY && parent.TransProps != null) {
                            parentScaleY = parent.TransProps.ScaleY;
                        }
                    } else {
                        if (bg.FixScaleX && parent.TransProps != null) {
                            parentScaleY = parent.TransProps.ScaleX;
                        }
                        if (bg.FixScaleY && parent.TransProps != null) {
                            parentScaleX = parent.TransProps.ScaleY;
                        }
                    }
                    bg.TransProps.ScaleX /= parentScaleX;
                    bg.TransProps.ScaleY /= parentScaleY;
                }
            }
        }
        if (bg instanceof PhxGraphicInsert) {
            this.writeInsert((PhxGraphicInsert)bg);
        } else if (bg instanceof GraphicBlock) {
            this.writeBlock((GraphicBlock)bg);
        } else if (bg instanceof Polygon) {
            this.writePolygon((Polygon)bg);
        } else if (bg instanceof Region) {
            this.writeRegion((Region)bg);
        } else if (bg instanceof Spline) {
            this.writeSpline((Spline)bg);
        } else if (bg instanceof Polyline) {
            this.writePolyline((Polyline)bg);
        } else if (bg instanceof Pie) {
            this.writePie((Pie)bg);
        } else if (bg instanceof Ellipse) {
            this.writeEllipse((Ellipse)bg);
        } else if (bg instanceof AttributeDef) {
            this.writeAttributeDef((AttributeDef)bg);
        } else if (bg instanceof AttributeRef) {
            this.writeAttributeRef((AttributeRef)bg);
        } else if (bg instanceof Paragraph) {
            this.writeParagraph((Paragraph)bg);
        } else if (bg instanceof Image) {
            this.writeImage((Image)bg);
        } else if (bg instanceof Rectangle) {
            this.writeRectangle((Rectangle)bg);
        }
        if (bg.emText()) {
            this.writeShape(bg.EmbeddedText);
        }
    }

    private void writePolyline(Polyline bg) {
        if (bg.Points == null || bg.Points.length < 4) {
            return;
        }
        double[] transformedPoints = SchemeEngine.MulPointsTM(SchemeEngine.GenTransform(bg), bg.Points);
        int penPattern = !this.insertMode || bg.PenPattern != -1 ? bg.PenPattern : 0;
        boolean isSpecialPrimitive = !this.insertMode && this.engine.getActualPrimID(penPattern, bg.PrimID) > 0.0;
        int n = penPattern = isSpecialPrimitive ? 0 : this.engine.getActualPenPattern(penPattern);
        if (bg.PointsCounts != null && bg.PointsCounts.length > 0 && penPattern == 0) {
            this.writeArrow(bg, transformedPoints);
            double[] allPoints = bg.PointsWithJump;
            int segmentOffset = 0;
            int[] pointsCounts = bg.PointsCounts;
            if (this.containsZero(pointsCounts)) {
                for (int segmentPointCount : pointsCounts) {
                    if (segmentPointCount == 0) continue;
                    double[] segmentPoints = new double[segmentPointCount * 2];
                    System.arraycopy(allPoints, segmentOffset, segmentPoints, 0, segmentPointCount * 2);
                    this.writeAsPolyline(bg, segmentPoints, isSpecialPrimitive);
                    segmentOffset += segmentPointCount * 2;
                }
            } else {
                this.paintIntersectionArc(bg, isSpecialPrimitive);
            }
        } else {
            double[] pointsToRender = bg.PointsWithJump != null ? bg.PointsWithJump : transformedPoints;
            this.writeArrow(bg, (double[])pointsToRender.clone());
            this.writeAsPolyline(bg, pointsToRender, isSpecialPrimitive);
        }
    }

    private boolean containsZero(int[] arr) {
        return IntStream.of(arr).anyMatch(x -> x == 0);
    }

    private StringBuilder strPath(int[] pointsCounts, double[] pointsWithJump) {
        StringBuilder pathBuilder = new StringBuilder();
        int arrayOffset = 0;
        BaseGraphic.RealPoint rpLast = new BaseGraphic.RealPoint();
        for (int i = 0; i < pointsCounts.length; ++i) {
            int pointCount = pointsCounts[i];
            double[] segmentPoints = this.extractSegmentPoints(pointsWithJump, arrayOffset, pointCount);
            if (i == 0) {
                this.appendFirstSegment(pathBuilder, pointsWithJump, segmentPoints);
            } else if (i % 2 == 0) {
                this.appendLineSegment(pathBuilder, segmentPoints);
            } else {
                boolean needReverse = SvgWriter.f2d(segmentPoints[0]) != SvgWriter.f2d(rpLast.X) || SvgWriter.f2d(segmentPoints[1]) != SvgWriter.f2d(rpLast.Y);
                this.appendArcSegment(pathBuilder, segmentPoints, needReverse);
            }
            arrayOffset += pointCount * 2;
            int length = segmentPoints.length;
            rpLast.X = segmentPoints[length - 2];
            rpLast.Y = segmentPoints[length - 1];
        }
        return pathBuilder;
    }

    private void paintIntersectionArc(Polyline bg, boolean isSpec) {
        double[] arrowPts;
        int[] pointsCounts = bg.PointsCounts;
        double[] pointsWithJump = bg.PointsWithJump;
        StringBuilder pathBuilder = this.strPath(pointsCounts, pointsWithJump);
        String pathAttributes = String.format("<path %s d=\"%s\" %s/>", this.strId(bg.ID), pathBuilder, this.strStyle(bg, true, isSpec));
        this._content.append(pathAttributes);
        if (bg.StartVisArrowType != 0 && bg.StartArrowPoints != null) {
            arrowPts = SchemeEngine.MulPointsTM(SchemeEngine.GenTransform(bg), bg.StartArrowPoints);
            this.paintArrow(bg, bg.StartVisArrowType, bg.StartVisArrowSize, arrowPts);
        }
        if (bg.EndVisArrowType != 0 && bg.EndArrowPoints != null) {
            arrowPts = SchemeEngine.MulPointsTM(SchemeEngine.GenTransform(bg), bg.EndArrowPoints);
            this.paintArrow(bg, bg.EndVisArrowType, bg.EndVisArrowSize, arrowPts);
        }
    }

    private double[] extractSegmentPoints(double[] sourceArray, int offset, int pointCount) {
        double[] segmentPoints = new double[pointCount * 2];
        System.arraycopy(sourceArray, offset, segmentPoints, 0, pointCount * 2);
        return segmentPoints;
    }

    private void appendFirstSegment(StringBuilder builder, double[] allPoints, double[] segmentPoints) {
        builder.append(String.format("M %s %s L ", SvgWriter.f2(allPoints[0]), SvgWriter.f2(allPoints[1])));
        int cnt = segmentPoints.length;
        for (int i = 2; i < cnt; ++i) {
            String point = SvgWriter.f2(segmentPoints[i]);
            builder.append(point).append(" ");
        }
    }

    private void appendLineSegment(StringBuilder builder, double[] points) {
        builder.append("L ");
        for (double point : points) {
            builder.append(SvgWriter.f2(point)).append(" ");
        }
    }

    private void appendArcSegment(StringBuilder builder, double[] segmentPoints, boolean needReverse) {
        int count = segmentPoints.length;
        double beginX = needReverse ? segmentPoints[count - 2] : segmentPoints[0];
        double beginY = needReverse ? segmentPoints[count - 1] : segmentPoints[1];
        double endX = needReverse ? segmentPoints[0] : segmentPoints[count - 2];
        double endY = needReverse ? segmentPoints[1] : segmentPoints[count - 1];
        BaseGraphic.RealPoint rpBegin = new BaseGraphic.RealPoint(beginX, beginY);
        BaseGraphic.RealPoint rpEnd = new BaseGraphic.RealPoint(endX, endY);
        double rx = Math.pow(rpBegin.X - rpEnd.X, 2.0);
        double ry = Math.pow(rpBegin.Y - rpEnd.Y, 2.0);
        double r = Math.sqrt(rx + ry) / 2.0;
        double angle = SchemeUtils.lineToAngle(rpBegin, rpEnd) - 90.0;
        boolean rotateCondition = angle > 90.0 && angle <= 180.0 || angle <= -90.0 && angle > -180.0;
        builder.append(String.format("A %s %s %s %s %s %s %s", r, r, 0, 0, rotateCondition ? 0 : 1, SvgWriter.f2(rpEnd.X), SvgWriter.f2(rpEnd.Y)));
    }

    private void writeArrow(BaseShape bg, double[] pts) {
        int pCount;
        int n = pCount = pts != null ? pts.length / 2 : 0;
        if (pCount < 2) {
            return;
        }
        if (bg.shapeType() == 210) {
            BaseGraphic.RealPoint np;
            double[] arrowPts;
            Polyline poly = (Polyline)bg;
            if (poly.StartVisArrowType != 0 && poly.StartArrowPoints != null) {
                arrowPts = SchemeEngine.MulPointsTM(SchemeEngine.GenTransform(bg), poly.StartArrowPoints);
                np = poly.trimSegmentByArrow(pts, 1, 0, true);
                pts[0] = np.X;
                pts[1] = np.Y;
                this.paintArrow(bg, poly.StartVisArrowType, poly.StartVisArrowSize, arrowPts);
            }
            if (poly.EndVisArrowType != 0 && poly.EndArrowPoints != null) {
                arrowPts = SchemeEngine.MulPointsTM(SchemeEngine.GenTransform(bg), poly.EndArrowPoints);
                np = poly.trimSegmentByArrow(pts, pCount - 2, pCount - 1, false);
                pts[pCount * 2 - 2] = np.X;
                pts[pCount * 2 - 1] = np.Y;
                this.paintArrow(bg, poly.EndVisArrowType, poly.EndVisArrowSize, arrowPts);
            }
        }
    }

    private void writeAsPolyline(BaseShape bg, double[] pts, boolean isSpec) {
        int pCount;
        int n = pCount = pts != null ? pts.length / 2 : 0;
        if (pCount < 2) {
            return;
        }
        this._content.append(String.format("<polyline %s points=\"%s\" %s/>", this.strId(bg.ID), this.strPoints(pts, 0, pCount), this.strStyle(bg, false, isSpec)));
    }

    private void paintArrow(BaseShape bg, int arrowType, double size, double[] pts) {
        if (arrowType == 0 || arrowType == 1) {
            this.paintArrowDef(bg, pts);
            return;
        }
        if (size <= 1.0E-12) {
            return;
        }
        switch (arrowType) {
            case 2: 
            case 5: 
            case 6: {
                this.paintArrowOpened(bg, pts);
                break;
            }
            case 3: {
                this.paintArrowClosed(bg, pts, true);
                break;
            }
            case 4: {
                this.paintArrowClosed(bg, pts, false);
                break;
            }
            case 7: {
                this.paintArrowCircle(bg, size, pts, true);
                break;
            }
            case 8: {
                this.paintArrowCircle(bg, size, pts, false);
                break;
            }
            case 9: {
                this.paintArrowCut(bg, pts);
                break;
            }
            case 10: {
                this.paintArrowSquare(bg, pts, true);
                break;
            }
            case 11: {
                this.paintArrowSquare(bg, pts, false);
                break;
            }
            case 21: {
                this.paintArrowDiamond(bg, pts, true);
                break;
            }
            case 22: {
                this.paintArrowDiamond(bg, pts, false);
                break;
            }
            case 12: {
                this.paintArrowTriangle(bg, pts, true);
                break;
            }
            case 13: {
                this.paintArrowTriangle(bg, pts, false);
                break;
            }
            case 14: {
                this.paintArrowOpenedExtra(bg, pts, true);
                break;
            }
            case 15: {
                this.paintArrowOpenedExtra(bg, pts, false);
                break;
            }
            case 16: {
                this.paintArrowTriangle2Opened(bg, pts);
                break;
            }
            case 17: {
                this.paintArrowTriangle2(bg, pts, true);
                break;
            }
            case 18: {
                this.paintArrowTriangle2(bg, pts, false);
                break;
            }
            case 19: {
                this.paintArrowBar(bg, pts);
                break;
            }
            case 20: {
                this.paintArrowFork(bg, pts);
                break;
            }
            case 23: {
                this.paintArrowDiamondCircle(bg, size, pts, true);
                break;
            }
            case 24: {
                this.paintArrowDiamondCircle(bg, size, pts, false);
                break;
            }
            case 25: {
                this.paintArrowDoubleBar(bg, pts);
                break;
            }
            case 26: {
                this.paintArrowCircleBar(bg, size, pts);
                break;
            }
            case 27: {
                this.paintArrowCircleFork(bg, size, pts);
                break;
            }
            case 28: {
                this.paintArrowBarFrok(bg, pts);
                break;
            }
            case 29: {
                this.paintArrowDoubleTriangle2Opened(bg, pts);
                break;
            }
            case 30: {
                this.paintArrowDoubleTriangle2(bg, pts, true);
                break;
            }
            case 31: {
                this.paintArrowDoubleTriangle2(bg, pts, false);
                break;
            }
            case 32: {
                this.paintArrowSemiCircle(bg, pts);
                break;
            }
        }
    }

    private void paintArrowDef(BaseShape bg, double[] pts) {
        this._content.append(String.format("<polygon points=\"%s\" %s/>", this.strPoints(pts, 0, 3), this.strStyleForArrow(bg, false, 1, true)));
    }

    private void paintArrowOpened(BaseShape bg, double[] pts) {
        this._content.append(String.format("<polyline points=\"%s\" %s/>", this.strPoints(pts, 0, 3), this.strStyleForArrow(bg, false, 1, true)));
    }

    private void paintArrowClosed(BaseShape bg, double[] pts, boolean full) {
        this._content.append(String.format("<polygon points=\"%s\" %s/>", this.strPoints(pts, 0, 3), this.strStyleForArrow(bg, full, full ? 0 : 1, !full)));
    }

    private void paintArrowDiamond(BaseShape bg, double[] pts, boolean full) {
        this._content.append(String.format("<polygon points=\"%s\" %s/>", this.strPoints(pts, 0, 4), this.strStyleForArrow(bg, full, full ? 0 : 1, !full)));
    }

    private void paintArrowCircle(BaseShape bg, double size, double[] pts, boolean full) {
        this._content.append(String.format("<circle cx=\"%s\" cy=\"%s\" r=\"%s\" %s/>", SvgWriter.f2(pts[0]), SvgWriter.f2(pts[1]), SvgWriter.f2(size * 0.5), this.strStyleForArrow(bg, full, 1, true)));
    }

    private void paintArrowDiamondCircle(BaseShape bg, double size, double[] pts, boolean full) {
        this._content.append(String.format("<circle cx=\"%s\" cy=\"%s\" r=\"%s\" %s/>", SvgWriter.f2(pts[0]), SvgWriter.f2(pts[1]), SvgWriter.f2(size * 0.5), this.strStyleForArrow(bg, full, 1, true)));
        this._content.append(String.format("<polygon points=\"%s\" %s/>", this.strPoints(pts, 1, 4), this.strStyleForArrow(bg, false, 1, true)));
    }

    private void paintArrowCut(BaseShape bg, double[] pts) {
        this._content.append(String.format("<polyline points=\"%s\" %s/>", this.strPoints(pts, 0, 2), this.strStyleForArrow(bg, false, 1, true)));
    }

    private void paintArrowSquare(BaseShape bg, double[] pts, boolean full) {
        this._content.append(String.format("<polygon points=\"%s\" %s/>", this.strPoints(pts, 0, 4), this.strStyleForArrow(bg, full, full ? 0 : 1, !full)));
    }

    private void paintArrowTriangle(BaseShape bg, double[] pts, boolean full) {
        this._content.append(String.format("<polygon points=\"%s\" %s/>", this.strPoints(pts, 0, 4), this.strStyleForArrow(bg, full, full ? 0 : 1, !full)));
    }

    private void paintArrowTriangle2(BaseShape bg, double[] pts, boolean full) {
        this._content.append(String.format("<polygon points=\"%s\" %s/>", this.strPoints(pts, 0, 3), this.strStyleForArrow(bg, full, full ? 0 : 1, !full)));
    }

    private void paintArrowDoubleTriangle2(BaseShape bg, double[] pts, boolean full) {
        this._content.append(String.format("<polygon points=\"%s\" %s/>", this.strPoints(pts, 0, 3), this.strStyleForArrow(bg, full, full ? 0 : 1, !full)));
        this._content.append(String.format("<polygon points=\"%s\" %s/>", this.strPoints(pts, 3, 3), this.strStyleForArrow(bg, full, full ? 0 : 1, !full)));
    }

    private void paintArrowOpenedExtra(BaseShape bg, double[] pts, boolean full) {
        this._content.append(String.format("<polygon points=\"%s\" %s/>", this.strPoints(pts, 0, 3), this.strStyleForArrow(bg, full, full ? 0 : 1, !full)));
    }

    private void paintArrowTriangle2Opened(BaseShape bg, double[] pts) {
        this._content.append(String.format("<polyline points=\"%s\" %s/>", this.strPoints(pts, 0, 3), this.strStyleForArrow(bg, false, 1, true)));
    }

    private void paintArrowDoubleTriangle2Opened(BaseShape bg, double[] pts) {
        this._content.append(String.format("<polyline points=\"%s\" %s/>", this.strPoints(pts, 0, 3), this.strStyleForArrow(bg, false, 1, true)));
        this._content.append(String.format("<polyline points=\"%s\" %s/>", this.strPoints(pts, 3, 3), this.strStyleForArrow(bg, false, 1, true)));
    }

    private void paintArrowBar(BaseShape bg, double[] pts) {
        this._content.append(String.format("<polyline points=\"%s\" %s/>", this.strPoints(pts, 0, 2), this.strStyleForArrow(bg, false, 1, true)));
    }

    private void paintArrowDoubleBar(BaseShape bg, double[] pts) {
        this._content.append(String.format("<polyline points=\"%s\" %s/>", this.strPoints(pts, 0, 2), this.strStyleForArrow(bg, false, 1, true)));
        this._content.append(String.format("<polyline points=\"%s\" %s/>", this.strPoints(pts, 2, 2), this.strStyleForArrow(bg, false, 1, true)));
    }

    private void paintArrowCircleBar(BaseShape bg, double size, double[] pts) {
        this._content.append(String.format("<polyline points=\"%s\" %s/>", this.strPoints(pts, 0, 2), this.strStyleForArrow(bg, false, 1, true)));
        this._content.append(String.format("<polyline points=\"%s\" %s/>", this.strPoints(pts, 2, 2), this.strStyleForArrow(bg, false, 1, true)));
        this._content.append(String.format("<circle cx=\"%s\" cy=\"%s\" r=\"%s\" %s/>", SvgWriter.f2(pts[8]), SvgWriter.f2(pts[9]), SvgWriter.f2(size * 0.5), this.strStyleForArrow(bg, false, 1, true)));
    }

    private void paintArrowSemiCircle(BaseShape bg, double[] pts) {
        if (pts == null || pts.length < 8) {
            return;
        }
        StringBuilder pointsStr = new StringBuilder();
        int idx = 5;
        for (int i = 2; i < pts.length; ++i) {
            if (++idx == 6) {
                pointsStr.append(" C");
                idx = 0;
            }
            pointsStr.append(" ").append(SvgWriter.f2(pts[i]));
        }
        this._content.append(String.format("<path d=\"M %s %s%s\" %s/>", SvgWriter.f2(pts[0]), SvgWriter.f2(pts[1]), pointsStr, this.strStyleForArrow(bg, false, 1, true)));
    }

    private void paintArrowFork(BaseShape bg, double[] pts) {
        this._content.append(String.format("<polyline points=\"%s\" %s/>", this.strPoints(pts, 0, 3), this.strStyleForArrow(bg, false, 1, true)));
        this._content.append(String.format("<polyline points=\"%s\" %s/>", this.strPoints(pts, 3, 2), this.strStyleForArrow(bg, false, 1, true)));
    }

    private void paintArrowBarFrok(BaseShape bg, double[] pts) {
        this._content.append(String.format("<polyline points=\"%s\" %s/>", this.strPoints(pts, 0, 2), this.strStyleForArrow(bg, false, 1, true)));
        this._content.append(String.format("<polyline points=\"%s\" %s/>", this.strPoints(pts, 2, 2), this.strStyleForArrow(bg, false, 1, true)));
        this._content.append(String.format("<polyline points=\"%s\" %s/>", this.strPoints(pts, 3, 2), this.strStyleForArrow(bg, false, 1, true)));
    }

    private void paintArrowCircleFork(BaseShape bg, double size, double[] pts) {
        this._content.append(String.format("<polyline points=\"%s\" %s/>", this.strPoints(pts, 0, 3), this.strStyleForArrow(bg, false, 1, true)));
        this._content.append(String.format("<polyline points=\"%s\" %s/>", this.strPoints(pts, 3, 2), this.strStyleForArrow(bg, false, 1, true)));
        this._content.append(String.format("<circle cx=\"%s\" cy=\"%s\" r=\"%s\" %s/>", SvgWriter.f2(pts[10]), SvgWriter.f2(pts[11]), SvgWriter.f2(size * 0.5), this.strStyleForArrow(bg, false, 1, true)));
    }

    private void writeSpline(Spline bg) {
        int pCount;
        int n = pCount = bg.Points != null ? bg.Points.length / 2 : 0;
        if (pCount < 2 || (pCount - 4) % 3 != 0) {
            return;
        }
        double[] pts = SchemeEngine.MulPointsTM(SchemeEngine.GenTransform(bg), bg.Points);
        this._content.append(String.format("<path %s d=\"M%s C%s\" %s/>", this.strId(bg.ID), this.strPoints(pts, 0, 1), this.strPoints(pts, 1, pCount - 1), this.strStyle(bg, false, false)));
        if (bg.shapeType() == 210 || bg.shapeType() == 212) {
            double[] arrowPts;
            if (bg.StartVisArrowType != 0 && bg.StartArrowPoints != null) {
                arrowPts = SchemeEngine.MulPointsTM(SchemeEngine.GenTransform(bg), bg.StartArrowPoints);
                this.paintArrow(bg, bg.StartVisArrowType, bg.StartVisArrowSize, arrowPts);
            }
            if (bg.EndVisArrowType != 0 && bg.EndArrowPoints != null) {
                arrowPts = SchemeEngine.MulPointsTM(SchemeEngine.GenTransform(bg), bg.EndArrowPoints);
                this.paintArrow(bg, bg.EndVisArrowType, bg.EndVisArrowSize, arrowPts);
            }
        }
    }

    private void writePolygon(Polygon bg) {
        int pCount;
        int n = pCount = bg.Points != null ? bg.Points.length / 2 : 0;
        if (pCount < 2) {
            return;
        }
        this.writeAsPolygon(bg, bg.Points);
    }

    private void writeAsPolygon(BaseShape bg, double[] points) {
        int pCount;
        int n = pCount = points != null ? points.length / 2 : 0;
        if (pCount < 2) {
            return;
        }
        double[] pts = SchemeEngine.MulPointsTM(SchemeEngine.GenTransform(bg), points);
        if (bg instanceof Polygon) {
            Polygon polygon = (Polygon)bg;
            this._content.append(String.format("<path %s d=\"%s\" %s/>", this.strId(bg.ID), this.strPath(polygon, pts), this.strStyle(bg, true, false)));
        }
    }

    private void writeRegion(Region bg) {
        int sectCount;
        int pCount;
        int n = pCount = bg.Points != null ? bg.Points.length / 2 : 0;
        if (pCount < 2) {
            return;
        }
        int n2 = sectCount = bg.Counts != null ? bg.Counts.length : 1;
        if (sectCount > 1 && bg.Counts[0] < pCount) {
            pCount = bg.Counts[0];
        }
        if ((pCount - 4) % 3 != 0) {
            return;
        }
        double[] pts = SchemeEngine.MulPointsTM(SchemeEngine.GenTransform(bg), bg.Points);
        this._content.append(String.format("<path %s d=\"%s\" %s/>", this.strId(bg.ID), this.strPath(bg, pts), this.strStyle(bg, true, false)));
    }

    private void writeRectangle(Rectangle bg) {
        if (bg.SideX < 1.0E-12 || bg.SideY < 1.0E-12) {
            this.writeAsPolygon(bg, bg.getRectPoints());
        } else {
            String template = "<rect %s%s x=\"%s\" y=\"%s\" width=\"%s\" height=\"%s\" %s/>";
            String id = this.strId(bg.ID);
            String transform = this.strTransform(bg, "");
            String x = SvgWriter.f2(-0.5 * bg.SideX * this.schemeScale);
            String y = SvgWriter.f2(-0.5 * bg.SideY * this.schemeScale);
            String width = SvgWriter.f2(bg.SideX * this.schemeScale);
            String height = SvgWriter.f2(bg.SideY * this.schemeScale);
            String style = this.strStyle(bg, true, false);
            this._content.append(String.format(template, id, transform, x, y, width, height, style));
        }
    }

    private int getShortLittleEndian(byte[] a, int offs) {
        return a[offs] & 0xFF | (a[offs + 1] & 0xFF) << 8;
    }

    private void writeImage(Image bg) throws Exception {
        String ext;
        byte[] content = bg instanceof PhxImage ? ((PhxImage)bg).Content : bg.Bmp;
        if (content == null || content.length <= 0) {
            this.writeRectangle(bg);
            return;
        }
        String string = ext = bg instanceof PhxImage ? FileSystemLibrary.getFileType(content) : "bmp";
        if (ext.isEmpty()) {
            int idReserved = this.getShortLittleEndian(content, 0);
            int idType = this.getShortLittleEndian(content, 2);
            if (idReserved == 0 && idType == 1) {
                ext = "png";
            } else {
                this.writeRectangle(bg);
                return;
            }
        }
        ByteArrayInputStream in = new ByteArrayInputStream(content);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ImageInfo ii = new ImageInfo();
        ii.setInput(in);
        if (ii.check()) {
            out.write(content);
        } else {
            ByteArrayInputStream bis;
            List images;
            boolean isICO = false;
            int idReserved = this.getShortLittleEndian(content, 0);
            int idType = this.getShortLittleEndian(content, 2);
            if (idReserved == 0 && idType == 1 && !(images = ICODecoder.readExt((InputStream)(bis = new ByteArrayInputStream(content)))).isEmpty()) {
                ICOImage img = (ICOImage)images.get(0);
                if (!img.isPngCompressed()) {
                    img.setPngCompressed(true);
                }
                ImageIO.write((RenderedImage)img.getImage(), "png", out);
                isICO = true;
            }
            if (!isICO) {
                bg.saveBitmapToStream(out);
            }
        }
        String fileFormat = ii.getFormatName().toLowerCase();
        if (SchemeUtils.hasCrop(bg)) {
            out = SchemeUtils.cropImage(out.toByteArray(), bg, fileFormat);
        }
        if (SchemeUtils.hasBrightnessContrast(bg)) {
            out = SchemeUtils.adjustBrightnessContrast(out.toByteArray(), (PhxImage)bg, fileFormat);
        }
        if (SchemeUtils.hasGamma(bg)) {
            out = SchemeUtils.adjustGamma(out.toByteArray(), (PhxImage)bg, fileFormat);
        }
        content = out.toByteArray();
        StringBuilder str = new StringBuilder();
        if (bg.Transparent != 0) {
            str.append(" opacity=\"").append(SvgWriter.f2((256.0 - (double)bg.Transparent) / 255.0)).append("\"");
        }
        String id = this.strId(bg.ID);
        String transform = this.strTransform(bg, "");
        String x = SvgWriter.f2(-0.5 * bg.SideX * this.schemeScale);
        String y = SvgWriter.f2(-0.5 * bg.SideY * this.schemeScale);
        String width = SvgWriter.f2(bg.SideX * this.schemeScale);
        String height = SvgWriter.f2(bg.SideY * this.schemeScale);
        this._content.append(String.format("<image %s%s%s x=\"%s\" y=\"%s\" width=\"%s\" height=\"%s\" xlink:href=\"data:image/%s;base64,%s\"/>", id, transform, str, x, y, width, height, ext, Base64BinString.Encode(content)));
    }

    private void writeEllipse(Ellipse bg) {
        if (bg.SideX < 1.0E-12 || bg.SideY < 1.0E-12 || bg.TransProps != null && (bg.TransProps.SkewX != 0.0 || bg.TransProps.SkewY != 0.0)) {
            double[] points = SchemeEngine.SidesToEllipse(bg.SideX, bg.SideY, bg.Slices);
            this.writeAsPolygon(bg, points);
        } else {
            String id = this.strId(bg.ID);
            String transform = this.strTransform(bg, "");
            String x = SvgWriter.f2(0.5 * bg.SideX * this.schemeScale);
            String y = SvgWriter.f2(0.5 * bg.SideY * this.schemeScale);
            String style = this.strStyle(bg, true, false);
            this._content.append(String.format("<ellipse %s%s rx=\"%s\" ry=\"%s\" %s/>", id, transform, x, y, style));
        }
    }

    private void writePie(Pie bg) {
        byte pieType = bg.PieType;
        double sideX = Math.abs(bg.SideX);
        double sideY = Math.abs(bg.SideY);
        double[] points = SchemeEngine.SidesToPie(sideX, sideY, bg.Slices + 1, pieType, bg.StartAngle, bg.EndAngle);
        int pCount = points.length / 2;
        for (int i = 0; i < pCount; ++i) {
            int idx = 2 * i + 1;
            points[idx] = -points[idx];
        }
        points = SchemeEngine.MulPointsTM(SchemeEngine.GenTransform(bg), points);
        if (pieType == 0) {
            this.writeAsPolyline(bg, points, false);
        } else {
            this.writeAsPolygon(bg, points);
        }
    }

    private boolean needRecalcPara(Paragraph para) {
        int count;
        if (para == null) {
            return false;
        }
        int n = count = para.Lines == null ? 0 : para.Lines.size();
        if (count <= 0) {
            return false;
        }
        if (para.getEngine() == null) {
            para.setEngine(this.engine);
        }
        double sideX = Math.max(para.SideX, para.exportSidesX);
        for (int i = 0; i < count; ++i) {
            RectTextLine line = (RectTextLine)para.Lines.get(i);
            if (line == null || !(sideX < line.SideX)) continue;
            return true;
        }
        return false;
    }

    private void writeParagraph(Paragraph bg) {
        if (!this.engine.tmpLayer.ShowTexts) {
            return;
        }
        if (bg.ShowBackground) {
            this.writeRectangle(bg);
        }
        if (bg.Lines == null || bg.Lines.isEmpty()) {
            return;
        }
        if (this.needRecalcPara(bg) && !bg.AutoSize) {
            Paragraph.parseLines(bg, bg.SideX);
        }
        int a = (int)(this.engine.tmpAngle + 0.5);
        double angle = (double)(-a) * Math.PI / 180.0;
        double lineSpacingX = 0.0;
        double lineSpacingY = 0.0;
        double lineSpacing = bg.LineSpacing;
        if (lineSpacing > 1.0) {
            lineSpacingX -= Math.sin(angle) * bg.lfHeight * (lineSpacing - 1.0);
            lineSpacingY += Math.cos(angle) * bg.lfHeight * (lineSpacing - 1.0);
        }
        int cnt = bg.Lines.size();
        for (int i = 0; i < cnt; ++i) {
            double fontSize;
            RectTextLine line = (RectTextLine)bg.Lines.get(i);
            if (line == null) continue;
            line.parentParagraph = bg;
            line.Text = this.correctText(line.Text);
            double height = Math.abs(bg.SideY);
            BaseGraphic.RealPoint translate = new BaseGraphic.RealPoint();
            translate.X = PdfWriter.getTranslateX(line);
            translate.Y = PdfWriter.getTranslateY(bg, height);
            double[] pts = new double[]{translate.X, translate.Y};
            pts = SchemeEngine.MulPointsTM(this.engine.GTM, pts);
            RectTextLine.ParagraphLine pl = line.paragraphLine;
            if (pl != null) {
                double interval = pl.spaceAfter + pl.spaceBefore;
                lineSpacing = interval / bg.lfHeight + pl.lineSpacing;
            }
            double sx = pts[0] + lineSpacingX;
            double sy = pts[1] + lineSpacingY;
            if (!line.Parts.isEmpty()) {
                RectTextLine.PartTextLine ptl = line.Parts.get(0);
                fontSize = ptl.fontHeight == 0.0 ? bg.lfHeight : ptl.fontHeight;
            } else {
                double lineH = line.SideY;
                fontSize = bg.lfHeight < 1.0E-12 ? 2.0 * lineH / 3.0 : bg.lfHeight;
            }
            double stringW = line.SideX;
            double planeXheight = Math.sin(angle) * fontSize;
            double planeYheight = Math.cos(angle) * fontSize;
            double planeXwidth = PdfWriter.getShiftAlign(line, Math.cos(angle) * stringW);
            double planeYwidth = PdfWriter.getShiftAlign(line, Math.sin(angle) * stringW);
            double tx = sx - planeXheight - planeXwidth;
            double ty = sy + planeYheight / 1.5 - planeYwidth / 1.5;
            String transformTemplate = String.format(" translate(%s, %s)  scale(%s, 1.0)", tx *= this.schemeScale, ty *= this.schemeScale, bg.WidthScale);
            if (line.Parts.isEmpty()) {
                String text = "<text %s class=\"st%s\" %s>%s</text>";
                String transform = this.strTransform(bg, transformTemplate);
                String style = this.textStyle(bg);
                int textStyleId = -1;
                if (this.mapStyles.containsValue(style)) {
                    for (Map.Entry<Integer, String> item : this.mapStyles.entrySet()) {
                        String value = item.getValue();
                        if (!value.equals(style)) continue;
                        textStyleId = item.getKey();
                        break;
                    }
                } else {
                    int size = this.mapStyles.size();
                    this.mapStyles.put(size, style);
                    String textStyle = String.format(".st%s { %s } \n", size, style);
                    this._styles.append(textStyle);
                    textStyleId = size;
                }
                String textLine = line.Text;
                this._content.append(String.format(text, this.strId(bg.ID), textStyleId, transform, textLine));
            } else {
                String tspan = "<tspan class=\"st%s\">%s</tspan>";
                StringBuilder spans = new StringBuilder();
                String transparent = "";
                if (bg.TransparentText != 0) {
                    double transparentText = (double)(256 - bg.TransparentText) / 255.0;
                    transparent = String.format("fill-opacity=\"%s\"", transparentText);
                }
                double startX = tx;
                double startY = ty;
                int cntj = line.Parts.size();
                for (int k = 0; k < cntj; ++k) {
                    RectTextLine.PartTextLine ptl = line.Parts.get(k);
                    String style = this.textStyle(ptl, bg);
                    String text = this.correctText(ptl.text);
                    double xBias = Math.cos(angle) * ptl.sides.X;
                    double yBias = Math.sin(angle) * ptl.sides.Y;
                    if (ptl.fontBgColor != null) {
                        double upperRightX = startX + xBias;
                        double upperRightY = startY + yBias;
                        double lowerLeftX = startX - Math.sin(angle) * ptl.sides.Y;
                        double lowerLeftY = startY - Math.cos(angle) * ptl.sides.Y;
                        double[] arr = new double[]{startX, startY, upperRightX, upperRightY, upperRightX, lowerLeftY, lowerLeftX, lowerLeftY};
                        int pCount = arr.length / 2;
                        arr = SchemeEngine.MulPointsTM(SchemeEngine.GenTransform(bg), arr);
                        this._content.append(String.format("<polygon %s points=\"%s\" fill=\"%s\"/>", this.strId(bg.ID), this.strPoints(arr, 0, pCount), SvgWriter.strColor(ptl.fontBgColor)));
                    }
                    if (this.mapStyles.containsValue(style)) {
                        for (Map.Entry<Integer, String> item : this.mapStyles.entrySet()) {
                            String value = item.getValue();
                            if (!value.equals(style)) continue;
                            int key = item.getKey();
                            String str = String.format(tspan, key, text);
                            spans.append(str);
                            break;
                        }
                    } else {
                        int size = this.mapStyles.size();
                        this.mapStyles.put(size, style);
                        String str = String.format(tspan, size, text);
                        spans.append(str);
                        String textStyle = String.format(".st%s { %s } \n", size, style);
                        this._styles.append(textStyle);
                    }
                    startX += xBias;
                    startY += yBias;
                }
                String textTemplate = "<text %s %s %s>%s</text>";
                String transform = this.strTransform(bg, transformTemplate);
                this._content.append(String.format(textTemplate, this.strId(bg.ID), transparent, transform, spans));
            }
            double adaptiveLineSpacing = fontSize * (Math.abs(lineSpacing) - 1.0);
            lineSpacingX -= Math.sin(angle) * (adaptiveLineSpacing + fontSize);
            lineSpacingY += Math.cos(angle) * (adaptiveLineSpacing + fontSize);
        }
    }

    private String textStyle(RectTextLine.PartTextLine ptl, Paragraph bg) {
        double px;
        StringBuilder sb = new StringBuilder();
        byte fontStyle = ptl.fontStyle;
        if ((fontStyle & 1) != 0) {
            sb.append("font-weight: bold;");
        }
        if ((fontStyle & 2) != 0) {
            sb.append("font-style: italic;");
        }
        String fontName = ptl.fontName != null ? ptl.fontName.trim() : "Arial";
        sb.append(String.format("font-family: %s;", fontName));
        if ((fontStyle & 4) != 0 && (fontStyle & 8) != 0) {
            sb.append("text-decoration: underline line-through;");
        } else {
            if ((fontStyle & 4) != 0) {
                sb.append("text-decoration: underline;");
            }
            if ((fontStyle & 8) != 0) {
                sb.append("text-decoration: line-through;");
            }
        }
        if (ptl.fontColor != null) {
            sb.append(String.format("fill: %s;", SvgWriter.strColor(ptl.fontColor)));
        }
        double d = px = ptl.fontHeight == 0.0 ? bg.lfHeight : ptl.fontHeight;
        if (ptl.ssScript != 0) {
            if (ptl.ssScript == 1) {
                sb.append("baseline-shift: sub;");
            }
            if (ptl.ssScript == 2) {
                sb.append("baseline-shift: super;");
            }
            px *= 0.7;
        }
        sb.append(String.format("font-size: %spx;", px * this.schemeScale));
        if (ptl.text.contains(" ")) {
            sb.append("white-space: pre;");
        }
        String style = sb.toString();
        return style.replaceAll(" {2,}", " ");
    }

    private String textStyle(Paragraph bg) {
        StringBuilder sb = new StringBuilder();
        RectTextLine line = (RectTextLine)bg.Lines.get(0);
        byte fontStyle = line.FontStyle;
        if ((fontStyle & 1) != 0) {
            sb.append("font-weight: bold;");
        }
        if ((fontStyle & 2) != 0) {
            sb.append("font-style: italic;");
        }
        double px = bg.lfHeight < 1.0E-12 ? line.SideY : bg.lfHeight;
        sb.append(String.format("font-size: %spx;", px * this.schemeScale));
        String fontName = line.FontName != null ? line.FontName.trim() : "Arial";
        sb.append(String.format("font-family: %s;", fontName));
        if ((fontStyle & 4) != 0 && (fontStyle & 8) != 0) {
            sb.append("text-decoration: underline line-through;");
        } else {
            if ((fontStyle & 4) != 0) {
                sb.append("text-decoration: underline;");
            }
            if ((fontStyle & 8) != 0) {
                sb.append("text-decoration: line-through;");
            }
        }
        if (bg.TransparentText != 0) {
            double transparentText = (double)(256 - bg.TransparentText) / 255.0;
            sb.append(String.format("fill-opacity: %s; ", transparentText));
        }
        if (line.FontColor != null) {
            Color fontColor = this.engine.getActualFontColor(line.FontColor);
            sb.append(String.format("fill: %s;", SvgWriter.strColor(fontColor)));
        }
        String style = sb.toString();
        return style.replaceAll(" {2,}", " ");
    }

    private String correctText(String text) {
        if (Strings.isVoid(text)) {
            return " ";
        }
        StringBuilder tmp = new StringBuilder();
        block7: for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '\"': {
                    tmp.append("&quot;");
                    continue block7;
                }
                case '&': {
                    tmp.append("&amp;");
                    continue block7;
                }
                case '<': {
                    tmp.append("&lt;");
                    continue block7;
                }
                case '>': {
                    tmp.append("&gt;");
                    continue block7;
                }
                case '\u2028': {
                    tmp.append('\n');
                    continue block7;
                }
                default: {
                    tmp.append(c);
                }
            }
        }
        return tmp.toString();
    }

    private void writeAttributeDef(AttributeDef bg) {
        if (bg.invisible()) {
            return;
        }
        if (bg.ParentGB != null && bg.Inscribe) {
            this.correctAttribute(bg);
        }
        this.writeParagraph(bg);
    }

    private void writeAttributeRef(AttributeRef bg) {
        if (bg.invisible()) {
            return;
        }
        if (bg.ParentGB != null && bg.Inscribe) {
            this.correctAttribute(bg);
        }
        this.writeParagraph(bg);
    }

    private void correctAttribute(Attribute attr) {
        double scaleX = 1.0;
        double scaleY = 1.0;
        BaseGraphic tmpBG = attr;
        while (tmpBG.ParentGB != null) {
            tmpBG = tmpBG.ParentGB;
            if (tmpBG.TransProps == null) {
                tmpBG.TransProps = new TransformProps();
            }
            scaleX *= tmpBG.TransProps.ScaleX;
            scaleY *= tmpBG.TransProps.ScaleY;
        }
        BaseGraphic parentGB = attr.ParentGB;
        if (parentGB instanceof GraphicBlock) {
            GraphicBlock gb = (GraphicBlock)parentGB;
            attr.SideX = (gb.MaxPtX - gb.MinPtX) * scaleX;
            attr.SideY = (gb.MaxPtY - gb.MinPtY) * scaleY;
        } else if (parentGB instanceof Rectangle) {
            Rectangle rect = (Rectangle)parentGB;
            attr.SideX = rect.SideX * scaleX;
            attr.SideY = rect.SideY * scaleY;
        } else {
            BaseGraphic.RealRect rr = parentGB.getMinMaxRect();
            if (parentGB instanceof Spline) {
                Spline spline = (Spline)parentGB;
                double[] pts = SchemeEngine.MulPointsTM(this.engine.GTM, spline.calcPoints());
                rr = SchemeUtils.getMinMaxPts(pts);
            }
            attr.SideX = (rr.Right - rr.Left) * scaleX;
            attr.SideY = (rr.Bottom - rr.Top) * scaleY;
        }
    }

    private void writeBlock(GraphicBlock block) throws Exception {
        if (block.Objects == null || block.Objects.isEmpty()) {
            return;
        }
        if (block != this.primBlock) {
            this._content.append(String.format("<g%s>", this.strTransform(block, "")));
        }
        int count = block.Objects.size();
        for (int i = 0; i < count; ++i) {
            BaseGraphic bg = block.Objects.get(i);
            if (bg == null || this.insertMode && (block.Objects.get(i) instanceof AttributeRef || block.Objects.get(i) instanceof AttributeDef)) continue;
            if (bg instanceof AttributeDef) {
                Attribute attr = (Attribute)bg;
                if (attr.invisible() || attr.getText().isEmpty()) continue;
                RectTextLine line = (RectTextLine)attr.Lines.get(0);
                if (line.FontName.equalsIgnoreCase("symbol")) continue;
                if (attr.getEngine() == null) {
                    attr.setEngine(this.engine);
                }
            }
            this.writeShape(bg);
        }
        if (block != this.primBlock) {
            if (!block.BlockParams.isEmpty()) {
                this._content.append("<v:custProps>");
                block.BlockParams.forEach(param -> this._content.append(this.getPrimParamStr((PrimParam)param)));
                this._content.append("</v:custProps>");
            }
            this._content.append("</g>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeInsert(PhxGraphicInsert insert) throws Exception {
        Primitive prim = this.s.findPrimInLibsById(insert.SourceID, insert.LibID);
        if (prim == null || prim.BG == null) {
            return;
        }
        GraphicBlock block = (GraphicBlock)prim.BG;
        if (insert.getInternalPrimGraphicBlock() != null) {
            block = insert.getInternalPrimGraphicBlock();
        }
        this.primBlock = block;
        if (block == null || block.Objects == null || block.Objects.isEmpty()) {
            return;
        }
        this.insertMode = true;
        try {
            this._content.append(String.format("<g %s%s>", this.strId(insert.ID), this.strTransform(insert, "")));
            this.writeBlock(block);
            int attCount = insert.Attributes != null ? insert.Attributes.size() : 0;
            for (int i = 0; i < attCount; ++i) {
                Attribute att = (Attribute)insert.Attributes.get(i);
                if (att == null || att.invisible()) continue;
                if (att.getEngine() == null) {
                    att.setEngine(this.engine);
                }
                if (att.Inscribe) {
                    att.ParentGB = insert;
                }
                this.writeShape(att);
            }
            this._content.append("</g>");
        }
        finally {
            this.insertMode = false;
        }
    }

    private String getPrimParamStr(PrimParam p) {
        if (p == null || Strings.isVoid(p.getName().trim())) {
            return "";
        }
        if (p.getType() == PrimParam.ValueType.Binary || p.getType() == PrimParam.ValueType.DateTime || p.getType() == PrimParam.ValueType.Undefined) {
            return "";
        }
        Function<PrimParam, String> formatFromParam = param -> {
            switch (param.getType()) {
                case Integer: {
                    return "v:format=\"0\" ";
                }
                case Double: {
                    return "v:format=\"0,00\" ";
                }
                case String: {
                    if (p.getDict().isEmpty()) {
                        return "v:format=\"@\" ";
                    }
                    return String.format("v:format=\"%s\" ", String.join((CharSequence)";", p.getDict()));
                }
            }
            return "";
        };
        Function<PrimParam, String> valueFromParam = param -> {
            String paramValue = HtmlUtils.htmlEnquote(param.getValue());
            switch (param.getType()) {
                case Integer: {
                    return String.format("v:val=\"VT0(%s):26\" ", paramValue);
                }
                case Double: {
                    return String.format("v:val=\"VT0(%s):26\" ", paramValue.replace(",", "."));
                }
                case Boolean: {
                    return String.format("v:val=\"VT0(%s):5\" ", paramValue);
                }
                case String: {
                    return String.format("v:val=\"VT4(%s)\" ", paramValue);
                }
            }
            return "";
        };
        StringBuilder content = new StringBuilder();
        content.append("<v:cp ");
        content.append(String.format("v:nameU=\"%s\" ", p.getName()));
        content.append(String.format("v:lbl=\"%s\" ", Strings.isVoid(p.getCaption()) ? p.getName() : p.getCaption()));
        content.append(String.format("v:type=\"%s\" ", p.getVisioParamType()));
        content.append(formatFromParam.apply(p));
        content.append(valueFromParam.apply(p));
        if (!p.isShowInContextMenu()) {
            content.append("v:invis=\"true\" ");
        }
        content.append("v:langID=\"1049\" ");
        content.append("/>");
        return content.toString();
    }

    public void setStateHost(ServerSideHost host) {
        this.stateHost = host;
    }

    private void putStateCaption(String caption) throws Exception {
        if (this.stateHost == null) {
            return;
        }
        this.stateHost.putRequestStateCaption(caption);
    }

    private void putStateText(String value) throws Exception {
        if (this.stateHost == null) {
            return;
        }
        this.stateHost.putRequestStateText(value);
    }

    private void putStateProgressMax(int value) throws Exception {
        if (this.stateHost == null) {
            return;
        }
        this.stateHost.putRequestStateProgressMax(value);
    }

    private void putStateProgressPosition(int value) throws Exception {
        if (this.stateHost == null) {
            return;
        }
        this.stateHost.putRequestStateProgressPosition(value);
    }

    private static String getPatternStringById(int patternId) {
        switch (patternId) {
            case 2: {
                return diagCellImage;
            }
            case 3: {
                return cellImage;
            }
            case 4: {
                return diagImage;
            }
            case 5: {
                return diagRevertImage;
            }
            case 6: {
                return vertImage;
            }
            case 7: {
                return horizImage;
            }
            case 8: {
                return dotImage;
            }
            case 9: {
                return dot2Image;
            }
            case 10: {
                return dot3Image;
            }
            case 11: {
                return dot4Image;
            }
            case 12: {
                return dot5Image;
            }
            case 13: {
                return dot6Image;
            }
            case 14: {
                return dot7Image;
            }
            case 15: {
                return horiz2Image;
            }
            case 16: {
                return doubleHorizImage;
            }
            case 17: {
                return horiz3Image;
            }
            case 18: {
                return doubleHoriz2Image;
            }
            case 19: {
                return horiz4Image;
            }
            case 20: {
                return vert2Image;
            }
            case 21: {
                return doubleVertImage;
            }
            case 22: {
                return vert3Image;
            }
            case 23: {
                return doubleVert2Image;
            }
            case 24: {
                return vert4Image;
            }
            case 25: {
                return diag2Image;
            }
            case 26: {
                return doubleDiagImage;
            }
            case 27: {
                return diag3Image;
            }
            case 28: {
                return doubleDiag2Image;
            }
            case 29: {
                return tripleDiagImage;
            }
            case 30: {
                return diagRevert2Image;
            }
            case 31: {
                return doubleDiagRevertImage;
            }
            case 32: {
                return diagRevert3Image;
            }
            case 33: {
                return doubleDiagRevert2Image;
            }
            case 34: {
                return tripleDiagRevertImage;
            }
            case 35: {
                return cell2Image;
            }
            case 36: {
                return doubleCellImage;
            }
            case 37: {
                return cell3Image;
            }
            case 38: {
                return doubleCell2Image;
            }
            case 39: {
                return cell4Image;
            }
            case 40: {
                return diagCell2Image;
            }
            case 41: {
                return doubleDiagCellImage;
            }
            case 42: {
                return diagCell3Image;
            }
            case 43: {
                return doubleDiagCell2Image;
            }
            case 44: {
                return pattern1Image;
            }
            case 45: {
                return pattern2Image;
            }
            case 46: {
                return pattern3Image;
            }
            case 47: {
                return pattern4Image;
            }
            case 48: {
                return pattern5Image;
            }
            case 49: {
                return pattern6Image;
            }
            case 50: {
                return pattern7Image;
            }
            case 51: {
                return pattern8Image;
            }
            case 52: {
                return pattern9Image;
            }
            case 53: {
                return pattern10Image;
            }
            case 54: {
                return pattern11Image;
            }
            case 55: {
                return pattern12Image;
            }
            case 56: {
                return pattern13Image;
            }
            case 57: {
                return pattern14Image;
            }
            case 58: {
                return pattern15Image;
            }
            case 59: {
                return pattern16Image;
            }
            case 60: {
                return pattern17Image;
            }
            case 61: {
                return pattern18Image;
            }
            case 62: {
                return pattern19Image;
            }
            case 63: {
                return pattern20Image;
            }
            case 64: {
                return pattern21Image;
            }
            case 65: {
                return pattern22Image;
            }
            case 66: {
                return pattern23Image;
            }
            case 67: {
                return pattern24Image;
            }
        }
        return null;
    }

    public static class RealPoint {
        private double x;
        private double y;

        public RealPoint(double x, double y) {
            this.x = x;
            this.y = y;
        }

        public void assign(RealPoint source) {
            this.x = source.x;
            this.y = source.y;
        }
    }
}

