/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes;

import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.schemes.Paragraph;
import inform.agent.schemes.SchemeParser;
import inform.agent.schemes.SchemeUtils;
import inform.agent.schemes.TransformProps;
import java.io.IOException;

public class TableCell
extends Paragraph {
    public int colSpan = 1;
    public int rowSpan = 1;
    boolean spanning = false;

    public TableCell() {
        this.Lines = new Paragraph.Lines();
        this.AutoSize = false;
        this.ShowBackground = true;
        this.lfHeight = 8.0;
        this.Align = (byte)2;
        this.VertAlign = 2;
        this.TransProps = new TransformProps();
        this.ID = Core.generateId();
    }

    public void loadTag(SchemeParser Parser2, TaggedReader reader) throws IOException, TaggedReaderException {
        switch (reader.getCurrentTag()) {
            case 7: {
                this.bColor = SchemeParser.parseColor(reader.getInt());
                break;
            }
            case 8: {
                this.BkColor = SchemeParser.parseColor(reader.getInt());
                break;
            }
            case 9: {
                this.BrushPattern = reader.getInt();
                break;
            }
            case 10: {
                this.Align = reader.getByte();
                break;
            }
            case 11: {
                this.VertAlign = reader.getByte();
                break;
            }
            case 12: {
                this.Lines.FontName = reader.getString();
                break;
            }
            case 13: {
                this.Lines.FontStyle = reader.getByte();
                break;
            }
            case 14: {
                this.Lines.FontColor = SchemeParser.parseColor(reader.getInt());
                break;
            }
            case 15: {
                this.lfHeight = reader.getDouble();
                break;
            }
            case 16: {
                this.TransProps.Angle = reader.getDouble();
                break;
            }
            case 20: {
                this.WidthScale = reader.getDouble();
                break;
            }
            case 21: {
                this.LineSpacing = reader.getDouble();
                break;
            }
            case 23: {
                this.TransparentText = Byte.toUnsignedInt(reader.getByte());
                break;
            }
            case 25: {
                this.LeftMargin = reader.getDouble();
                break;
            }
            case 26: {
                this.RightMargin = reader.getDouble();
                break;
            }
            case 27: {
                this.TopMargin = reader.getDouble();
                break;
            }
            case 28: {
                this.BottomMargin = reader.getDouble();
                break;
            }
            case 30: {
                this.exportSidesX = reader.getDouble();
                break;
            }
            case 31: {
                this.exportSidesY = reader.getDouble();
            }
        }
    }

    public synchronized void writeCellTaggedData(TaggedWriter writer) throws IOException {
        if (writer == null) {
            return;
        }
        SchemeUtils.writeColor(writer, 7, this.bColor);
        SchemeUtils.writeColor(writer, 8, this.BkColor);
        SchemeUtils.writeColor(writer, 14, this.Lines.FontColor);
        writer.putInt08(10, this.Align);
        writer.putInt08(11, (byte)this.VertAlign);
        if (this.BrushPattern != -1) {
            writer.putInt32(9, this.BrushPattern);
        }
        if (!this.Lines.FontName.equals("Times New Roman")) {
            writer.putString(12, this.Lines.FontName);
        }
        if (this.Lines.FontStyle != 0) {
            writer.putInt08(13, this.Lines.FontStyle);
        }
        if (this.lfHeight != 0.0) {
            writer.putDouble(15, this.lfHeight);
        }
        if (Math.abs(this.TransProps.Angle) > FloatTolerance) {
            writer.putDouble(16, this.TransProps.Angle);
        }
        if (this.WidthScale != 1.0) {
            writer.putDouble(20, this.WidthScale);
        }
        if (this.LineSpacing != 1.0) {
            writer.putDouble(21, this.LineSpacing);
        }
        if (this.TransparentText != 0) {
            writer.putDouble(23, this.TransparentText);
        }
        if (!SchemeUtils.isEqual(this.LeftMargin, 0.0)) {
            writer.putDouble(25, this.LeftMargin);
        }
        if (!SchemeUtils.isEqual(this.RightMargin, 0.0)) {
            writer.putDouble(26, this.RightMargin);
        }
        if (!SchemeUtils.isEqual(this.TopMargin, 0.0)) {
            writer.putDouble(27, this.TopMargin);
        }
        if (!SchemeUtils.isEqual(this.BottomMargin, 0.0)) {
            writer.putDouble(28, this.BottomMargin);
        }
    }

    @Override
    public int shapeType() {
        return 223;
    }
}

