/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes.converters.odg;

import inform.agent.Core;
import inform.agent.LogContext;
import inform.agent.net.Client;
import inform.agent.schemes.SchemeImportRequest;
import inform.agent.schemes.converters.odg.content.OdgContent;
import inform.agent.schemes.converters.odg.content.OdgContentParser;
import inform.agent.schemes.converters.odg.meta.OdgMeta;
import inform.agent.schemes.converters.odg.meta.OdgMetaParser;
import inform.agent.schemes.converters.odg.settings.OdgSettings;
import inform.agent.schemes.converters.odg.settings.OdgSettingsParser;
import inform.agent.schemes.converters.odg.styles.OdgStyles;
import inform.agent.schemes.converters.odg.styles.OdgStylesParser;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OdgParser {
    private final Map<Path, Document> docs = new HashMap<Path, Document>();
    private Document flatDoc;
    private final byte[] content;
    private final Map<String, byte[]> picture = new HashMap<String, byte[]>();

    public OdgParser(byte[] content, boolean isFlatXml) throws Exception {
        this.content = content;
        if (isFlatXml) {
            this.parseFlatDocument();
        } else {
            this.parseDocuments();
        }
    }

    public OdgContent parseContent() {
        OdgContentParser contentParser;
        if (this.flatDoc == null) {
            String contentFileName = "content.xml";
            Document content = this.docs.get(Paths.get(contentFileName, new String[0]));
            contentParser = new OdgContentParser(content);
        } else {
            contentParser = new OdgContentParser(this.flatDoc);
        }
        return contentParser.getContent();
    }

    public OdgMeta parseMeta() throws XPathExpressionException {
        OdgMetaParser metaParser;
        if (this.flatDoc == null) {
            String metaFileName = "meta.xml";
            Document meta = this.docs.get(Paths.get(metaFileName, new String[0]));
            metaParser = new OdgMetaParser(meta);
        } else {
            metaParser = new OdgMetaParser(this.flatDoc);
        }
        return metaParser.getMeta();
    }

    public OdgStyles parseStyles() {
        OdgStylesParser stylesParser;
        if (this.flatDoc == null) {
            String stylesFileName = "styles.xml";
            Document styles = this.docs.get(Paths.get(stylesFileName, new String[0]));
            stylesParser = new OdgStylesParser(styles);
        } else {
            stylesParser = new OdgStylesParser(this.flatDoc);
        }
        return stylesParser.getStyles();
    }

    public OdgSettings parseSettings() {
        OdgSettingsParser settingsParser;
        if (this.flatDoc == null) {
            String settingsFileName = "settings.xml";
            Document setting = this.docs.get(Paths.get(settingsFileName, new String[0]));
            settingsParser = new OdgSettingsParser(setting);
        } else {
            settingsParser = new OdgSettingsParser(this.flatDoc);
        }
        return settingsParser.getSettings();
    }

    public Map<String, byte[]> getPictures() {
        return this.picture;
    }

    private void parseFlatDocument() throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setIgnoringElementContentWhitespace(true);
        dbf.setCoalescing(true);
        dbf.setNamespaceAware(true);
        DocumentBuilder builder = dbf.newDocumentBuilder();
        this.flatDoc = builder.parse(new ByteArrayInputStream(this.content));
    }

    private void parseDocuments() throws Exception {
        block21: {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setIgnoringElementContentWhitespace(true);
            dbf.setCoalescing(true);
            dbf.setNamespaceAware(true);
            DocumentBuilder builder = dbf.newDocumentBuilder();
            try (ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(this.content));){
                ZipEntry zipEntry;
                byte[] buffer = new byte[100000];
                while ((zipEntry = zis.getNextEntry()) != null) {
                    byte[] byteContent;
                    if (zipEntry.getSize() < 0L) {
                        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                            int len;
                            while ((len = zis.read(buffer)) != -1) {
                                os.write(buffer, 0, len);
                            }
                            byteContent = os.toByteArray();
                        }
                    } else {
                        int bytes_read;
                        byte[] blob = new byte[(int)zipEntry.getSize()];
                        int offset = 0;
                        while ((bytes_read = zis.read(blob, offset, blob.length - offset)) > 0) {
                            offset += bytes_read;
                        }
                        byteContent = blob;
                    }
                    if (zipEntry.getName().endsWith(".xml")) {
                        try {
                            this.docs.put(Paths.get(zipEntry.getName(), new String[0]), builder.parse(new ByteArrayInputStream(byteContent)));
                        }
                        catch (Exception e) {
                            SchemeImportRequest currentRequest = (SchemeImportRequest)LogContext.CURRENT.get();
                            if (currentRequest != null) {
                                currentRequest.putRequestStateLog("\u041e\u0448\u0438\u0431\u043a\u0430 \u0447\u0442\u0435\u043d\u0438\u044f \u0444\u0430\u0439\u043b\u0430 " + zipEntry.getName() + ": " + e.getMessage());
                            }
                            Core.logger.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u0447\u0442\u0435\u043d\u0438\u044f \u0444\u0430\u0439\u043b\u0430 " + zipEntry.getName(), e);
                        }
                    }
                    if (!zipEntry.getName().contains("Picture")) continue;
                    this.picture.put(Paths.get(zipEntry.getName(), new String[0]).getFileName().toString(), byteContent);
                }
            }
            catch (ZipException e) {
                SchemeImportRequest currentRequest = (SchemeImportRequest)LogContext.CURRENT.get();
                if (currentRequest == null) break block21;
                currentRequest.putRequestStateText("\u0421\u0442\u0430\u0442\u0443\u0441: \u043f\u0440\u0435\u0440\u0432\u0430\u043d\u043e");
                Client client = currentRequest.client();
                client.sendError(currentRequest.getRequestHeader(), null, "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u0442\u043a\u0440\u044b\u0442\u044c \u0444\u0430\u0439\u043b");
            }
        }
    }

    public static List<Element> getChildElements(Element root) {
        if (root == null) {
            return null;
        }
        NodeList nodes = root.getChildNodes();
        ArrayList<Element> result = new ArrayList<Element>();
        int cnt = nodes.getLength();
        for (int i = 0; i < cnt; ++i) {
            Node item = nodes.item(i);
            if (item.getNodeType() != 1) continue;
            Element e = (Element)item;
            result.add(e);
        }
        return result;
    }
}

