/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes.converters.odg.content.evaluator;

import inform.agent.schemes.converters.odg.content.OdgEnhancedGeometry;
import inform.agent.schemes.converters.odg.content.evaluator.AbstractSyntaxTreeNode;
import inform.agent.schemes.converters.odg.content.evaluator.OdgExpressionParser;
import inform.agent.schemes.converters.odg.content.evaluator.OdgExpressionTokenizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;

public class OdgExpressionEvaluator {
    private static final HashSet<String> uncomputableFunctions = new HashSet<String>(Arrays.asList("nurbs", "polyline"));
    private final OdgEnhancedGeometry geometry;

    public OdgExpressionEvaluator(OdgEnhancedGeometry geometry) {
        this.geometry = geometry;
    }

    public String evaluateExpression(String value) throws Exception {
        AbstractSyntaxTreeNode.AstFunctionCallNode fRoot;
        String functionName;
        OdgExpressionTokenizer oet = new OdgExpressionTokenizer(value);
        OdgExpressionParser oxp = new OdgExpressionParser(oet, this.geometry);
        AbstractSyntaxTreeNode root = oxp.parseExpression();
        if (root instanceof AbstractSyntaxTreeNode.AstFunctionCallNode && OdgExpressionEvaluator.isUncomputable(functionName = (fRoot = (AbstractSyntaxTreeNode.AstFunctionCallNode)root).getFunctionName().toLowerCase())) {
            ArrayList<String> arguments = new ArrayList<String>();
            for (AbstractSyntaxTreeNode argument : fRoot.getArguments()) {
                arguments.add(OdgExpressionEvaluator.cutDecimalPlaces(String.valueOf(argument.evaluate())));
            }
            return functionName + "(" + String.join((CharSequence)",", arguments) + ")";
        }
        String res = String.valueOf(root.evaluate());
        return OdgExpressionEvaluator.cutDecimalPlaces(res);
    }

    private static String cutDecimalPlaces(String number) {
        if (number.endsWith(".0")) {
            return number.substring(0, number.length() - 2);
        }
        return number;
    }

    private static boolean isUncomputable(String functionName) {
        return uncomputableFunctions.contains(functionName.toLowerCase());
    }
}

