/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes.converters.vsdx;

import inform.agent.schemes.converters.vsdx.VsdxMaster;
import inform.agent.schemes.converters.vsdx.VsdxPage;
import inform.agent.schemes.converters.vsdx.VsdxShape;
import inform.agent.schemes.converters.vsdx.VsdxStyle;
import inform.agent.schemes.converters.vsdx.themes.VsdxTheme;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class Vsdx {
    public static final Map<String, String> VSDX_SYS_COLORS = new HashMap<String, String>();
    public Map<String, String> documentColors;
    public Map<String, VsdxStyle> styles;
    public String currentPage;
    public List<VsdxPage> pages = new ArrayList<VsdxPage>();
    public List<VsdxMaster> masters = new ArrayList<VsdxMaster>();
    public List<VsdxTheme> themes = new ArrayList<VsdxTheme>();
    public Map<String, VsdxShape> baseShapes = new HashMap<String, VsdxShape>();
    public List<VsdxPage> backPages;
    public int totalLayers;
    public int totalShapes;
    private boolean fromOldFormat = false;

    public void setFromOldFormat(boolean value) {
        this.fromOldFormat = value;
    }

    public boolean isFromOldFormat() {
        return this.fromOldFormat;
    }

    public Color parseColor(String value) {
        return this.parseNullableColor(value).orElse(Color.BLACK);
    }

    public Optional<Color> parseNullableColor(String color) {
        if (color == null || color.isEmpty()) {
            return Optional.empty();
        }
        if (color.startsWith("#")) {
            return Optional.of(Color.decode(color));
        }
        if (this.documentColors != null && this.documentColors.containsKey(color)) {
            return Optional.of(Color.decode(this.documentColors.get(color)));
        }
        if (VSDX_SYS_COLORS.containsKey(color)) {
            return Optional.of(Color.decode(VSDX_SYS_COLORS.get(color)));
        }
        return Optional.empty();
    }

    private String checkThemedValue(String propName, String propValue) {
        return "Themed".equals(propValue) ? null : propValue;
    }

    private void mergeTextStyle(VsdxStyle style, Map<String, VsdxStyle> styles, Set<String> ready) {
        String value;
        if (style == null) {
            return;
        }
        if (ready.contains(style.ID)) {
            return;
        }
        if (style.TextStyleID == null || style.TextStyleID.isEmpty()) {
            ready.add(style.ID);
            return;
        }
        VsdxStyle inheritedStyle = styles.get(style.TextStyleID);
        if (inheritedStyle == null) {
            return;
        }
        if (!ready.contains(style.TextStyleID)) {
            this.mergeTextStyle(inheritedStyle, styles, ready);
            ready.add(style.TextStyleID);
        }
        if (inheritedStyle.cellValues != null) {
            if (style.cellValues == null) {
                style.cellValues = new HashMap<String, String>();
            }
            for (String prop : VsdxStyle.TEXTSTYLE_PROPS) {
                if (this.checkThemedValue(prop, style.cellValues.get(prop)) != null || !inheritedStyle.cellValues.containsKey(prop)) continue;
                value = inheritedStyle.cellValues.get(prop);
                if ((value = this.checkThemedValue(prop, value)) == null) continue;
                style.cellValues.put(prop, value);
            }
        }
        if (inheritedStyle.characterValues != null) {
            if (style.characterValues == null) {
                style.characterValues = new HashMap<String, String>();
            }
            for (String prop : inheritedStyle.characterValues.keySet()) {
                if (this.checkThemedValue(prop, style.characterValues.get(prop)) != null) continue;
                value = inheritedStyle.characterValues.get(prop);
                if ((value = this.checkThemedValue(prop, value)) == null) continue;
                style.characterValues.put(prop, value);
            }
        }
        if (inheritedStyle.paragraphValues != null) {
            if (style.paragraphValues == null) {
                style.paragraphValues = new HashMap<String, String>();
            }
            for (String prop : inheritedStyle.paragraphValues.keySet()) {
                if (this.checkThemedValue(prop, style.paragraphValues.get(prop)) != null) continue;
                value = inheritedStyle.paragraphValues.get(prop);
                if ((value = this.checkThemedValue(prop, value)) == null) continue;
                style.paragraphValues.put(prop, value);
            }
        }
    }

    private void mergeFillStyle(VsdxStyle style, Map<String, VsdxStyle> styles, Set<String> ready) {
        if (style == null) {
            return;
        }
        if (ready.contains(style.ID)) {
            return;
        }
        if (style.FillStyleID == null || style.FillStyleID.isEmpty()) {
            return;
        }
        VsdxStyle inheritedStyle = styles.get(style.FillStyleID);
        if (inheritedStyle == null) {
            return;
        }
        if (!ready.contains(style.FillStyleID)) {
            this.mergeFillStyle(inheritedStyle, styles, ready);
            ready.add(style.FillStyleID);
        }
        if (inheritedStyle.cellValues != null) {
            if (style.cellValues == null) {
                style.cellValues = new HashMap<String, String>();
            }
            for (String prop : VsdxStyle.FILLSTYLE_PROPS) {
                if (this.checkThemedValue(prop, style.cellValues.get(prop)) != null || !inheritedStyle.cellValues.containsKey(prop)) continue;
                String value = inheritedStyle.cellValues.get(prop);
                if ((value = this.checkThemedValue(prop, value)) == null) continue;
                style.cellValues.put(prop, value);
            }
        }
        if (inheritedStyle.fillGradientValues != null && style.fillGradientValues == null) {
            style.fillGradientValues = inheritedStyle.fillGradientValues;
        }
    }

    private void mergeLineStyle(VsdxStyle style, Map<String, VsdxStyle> styles, Set<String> ready) {
        if (style == null) {
            return;
        }
        if (ready.contains(style.ID)) {
            return;
        }
        if (style.LineStyleID == null || style.LineStyleID.isEmpty()) {
            return;
        }
        VsdxStyle inheritedStyle = styles.get(style.LineStyleID);
        if (inheritedStyle == null) {
            return;
        }
        if (!ready.contains(style.LineStyleID)) {
            this.mergeLineStyle(inheritedStyle, styles, ready);
            ready.add(style.LineStyleID);
        }
        if (inheritedStyle.cellValues != null) {
            if (style.cellValues == null) {
                style.cellValues = new HashMap<String, String>();
            }
            for (String prop : VsdxStyle.LINESTYLE_PROPS) {
                if (this.checkThemedValue(prop, style.cellValues.get(prop)) != null || !inheritedStyle.cellValues.containsKey(prop)) continue;
                String value = inheritedStyle.cellValues.get(prop);
                if ((value = this.checkThemedValue(prop, value)) == null) continue;
                style.cellValues.put(prop, value);
            }
        }
    }

    public void mergeStyles(Map<String, VsdxStyle> styles) {
        if (styles == null) {
            return;
        }
        HashSet<String> ready = new HashSet<String>();
        for (VsdxStyle style : styles.values()) {
            this.mergeTextStyle(style, styles, ready);
        }
        ready.clear();
        for (VsdxStyle style : styles.values()) {
            this.mergeFillStyle(style, styles, ready);
        }
        ready.clear();
        for (VsdxStyle style : styles.values()) {
            this.mergeLineStyle(style, styles, ready);
        }
    }

    public VsdxPage pageById(String id) {
        if (id == null || id.isEmpty()) {
            return null;
        }
        for (VsdxPage page : this.pages) {
            if (!id.equals(page.ID)) continue;
            return page;
        }
        return null;
    }

    public VsdxPage findPage(String pageID) {
        if (pageID == null || pageID.isEmpty()) {
            return null;
        }
        for (VsdxPage p : this.pages) {
            if (!pageID.equals(p.ID)) continue;
            return p;
        }
        return null;
    }

    static {
        VSDX_SYS_COLORS.put("0", "#000000");
        VSDX_SYS_COLORS.put("1", "#FFFFFF");
        VSDX_SYS_COLORS.put("2", "#FF0000");
        VSDX_SYS_COLORS.put("3", "#00FF00");
        VSDX_SYS_COLORS.put("4", "#0000FF");
        VSDX_SYS_COLORS.put("5", "#FFFF00");
        VSDX_SYS_COLORS.put("6", "#FF00FF");
        VSDX_SYS_COLORS.put("7", "#00FFFF");
        VSDX_SYS_COLORS.put("8", "#800000");
        VSDX_SYS_COLORS.put("9", "#008000");
        VSDX_SYS_COLORS.put("10", "#000080");
        VSDX_SYS_COLORS.put("11", "#808000");
        VSDX_SYS_COLORS.put("12", "#800080");
        VSDX_SYS_COLORS.put("13", "#008080");
        VSDX_SYS_COLORS.put("14", "#C0C0C0");
        VSDX_SYS_COLORS.put("15", "#E6E6E6");
        VSDX_SYS_COLORS.put("16", "#CDCDCD");
        VSDX_SYS_COLORS.put("17", "#B3B3B3");
        VSDX_SYS_COLORS.put("18", "#9A9A9A");
        VSDX_SYS_COLORS.put("19", "#808080");
        VSDX_SYS_COLORS.put("20", "#666666");
        VSDX_SYS_COLORS.put("21", "#4D4D4D");
        VSDX_SYS_COLORS.put("22", "#333333");
        VSDX_SYS_COLORS.put("23", "#1A1A1A");
    }
}

