/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes.converters.vsdx;

import inform.agent.schemes.converters.vsdx.VsdxCharacter;
import inform.agent.schemes.converters.vsdx.VsdxParser;
import inform.agent.schemes.converters.vsdx.VsdxRowsSectionParser;
import inform.agent.schemes.converters.vsdx.VsdxShape;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VsdxCharacterParser
extends VsdxRowsSectionParser {
    VsdxCharacterParser(VsdxParser vsdxParser, Element characterNode) {
        super(vsdxParser, characterNode);
    }

    public void parse(VsdxShape shape) {
        if (shape == null) {
            return;
        }
        Element characterSection = this.getSectionNode();
        if (characterSection == null) {
            return;
        }
        NodeList childNodes = characterSection.getChildNodes();
        if (childNodes == null) {
            return;
        }
        int cnt = childNodes.getLength();
        if (cnt == 0) {
            return;
        }
        if (shape.Characters == null) {
            shape.Characters = new ArrayList<VsdxCharacter>();
        }
        for (int i = 0; i < cnt; ++i) {
            NodeList cells;
            Node item = childNodes.item(i);
            if (item == null || item.getNodeType() != 1 || (cells = item.getChildNodes()) == null) continue;
            String IX = ((Element)item).getAttribute("IX");
            VsdxCharacter row = shape.findCharacterById(IX);
            if (row == null) {
                row = new VsdxCharacter();
                row.IX = IX;
                shape.Characters.add(row);
                if (shape.Character != null) {
                    row.applyProperties(shape.Character);
                }
            }
            int cntj = cells.getLength();
            block27: for (int j = 0; j < cntj; ++j) {
                if (cells.item(j).getNodeType() != 1) continue;
                Element cell = (Element)cells.item(j);
                String cellValue = cell.getAttribute("V");
                switch (cell.getAttribute("N")) {
                    case "Font": {
                        row.Font = cellValue;
                        continue block27;
                    }
                    case "Size": {
                        row.Size = cellValue;
                        continue block27;
                    }
                    case "Style": {
                        row.Style = cellValue;
                        continue block27;
                    }
                    case "Color": {
                        row.Color = cellValue;
                        continue block27;
                    }
                    case "Case": {
                        row.Case = cellValue;
                        continue block27;
                    }
                    case "Strikethru": {
                        row.Strikethru = cellValue;
                        continue block27;
                    }
                    case "Pos": {
                        row.Pos = cellValue;
                        continue block27;
                    }
                    case "DblUnderline": {
                        row.DoubleULine = cellValue;
                        continue block27;
                    }
                    case "DoubleStrikethrough": {
                        row.DoubleStrikethrough = cellValue;
                        continue block27;
                    }
                    case "FontScale": {
                        row.FontScale = cellValue;
                        continue block27;
                    }
                    case "ColorTrans": {
                        row.ColorTrans = cellValue;
                    }
                }
            }
        }
    }
}

