/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes.converters.vsdx;

import inform.agent.Core;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFChart;
import org.apache.poi.hssf.usermodel.HSSFFormulaEvaluator;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.util.CellRangeAddressBase;

public class VsdxChart {
    public VsdxChartType chartType;
    public int chartHeight;
    public int chartWidth;
    public List<VsdxChartSeries> chartSeries;
    private static final byte[] MSOFFICE_HEADER = new byte[]{-48, -49, 17, -32, -95, -79, 26, -31};

    /*
     * Enabled aggressive exception aggregation
     */
    public static List<VsdxChart> parseChartsFromXLS(byte[] content) {
        if (content == null || content.length < MSOFFICE_HEADER.length) {
            return null;
        }
        for (int i = 0; i < MSOFFICE_HEADER.length; ++i) {
            if (MSOFFICE_HEADER[i] == content[i]) continue;
            return null;
        }
        try (ByteArrayInputStream is = new ByteArrayInputStream(content);){
            HSSFWorkbook wb = new HSSFWorkbook((InputStream)is);
            int activeSheetIndex = wb.getActiveSheetIndex();
            if (activeSheetIndex == 0 && wb.getNumberOfSheets() == 2) {
                HSSFSheet sheet = wb.getSheetAt(activeSheetIndex);
                if (sheet == null) {
                    List<VsdxChart> list = null;
                    return list;
                }
                HSSFSheet sheetData = wb.getSheetAt(1);
                if (sheetData == null) {
                    List<VsdxChart> list = null;
                    return list;
                }
                HSSFChart[] charts = HSSFChart.getSheetCharts((HSSFSheet)sheet);
                if (charts == null || charts.length == 0) {
                    List<VsdxChart> list = null;
                    return list;
                }
                ArrayList<VsdxChart> result = new ArrayList<VsdxChart>();
                for (HSSFChart chart : charts) {
                    VsdxChart vsdxChart = new VsdxChart();
                    result.add(vsdxChart);
                    vsdxChart.chartHeight = chart.getChartHeight();
                    vsdxChart.chartWidth = chart.getChartWidth();
                    switch (chart.getType()) {
                        case Bar: {
                            vsdxChart.chartType = VsdxChartType.BAR;
                            break;
                        }
                        case Line: {
                            vsdxChart.chartType = VsdxChartType.LINE;
                            break;
                        }
                        case Pie: {
                            vsdxChart.chartType = VsdxChartType.PIE;
                            break;
                        }
                        case Area: {
                            vsdxChart.chartType = VsdxChartType.AREA;
                            break;
                        }
                    }
                    HSSFChart.HSSFSeries[] series = chart.getSeries();
                    vsdxChart.chartSeries = new ArrayList<VsdxChartSeries>();
                    for (HSSFChart.HSSFSeries s : series) {
                        VsdxChartSeries vsdxSeries = new VsdxChartSeries();
                        vsdxSeries.title = s.getSeriesTitle();
                        vsdxSeries.cells = new ArrayList<VsdxChartCell>();
                        CellRangeAddressBase valuesCellRange = s.getValuesCellRange();
                        int rend = valuesCellRange.getLastRow();
                        for (int r = valuesCellRange.getFirstRow(); r <= rend; ++r) {
                            HSSFRow row = sheetData.getRow(r);
                            if (row == null) continue;
                            int cend = valuesCellRange.getLastColumn();
                            for (int c = valuesCellRange.getFirstColumn(); c <= cend; ++c) {
                                HSSFCell cell = row.getCell(c);
                                VsdxChartCell vsdxCell = new VsdxChartCell();
                                if (cell != null) {
                                    block12 : switch (cell.getCellType()) {
                                        case BLANK: {
                                            vsdxCell.numValue = cell.getNumericCellValue();
                                            vsdxCell.strValue = cell.getStringCellValue();
                                            break;
                                        }
                                        case NUMERIC: {
                                            vsdxCell.type = VsdxCellType.NUMERIC;
                                            vsdxCell.numValue = cell.getNumericCellValue();
                                            break;
                                        }
                                        case STRING: {
                                            vsdxCell.type = VsdxCellType.STRING;
                                            vsdxCell.strValue = cell.getStringCellValue();
                                            break;
                                        }
                                        case FORMULA: {
                                            HSSFFormulaEvaluator evaluator = wb.getCreationHelper().createFormulaEvaluator();
                                            CellValue value = evaluator.evaluate((Cell)cell);
                                            CellType type2 = value.getCellType();
                                            switch (type2) {
                                                case BOOLEAN: {
                                                    break block12;
                                                }
                                                case NUMERIC: {
                                                    vsdxCell.numValue = value.getNumberValue();
                                                    vsdxCell.type = VsdxCellType.NUMERIC;
                                                    break block12;
                                                }
                                            }
                                            vsdxCell.type = VsdxCellType.STRING;
                                            vsdxCell.strValue = value.getStringValue();
                                        }
                                    }
                                }
                                vsdxSeries.cells.add(vsdxCell);
                            }
                        }
                        vsdxSeries.categoryLabels = new ArrayList<String>();
                        CellRangeAddressBase categoryLabelsCellRange = s.getCategoryLabelsCellRange();
                        int rend2 = categoryLabelsCellRange.getLastRow();
                        for (int r = categoryLabelsCellRange.getFirstRow(); r <= rend2; ++r) {
                            HSSFRow row = sheetData.getRow(r);
                            if (row == null) continue;
                            int cend = categoryLabelsCellRange.getLastColumn();
                            for (int c = categoryLabelsCellRange.getFirstColumn(); c <= cend; ++c) {
                                HSSFCell cell = row.getCell(c);
                                if (cell == null) continue;
                                vsdxSeries.categoryLabels.add(cell.getCellType() == CellType.STRING ? cell.getStringCellValue() : "");
                            }
                        }
                        vsdxChart.chartSeries.add(vsdxSeries);
                    }
                }
                ArrayList<VsdxChart> arrayList = result.isEmpty() ? null : result;
                return arrayList;
            }
        }
        catch (IOException ex) {
            Core.logger.info(ex.getMessage());
        }
        return null;
    }

    public static class VsdxChartSeries {
        public String title;
        public List<VsdxChartCell> cells;
        public List<String> categoryLabels;
    }

    public static class VsdxChartCell {
        public VsdxCellType type;
        public String strValue;
        public double numValue;
    }

    public static enum VsdxCellType {
        NUMERIC,
        STRING;

    }

    public static enum VsdxChartType {
        BAR,
        LINE,
        PIE,
        AREA;

    }
}

