/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes.converters.vsdx;

import inform.agent.schemes.SchemeUtils;
import inform.agent.schemes.converters.vsdx.VsdxUtils;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class VsdxForeignData {
    byte[] rawData;
    Map<String, String> attributes;
    OleFormat rawFormat;

    public byte[] getRawData() {
        return this.rawData;
    }

    public boolean hasAttribute(String attrName) {
        return this.attributes == null ? false : this.attributes.containsKey(attrName);
    }

    public String getAttribute(String attrName) {
        return this.attributes == null ? null : this.attributes.get(attrName);
    }

    public OleFormat getRawFormat() {
        return this.rawFormat;
    }

    void applyProperties(VsdxForeignData foreignData) {
        if (foreignData == null) {
            return;
        }
        if (foreignData.rawData != null) {
            this.rawData = Arrays.copyOf(foreignData.rawData, foreignData.rawData.length);
        }
        if (foreignData.rawFormat != null) {
            this.rawFormat = foreignData.rawFormat;
        }
        if (foreignData.attributes != null) {
            if (this.attributes == null) {
                this.attributes = new HashMap<String, String>();
            }
            this.attributes.putAll(foreignData.attributes);
        }
    }

    public int getExtentX() {
        return this.hasAttribute("ExtentX") ? SchemeUtils.convertInt(this.getAttribute("ExtentX")) : 0;
    }

    public int getExtentY() {
        return this.hasAttribute("ExtentY") ? SchemeUtils.convertInt(this.getAttribute("ExtentY")) : 0;
    }

    public double getObjectWidth() {
        return this.hasAttribute("ObjectWidth") ? VsdxUtils.convertDouble(this.getAttribute("ObjectWidth"), null) : 0.0;
    }

    public double getObjectHeight() {
        return this.hasAttribute("ObjectHeight") ? VsdxUtils.convertDouble(this.getAttribute("ObjectHeight"), null) : 0.0;
    }

    public static OleFormat getOleFormat(Path path) {
        if (path != null) {
            String filename = path.toString().toLowerCase();
            if (filename.endsWith(".vsd") || filename.endsWith(".vdw")) {
                return OleFormat.VSD;
            }
            if (filename.endsWith(".vsdx") || filename.endsWith(".vsdm") || filename.endsWith(".vstx")) {
                return OleFormat.VSDX;
            }
            if (filename.endsWith(".emf") || filename.endsWith(".wmf")) {
                return OleFormat.EMF;
            }
            if (filename.endsWith(".xls")) {
                return OleFormat.XLS;
            }
            if (filename.endsWith(".xlsx")) {
                return OleFormat.XLSX;
            }
        }
        return null;
    }

    public static enum OleFormat {
        EMF,
        VSD,
        VSDX,
        XLS,
        XLSX;

    }
}

