/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes.converters.vsdx;

import inform.agent.schemes.VsdxReader;
import inform.agent.schemes.converters.vsdx.Vsdx;
import inform.agent.schemes.converters.vsdx.VsdxComment;
import inform.agent.schemes.converters.vsdx.VsdxConnect;
import inform.agent.schemes.converters.vsdx.VsdxLayer;
import inform.agent.schemes.converters.vsdx.VsdxShape;
import inform.agent.schemes.converters.vsdx.VsdxStyle;
import inform.agent.schemes.converters.vsdx.VsdxUtils;
import java.util.ArrayList;
import java.util.List;

public class VsdxPage {
    public String ID;
    public String Name;
    public String ThemeIndex;
    public String ColorSchemeIndex;
    public String EffectSchemeIndex;
    public String ConnectorSchemeIndex;
    public String FontSchemeIndex;
    public String VariationColorIndex;
    public String LineStyle;
    public String FillStyle;
    public String TextStyle;
    public String PageScale;
    public String DrawingScale;
    public String PageWidth;
    public String PageHeight;
    public String PageLeftMargin;
    public String PageMeasureUnits;
    public String PageRightMargin;
    public String PageTopMargin;
    public String PageBottomMargin;
    public String XRulerOrigin;
    public String YRulerOrigin;
    public String Background;
    public String BackPage;
    private static final int UNDEFINED_INT = -100;
    private int intLineJumpCode = -100;
    private int intLineJumpType = -100;
    public static double LINE_JUMP_DEF_SIZE = 2.0;
    public static int LINE_JUMP_DEF_TYPE = 1;
    public String LineJumpCode;
    public String LineJumpStyle;
    public String LineJumpFactorX;
    public String LineJumpFactorY;
    public String LineToNodeX;
    public String LineToNodeY;
    public List<VsdxLayer> layers;
    public List<VsdxShape> shapes;
    public List<VsdxConnect> connects;
    public List<VsdxComment> comments;
    public boolean isLandscape = false;
    public double avesID = 0.0;
    public final Vsdx vsdx;

    public VsdxPage(Vsdx vsdx) {
        this.vsdx = vsdx;
    }

    private List<VsdxShape> findShape(String shapeId, List<VsdxShape> listShapes) {
        if (listShapes == null) {
            return null;
        }
        assert (shapeId != null);
        for (VsdxShape shape : listShapes) {
            if (!shapeId.equals(shape.ID)) continue;
            ArrayList<VsdxShape> result = new ArrayList<VsdxShape>();
            result.add(shape);
            return result;
        }
        for (VsdxShape shape : listShapes) {
            List<VsdxShape> result = this.findShape(shapeId, shape.getShapes());
            if (result == null) continue;
            result.add(shape);
            return result;
        }
        return null;
    }

    public VsdxShape[] findShapePath(String shapeId) {
        if (shapeId == null || shapeId.isEmpty()) {
            return null;
        }
        List<VsdxShape> shapePath = this.findShape(shapeId, this.shapes);
        if (shapePath == null) {
            return null;
        }
        VsdxShape[] result = new VsdxShape[shapePath.size()];
        int i = 0;
        int j = result.length - 1;
        while (i < result.length) {
            result[j] = shapePath.get(i);
            ++i;
            --j;
        }
        return result;
    }

    public int getLineJumpCode() {
        if (this.intLineJumpCode == -100) {
            String strLineJumpCode = this.LineJumpCode != null ? this.LineJumpCode : this.findCellValueInStyle("LineJumpCode", VsdxStyle.TYPE.LINESTYLE);
            this.intLineJumpCode = (int)VsdxUtils.convertDouble(strLineJumpCode, null);
        }
        return this.intLineJumpCode;
    }

    public int getLineJumpType() {
        if (this.intLineJumpType == -100) {
            String strLineJumpStyle = this.LineJumpStyle != null ? this.LineJumpStyle : this.findCellValueInStyle("LineJumpStyle", VsdxStyle.TYPE.LINESTYLE);
            int lineJumpStyle = (int)VsdxUtils.convertDouble(strLineJumpStyle, null);
            this.intLineJumpType = LINE_JUMP_DEF_TYPE;
            if (lineJumpStyle == 2) {
                this.intLineJumpType = 0;
            } else if (lineJumpStyle >= 3 && lineJumpStyle <= 9) {
                this.intLineJumpType = lineJumpStyle - 1;
            }
        }
        return this.intLineJumpType;
    }

    public double getLineJumpSizeX() {
        String strLineJumpFactorX = this.LineJumpFactorX != null ? this.LineJumpFactorX : this.findCellValueInStyle("LineJumpFactorX", VsdxStyle.TYPE.LINESTYLE);
        String strLineToNodeX = this.LineToNodeX != null ? this.LineToNodeX : this.findCellValueInStyle("LineToNodeX", VsdxStyle.TYPE.LINESTYLE);
        return VsdxUtils.convertDouble(strLineJumpFactorX, null) * VsdxReader.inchToMM(strLineToNodeX, null);
    }

    public double getLineJumpSizeY() {
        String strLineJumpFactorY = this.LineJumpFactorY != null ? this.LineJumpFactorY : this.findCellValueInStyle("LineJumpFactorY", VsdxStyle.TYPE.LINESTYLE);
        String strLineToNodeY = this.LineToNodeY != null ? this.LineToNodeY : this.findCellValueInStyle("LineToNodeY", VsdxStyle.TYPE.LINESTYLE);
        return VsdxUtils.convertDouble(strLineJumpFactorY, null) * VsdxReader.inchToMM(strLineToNodeY, null);
    }

    public String findCellValueInStyle(String cellName, VsdxStyle.TYPE styleType) {
        if (this.vsdx == null || this.vsdx.styles == null) {
            return null;
        }
        String idStyle = null;
        switch (styleType) {
            case LINESTYLE: {
                idStyle = this.LineStyle;
                break;
            }
            case FILLSTYLE: {
                idStyle = this.FillStyle;
                break;
            }
            case TEXTSTYLE: {
                idStyle = this.TextStyle;
                break;
            }
        }
        block10: while (idStyle != null) {
            VsdxStyle style = this.vsdx.styles.get(idStyle);
            if (style == null) {
                return null;
            }
            if (style.cellValues != null && style.cellValues.containsKey(cellName)) {
                return style.cellValues.get(cellName);
            }
            switch (styleType) {
                case LINESTYLE: {
                    idStyle = style.LineStyleID;
                    continue block10;
                }
                case FILLSTYLE: {
                    idStyle = style.FillStyleID;
                    continue block10;
                }
                case TEXTSTYLE: {
                    idStyle = style.TextStyleID;
                    continue block10;
                }
            }
            return null;
        }
        return null;
    }
}

